/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.expr;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.EmptyStackException;
import java.util.Map;
import java.util.Stack;

public class ExpressionParser<T> {
    protected OperatorStreamTokenizer _strtok;
    protected Stack<T> _output = new Stack();
    protected Stack<Object> _operation = new Stack();
    protected static final Map<String, Operator> OPERATORS = Maps.newHashMap();
    protected static final Map<String, Operator> UNARY_ALTERNATES = Maps.newHashMap();

    static {
        ExpressionParser.addOperator(".", false, 1, 2);
        ExpressionParser.addOperator("++", true, 2, 1);
        ExpressionParser.addOperator("--", true, 2, 1);
        ExpressionParser.addUnaryAlternate("+", true, 2, 1);
        ExpressionParser.addUnaryAlternate("-", true, 2, 1);
        ExpressionParser.addOperator("!", true, 2, 1);
        ExpressionParser.addOperator("*", false, 3, 2);
        ExpressionParser.addOperator("/", false, 3, 2);
        ExpressionParser.addOperator("%", false, 3, 2);
        ExpressionParser.addOperator("+", false, 4, 2);
        ExpressionParser.addOperator("-", false, 4, 2);
        ExpressionParser.addOperator("<", false, 6, 2);
        ExpressionParser.addOperator("<=", false, 6, 2);
        ExpressionParser.addOperator(">", false, 6, 2);
        ExpressionParser.addOperator(">=", false, 6, 2);
        ExpressionParser.addOperator("==", false, 7, 2);
        ExpressionParser.addOperator("!=", false, 7, 2);
        ExpressionParser.addOperator("&", false, 8, 2);
        ExpressionParser.addOperator("^", false, 9, 2);
        ExpressionParser.addOperator("|", false, 10, 2);
        ExpressionParser.addOperator("&&", false, 11, 2);
        ExpressionParser.addOperator("||", false, 12, 2);
    }

    public static void main(String ... args) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while ((line = reader.readLine()) != null) {
            String result = (String)new ExpressionParser<String>((Reader)new StringReader(line)){

                @Override
                protected String handleNumber(double value) {
                    return String.valueOf(value);
                }

                @Override
                protected String handleString(String value) {
                    return "\"" + value + "\"";
                }

                @Override
                protected String handleOperator(String operator, int arity) throws Exception {
                    StringBuilder buf = new StringBuilder();
                    int ii = 0;
                    while (ii < arity) {
                        buf.insert(0, String.valueOf((String)this._output.pop()) + " ");
                        ++ii;
                    }
                    return String.valueOf(buf.toString()) + operator;
                }

                @Override
                protected String handleFunctionCall(String function, int arity) throws Exception {
                    StringBuilder buf = new StringBuilder();
                    int ii = 0;
                    while (ii < arity) {
                        buf.insert(0, String.valueOf((String)this._output.pop()) + " ");
                        ++ii;
                    }
                    return String.valueOf(buf.toString()) + function + "()";
                }

                @Override
                protected String handleArrayIndex(String array) throws Exception {
                    return String.valueOf((String)this._output.pop()) + " " + array + "[]";
                }

                @Override
                protected String handleIdentifier(String name) {
                    return name;
                }
            }.parse();
            System.out.println(result);
        }
    }

    public ExpressionParser(Reader reader) {
        this._strtok = new OperatorStreamTokenizer(reader);
    }

    /*
     * Unable to fully structure code
     */
    public T parse() throws Exception {
        lastToken = -4;
        while ((token = this._strtok.nextToken()) != -1) {
            switch (token) {
                case -2: {
                    this.handle(this._strtok.nval);
                    break;
                }
                case 34: 
                case 39: {
                    this.handle(this._strtok.sval);
                    break;
                }
                case -3: {
                    sval = this._strtok.sval;
                    ntoken = this._strtok.nextToken();
                    this._strtok.pushBack();
                    if (ntoken == 40) {
                        this._operation.push(new FunctionCall(sval));
                        break;
                    }
                    if (ntoken == 91) {
                        this._operation.push(new ArrayIndex(sval));
                        break;
                    }
                    this.handle(new Identifier(sval));
                    break;
                }
                case 44: {
                    try {
                        while (!this._operation.peek().equals(Character.valueOf('('))) {
                            this.handle(this._operation.pop());
                        }
                    }
                    catch (EmptyStackException e) {
                        throw new Exception("Misplaced separator or mismatched parentheses.");
                    }
                    size = this._operation.size();
                    v0 = fn = size < 2 ? null : this._operation.get(size - 2);
                    if (!(fn instanceof FunctionCall)) {
                        throw new Exception("Misplaced separator.");
                    }
                    ++((FunctionCall)fn).arity;
                    break;
                }
                case -5: {
                    op = ExpressionParser.OPERATORS.get(this._strtok.sval);
                    if (op == null) {
                        throw new Exception("Invalid operator " + this._strtok.sval);
                    }
                    if (op.arity != 2 || lastToken == -2 || lastToken == -3 || lastToken == 39 || lastToken == 34 || lastToken == 41 || lastToken == 93 || (op = ExpressionParser.UNARY_ALTERNATES.get(this._strtok.sval)) != null) ** GOTO lbl48
                    throw new Exception("Too few operands for " + this._strtok.sval);
                    while ((top = this._operation.peek()) instanceof Operator) {
                        otop = (Operator)top;
                        if (op.rightAssociative != false ? op.precedence <= otop.precedence : op.precedence < otop.precedence) break;
                        this.handle(this._operation.pop());
lbl48:
                        // 2 sources

                        if (!this._operation.isEmpty()) continue;
                    }
                    this._operation.push(op);
                    break;
                }
                case 40: 
                case 91: {
                    this._operation.push(Character.valueOf((char)token));
                    break;
                }
                case 41: 
                case 93: {
                    if (token == 41) {
                        left = Character.valueOf('(');
                        clazz = FunctionCall.class;
                    } else {
                        left = Character.valueOf('[');
                        clazz = ArrayIndex.class;
                    }
                    try {
                        while (!(top = this._operation.pop()).equals(left)) {
                            this.handle(top);
                        }
                        if (this._operation.isEmpty() || !clazz.isInstance(this._operation.peek())) break;
                        top = this._operation.pop();
                        if (top instanceof FunctionCall && lastToken != 40) {
                            ++((FunctionCall)top).arity;
                        }
                        this.handle(top);
                        break;
                    }
                    catch (EmptyStackException e) {
                        throw new Exception("Mismatched " + (char)token);
                    }
                }
            }
            lastToken = token;
        }
        while (!this._operation.isEmpty()) {
            top = this._operation.pop();
            if (top.equals(Character.valueOf('(')) || top.equals(Character.valueOf('['))) {
                throw new Exception("Mismatched " + top);
            }
            this.handle(top);
        }
        return this._output.isEmpty() != false ? null : (T)this._output.pop();
    }

    protected void handle(Object value) throws Exception {
        T result = value instanceof Double ? this.handleNumber((Double)value) : (value instanceof String ? this.handleString((String)value) : ((Identifier)value).handle(this));
        this._output.push(result);
    }

    protected T handleNumber(double value) throws Exception {
        throw new Exception("Unable to handle number " + value);
    }

    protected T handleString(String value) throws Exception {
        throw new Exception("Unable to handle string " + value);
    }

    protected T handleOperator(String operator, int arity) throws Exception {
        throw new Exception("Unable to handle operator " + operator);
    }

    protected T handleFunctionCall(String function, int arity) throws Exception {
        throw new Exception("Unable to handle function " + function);
    }

    protected T handleArrayIndex(String array) throws Exception {
        throw new Exception("Unable to handle array index " + array);
    }

    protected T handleIdentifier(String name) throws Exception {
        throw new Exception("Unable to handle identifier " + name);
    }

    protected static void addOperator(String name, boolean rightAssociative, int precedence, int arity) {
        OPERATORS.put(name, new Operator(name, rightAssociative, precedence, arity));
    }

    protected static void addUnaryAlternate(String name, boolean rightAssociative, int precedence, int arity) {
        UNARY_ALTERNATES.put(name, new Operator(name, rightAssociative, precedence, arity));
    }

    protected static class ArrayIndex
    extends Identifier {
        public ArrayIndex(String name) {
            super(name);
        }

        @Override
        public <T> T handle(ExpressionParser<T> parser) throws Exception {
            return parser.handleArrayIndex(this.name);
        }
    }

    protected static class FunctionCall
    extends Identifier {
        public int arity;

        public FunctionCall(String name) {
            super(name);
        }

        @Override
        public <T> T handle(ExpressionParser<T> parser) throws Exception {
            return parser.handleFunctionCall(this.name, this.arity);
        }
    }

    protected static class Identifier {
        public final String name;

        public Identifier(String name) {
            this.name = name;
        }

        public <T> T handle(ExpressionParser<T> parser) throws Exception {
            return parser.handleIdentifier(this.name);
        }
    }

    protected static class Operator
    extends Identifier {
        public final boolean rightAssociative;
        public final int precedence;
        public final int arity;

        public Operator(String name, boolean rightAssociative, int precedence, int arity) {
            super(name);
            this.rightAssociative = rightAssociative;
            this.precedence = precedence;
            this.arity = arity;
        }

        @Override
        public <T> T handle(ExpressionParser<T> parser) throws Exception {
            return parser.handleOperator(this.name, this.arity);
        }
    }

    protected static class OperatorStreamTokenizer
    extends StreamTokenizer {
        public static final int TT_NOTHING = -4;
        public static final int TT_OPERATOR = -5;
        protected int _nttype = -4;
        protected String _nsval;
        protected double _nnval;

        public OperatorStreamTokenizer(Reader reader) {
            super(reader);
            this.ordinaryChar(47);
            this.ordinaryChar(45);
            this.wordChars(95, 95);
            this.wordChars(58, 58);
        }

        @Override
        public int nextToken() throws IOException {
            int paired;
            int token;
            if (this._nttype != -4) {
                token = this.ttype = this._nttype;
                this.sval = this._nsval;
                this.nval = this._nnval;
                this._nttype = -4;
            } else {
                token = super.nextToken();
            }
            switch (token) {
                case 37: 
                case 42: 
                case 46: 
                case 47: 
                case 94: {
                    paired = -4;
                    break;
                }
                case 38: 
                case 43: 
                case 45: 
                case 124: {
                    paired = token;
                    break;
                }
                case 33: 
                case 60: 
                case 61: 
                case 62: {
                    paired = 61;
                    break;
                }
                default: {
                    return token;
                }
            }
            int ntoken = super.nextToken();
            if (ntoken == paired) {
                this.sval = new String(new char[]{(char)token, (char)paired});
            } else {
                this._nttype = ntoken;
                this._nsval = this.sval;
                this._nnval = this.nval;
                this.sval = Character.toString((char)token);
            }
            this.ttype = -5;
            return -5;
        }
    }
}

