/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.threerings.math.FloatMath;
import com.threerings.tudey.data.actor.Actor;
import java.util.ArrayList;

public class ActorHistory {
    protected int _duration;
    protected ArrayList<Entry> _entries = new ArrayList();
    protected boolean _seenLast;
    protected int _lastUpdate;

    public ActorHistory(int timestamp, Actor actor, int duration) {
        this._duration = duration;
        this.init(timestamp, actor);
    }

    public void init(int timestamp, Actor actor) {
        this._entries.clear();
        this.record(timestamp, actor, true);
    }

    public void record(int timestamp, Actor actor, boolean updated) {
        this._entries.add(new Entry(timestamp, actor));
        if (updated) {
            this._lastUpdate = timestamp;
            this._seenLast = false;
        }
        int oldest = timestamp - this._duration;
        while (this._entries.get(0).getTimestamp() < oldest) {
            this._entries.remove(0);
        }
    }

    public boolean isCreated(int timestamp) {
        return timestamp >= this._entries.get(0).getActor().getCreated();
    }

    public boolean isDestroyed(int timestamp) {
        return timestamp >= this._entries.get(this._entries.size() - 1).getActor().getDestroyed();
    }

    public boolean get(int timestamp, Actor result, boolean isStatic) {
        int dist;
        if (this._seenLast && isStatic) {
            return false;
        }
        this._seenLast = timestamp >= this._lastUpdate;
        Entry start = this._entries.get(0);
        if (timestamp <= start.getTimestamp()) {
            start.extrapolate(timestamp, result);
            return true;
        }
        int eidx = this._entries.size() - 1;
        Entry end = this._entries.get(eidx);
        if (timestamp >= end.getTimestamp()) {
            end.extrapolate(timestamp, result);
            return true;
        }
        int sidx = 0;
        while ((dist = eidx - sidx) != 1) {
            int midx = dist == 2 ? sidx + 1 : sidx + Math.min(Math.max(FloatMath.round((float)dist * start.getPortion(end, timestamp)), 1), dist - 1);
            Entry middle = this._entries.get(midx);
            if (timestamp < middle.getTimestamp()) {
                eidx = midx;
                end = middle;
                continue;
            }
            sidx = midx;
            start = middle;
        }
        start.interpolate(end, timestamp, result);
        return true;
    }

    public void clear() {
        this._entries.clear();
    }

    protected static class Entry {
        protected int _timestamp;
        protected Actor _actor;

        public Entry(int timestamp, Actor actor) {
            this._timestamp = timestamp;
            this._actor = actor;
        }

        public int getTimestamp() {
            return this._timestamp;
        }

        public Actor getActor() {
            return this._actor;
        }

        public Actor extrapolate(int timestamp, Actor result) {
            return this._actor.extrapolate((float)(timestamp - this._timestamp) / 1000.0f, timestamp, result);
        }

        public Actor interpolate(Entry other, int timestamp, Actor result) {
            return this._actor.interpolate(other.getActor(), this._timestamp, other.getTimestamp(), timestamp, result);
        }

        public float getPortion(Entry other, int timestamp) {
            return (float)(timestamp - this._timestamp) / (float)(other.getTimestamp() - this._timestamp);
        }
    }
}

