/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.threerings.config.ConfigManager;
import com.threerings.math.Ray2D;
import com.threerings.math.Rect;
import com.threerings.math.Vector2f;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.data.actor.Mobile;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.ActorLogic;
import com.threerings.tudey.server.logic.ActorTracker;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.util.ActorAdvancer;
import com.threerings.util.ThreadLocalLogger;
import java.util.Map;

public class MobileLogic
extends ActorLogic
implements TudeySceneManager.TickParticipant,
ActorAdvancer.Environment,
ActorTracker {
    protected ActorAdvancer _advancer;
    protected Logic _tracked;
    protected boolean _inStasis;
    protected int _penetrationCount;
    protected Vector2f _penetrationSum = new Vector2f();

    public float getDirection() {
        return ((Mobile)this.getActor()).getDirection();
    }

    @Override
    public boolean tick(int timestamp) {
        ThreadLocalLogger.log(this._actor, "[start tick]", this._actor.getTranslation());
        int stasisInterval = ((ActorConfig.Mobile)this._config).stasisInterval;
        if (stasisInterval > 0 && timestamp - this._snaptime > stasisInterval) {
            this._scenemgr.removeTickParticipant(this);
            this._inStasis = true;
            this.enteredStasis();
        }
        this._advancer.advance(timestamp);
        if (this._penetrationCount > 0) {
            this.penetratedEnvironment(this._penetrationSum.multLocal(1.0f / (float)this._penetrationCount));
            this._penetrationCount = 0;
            this._penetrationSum.set(Vector2f.ZERO);
        }
        this.updateShape();
        this._scenemgr.triggerIntersectionSensors(timestamp, this);
        ThreadLocalLogger.log(this._actor, "[after tick]", this._actor.getTranslation());
        return true;
    }

    @Override
    public TudeySceneModel getSceneModel() {
        return this._scenemgr.getSceneModel();
    }

    @Override
    public boolean getPenetration(Actor actor, Shape shape, Vector2f result) {
        if (!this._scenemgr.getPenetration(actor, shape, result)) {
            return false;
        }
        ++this._penetrationCount;
        this._penetrationSum.addLocal(result);
        return true;
    }

    @Override
    public boolean getIntersection(Ray2D ray, float length, int mask, int timestamp, Vector2f intersection) {
        return this._scenemgr.getIntersection(ray, length, mask, timestamp, intersection);
    }

    @Override
    public boolean collides(Actor actor, Shape shape) {
        return this._scenemgr.collides(actor, shape);
    }

    public boolean collides(int mask, Shape shape) {
        return this._scenemgr.collides(mask, shape);
    }

    @Override
    public int getDirections(Actor actor, Shape shape) {
        return this._scenemgr.getDirections(actor, shape);
    }

    @Override
    public Actor getSnapshot() {
        if (this._inStasis) {
            this._scenemgr.addTickParticipant(this);
            this._inStasis = false;
            this._advancer.jump(this._scenemgr.getTimestamp());
            this.leftStasis();
        }
        return super.getSnapshot();
    }

    @Override
    public void transfer(Logic source, Map<Object, Object> refs) {
        super.transfer(source, refs);
        MobileLogic msource = (MobileLogic)source;
        this._advancer.transfer(msource._advancer);
        if (this._inStasis == msource._inStasis) {
            return;
        }
        this._inStasis = msource._inStasis;
        if (this._inStasis) {
            this._scenemgr.removeTickParticipant(this);
            this.enteredStasis();
        } else {
            this._scenemgr.addTickParticipant(this);
            this.leftStasis();
        }
    }

    @Override
    protected void didInit() {
        this._advancer = this.createAdvancer();
        ActorConfig.Mobile config = (ActorConfig.Mobile)this._config;
        this._inStasis = config.startInStasis;
        if (!this._inStasis) {
            this._scenemgr.addTickParticipant(this);
            this.leftStasis();
        }
    }

    @Override
    protected void wasDestroyed() {
        super.wasDestroyed();
        this._scenemgr.removeTickParticipant(this);
    }

    protected ActorAdvancer createAdvancer() {
        return this._actor.createAdvancer(this, this._actor.getCreated());
    }

    protected void leftStasis() {
    }

    protected void enteredStasis() {
    }

    protected void penetratedEnvironment(Vector2f penetration) {
    }

    @Override
    protected void updateShape() {
        super.updateShape();
        Rect bounds = this._shape.getBounds();
        float step = bounds.getShortestEdge() / 2.0f;
        ((Mobile)this.getActor()).setMaxStep(step);
    }

    @Override
    public void setTracked(Logic actor) {
        this._tracked = actor;
    }

    @Override
    public Logic getTracked() {
        return this._tracked;
    }

    @Override
    public ConfigManager getConfigManager() {
        return this._scenemgr.getConfigManager();
    }
}

