/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl;

import com.samskivert.util.RunQueue;
import com.threerings.media.image.Colorization;
import com.threerings.opengl.DisplayCanvas;
import com.threerings.opengl.GlApp;
import com.threerings.opengl.Log;
import com.threerings.opengl.gui.DisplayRoot;
import com.threerings.opengl.gui.Root;
import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.PixelFormat;

public abstract class GlDisplayApp
extends GlApp {
    protected Root _displayRoot;

    public GlDisplayApp() {
        Display.setVSyncEnabled((!Boolean.getBoolean("no_vsync") ? 1 : 0) != 0);
    }

    public DisplayMode[] getAvailableDisplayModes() {
        try {
            return Display.getAvailableDisplayModes();
        }
        catch (LWJGLException e) {
            Log.log.warning((Object)"Failed to retrieve available display modes.", new Object[]{e});
            return new DisplayMode[]{Display.getDisplayMode()};
        }
    }

    public void setDisplayModeAndFullscreen(DisplayMode mode) {
        try {
            Display.setDisplayModeAndFullscreen((DisplayMode)mode);
        }
        catch (LWJGLException e) {
            Log.log.warning((Object)"Failed to set display mode/fullscreen.", new Object[]{"mode", mode, e});
        }
    }

    public void setDisplayMode(DisplayMode mode) {
        if (Display.getDisplayMode().equals((Object)mode)) {
            return;
        }
        try {
            Display.setDisplayMode((DisplayMode)mode);
            if (Display.isCreated()) {
                this._renderer.setSize(mode.getWidth(), mode.getHeight());
            }
        }
        catch (LWJGLException e) {
            Log.log.warning((Object)"Failed to set display mode.", new Object[]{"mode", mode, e});
        }
    }

    public void setFullscreen(boolean fullscreen) {
        try {
            Display.setFullscreen((boolean)fullscreen);
        }
        catch (LWJGLException e) {
            Log.log.warning((Object)"Failed to set fullscreen mode.", new Object[]{"fullscreen", fullscreen, e});
        }
    }

    public void setIcon(String ... paths) {
        ByteBuffer[] icons = new ByteBuffer[paths.length];
        int ii = 0;
        while (ii < paths.length) {
            BufferedImage image = this._imgcache.getBufferedImage(paths[ii], new Colorization[0]);
            int[] argb = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
            ByteBuffer buf = BufferUtils.createByteBuffer((int)(argb.length * 4));
            int[] nArray = argb;
            int n = argb.length;
            int n2 = 0;
            while (n2 < n) {
                int pixel = nArray[n2];
                buf.put((byte)(pixel >> 16 & 0xFF));
                buf.put((byte)(pixel >> 8 & 0xFF));
                buf.put((byte)(pixel & 0xFF));
                buf.put((byte)(pixel >> 24 & 0xFF));
                ++n2;
            }
            buf.rewind();
            icons[ii] = buf;
            ++ii;
        }
        Display.setIcon((ByteBuffer[])icons);
    }

    @Override
    public void makeCurrent() {
        try {
            Display.makeCurrent();
        }
        catch (LWJGLException e) {
            Log.log.warning((Object)"Failed to make context current.", new Object[]{e});
        }
    }

    @Override
    public RunQueue getRunQueue() {
        return RunQueue.AWT;
    }

    @Override
    public Root createRoot() {
        if (this._displayRoot == null) {
            this._displayRoot = new DisplayRoot(this);
        }
        return this._displayRoot;
    }

    @Override
    public Root getRoot() {
        return this._displayRoot;
    }

    @Override
    public void startup() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GlDisplayApp.this.init();
            }
        });
    }

    @Override
    public void shutdown() {
        this.willShutdown();
        Keyboard.destroy();
        Mouse.destroy();
        Controllers.destroy();
        Display.destroy();
        System.exit(0);
    }

    @Override
    protected void init() {
        if (!this.createDisplay()) {
            return;
        }
        super.init();
    }

    @Override
    protected void didInit() {
        super.didInit();
        try {
            Keyboard.create();
            DisplayCanvas.patchLwjglKeyboard();
        }
        catch (LWJGLException e) {
            Log.log.warning((Object)"Failed to create keyboard.", new Object[]{e});
        }
        try {
            Mouse.create();
        }
        catch (LWJGLException e) {
            Log.log.warning((Object)"Failed to create mouse.", new Object[]{e});
        }
        try {
            Controllers.create();
        }
        catch (LWJGLException e) {
            Log.log.warning((Object)"Failed to create controllers.", new Object[]{e});
        }
        Runnable updater = new Runnable(){

            @Override
            public void run() {
                if (Display.isCloseRequested()) {
                    GlDisplayApp.this.shutdown();
                }
                GlDisplayApp.this.makeCurrent();
                GlDisplayApp.this.updateFrame();
                EventQueue.invokeLater(this);
            }
        };
        EventQueue.invokeLater(updater);
    }

    @Override
    protected void willShutdown() {
        if (this._displayRoot != null) {
            this._displayRoot.dispose();
            this._displayRoot = null;
        }
        super.willShutdown();
    }

    @Override
    protected void initRenderer() {
        DisplayMode mode = Display.getDisplayMode();
        this._renderer.init(Display.getDrawable(), mode.getWidth(), mode.getHeight());
    }

    protected boolean createDisplay() {
        if (this.attemptCreateDisplay()) {
            return true;
        }
        boolean fullscreen = !Display.isFullscreen();
        Log.log.info((Object)"Couldn't create display; switching fullscreen mode.", new Object[]{"fullscreen", fullscreen});
        try {
            Display.setFullscreen((boolean)fullscreen);
        }
        catch (LWJGLException e) {
            Log.log.warning((Object)"Failed to switch fullscreen mode.", new Object[]{e});
            return false;
        }
        if (this.attemptCreateDisplay()) {
            return true;
        }
        Log.log.warning((Object)"Couldn't find valid pixel format.", new Object[0]);
        return false;
    }

    protected boolean attemptCreateDisplay() {
        PixelFormat[] pixelFormatArray = this.getPixelFormats();
        int n = pixelFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            PixelFormat format = pixelFormatArray[n2];
            try {
                Display.create((PixelFormat)format);
                return true;
            }
            catch (LWJGLException lWJGLException) {
                ++n2;
            }
        }
        return false;
    }

    protected void updateFrame() {
        try {
            this.updateView();
            if (Display.isVisible()) {
                this.renderView();
            }
            Display.update();
        }
        catch (Exception e) {
            Log.log.warning((Object)"Caught exception in frame loop.", new Object[]{e});
        }
    }
}

