/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.sprite;

import com.google.common.collect.Lists;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.samskivert.util.RandomUtil;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.crowd.chat.data.UserMessage;
import com.threerings.expr.Bound;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.expr.SimpleScope;
import com.threerings.expr.Updater;
import com.threerings.math.FloatMath;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector2f;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.event.Event;
import com.threerings.opengl.model.Animation;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.AnimationConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.scene.Scene;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.sprite.EntrySprite;
import com.threerings.tudey.client.sprite.Sprite;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.config.ActorSpriteConfig;
import com.threerings.tudey.data.TudeyOccupantInfo;
import com.threerings.tudey.data.actor.Active;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.data.actor.EntryState;
import com.threerings.tudey.data.actor.HasActor;
import com.threerings.tudey.data.actor.Mobile;
import com.threerings.tudey.shape.ShapeElement;
import com.threerings.tudey.util.ActorAdvancer;
import com.threerings.tudey.util.ActorHistory;
import com.threerings.tudey.util.TudeyContext;
import java.util.ArrayList;
import java.util.List;

public class ActorSprite
extends Sprite
implements TudeySceneView.TickParticipant,
ConfigUpdateListener<ActorConfig>,
HasActor {
    protected ActorHistory _history;
    protected ActorAdvancer _advancer;
    @Scoped
    protected Actor _actor;
    protected ActorConfig _config;
    protected int _removed = Integer.MAX_VALUE;
    @Scoped
    protected Model _model;
    @Scoped
    protected List<Model> _attachedModels;
    protected boolean _attachedVisible = true;
    protected ShapeElement _shape;
    protected Implementation _impl = NULL_IMPLEMENTATION;
    protected boolean _disposed;
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null){};

    public ActorSprite(TudeyContext ctx, TudeySceneView view, int timestamp, Actor actor) {
        super(ctx, view);
        this._actor = (Actor)actor.clone();
        this._advancer = this._actor.maybeCreateAdvancer(ctx, view, timestamp);
        if (this._advancer == null) {
            this._history = new ActorHistory(timestamp, actor, view.getBufferDelay() * 2);
        }
        this._model = new Model(ctx);
        this._model.setUserObject(this);
        this._attachedModels = Lists.newArrayList();
        this._attachedModels.add(this._model);
        this._shape = new ShapeElement(this._actor.getOriginal().shape);
        this._shape.setUserObject(this);
        this._view.addTickParticipant(this);
        this.updateActor();
        if (this.isCreated()) {
            this._view.getScene().add(this._model);
            this._view.getActorSpace().add(this._shape);
            this._model.tick(0.0f);
            this.update();
            if (timestamp == this._actor.getCreated()) {
                this._impl.wasCreated();
            }
        } else {
            this._impl = null;
        }
    }

    public void reinit(int timestamp, Actor actor) {
        actor.copy(this._actor);
        if (this._actor.isClientControlled(this._ctx, this._view)) {
            if (this._advancer == null) {
                this._advancer = this._actor.createAdvancer(this._view, timestamp);
                this._history = null;
            } else {
                this._advancer.init(this._actor, timestamp);
            }
        } else if (this._history == null) {
            this._history = new ActorHistory(timestamp, actor, this._view.getBufferDelay() * 2);
            this._advancer = null;
        } else {
            this._history.init(timestamp, actor);
        }
        this.updateActor();
    }

    public ActorAdvancer getAdvancer() {
        return this._advancer;
    }

    public List<Model> getModels() {
        return this._attachedModels;
    }

    public Implementation getImplementation() {
        return this._impl;
    }

    public void attachScaledModel(Model model) {
        this.attachScaledModel(model, model.getLocalTransform().approximateUniformScale());
    }

    public void attachScaledModel(Model model, float baseScale) {
        Transform3D transform = model.getLocalTransform();
        transform.setScale(baseScale * this.getAttachedScale());
        transform.promote(2);
        this.attachModel(model);
    }

    public void attachModel(Model model) {
        if (!this._attachedModels.contains(model) && !this._disposed) {
            this._attachedModels.add(model);
            if (this._impl != null && this._attachedVisible) {
                ActorSprite.updateAttachedTransform(model, this._model.getLocalTransform());
                this._view.getScene().add(model);
            }
        }
    }

    public void detachModel(Model model) {
        if (model == this._model) {
            return;
        }
        if (this._attachedModels.remove(model) && this._impl != null && this._attachedVisible) {
            this._view.getScene().remove(model);
        }
    }

    public void setAttachedVisibility(boolean visible) {
        if (this._attachedVisible != visible) {
            this._attachedVisible = visible;
            for (Model model : this._attachedModels) {
                if (model == this._model) continue;
                if (this._attachedVisible) {
                    ActorSprite.updateAttachedTransform(model, this._model.getLocalTransform());
                    this._view.getScene().add(model);
                    continue;
                }
                this._view.getScene().remove(model);
            }
        }
    }

    public void spawnAttachedTransientModel(ConfigReference<ModelConfig> ref) {
        this.spawnAttachedTransientModel(ref, true);
    }

    public void spawnAttachedTransientModel(ConfigReference<ModelConfig> ref, final boolean rotate) {
        if (this._impl == null) {
            return;
        }
        final Scene.Transient trans = this._view.getScene().getFromTransientPool(ref);
        trans.setUpdater(new Updater(){

            @Override
            public void update() {
                ActorSprite.updateAttachedTransform(trans, ActorSprite.this._model.getLocalTransform(), rotate);
            }
        });
        ActorSprite.updateAttachedTransform(trans, this._model.getLocalTransform(), rotate);
        this._view.getScene().add(trans);
    }

    public Model spawnTransientModel(ConfigReference<ModelConfig> ref) {
        return this.spawnTransientModel(ref, true);
    }

    public Model spawnTransientModel(ConfigReference<ModelConfig> ref, boolean rotate) {
        return this.spawnOffsetTransientModel(ref, rotate, 0.0f);
    }

    public Model spawnOffsetTransientModel(ConfigReference<ModelConfig> ref, boolean rotate) {
        return this.spawnOffsetTransientModel(ref, rotate, this.getAttachedScale() - 1.0f);
    }

    public void update(int timestamp, Actor actor, boolean updated) {
        if (this._advancer == null) {
            this._history.record(timestamp, actor, updated || !this.isStatic(actor));
        } else {
            this._advancer.init((Actor)actor.copy(this._advancer.getActor()), timestamp);
        }
    }

    public void remove(int timestamp) {
        this._removed = timestamp;
    }

    public void occupantEntered(TudeyOccupantInfo info) {
        if (this._impl != null) {
            this._impl.occupantEntered(info);
        }
    }

    public void occupantLeft(TudeyOccupantInfo info) {
        if (this._impl != null) {
            this._impl.occupantLeft(info);
        }
    }

    public void occupantUpdated(TudeyOccupantInfo oinfo, TudeyOccupantInfo ninfo) {
        if (this._impl != null) {
            this._impl.occupantUpdated(oinfo, ninfo);
        }
    }

    public boolean displayMessage(UserMessage msg, boolean alreadyDisplayed) {
        return this._impl != null && this._impl.displayMessage(msg, alreadyDisplayed);
    }

    public void clearMessages() {
        if (this._impl != null) {
            this._impl.clearMessages();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean tick(int delayedTime) {
        if (this._disposed) {
            return false;
        }
        boolean updated = this.updateActor();
        if (this._impl == null) {
            if (!this.isCreated()) return true;
            for (Model attached : this._attachedModels) {
                if (!this._attachedVisible && attached != this._model) continue;
                this._view.getScene().add(attached);
            }
            this._view.getActorSpace().add(this._shape);
            this._impl = NULL_IMPLEMENTATION;
            this.update();
            this._impl.wasCreated();
        } else if (this._impl.shouldUpdate(updated, this._actor)) {
            this.update();
        }
        if (this.isDestroyed()) {
            this._impl.willBeDestroyed();
            this.dispose();
            return false;
        }
        if (!this.isRemoved()) return true;
        this.dispose();
        return false;
    }

    @Override
    public void configUpdated(ConfigEvent<ActorConfig> event) {
        this.updateFromConfig();
        this._impl.update(this._actor);
    }

    @Override
    public Actor getActor() {
        return this._actor;
    }

    @Override
    public Model getModel() {
        return this._model;
    }

    @Override
    public int getFloorFlags() {
        return this._impl.getFloorFlags();
    }

    @Override
    public int getFloorMask() {
        return this._impl.getFloorMask();
    }

    @Override
    public boolean isHoverable() {
        return this._impl.isHoverable();
    }

    @Override
    public boolean isClickable() {
        return this._impl.isClickable();
    }

    @Override
    public String getTooltipText() {
        return this._impl.getTooltipText();
    }

    @Override
    public float getTooltipTimeout() {
        return this._impl.getTooltipTimeout();
    }

    @Override
    public String getTooltipWindowStyle() {
        return this._impl.getTooltipWindowStyle();
    }

    @Override
    public Component createTooltipComponent(String tiptext) {
        return this._impl.createTooltipComponent(tiptext);
    }

    @Override
    public boolean dispatchEvent(Event event) {
        return this._impl.dispatchEvent(event);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._impl != null) {
            this._impl.dispose();
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        for (Model attached : this._attachedModels) {
            if (!this._attachedVisible && this._model != attached) continue;
            this._view.getScene().remove(attached);
        }
        if (this._history != null) {
            this._history.clear();
        }
        this._attachedModels.clear();
        this._view.getActorSpace().remove(this._shape);
        this._model.setUserObject(null);
        this._disposed = true;
    }

    protected boolean updateActor() {
        if (this._advancer == null) {
            return this._history.get(this._view.getDelayedTime(), this._actor, this.isStatic(this._actor));
        }
        this._advancer.advance(this._view.getAdvancedTime());
        return true;
    }

    protected boolean isCreated() {
        return this._advancer == null ? this._history.isCreated(this._view.getDelayedTime()) : this._view.getAdvancedTime() >= this._actor.getCreated();
    }

    protected boolean isDestroyed() {
        return this._advancer == null ? this._history.isDestroyed(this._view.getDelayedTime()) : this._view.getAdvancedTime() >= this._actor.getDestroyed();
    }

    protected boolean isRemoved() {
        return this.getActorTime() >= this._removed;
    }

    protected int getActorTime() {
        return this._advancer == null ? this._view.getDelayedTime() : this._view.getAdvancedTime();
    }

    protected boolean isStatic(Actor actor) {
        return this._impl != null && this._impl.isStatic(actor);
    }

    protected void update() {
        this.setConfig(this._actor.getConfig());
        this._impl.update(this._actor);
        this.updateShape();
    }

    protected void setConfig(ConfigReference<ActorConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(ActorConfig.class, ref));
    }

    protected void setConfig(ActorConfig config) {
        if (this._config == config) {
            return;
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    protected void updateFromConfig() {
        Implementation nimpl = this._config == null ? null : this._config.getSpriteImplementation(this._ctx, this, this._impl);
        Implementation implementation = nimpl = nimpl == null ? NULL_IMPLEMENTATION : nimpl;
        if (this._impl != nimpl) {
            if (this._impl != null) {
                this._impl.dispose();
            }
            this._impl = nimpl;
        }
    }

    protected void updateShape() {
        this._shape.getTransform().set(this._actor.getTranslation(), this._actor.getRotation(), 1.0f);
        this._shape.setConfig(this._actor.getOriginal().shape);
    }

    protected float getAttachedScale() {
        return this._impl == null ? 1.0f : this._impl.getAttachedScale();
    }

    public Model spawnOffsetTransientModel(ConfigReference<ModelConfig> ref, boolean rotate, float offset) {
        if (ref != null) {
            Transform3D mxform = this._model.getLocalTransform();
            Transform3D txform = new Transform3D(2);
            mxform.extractTranslation(txform.getTranslation());
            if (offset != 0.0f) {
                txform.getTranslation().z += offset;
            }
            if (rotate) {
                mxform.extractRotation(txform.getRotation());
            }
            return this._view.getScene().spawnTransient(ref, txform);
        }
        return null;
    }

    protected static void updateAttachedTransform(Model attached, Transform3D mtrans) {
        ActorSprite.updateAttachedTransform(attached, mtrans, true);
    }

    protected static void updateAttachedTransform(Model attached, Transform3D mtrans, boolean rotate) {
        Transform3D atrans = attached.getLocalTransform();
        atrans.set(mtrans.getTranslation(), rotate ? mtrans.getRotation() : Quaternion.IDENTITY, atrans.approximateUniformScale());
        attached.updateBounds();
    }

    public ShapeElement getShapeElement() {
        return this._shape;
    }

    protected static void flash(TudeySceneView view, final ColorState colorState, final Color4f color, final Color4f baseColor, long delay, final long duration) {
        final long start = System.currentTimeMillis() + delay;
        view.addTickParticipant(new TudeySceneView.TickParticipant(){
            protected long _astart;

            @Override
            public boolean tick(int delayedTime) {
                long now = System.currentTimeMillis();
                if (now < start) {
                    return true;
                }
                if (this._astart == 0L) {
                    this._astart = now;
                }
                long elapsed = now - this._astart;
                float t = (float)elapsed / (float)duration;
                color.lerp(baseColor, Math.min(t * t, 1.0f), colorState.getColor());
                colorState.setDirty(true);
                return elapsed < duration;
            }
        }, true);
    }

    public static class Acting
    extends Moving {
        protected int _lastActivity;
        protected int _lastActivityStarted;
        protected IntMap<Activity> _activities = IntMaps.newHashIntMap();
        protected Activity _activity;

        public Acting(TudeyContext ctx, Scope parentScope, ActorSpriteConfig.Moving config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        @Override
        public void update(Actor actor) {
            Active active = (Active)actor;
            int activity = active.getActivity();
            int started = active.getActivityStarted();
            if (activity != this._lastActivity || started > this._lastActivityStarted) {
                this.activityChanged();
                Activity previous = this._activity;
                this._lastActivity = activity;
                Activity next = (Activity)this._activities.get(this._lastActivity);
                this._lastActivityStarted = started;
                if (this._activity != null) {
                    this._activity.stop(next);
                }
                if ((this._activity = next) != null) {
                    this._activity.start(previous);
                }
            }
            if (this._activity != null) {
                this._activity.update();
            }
            super.update(actor);
        }

        @Override
        protected Animation getBase(Mobile actor) {
            return this._activity != null && this._activity.getPriority() == 0 ? null : super.getBase(actor);
        }

        protected Acting(TudeyContext ctx, Scope parentScope) {
            super(ctx, parentScope);
        }

        protected void activityChanged() {
        }

        protected class Activity {
            protected Animation[] _anims;
            protected int _idx;

            public Activity(String ... anims) {
                ArrayList list = Lists.newArrayListWithCapacity((int)anims.length);
                String[] stringArray = anims;
                int n = anims.length;
                int n2 = 0;
                while (n2 < n) {
                    String anim = stringArray[n2];
                    Animation animation = Acting.this._model.getAnimation(anim);
                    if (animation != null) {
                        list.add(animation);
                    }
                    ++n2;
                }
                this._anims = list.toArray(new Animation[list.size()]);
            }

            public Activity(ConfigReference<AnimationConfig> anim) {
                this.setAnimation(anim);
            }

            public Activity(ConfigReference<AnimationConfig> ... anims) {
                ArrayList list = Lists.newArrayListWithCapacity((int)anims.length);
                ConfigReference<AnimationConfig>[] configReferenceArray = anims;
                int n = anims.length;
                int n2 = 0;
                while (n2 < n) {
                    Animation animation;
                    ConfigReference<AnimationConfig> anim = configReferenceArray[n2];
                    Animation animation2 = animation = anim == null ? null : Acting.this._model.createAnimation(anim);
                    if (anim != null) {
                        list.add(animation);
                    }
                    ++n2;
                }
                this._anims = list.toArray(new Animation[list.size()]);
            }

            public Activity(Animation ... anims) {
                this._anims = anims;
            }

            public Animation[] getAnimations() {
                return this._anims;
            }

            public int getPriority() {
                return this._anims.length == 0 ? 0 : this._anims[0].getPriority();
            }

            public void start(Activity previous) {
                if (this._anims.length > 0) {
                    this._idx = 0;
                    this._anims[0].start();
                }
            }

            public void stop(Activity next) {
                if (this._idx < this._anims.length) {
                    this._anims[this._idx].stop();
                }
            }

            public void update() {
                if (this._idx < this._anims.length - 1 && !this._anims[this._idx].isPlaying()) {
                    this._anims[++this._idx].start();
                }
            }

            protected void setAnimation(ConfigReference<AnimationConfig> anim) {
                Animation[] animationArray;
                Animation mation;
                Animation animation = mation = anim == null ? null : Acting.this._model.createAnimation(anim);
                if (mation == null) {
                    animationArray = new Animation[]{};
                } else {
                    Animation[] animationArray2 = new Animation[1];
                    animationArray = animationArray2;
                    animationArray2[0] = mation;
                }
                this._anims = animationArray;
            }
        }
    }

    public static abstract class Implementation
    extends SimpleScope {
        public Implementation(Scope parentScope) {
            super(parentScope);
        }

        public int getFloorFlags() {
            return 0;
        }

        public int getFloorMask() {
            return 255;
        }

        public boolean isHoverable() {
            return false;
        }

        public boolean isClickable() {
            return false;
        }

        public String getTooltipText() {
            return null;
        }

        public float getTooltipTimeout() {
            return -1.0f;
        }

        public String getTooltipWindowStyle() {
            return "Default/TooltipWindow";
        }

        public Component createTooltipComponent(String tiptext) {
            return null;
        }

        public boolean dispatchEvent(Event event) {
            return false;
        }

        public boolean shouldUpdate(boolean updated, Actor actor) {
            return updated;
        }

        public void update(Actor actor) {
        }

        public void wasCreated() {
        }

        public void willBeDestroyed() {
        }

        public void occupantEntered(TudeyOccupantInfo info) {
        }

        public void occupantLeft(TudeyOccupantInfo info) {
        }

        public void occupantUpdated(TudeyOccupantInfo oinfo, TudeyOccupantInfo ninfo) {
        }

        public boolean displayMessage(UserMessage msg, boolean alreadyDisplayed) {
            return false;
        }

        public void clearMessages() {
        }

        public float getAttachedScale() {
            return 1.0f;
        }

        public boolean isStatic(Actor actor) {
            return actor.getOriginal().isStatic;
        }

        @Override
        public String getScopeName() {
            return "impl";
        }
    }

    public static class Moving
    extends Original {
        private Animation _lastIdle;
        protected Animation[] _idles;
        protected float[] _idleWeights;
        protected Animation[][] _movements;
        protected Animation[][] _rotations;
        protected Animation _currentIdle;

        public Moving(TudeyContext ctx, Scope parentScope, ActorSpriteConfig.Moving config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        @Override
        public void setConfig(ActorSpriteConfig config) {
            super.setConfig(config);
            ActorSpriteConfig.Moving mconfig = (ActorSpriteConfig.Moving)config;
            this._idles = this.resolve(mconfig.idles);
            this._idleWeights = mconfig.getIdleWeights();
            this._movements = this.resolve(mconfig.movements);
            this._rotations = this.resolve(mconfig.rotations);
        }

        @Override
        public void update(Actor actor) {
            super.update(actor);
            Animation base = this.getBase((Mobile)actor);
            if (base != null && !base.isPlaying()) {
                base.start();
            }
        }

        @Override
        public float getAttachedScale() {
            return ((ActorSpriteConfig.Moving)this._config).attachedScale;
        }

        @Override
        public boolean isStatic(Actor actor) {
            return false;
        }

        protected Moving(TudeyContext ctx, Scope parentScope) {
            super(ctx, parentScope);
        }

        protected Animation[] resolve(ActorSpriteConfig.WeightedAnimation[] weighted) {
            Animation[] anims = new Animation[weighted.length];
            int ii = 0;
            while (ii < anims.length) {
                anims[ii] = this._model.createAnimation(weighted[ii].animation);
                ++ii;
            }
            return anims;
        }

        protected Animation[][] resolve(ActorSpriteConfig.MovementSet[] sets) {
            Animation[][] anims = new Animation[sets.length][];
            int ii = 0;
            while (ii < anims.length) {
                anims[ii] = sets[ii].resolve(this._model);
                ++ii;
            }
            return anims;
        }

        protected Animation[][] resolve(ActorSpriteConfig.RotationSet[] sets) {
            Animation[][] anims = new Animation[sets.length][];
            int ii = 0;
            while (ii < anims.length) {
                anims[ii] = sets[ii].resolve(this._model);
                ++ii;
            }
            return anims;
        }

        protected Animation getBase(Mobile actor) {
            Animation anim;
            if (actor.isSet(2)) {
                anim = this.getMovement(actor);
                if (this._lastIdle != null && this._lastIdle.isPlaying()) {
                    this._lastIdle.stop();
                }
                if (anim != null) {
                    return anim;
                }
            }
            if (actor.getTurnDirection() != 0) {
                anim = this.getRotation(actor);
                if (this._lastIdle != null && this._lastIdle.isPlaying()) {
                    this._lastIdle.stop();
                }
                if (anim != null) {
                    return anim;
                }
            }
            this._lastIdle = this.getIdle();
            return this._lastIdle;
        }

        protected Animation getIdle() {
            return Moving.getWeightedAnimation(this._idles, this._idleWeights);
        }

        protected Animation getMovement(Mobile actor) {
            ActorSpriteConfig.Moving config = (ActorSpriteConfig.Moving)this._config;
            return Moving.getMovement(actor, config.scale, config.movements, this._movements);
        }

        protected Animation getRotation(Mobile actor) {
            ActorSpriteConfig.Moving config = (ActorSpriteConfig.Moving)this._config;
            return Moving.getRotation(actor, config.rotations, this._rotations);
        }

        protected static Animation getWeightedAnimation(Animation[] anims, float[] weights) {
            if (anims.length == 0) {
                return null;
            }
            Animation[] animationArray = anims;
            int n = anims.length;
            int n2 = 0;
            while (n2 < n) {
                Animation anim = animationArray[n2];
                if (anim.isPlaying()) {
                    return anim;
                }
                ++n2;
            }
            return anims[RandomUtil.getWeightedIndex((float[])weights)];
        }

        protected static Animation getMovement(Mobile actor, float scale, ActorSpriteConfig.MovementSet[] sets, Animation[][] movements) {
            float angle;
            int mlen = movements.length;
            if (mlen == 0) {
                return null;
            }
            float sspeed = actor.getSpeed() / scale;
            int idx = 0;
            if (mlen > 1) {
                float cdiff = Math.abs(sspeed - sets[0].speed);
                int ii = 1;
                while (ii < sets.length) {
                    float diff = Math.abs(sspeed - sets[ii].speed);
                    if (diff < cdiff) {
                        cdiff = diff;
                        idx = ii;
                    }
                    ++ii;
                }
            }
            Animation movement = (angle = (FloatMath.getAngularDifference(actor.getDirection(), actor.getRotation()) / 1.5707964f + 2.5f) % 4.0f) <= 0.01f || angle >= 2.99f ? movements[idx][3] : (angle < 0.99f ? movements[idx][0] : (angle <= 2.01f ? movements[idx][1] : movements[idx][2]));
            movement.setSpeed(sspeed / sets[idx].speed);
            return movement;
        }

        protected static Animation getRotation(Mobile actor, ActorSpriteConfig.RotationSet[] sets, Animation[][] rotations) {
            int rlen = rotations.length;
            if (rlen == 0) {
                return null;
            }
            float rate = actor.getTurnRate();
            int idx = 0;
            if (rlen > 1) {
                float cdiff = Math.abs(rate - sets[0].rate);
                int ii = 1;
                while (ii < sets.length) {
                    float diff = Math.abs(rate - sets[ii].rate);
                    if (diff < cdiff) {
                        cdiff = diff;
                        idx = ii;
                    }
                    ++ii;
                }
            }
            Animation rotation = rotations[idx][actor.getTurnDirection() > 0 ? 0 : 1];
            rotation.setSpeed(rate / sets[idx].rate);
            return rotation;
        }
    }

    public static class Original
    extends Implementation {
        protected TudeyContext _ctx;
        protected ActorSpriteConfig _config;
        protected boolean _initZ;
        protected ColorState _colorState = new ColorState();
        @Bound
        protected Model _model;
        @Bound
        protected TudeySceneView _view;
        @Bound
        protected List<Model> _attachedModels;

        public Original(TudeyContext ctx, Scope parentScope, ActorSpriteConfig config) {
            this(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(ActorSpriteConfig config) {
            this._config = config;
            this._model.setConfig(this.getModelConfig());
            this._model.getLocalTransform().setScale(config.scale);
        }

        @Override
        public int getFloorFlags() {
            return this._config.floorFlags;
        }

        @Override
        public int getFloorMask() {
            return this._config.floorMask;
        }

        @Override
        public Component createTooltipComponent(String tiptext) {
            return Component.createDefaultTooltipComponent(this._ctx, tiptext);
        }

        @Override
        public void update(Actor actor) {
            Vector2f translation = actor.getTranslation();
            Transform3D mtrans = this._model.getLocalTransform();
            float oldZ = mtrans.getTranslation().z;
            this._view.getFloorTransform(translation.x, translation.y, actor.getRotation(), this._config.floorMask, mtrans);
            if (this._config.smoothZ > 0.0f && !this._initZ) {
                float newZ = mtrans.getTranslation().z;
                mtrans.getTranslation().z = newZ = oldZ + Math.signum(newZ - oldZ) * this._config.smoothZ;
            }
            this._initZ = true;
            mtrans.promote(2);
            this._model.updateBounds();
            int ii = 1;
            int nn = this._attachedModels.size();
            while (ii < nn) {
                ActorSprite.updateAttachedTransform(this._attachedModels.get(ii), mtrans);
                ++ii;
            }
        }

        @Override
        public void wasCreated() {
            ((ActorSprite)this.getParentScope()).spawnTransientModel(this._config.creationTransient);
        }

        @Override
        public void willBeDestroyed() {
            ((ActorSprite)this.getParentScope()).spawnTransientModel(this._config.destructionTransient);
        }

        protected Original(TudeyContext ctx, Scope parentScope) {
            super(parentScope);
            this._ctx = ctx;
            this._model.setColorState(this._colorState);
        }

        protected ConfigReference<ModelConfig> getModelConfig() {
            return this._config.model;
        }

        protected boolean isControlled() {
            return ((ActorSprite)this.getParentScope()).getAdvancer() != null;
        }

        public void flash(Color4f color, Color4f baseColor, long delay, long duration) {
            ActorSprite.flash(this._view, this._colorState, color, baseColor, delay, duration);
        }
    }

    public static class StatefulEntry
    extends Original {
        protected Model _entryModel;
        protected Animation[] _states;
        protected int _lastStateEntered;

        public StatefulEntry(TudeyContext ctx, Scope parentScope, ActorSpriteConfig.StatefulEntry config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        @Override
        public void setConfig(ActorSpriteConfig config) {
            super.setConfig(config);
            EntryState estate = (EntryState)((ActorSprite)this._parentScope).getActor();
            EntrySprite esprite = this._view.getEntrySprite(estate.getKey());
            Model model = this._entryModel = esprite == null ? null : esprite.getModel();
            if (this._entryModel == null) {
                return;
            }
            ActorSpriteConfig.StatefulEntry sconfig = (ActorSpriteConfig.StatefulEntry)config;
            this._states = new Animation[sconfig.states.length];
            int ii = 0;
            while (ii < this._states.length) {
                this._states[ii] = this._entryModel.createAnimation(sconfig.states[ii].animation);
                ++ii;
            }
        }

        @Override
        public void update(Actor actor) {
            super.update(actor);
            if (this._entryModel == null) {
                return;
            }
            EntryState estate = (EntryState)actor;
            int entered = estate.getStateEntered();
            if (entered > this._lastStateEntered) {
                Animation anim;
                int state = estate.getState();
                Animation animation = anim = state < this._states.length ? this._states[state] : null;
                if (anim != null) {
                    anim.start();
                    anim.tick((float)(this._view.getDelayedTime() - entered) / 1000.0f);
                }
                this._lastStateEntered = entered;
            }
        }
    }

    public static class StatefulModelEntry
    extends Original {
        protected Model _entryModel;
        protected int _lastStateEntered;

        public StatefulModelEntry(TudeyContext ctx, Scope parentScope, ActorSpriteConfig.StatefulModelEntry config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        @Override
        public void setConfig(ActorSpriteConfig config) {
            super.setConfig(config);
            EntryState estate = (EntryState)((ActorSprite)this._parentScope).getActor();
            EntrySprite esprite = this._view.getEntrySprite(estate.getKey());
            this._entryModel = esprite == null ? null : esprite.getModel();
        }

        @Override
        public void update(Actor actor) {
            super.update(actor);
            ActorSpriteConfig.StatefulModelEntry config = (ActorSpriteConfig.StatefulModelEntry)this._config;
            EntryState estate = (EntryState)actor;
            int entered = estate.getStateEntered();
            if (entered > this._lastStateEntered) {
                ConfigReference<ModelConfig> model;
                int state = estate.getState();
                ConfigReference<ModelConfig> configReference = model = state < config.states.length ? config.states[state].model : null;
                if (model != null && this._entryModel != null) {
                    this._entryModel.setConfig(model);
                }
                this._lastStateEntered = entered;
            }
        }
    }
}

