/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.util;

import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.renderer.util.BatchFactory;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.SimpleTransformable;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;

public class Grid
extends SimpleTransformable {
    public Grid(GlContext ctx, int lines, float spacing) {
        this._ctx = ctx;
        this._queue = ctx.getCompositor().getQueue("Opaque");
        FloatBuffer vbuf = BufferUtils.createFloatBuffer((int)(lines * 2 * 2 * 3));
        float extent = (float)(lines - 1) * spacing * 0.5f;
        int ii = 0;
        while (ii < lines) {
            float y = (float)ii * spacing - extent;
            vbuf.put(-extent).put(y).put(0.0f);
            vbuf.put(extent).put(y).put(0.0f);
            ++ii;
        }
        ii = 0;
        while (ii < lines) {
            float x = (float)ii * spacing - extent;
            vbuf.put(x).put(-extent).put(0.0f);
            vbuf.put(x).put(extent).put(0.0f);
            ++ii;
        }
        vbuf.rewind();
        this._batch = BatchFactory.createLineBatch(this._ctx.getRenderer(), vbuf);
        RenderState.copy(this.createStates(), this._batch.getStates());
    }

    public Color4f getColor() {
        ColorState cstate = (ColorState)this._batch.getStates()[2];
        return cstate.getColor();
    }

    @Override
    protected RenderState[] createStates() {
        RenderState[] states = super.createStates();
        states[2] = new ColorState();
        return states;
    }
}

