/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.expr.Updater;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Light;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import java.util.List;

@EditorTypes(value={Directional.class, Point.class, Spot.class})
public abstract class LightConfig
extends DeepObject
implements Exportable {
    @Editable(hgroup="p")
    public Colors colors = new Colors();

    public LightConfig(LightConfig other) {
        this.colors.ambient.set(other.colors.ambient);
        this.colors.diffuse.set(other.colors.diffuse);
        this.colors.specular.set(other.colors.specular);
    }

    public LightConfig() {
    }

    public Light createLight(GlContext ctx, Scope scope, boolean world, List<Updater> updaters) {
        Light light = new Light();
        light.ambient.set(this.colors.ambient);
        light.diffuse.set(this.colors.diffuse);
        light.specular.set(this.colors.specular);
        light.position.set(0.0f, 0.0f, 0.0f, 0.0f);
        updaters.add(this.createUpdater(ctx, scope, world, light));
        return light;
    }

    protected abstract Updater createUpdater(GlContext var1, Scope var2, boolean var3, Light var4);

    public static class Attenuation
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0, step=0.01)
        public float constant = 1.0f;
        @Editable(min=0.0, step=0.01)
        public float linear;
        @Editable(min=0.0, step=0.01)
        public float quadratic;
    }

    public static class Colors
    extends DeepObject
    implements Exportable {
        @Editable
        public Color4f ambient = new Color4f(0.0f, 0.0f, 0.0f, 1.0f);
        @Editable
        public Color4f diffuse = new Color4f(1.0f, 1.0f, 1.0f, 1.0f);
        @Editable
        public Color4f specular = new Color4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static class Directional
    extends LightConfig {
        @Editable(mode="normalized", hgroup="p")
        public Vector3f direction = new Vector3f(0.0f, 0.0f, 1.0f);

        public Directional(LightConfig other) {
            super(other);
        }

        public Directional() {
        }

        @Override
        protected Updater createUpdater(GlContext ctx, Scope scope, boolean world, final Light light) {
            final Transform3D transform = ScopeUtil.resolve(scope, world ? "worldTransform" : "viewTransform", new Transform3D());
            return new Updater(){
                protected Vector3f _dir = new Vector3f();

                @Override
                public void update() {
                    transform.transformVector(Directional.this.direction, this._dir);
                    light.position.set(this._dir.x, this._dir.y, this._dir.z, 0.0f);
                    light.dirty = true;
                }
            };
        }
    }

    public static class Falloff
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0, max=128.0)
        public float exponent;
        @Editable(min=0.0, max=90.0)
        public float cutoff;
    }

    public static class Point
    extends LightConfig {
        @Editable(step=0.01, hgroup="p")
        public Vector3f position = new Vector3f();
        @Editable(hgroup="p")
        public Attenuation attenuation = new Attenuation();

        public Point(Point other) {
            super(other);
            this.position.set(other.position);
            this.attenuation.constant = other.attenuation.constant;
            this.attenuation.linear = other.attenuation.linear;
            this.attenuation.quadratic = other.attenuation.quadratic;
        }

        public Point(LightConfig other) {
            super(other);
        }

        public Point() {
        }

        @Override
        public Light createLight(GlContext ctx, Scope scope, boolean world, List<Updater> updaters) {
            Light light = super.createLight(ctx, scope, world, updaters);
            light.constantAttenuation = this.attenuation.constant;
            light.linearAttenuation = this.attenuation.linear;
            light.quadraticAttenuation = this.attenuation.quadratic;
            light.position.w = 1.0f;
            return light;
        }

        @Override
        protected Updater createUpdater(GlContext ctx, Scope scope, boolean world, final Light light) {
            final Transform3D transform = ScopeUtil.resolve(scope, world ? "worldTransform" : "viewTransform", new Transform3D());
            return new Updater(){
                protected Vector3f _pos = new Vector3f();

                @Override
                public void update() {
                    transform.transformPoint(Point.this.position, this._pos);
                    light.position.set(this._pos.x, this._pos.y, this._pos.z, 1.0f);
                    light.dirty = true;
                }
            };
        }
    }

    public static class Spot
    extends Point {
        @Editable(mode="normalized", hgroup="d")
        public Vector3f direction = new Vector3f(0.0f, 0.0f, -1.0f);
        @Editable(hgroup="d")
        public Falloff falloff = new Falloff();

        public Spot(Point other) {
            super(other);
        }

        public Spot(LightConfig other) {
            super(other);
        }

        public Spot() {
        }

        @Override
        public Light createLight(GlContext ctx, Scope scope, boolean world, List<Updater> updaters) {
            Light light = super.createLight(ctx, scope, world, updaters);
            light.spotExponent = this.falloff.exponent;
            light.spotCutoff = this.falloff.cutoff;
            return light;
        }

        @Override
        protected Updater createUpdater(GlContext ctx, Scope scope, boolean world, final Light light) {
            final Transform3D transform = ScopeUtil.resolve(scope, world ? "worldTransform" : "viewTransform", new Transform3D());
            return new Updater(){
                protected Vector3f _pos = new Vector3f();

                @Override
                public void update() {
                    transform.transformPoint(Spot.this.position, this._pos);
                    light.position.set(this._pos.x, this._pos.y, this._pos.z, 1.0f);
                    transform.transformVector(Spot.this.direction, light.spotDirection);
                    light.dirty = true;
                }
            };
        }
    }
}

