/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.probs;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.opengl.effect.ColorFunction;
import com.threerings.opengl.effect.Easing;
import com.threerings.probs.ColorVariable;
import com.threerings.util.DeepObject;

@EditorTypes(value={Fixed.class, VariableConstant.class, VariableLinear.class}, label="mode")
public abstract class ColorFunctionVariable
extends DeepObject
implements Exportable,
Streamable {
    public abstract ColorFunction getValue(ColorFunction var1);

    public static class VariableLinear
    extends ColorFunctionVariable {
        @Editable(mode="%INHERIT%")
        public ColorVariable start = new ColorVariable.Constant();
        @Editable(mode="%INHERIT%")
        public ColorVariable end = new ColorVariable.Constant();
        @Editable
        public Easing easing = new Easing.None();

        @Override
        public ColorFunction getValue(ColorFunction result) {
            ColorFunction.Linear lresult = result instanceof ColorFunction.Linear ? (ColorFunction.Linear)result : new ColorFunction.Linear();
            this.start.getValue(lresult.start);
            this.end.getValue(lresult.end);
            lresult.easing = this.easing.copy(lresult.easing);
            return lresult;
        }
    }

    public static class VariableConstant
    extends ColorFunctionVariable {
        @Editable(mode="%INHERIT%")
        public ColorVariable value = new ColorVariable.Constant();

        @Override
        public ColorFunction getValue(ColorFunction result) {
            ColorFunction.Constant cresult = result instanceof ColorFunction.Constant ? (ColorFunction.Constant)result : new ColorFunction.Constant();
            this.value.getValue(cresult.value);
            return cresult;
        }
    }

    public static class Fixed
    extends ColorFunctionVariable {
        @Editable(mode="%INHERIT%")
        public ColorFunction function = new ColorFunction.Constant();

        public Fixed(ColorFunction function) {
            this.function = function;
        }

        public Fixed() {
        }

        @Override
        public ColorFunction getValue(ColorFunction result) {
            return this.function.copy(result);
        }
    }
}

