/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer;

import com.samskivert.util.IntListUtil;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public abstract class Texture {
    protected Renderer _renderer;
    protected int _id;
    protected int _target;
    protected int _format;
    protected int _minFilter = 9986;
    protected int _magFilter = 9729;
    protected float _maxAnisotropy = 1.0f;
    protected int _wrapS = 10497;
    protected int _wrapT = 10497;
    protected int _wrapR = 10497;
    protected Color4f _borderColor = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    protected boolean _generateMipmaps;
    protected int _compareMode = 0;
    protected int _compareFunc = 515;
    protected int _depthMode = 6409;
    protected int[] _bytes = new int[0];
    protected static FloatBuffer _vbuf = BufferUtils.createFloatBuffer((int)16);
    protected static final int[] FORMATS = new int[]{6409, 6410, 6407, 6408};
    protected static final int[] COMPRESSED_FORMATS = new int[]{34026, 34027, 34029, 34030};

    public Texture(Renderer renderer, int target) {
        this._renderer = renderer;
        IntBuffer idbuf = BufferUtils.createIntBuffer((int)1);
        GL11.glGenTextures((IntBuffer)idbuf);
        this._id = idbuf.get(0);
        this._target = target;
        this._renderer.textureCreated();
    }

    public final int getId() {
        return this._id;
    }

    public final int getTarget() {
        return this._target;
    }

    public int getFormat() {
        return this._format;
    }

    public boolean hasAlpha() {
        return this._format == 6406 || this._format == 34025 || this._format == 6410 || this._format == 34027 || this._format == 6408 || this._format == 34030;
    }

    public boolean isDepth() {
        return Texture.isDepth(this._format);
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public int getDepth() {
        return 1;
    }

    public void setFilters(int min, int mag) {
        this.setMinFilter(min);
        this.setMagFilter(mag);
    }

    public void setMinFilter(int minFilter) {
        if (this._minFilter != minFilter) {
            this._renderer.setTexture(this);
            this._minFilter = minFilter;
            GL11.glTexParameteri((int)this._target, (int)10241, (int)this._minFilter);
        }
    }

    public void setMagFilter(int magFilter) {
        if (this._magFilter != magFilter) {
            this._renderer.setTexture(this);
            this._magFilter = magFilter;
            GL11.glTexParameteri((int)this._target, (int)10240, (int)this._magFilter);
        }
    }

    public void setMaxAnisotropy(float maxAnisotropy) {
        if (this._maxAnisotropy != maxAnisotropy) {
            this._renderer.setTexture(this);
            this._maxAnisotropy = maxAnisotropy;
            GL11.glTexParameterf((int)this._target, (int)34046, (float)this._maxAnisotropy);
        }
    }

    public void setWrap(int s, int t) {
        this.setWrapS(s);
        this.setWrapT(t);
    }

    public void setWrap(int s, int t, int r) {
        this.setWrapS(s);
        this.setWrapT(t);
        this.setWrapR(r);
    }

    public void setWrapS(int wrap) {
        if (this._wrapS != wrap) {
            this._renderer.setTexture(this);
            this._wrapS = wrap;
            GL11.glTexParameteri((int)this._target, (int)10242, (int)this._wrapS);
        }
    }

    public void setWrapT(int wrap) {
        if (this._wrapT != wrap) {
            this._renderer.setTexture(this);
            this._wrapT = wrap;
            GL11.glTexParameteri((int)this._target, (int)10243, (int)this._wrapT);
        }
    }

    public void setWrapR(int wrap) {
        if (this._wrapR != wrap) {
            this._renderer.setTexture(this);
            this._wrapR = wrap;
            GL11.glTexParameteri((int)this._target, (int)32882, (int)this._wrapR);
        }
    }

    public void setBorderColor(Color4f borderColor) {
        if (!this._borderColor.equals(borderColor)) {
            this._renderer.setTexture(this);
            this._borderColor.set(borderColor).get(_vbuf).rewind();
            GL11.glTexParameter((int)this._target, (int)4100, (FloatBuffer)_vbuf);
        }
    }

    public void setGenerateMipmaps(boolean generate) {
        if (this._generateMipmaps != generate) {
            this._renderer.setTexture(this);
            this._generateMipmaps = generate;
            GL11.glTexParameteri((int)this._target, (int)33169, (int)(this._generateMipmaps ? 1 : 0));
        }
    }

    public void setCompare(int mode, int func) {
        this.setCompareMode(mode);
        this.setCompareFunc(func);
    }

    public void setCompareMode(int compareMode) {
        if (this._compareMode != compareMode) {
            this._renderer.setTexture(this);
            this._compareMode = compareMode;
            GL11.glTexParameteri((int)this._target, (int)34892, (int)this._compareMode);
        }
    }

    public void setCompareFunc(int compareFunc) {
        if (this._compareFunc != compareFunc) {
            this._renderer.setTexture(this);
            this._compareFunc = compareFunc;
            GL11.glTexParameteri((int)this._target, (int)34893, (int)this._compareFunc);
        }
    }

    public void setDepthMode(int depthMode) {
        if (this._depthMode != depthMode) {
            this._renderer.setTexture(this);
            this._depthMode = depthMode;
            GL11.glTexParameteri((int)this._target, (int)34891, (int)this._depthMode);
        }
    }

    public void generateMipmap() {
        this._renderer.setTexture(this);
        EXTFramebufferObject.glGenerateMipmapEXT((int)this._target);
    }

    public void delete() {
        IntBuffer idbuf = BufferUtils.createIntBuffer((int)1);
        idbuf.put(this._id).rewind();
        GL11.glDeleteTextures((IntBuffer)idbuf);
        this._id = 0;
        this._renderer.textureDeleted(this.getTotalBytes());
    }

    protected Texture() {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._id > 0) {
            this._renderer.textureFinalized(this._id, this.getTotalBytes());
        }
    }

    protected void setMipmapBytes(int bytes, int ... dimensions) {
        int ll = 0;
        for (int size = IntListUtil.getMaxValue((int[])dimensions); size > 0; size /= 2) {
            this.setBytes(ll, bytes);
            ++ll;
            bytes /= 4;
        }
    }

    protected void setBytes(int level, int bytes) {
        if (level >= this._bytes.length) {
            int[] obytes = this._bytes;
            this._bytes = new int[level + 1];
            System.arraycopy(obytes, 0, this._bytes, 0, obytes.length);
        }
        this._renderer.textureResized(bytes - this._bytes[level]);
        this._bytes[level] = bytes;
    }

    protected int getTotalBytes() {
        return IntListUtil.sum((int[])this._bytes);
    }

    protected static int getFormat(BufferedImage image) {
        return FORMATS[image.getColorModel().getNumComponents() - 1];
    }

    protected static int getInternalFormat(BufferedImage image, boolean compress) {
        int[] formats = GLContext.getCapabilities().GL_ARB_texture_compression && compress ? COMPRESSED_FORMATS : FORMATS;
        return formats[image.getColorModel().getNumComponents() - 1];
    }

    protected static int getTransferFormat(int internalFormat) {
        return Texture.isDepth(internalFormat) ? 6402 : 6408;
    }

    protected static boolean isDepth(int format) {
        return format == 6402 || format == 33189 || format == 33190 || format == 33191;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static BufferedImage halveImage(BufferedImage image) {
        int width = Math.max(1, image.getWidth() / 2);
        int height = Math.max(1, image.getHeight() / 2);
        BufferedImage dest = new BufferedImage(width, height, image.getType());
        Graphics2D graphics = dest.createGraphics();
        try {
            graphics.drawImage(image, 0, 0, width, height, null);
        }
        finally {
            graphics.dispose();
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ByteBuffer getData(BufferedImage image, boolean premultiply, int width, int height, boolean rescale) {
        double yscale;
        double xscale;
        int iwidth = image.getWidth();
        int iheight = image.getHeight();
        int ncomps = image.getColorModel().getNumComponents();
        boolean hasAlpha = ncomps == 2 || ncomps == 4;
        ComponentColorModel cmodel = new ComponentColorModel(ColorSpace.getInstance(ncomps >= 3 ? 1000 : 1003), hasAlpha, hasAlpha && premultiply, hasAlpha ? 3 : 1, 0);
        BufferedImage dest = new BufferedImage(cmodel, Raster.createInterleavedRaster(0, width, height, ncomps, null), cmodel.isAlphaPremultiplied(), null);
        if (rescale && (width != iwidth || height != iheight)) {
            xscale = (double)width / (double)iwidth;
            yscale = -((double)height) / (double)iheight;
        } else {
            xscale = 1.0;
            yscale = -1.0;
        }
        AffineTransform xform = AffineTransform.getScaleInstance(xscale, yscale);
        xform.translate(0.0, -iheight);
        Graphics2D graphics = dest.createGraphics();
        try {
            graphics.setComposite(AlphaComposite.Src);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, rescale ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            graphics.drawRenderedImage(image, xform);
        }
        finally {
            graphics.dispose();
        }
        byte[] rgba = ((DataBufferByte)dest.getRaster().getDataBuffer()).getData();
        ByteBuffer data = BufferUtils.createByteBuffer((int)(width * height * ncomps));
        data.put(rgba).rewind();
        return data;
    }
}

