/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export.util;

import com.threerings.export.BinaryExporter;
import com.threerings.export.BinaryImporter;
import com.threerings.export.Log;
import com.threerings.export.XMLExporter;
import com.threerings.export.XMLImporter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ExportUtil {
    public static String toString(Object object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLExporter out = new XMLExporter(baos);
        try {
            out.writeObject(object);
            out.close();
            return baos.toString();
        }
        catch (IOException e) {
            Log.log.warning((Object)"Error exporting object to string.", new Object[]{"object", object, e});
            return null;
        }
    }

    public static Object fromString(String string) {
        XMLImporter in = new XMLImporter(new ByteArrayInputStream(string.getBytes()));
        try {
            Object object = in.readObject();
            in.close();
            return object;
        }
        catch (IOException e) {
            Log.log.warning((Object)"Error importing object from string.", new Object[]{"string", string, e});
            return null;
        }
    }

    public static byte[] toBytes(Object object) {
        return ExportUtil.toBytes(object, true);
    }

    public static byte[] toBytes(Object object, boolean compress) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryExporter out = new BinaryExporter(baos, compress);
        try {
            out.writeObject(object);
            out.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            Log.log.warning((Object)"Error exporting object to byte array.", new Object[]{"object", object, e});
            return new byte[0];
        }
    }

    public static Object fromBytes(byte[] bytes) {
        BinaryImporter in = new BinaryImporter(new ByteArrayInputStream(bytes));
        try {
            Object object = in.readObject();
            in.close();
            return object;
        }
        catch (IOException e) {
            Log.log.warning((Object)"Error importing object from byte array.", new Object[]{e});
            return null;
        }
    }
}

