/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.google.common.base.Objects;
import com.samskivert.util.StringUtil;
import com.threerings.editor.Log;
import com.threerings.editor.swing.PropertyEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class ChoiceEditor
extends PropertyEditor
implements ActionListener {
    protected JComboBox _box;

    @Override
    public void actionPerformed(ActionEvent event) {
        Object selected = this._box.getSelectedItem();
        if (!Objects.equal((Object)this._property.get(this._object), (Object)selected)) {
            this._property.set(this._object, selected);
            this.fireStateChanged();
        }
    }

    @Override
    public void update() {
        Object[] options = this.getOptions();
        this._box.setModel(new DefaultComboBoxModel<Object>(options));
        this._box.setSelectedItem(this._property.get(this._object));
    }

    @Override
    protected void didInit() {
        this.add(new JLabel(this.getPropertyLabel() + ":"));
        this._box = new JComboBox();
        this.add(this._box);
        this._box.addActionListener(this);
    }

    protected Object[] getOptions() {
        Object mobj = this._property.getMemberObject(this._object);
        if (mobj == null) {
            return new Object[0];
        }
        Class<?> mclass = mobj.getClass();
        Member member = this._property.getMember();
        String mname = member.getName();
        mname = member instanceof Method ? mname.substring(3) : StringUtil.capitalize((String)mname);
        try {
            return (Object[])mclass.getMethod("get" + mname + "Options", new Class[0]).invoke(mobj, new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (Exception e) {
            Log.log.warning((Object)"Error retrieving options.", new Object[]{"class", mclass, "member", mname, e});
        }
        return new Object[0];
    }
}

