/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.google.common.collect.Sets;
import com.samskivert.util.ObserverList;
import com.samskivert.util.Tuple;
import com.samskivert.util.WeakObserverList;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.editor.Editable;
import com.threerings.editor.Strippable;
import com.threerings.editor.util.EditorContext;
import com.threerings.editor.util.PropertyUtil;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.resource.ResourceManager;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;

public abstract class ManagedConfig
extends DeepObject
implements Exportable,
ConfigUpdateListener<ManagedConfig>,
ResourceManager.ModificationObserver {
    @Editable(height=3, width=40, collapsible=true)
    @Strippable
    public String comment = "";
    protected String _name;
    @DeepOmit
    protected transient ConfigManager _cfgmgr;
    @DeepOmit
    protected transient WeakObserverList<ConfigUpdateListener<ManagedConfig>> _listeners;
    @DeepOmit
    protected transient ArrayList<ManagedConfig> _updateConfigs;
    @DeepOmit
    protected transient HashSet<String> _updateResources;

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public ConfigReference<? extends ManagedConfig> getReference() {
        return new ConfigReference(this._name);
    }

    public ConfigManager getConfigManager() {
        return this._cfgmgr;
    }

    public ManagedConfig getInstance(String firstKey, Object firstValue, Object ... otherArgs) {
        return this.getInstance(null, firstKey, firstValue, otherArgs);
    }

    public ManagedConfig getInstance(Scope scope, String firstKey, Object firstValue, Object ... otherArgs) {
        return this.getInstance(scope, new ArgumentMap(firstKey, firstValue, otherArgs));
    }

    public ManagedConfig getInstance(Scope scope) {
        return this.getInstance(scope, null);
    }

    public ManagedConfig getInstance(ArgumentMap args) {
        return this.getInstance(null, args);
    }

    public ManagedConfig getInstance(Scope scope, ArgumentMap args) {
        return this;
    }

    public void addListener(ConfigUpdateListener listener) {
        if (this._listeners == null) {
            this._listeners = WeakObserverList.newFastUnsafe();
            this._listeners.setCheckDuplicates(false);
            this.addUpdateDependencies();
        }
        ConfigUpdateListener mlistener = listener;
        this._listeners.add((Object)mlistener);
    }

    public void removeListener(ConfigUpdateListener listener) {
        if (this._listeners != null) {
            ConfigUpdateListener mlistener = listener;
            this._listeners.remove((Object)mlistener);
            if (this._listeners.isEmpty()) {
                this._listeners = null;
                this.clearUpdateDependencies();
            }
        }
    }

    public void init(ConfigManager cfgmgr) {
        this._cfgmgr = cfgmgr;
    }

    public void updateFromSource(EditorContext ctx, boolean force) {
    }

    public void wasUpdated() {
        if (this._updateConfigs != null) {
            this.clearUpdateDependencies();
            this.addUpdateDependencies();
        }
        this.fireConfigUpdated();
    }

    public boolean validateReferences(String where, PrintStream out) {
        HashSet configs = Sets.newHashSet();
        HashSet resources = Sets.newHashSet();
        PropertyUtil.getReferences(this._cfgmgr, this, configs, resources);
        return PropertyUtil.validateReferences(where, this._cfgmgr, configs, resources, out);
    }

    public void validateOuters(String where) {
    }

    @Override
    public void configUpdated(ConfigEvent<ManagedConfig> event) {
        this.fireConfigUpdated();
    }

    public void resourceModified(String path, long lastModified) {
        this.fireConfigUpdated();
    }

    protected void getUpdateReferences(ConfigReferenceSet refs) {
    }

    protected void getUpdateResources(HashSet<String> paths) {
    }

    protected void fireConfigUpdated() {
        if (this._listeners != null) {
            final ConfigEvent<ManagedConfig> event = new ConfigEvent<ManagedConfig>(this, this);
            this._listeners.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<ConfigUpdateListener<ManagedConfig>>(){

                public boolean apply(ConfigUpdateListener<ManagedConfig> listener) {
                    listener.configUpdated(event);
                    return true;
                }
            });
        }
        this.maybeFireOnConfigManager();
    }

    protected void maybeFireOnConfigManager() {
        if (this._cfgmgr != null) {
            ConfigManager mgr = this._cfgmgr.isResourceClass(this.getClass()) ? this._cfgmgr.getRoot() : this._cfgmgr;
            mgr.fireConfigUpdated(this);
        }
    }

    protected void addUpdateDependencies() {
        ConfigReferenceSet refs = new ConfigReferenceSet();
        this.getUpdateReferences(refs);
        this._updateConfigs = new ArrayList(refs.size());
        for (Tuple ref : refs) {
            Class mclass = (Class)ref.left;
            ConfigReference mref = (ConfigReference)ref.right;
            Object config = this._cfgmgr.getConfig(mclass, mref);
            if (config == null) continue;
            ((ManagedConfig)config).addListener(this);
            this._updateConfigs.add((ManagedConfig)config);
        }
        this._updateResources = new HashSet<String>();
        this.getUpdateResources(this._updateResources);
        ResourceManager rsrcmgr = this._cfgmgr.getResourceManager();
        for (String path : this._updateResources) {
            rsrcmgr.addModificationObserver(path, (ResourceManager.ModificationObserver)this);
        }
    }

    protected void clearUpdateDependencies() {
        if (this._updateConfigs != null) {
            int nn = this._updateConfigs.size();
            for (int ii = 0; ii < nn; ++ii) {
                this._updateConfigs.get(ii).removeListener(this);
            }
            this._updateConfigs = null;
        }
        if (this._updateResources != null) {
            ResourceManager rsrcmgr = this._cfgmgr.getResourceManager();
            for (String path : this._updateResources) {
                rsrcmgr.removeModificationObserver(path, (ResourceManager.ModificationObserver)this);
            }
            this._updateResources = null;
        }
    }
}

