package com.threerings.tudey.util;

import java.io.PrintStream;

public class DepthWriterException extends Exception {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	 /**
     * Constructs a new exception with <code>null</code> as its detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #initCause}.
     */
    public DepthWriterException() {
	super();
    }

    /**
     * Constructs a new exception with the specified detail message.  The
     * cause is not initialized, and may subsequently be initialized by
     * a call to {@link #initCause}.
     *
     * @param   message   the detail message. The detail message is saved for 
     *          later retrieval by the {@link #getMessage()} method.
     */
    public DepthWriterException(String message) {
	super(message);
    }

    public void printStackTrace(int depth) {
        printStackTrace(System.err,depth);
    }
    
    public void printStackTrace(PrintStream s,int depth) {
        synchronized (s) {
            s.println(this);
            StackTraceElement[] trace = getStackTrace();
            for (int i=0; i < trace.length && i < depth; i++)
                s.println("\tat " + trace[i]);
        }
    }
}
