/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.threerings.config.ConfigManager;
import com.threerings.math.Ray2D;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.shape.Shape;

public class ActorAdvancer {
    protected Environment _environment;
    protected Actor _actor;
    protected int _timestamp;
    protected Shape _shape;
    protected Transform2D _transform = new Transform2D(2);

    public ActorAdvancer(Environment environment, Actor actor, int timestamp) {
        this._environment = environment;
        this.init(actor, timestamp);
    }

    public Actor getActor() {
        return this._actor;
    }

    public int getTimestamp() {
        return this._timestamp;
    }

    public void init(Actor actor, int timestamp) {
        this._actor = actor;
        this._timestamp = timestamp;
        this.updateShape();
    }

    public void transfer(ActorAdvancer source) {
        this._timestamp = source._timestamp;
    }

    public void advance(int timestamp) {
        if (timestamp <= this._timestamp) {
            return;
        }
        float elapsed = (float)(timestamp - this._timestamp) / 1000.0f;
        this._timestamp = timestamp;
        this.step(elapsed);
    }

    public void jump(int timestamp) {
        this._timestamp = Math.max(this._timestamp, timestamp);
    }

    protected void step(float elapsed) {
    }

    protected void updateShape() {
        this._transform.set(this._actor.getTranslation(), this._actor.getRotation(), 1.0f);
        this._shape = this._actor.getOriginal().shape.getShape().transform(this._transform, this._shape);
    }

    public static interface Environment {
        public TudeySceneModel getSceneModel();

        public boolean getPenetration(Actor var1, Shape var2, Vector2f var3);

        public boolean getIntersection(Ray2D var1, float var2, int var3, int var4, Vector2f var5);

        public boolean collides(Actor var1, Shape var2);

        public int getDirections(Actor var1, Shape var2);

        public ConfigManager getConfigManager();
    }
}

