/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.threerings.tudey.data.actor.Active;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.util.ActorAdvancer;
import com.threerings.tudey.util.MobileAdvancer;

public class ActiveAdvancer
extends MobileAdvancer {
    protected Active _active;
    protected IntMap<Activity> _activities = IntMaps.newHashIntMap();

    public ActiveAdvancer(ActorAdvancer.Environment environment, Active active, int timestamp) {
        super(environment, active, timestamp);
    }

    public boolean canMove() {
        Activity activity = this.getActivity();
        return activity == null || activity.allowsMovement();
    }

    public boolean canRotate() {
        Activity activity = this.getActivity();
        return activity == null || activity.allowsRotation();
    }

    @Override
    public void init(Actor actor, int timestamp) {
        super.init(actor, timestamp);
        this._active = (Active)actor;
    }

    @Override
    protected void step(float elapsed) {
        Activity activity = this.getActivity();
        if (activity != null) {
            activity.step(elapsed);
        }
        super.step(elapsed);
    }

    @Override
    protected void mobileStep(float elapsed, int timestamp) {
        if (!this.canMove()) {
            this._active.clear(2);
        }
        super.mobileStep(elapsed, timestamp);
    }

    protected Activity getActivity() {
        return (Activity)this._activities.get(this._active.getActivity());
    }

    protected class Activity {
        protected boolean _movement;
        protected boolean _rotation;
        protected int _clear;

        public Activity(int clear) {
            this(false, clear);
        }

        public Activity(boolean movement, int clear) {
            this(movement, movement, clear);
        }

        public Activity(boolean movement, boolean rotation, int clear) {
            this._movement = movement;
            this._rotation = rotation;
            this._clear = clear;
        }

        public boolean allowsMovement() {
            return this._movement;
        }

        public boolean allowsRotation() {
            return this._rotation;
        }

        public void step(float elapsed) {
            int started = ActiveAdvancer.this._active.getActivityStarted();
            if (ActiveAdvancer.this._timestamp - started >= this._clear) {
                ActiveAdvancer.this._active.setActivity(0, started + this._clear);
            } else if (!ActiveAdvancer.this.canMove()) {
                ActiveAdvancer.this._active.clear(2);
            }
        }

        public void updateInput() {
        }
    }
}

