/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.Histogram;
import com.samskivert.util.IntMaps;
import com.samskivert.util.Interval;
import com.samskivert.util.ObserverList;
import com.samskivert.util.Randoms;
import com.samskivert.util.RunAnywhere;
import com.samskivert.util.RunQueue;
import com.samskivert.util.StringUtil;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.OccupantInfo;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.server.CrowdSession;
import com.threerings.math.Ray2D;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.server.ClientManager;
import com.threerings.presents.server.PresentsSession;
import com.threerings.tudey.Log;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.config.CameraConfig;
import com.threerings.tudey.config.EffectConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.data.InputFrame;
import com.threerings.tudey.data.TudeyBodyObject;
import com.threerings.tudey.data.TudeyCodes;
import com.threerings.tudey.data.TudeySceneConfig;
import com.threerings.tudey.data.TudeySceneMarshaller;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.data.TudeySceneObject;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.data.effect.Effect;
import com.threerings.tudey.server.ClientLiaison;
import com.threerings.tudey.server.TudeySceneProvider;
import com.threerings.tudey.server.TudeySceneRegistry;
import com.threerings.tudey.server.logic.ActorLogic;
import com.threerings.tudey.server.logic.EffectLogic;
import com.threerings.tudey.server.logic.EntryLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.PawnLogic;
import com.threerings.tudey.server.util.Pathfinder;
import com.threerings.tudey.server.util.SceneTicker;
import com.threerings.tudey.shape.Compound;
import com.threerings.tudey.shape.Segment;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.ShapeElement;
import com.threerings.tudey.space.HashSpace;
import com.threerings.tudey.space.SpaceElement;
import com.threerings.tudey.util.ActorAdvancer;
import com.threerings.tudey.util.TudeySceneMetrics;
import com.threerings.tudey.util.TudeyUtil;
import com.threerings.util.Name;
import com.threerings.util.ThreadLocalLogger;
import com.threerings.whirled.server.SceneManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TudeySceneManager
extends SceneManager
implements TudeySceneProvider,
TudeySceneModel.Observer,
ActorAdvancer.Environment,
RunQueue,
TudeyCodes {
    @Inject
    protected Injector _injector;
    @Inject
    protected ClientManager _clmgr;
    protected TudeySceneObject _tsobj;
    protected ConfigManager _cfgmgr;
    protected SceneTicker _ticker;
    protected long _lastTick;
    protected long _tickDuration;
    protected int _timestamp;
    protected int _previousTimestamp;
    protected long _emptyTime;
    protected int _lastActorId;
    protected HashIntMap<Object> _entering = IntMaps.newHashIntMap();
    protected HashIntMap<ClientLiaison> _clients = IntMaps.newHashIntMap();
    protected ObserverList<TickParticipant> _tickParticipants = ObserverList.newSafeInOrder();
    protected boolean _ticking;
    protected ObserverList<ActorObserver> _actorObservers = ObserverList.newFastUnsafe();
    protected ObserverList<ShutdownObserver> _shutdownObservers = ObserverList.newFastUnsafe();
    protected HashMap<Object, EntryLogic> _entries = Maps.newHashMap();
    protected HashIntMap<ActorLogic> _actors = IntMaps.newHashIntMap();
    protected HashIntMap<BodyObject> _bodys = IntMaps.newHashIntMap();
    protected Set<ActorLogic> _staticActors = Sets.newHashSet();
    protected HashMap<String, ArrayList<Logic>> _tagged = Maps.newHashMap();
    protected HashMap<Class<?>, ArrayList<Logic>> _instances = Maps.newHashMap();
    protected ArrayList<Logic> _defaultEntrances = Lists.newArrayList();
    protected HashSpace _actorSpace = new HashSpace(64.0f, 6);
    protected HashSpace _sensorSpace = new HashSpace(64.0f, 6);
    protected Pathfinder _pathfinder;
    protected Set<ActorLogic> _staticActorsAdded = Sets.newHashSet();
    protected Set<ActorLogic> _staticActorsUpdated = Sets.newHashSet();
    protected Set<ActorLogic> _staticActorsRemoved = Sets.newHashSet();
    protected ArrayList<EffectLogic> _effectsFired = Lists.newArrayList();
    protected List<Runnable> _runnables = Lists.newArrayList();
    protected Rect _defaultLocalInterest = TudeySceneMetrics.getDefaultLocalInterest();
    protected ArrayList<SpaceElement> _elements = Lists.newArrayList();
    protected ArrayList<Effect> _effects = Lists.newArrayList();
    protected List<Runnable> _runlist = Lists.newArrayList();
    protected TickOp _tickOp = new TickOp();
    protected ProfileTickOp _profileTickOp = new ProfileTickOp();
    protected Vector2f _penetration = new Vector2f();
    protected static boolean _tickProfEnabled;
    protected static int _tickProfInterval;
    protected static Map<String, TickProfile> _profiles;
    protected static long _tickParticipantCount;
    protected static final ObserverList.ObserverOp<ShutdownObserver> _shutdownOp;

    static {
        _tickProfInterval = 100;
        _profiles = Maps.newHashMap();
        _shutdownOp = new ObserverList.ObserverOp<ShutdownObserver>(){

            public boolean apply(ShutdownObserver observer) {
                observer.didShutdown();
                return false;
            }
        };
    }

    public static void setTickProfEnabled(boolean enabled) {
        _tickProfEnabled = enabled;
    }

    public static boolean isTickProfEnabled() {
        return _tickProfEnabled;
    }

    public static void setTickProfInterval(int interval) {
        _tickProfInterval = interval;
    }

    public static int getTickProfInterval() {
        return _tickProfInterval;
    }

    public static void dumpTickProfiles() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, TickProfile> entry : _profiles.entrySet()) {
            buf.append(entry.getKey()).append(" => ").append(entry.getValue()).append('\n');
        }
        Log.log.info((Object)buf.toString(), new Object[0]);
    }

    public static void clearTickProfiles() {
        _profiles.clear();
    }

    public int getBufferDelay() {
        return TudeyUtil.getBufferDelay(this.getTickInterval());
    }

    public int getTicksPerSecond() {
        return 1000 / this.getTickInterval();
    }

    public int getTickInterval() {
        return this._ticker == null ? 50 : this._ticker.getActualInterval();
    }

    public int getTransmitInterval() {
        return ((TudeySceneConfig)this._config).getTransmitInterval();
    }

    @Override
    public ConfigManager getConfigManager() {
        return this._cfgmgr;
    }

    public void addTickParticipant(TickParticipant participant) {
        this.addTickParticipant(participant, false);
    }

    public void addTickParticipant(final TickParticipant participant, boolean withinTick) {
        if (withinTick && !this._ticking) {
            this._tickParticipants.add((Object)new TickParticipant(){

                @Override
                public boolean tick(int timestamp) {
                    TudeySceneManager.this._tickParticipants.add((Object)participant);
                    return false;
                }
            });
        } else {
            this._tickParticipants.add((Object)participant);
        }
    }

    public void removeTickParticipant(TickParticipant participant) {
        this._tickParticipants.remove((Object)participant);
    }

    public void addActorObserver(ActorObserver observer) {
        this._actorObservers.add((Object)observer);
    }

    public void removeActorObserver(ActorObserver observer) {
        this._actorObservers.remove((Object)observer);
    }

    public void addShutdownObserver(ShutdownObserver observer) {
        this._shutdownObservers.add((Object)observer);
    }

    public void removeShutdownObserver(ShutdownObserver observer) {
        this._shutdownObservers.remove((Object)observer);
    }

    public int getTimestamp() {
        return this._timestamp;
    }

    public int getPreviousTimestamp() {
        return this._previousTimestamp;
    }

    public int getNextTimestamp() {
        return this._timestamp + this.getTickInterval();
    }

    public long getTickDuration() {
        return this._tickDuration;
    }

    public List<Logic> getTagged(String tag) {
        List list = this._tagged.get(tag);
        return list == null ? ImmutableList.of() : list;
    }

    public int taggedCount(String tag) {
        List list = this._tagged.get(tag);
        return list == null ? 0 : list.size();
    }

    public <L extends Logic> List<L> getInstances(Class<L> clazz) {
        List list = this._instances.get(clazz);
        return list == null ? ImmutableList.of() : list;
    }

    public HashSpace getActorSpace() {
        return this._actorSpace;
    }

    public HashSpace getSensorSpace() {
        return this._sensorSpace;
    }

    public Pathfinder getPathfinder() {
        return this._pathfinder;
    }

    public void setDefaultLocalInterest(Rect interest) {
        this._defaultLocalInterest = interest;
    }

    public Rect getDefaultLocalInterest() {
        return this._defaultLocalInterest;
    }

    public boolean getDebugRegions() {
        return false;
    }

    public boolean getDebugShaps() {
        return false;
    }

    public boolean getDebugBlocked() {
        return false;
    }

    public boolean canResurrect(Name reviver, Name revived) {
        return false;
    }

    public ActorLogic spawnActor(int timestamp, Vector2f translation, float rotation, String name) {
        return this.spawnActor(timestamp, translation, rotation, new ConfigReference<ActorConfig>(name));
    }

    public ActorLogic spawnActor(int timestamp, Vector2f translation, float rotation, String name, String firstKey, Object firstValue, Object ... otherArgs) {
        return this.spawnActor(timestamp, translation, rotation, new ConfigReference<ActorConfig>(name, firstKey, firstValue, otherArgs));
    }

    public ActorLogic spawnActor(int timestamp, Vector2f translation, float rotation, ConfigReference<ActorConfig> ref) {
        return this.spawnActor(timestamp, translation, rotation, ref, null);
    }

    public ActorLogic spawnActor(int timestamp, Vector2f translation, float rotation, ConfigReference<ActorConfig> ref, Actor actor) {
        ActorConfig.Original original;
        if (!this._plobj.isActive()) {
            return null;
        }
        ActorConfig config = this._cfgmgr.getConfig(ActorConfig.class, ref);
        ActorConfig.Original original2 = original = config == null ? null : config.getOriginal(this._cfgmgr);
        if (original == null) {
            Log.log.warning((Object)"Failed to resolve actor config.", new Object[]{"actor", ref, "where", this.where()});
            return null;
        }
        final ActorLogic logic = (ActorLogic)this.createLogic(original.getLogicClassName());
        if (logic == null) {
            return null;
        }
        int id = actor == null ? (this._lastActorId = this._lastActorId + 1) : actor.getId();
        logic.init(this, ref, original, id, timestamp, translation, rotation, actor);
        this._actors.put(id, (Object)logic);
        this.addMappings(logic);
        if (logic.isStatic()) {
            this._staticActors.add(logic);
            this._staticActorsAdded.add(logic);
        }
        this._actorObservers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<ActorObserver>(){

            public boolean apply(ActorObserver observer) {
                observer.actorAdded(logic);
                return true;
            }
        });
        return logic;
    }

    public EffectLogic fireEffect(int timestamp, Logic target, Vector2f translation, float rotation, String name) {
        return this.fireEffect(timestamp, target, translation, rotation, new ConfigReference<EffectConfig>(name));
    }

    public void flashShape(int timestamp, Logic target, int lifespan, boolean outline, Shape ... shapes) {
        this.flashShape(timestamp, target, lifespan, outline, -1.570796f, shapes);
    }

    public void flashShape(int timestamp, Logic target, int lifespan, boolean outline, float rotation, Shape ... shapes) {
        Shape compound = new Compound(shapes);
        Vector2f center = compound.getCenter();
        compound = compound.transform(new Transform2D(center.negate(), 0.0f));
        this.fireEffect(timestamp, target, center, rotation, "Debug/Show Actor Shape", "Shape", compound.createConfig(), "lifespan", lifespan, "outline", outline);
    }

    public EffectLogic fireEffect(int timestamp, Logic target, Vector2f translation, float rotation, String name, String firstKey, Object firstValue, Object ... otherArgs) {
        return this.fireEffect(timestamp, target, translation, rotation, new ConfigReference<EffectConfig>(name, firstKey, firstValue, otherArgs));
    }

    public EffectLogic fireEffect(int timestamp, Logic target, Vector2f translation, float rotation, ConfigReference<EffectConfig> ref) {
        EffectConfig.Original original;
        if (!this._plobj.isActive()) {
            return null;
        }
        EffectConfig config = this._cfgmgr.getConfig(EffectConfig.class, ref);
        EffectConfig.Original original2 = original = config == null ? null : config.getOriginal(this._cfgmgr);
        if (original == null) {
            Log.log.warning((Object)"Failed to resolve effect config.", new Object[]{"effect", ref, "where", this.where()});
            return null;
        }
        EffectLogic logic = (EffectLogic)this.createLogic(original.getLogicClassName());
        if (logic == null) {
            return null;
        }
        timestamp = Math.max(timestamp, this._previousTimestamp + 1);
        logic.init(this, ref, original, timestamp, target, translation, rotation);
        this._effectsFired.add(logic);
        return logic;
    }

    public Logic createLogic(String cname) {
        try {
            return (Logic)this._injector.getInstance(Class.forName(cname));
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to instantiate logic.", new Object[]{"class", cname, e});
            return null;
        }
    }

    public Logic getLogic(EntityKey key) {
        if (key instanceof EntityKey.Entry) {
            return this.getEntryLogic(((EntityKey.Entry)key).getKey());
        }
        if (key instanceof EntityKey.Actor) {
            return this.getActorLogic(((EntityKey.Actor)key).getId());
        }
        return null;
    }

    public EntryLogic getEntryLogic(Object key) {
        return this._entries.get(key);
    }

    public ActorLogic getActorLogic(int id) {
        return (ActorLogic)this._actors.get(id);
    }

    public void getVisibleActors(PawnLogic target, Rect bounds, Collection<ActorLogic> results) {
        this._actorSpace.getElements(bounds, this._elements);
        int ii = 0;
        int nn = this._elements.size();
        while (ii < nn) {
            ActorLogic actor = (ActorLogic)this._elements.get(ii).getUserObject();
            if (!actor.isStatic() && (target == null || actor.isVisible(target))) {
                results.add(actor);
            }
            ++ii;
        }
        this._elements.clear();
    }

    public Set<ActorLogic> getStaticActors() {
        return this._staticActors;
    }

    public Set<ActorLogic> getStaticActorsAdded() {
        return this._staticActorsAdded;
    }

    public Set<ActorLogic> getStaticActorsUpdated() {
        return this._staticActorsUpdated;
    }

    public Set<ActorLogic> getStaticActorsRemoved() {
        return this._staticActorsRemoved;
    }

    public Effect[] getEffectsFired(PawnLogic target, Rect bounds) {
        int ii = 0;
        int nn = this._effectsFired.size();
        while (ii < nn) {
            EffectLogic logic = this._effectsFired.get(ii);
            if (logic.getShape().getBounds().intersects(bounds) && (target == null || logic.isVisible(target))) {
                this._effects.add(logic.getEffect());
            }
            ++ii;
        }
        Effect[] array = this._effects.toArray(new Effect[this._effects.size()]);
        this._effects.clear();
        return array;
    }

    public PawnLogic getTarget(ClientObject clobj) {
        ClientLiaison client = (ClientLiaison)this._clients.get(clobj.getOid());
        return client == null ? null : client.getTarget();
    }

    public void removeActorLogic(int id) {
        final ActorLogic logic = (ActorLogic)this._actors.remove(id);
        if (logic == null) {
            Log.log.warning((Object)"Missing actor to remove.", new Object[]{"where", this.where(), "id", id});
            return;
        }
        this.removeMappings(logic);
        if (logic.isStatic()) {
            this._staticActors.remove(logic);
            if (!this._staticActorsAdded.remove(logic)) {
                this._staticActorsUpdated.remove(logic);
                this._staticActorsRemoved.add(logic);
            }
        }
        this._actorObservers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<ActorObserver>(){

            public boolean apply(ActorObserver observer) {
                observer.actorRemoved(logic);
                return true;
            }
        });
    }

    public int triggerIntersectionSensors(int timestamp, ActorLogic actor) {
        return this.triggerSensors(IntersectionSensor.class, timestamp, actor.getShape(), actor.getActor().getCollisionFlags(), actor);
    }

    public int triggerSensors(Class<? extends Sensor> type, int timestamp, Shape shape, int flags, ActorLogic actor) {
        return this.triggerSensors(type, timestamp, (Collection<Shape>)ImmutableList.of((Object)shape), flags, actor);
    }

    public int triggerSensors(Class<? extends Sensor> type, int timestamp, Collection<Shape> shapes, int flags, ActorLogic actor) {
        if (flags == 0) {
            return 0;
        }
        HashSet elements = Sets.newHashSet();
        for (Shape shape : shapes) {
            this._sensorSpace.getIntersecting(shape, elements);
        }
        int count = 0;
        for (SpaceElement element : elements) {
            Sensor sensor = (Sensor)element.getUserObject();
            if (!type.isInstance(sensor) || (flags & sensor.getMask()) == 0) continue;
            sensor.trigger(timestamp, actor);
            ++count;
        }
        return count;
    }

    public boolean collides(ActorLogic logic) {
        return this.collides(logic, logic.getShape());
    }

    public boolean collides(ActorLogic logic, Shape shape) {
        return this.collides(logic, shape, this._timestamp);
    }

    public boolean collides(ActorLogic logic, Shape shape, int timestamp) {
        return this.collides(logic.getActor(), shape, timestamp);
    }

    public boolean collides(Actor actor, Shape shape, int timestamp) {
        if (((TudeySceneModel)this._scene.getSceneModel()).collides(actor, shape)) {
            return true;
        }
        this._actorSpace.getIntersecting(shape, this._elements);
        try {
            int ii = 0;
            int nn = this._elements.size();
            while (ii < nn) {
                SpaceElement element = this._elements.get(ii);
                Actor oactor = ((ActorLogic)element.getUserObject()).getActor();
                if (timestamp < oactor.getDestroyed() && actor.canCollide(oactor)) {
                    return true;
                }
                ++ii;
            }
        }
        finally {
            this._elements.clear();
        }
        return false;
    }

    public boolean collides(int mask, Shape shape) {
        return this.collides(mask, shape, this._timestamp);
    }

    public boolean collides(int mask, Shape shape, int timestamp) {
        if (mask == 0) {
            return false;
        }
        if (((TudeySceneModel)this._scene.getSceneModel()).collides(mask, shape)) {
            return true;
        }
        this._actorSpace.getIntersecting(shape, this._elements);
        try {
            int ii = 0;
            int nn = this._elements.size();
            while (ii < nn) {
                SpaceElement element = this._elements.get(ii);
                Actor actor = ((ActorLogic)element.getUserObject()).getActor();
                if (timestamp < actor.getDestroyed() && (actor.getCollisionFlags() & mask) != 0) {
                    return true;
                }
                ++ii;
            }
        }
        finally {
            this._elements.clear();
        }
        return false;
    }

    public boolean collides(ActorLogic exclude, int mask, Shape shape) {
        if (mask == 0) {
            return false;
        }
        if (((TudeySceneModel)this._scene.getSceneModel()).collides(mask, shape)) {
            return true;
        }
        this._actorSpace.getIntersecting(shape, this._elements);
        try {
            int ii = 0;
            int nn = this._elements.size();
            while (ii < nn) {
                SpaceElement element = this._elements.get(ii);
                Actor actor = ((ActorLogic)element.getUserObject()).getActor();
                if (actor.getId() != exclude.getActor().getId() && this._timestamp < actor.getDestroyed() && (actor.getCollisionFlags() & mask) != 0) {
                    return true;
                }
                ++ii;
            }
        }
        finally {
            this._elements.clear();
        }
        return false;
    }

    @Override
    public boolean getIntersection(Ray2D ray, float length, int mask, int timestamp, Vector2f intersection) {
        if (mask == 0) {
            return false;
        }
        boolean intersects = this.getSceneModel().getIntersection(ray, length, mask, intersection);
        float resultDist = intersects ? ray.getOrigin().distanceSquared(intersection) : length * length;
        Segment seg = new Segment(ray.getOrigin(), ray.getOrigin().add(ray.getDirection().mult(length)));
        this._actorSpace.getIntersecting(seg, this._elements);
        Vector2f result = new Vector2f();
        int ii = 0;
        int nn = this._elements.size();
        while (ii < nn) {
            float dist;
            SpaceElement element = this._elements.get(ii);
            ActorLogic logic = (ActorLogic)element.getUserObject();
            Actor actor = logic.getActor();
            if (timestamp < actor.getDestroyed() && (actor.getCollisionFlags() & mask) != 0 && logic.getShape().getIntersection(ray, result) && (dist = ray.getOrigin().distanceSquared(result)) < resultDist) {
                intersection.set(result);
                resultDist = dist;
            }
            ++ii;
        }
        this._elements.clear();
        return resultDist < length * length;
    }

    public void staticActorUpdated(ActorLogic logic) {
        if (!this._staticActorsAdded.contains(logic)) {
            this._staticActorsUpdated.add(logic);
        }
    }

    public void mapEnteringBody(BodyObject body, Object portalKey) {
        this._entering.put(body.getOid(), portalKey);
    }

    public void clearEnteringBody(BodyObject body) {
        this._entering.remove(body.getOid());
    }

    public void bodyWillEnter(BodyObject body) {
        ConfigReference<ActorConfig> ref;
        PresentsSession client = this._clmgr.getClient(body.username);
        if (client != null) {
            client.setIncomingMessageThrottle(1500 / this.getTransmitInterval());
        }
        if ((ref = this.getPawnConfig(body)) != null) {
            ActorLogic logic;
            Logic entrance;
            float rotation;
            Object portalKey = this._entering.remove(body.getOid());
            Transform2D transform = this.getPortalTransform(portalKey);
            Vector2f translation = transform == null ? Vector2f.ZERO : transform.extractTranslation();
            float f = rotation = transform == null ? 0.0f : transform.extractRotation();
            if (transform == null && (entrance = this.getDefaultEntrance(body)) != null) {
                translation = entrance.getTranslation();
                rotation = entrance.getRotation();
            }
            if ((logic = this.spawnActor(this.getNextTimestamp(), translation, rotation, ref)) != null) {
                logic.bodyWillEnter(body);
                ((TudeyBodyObject)body).setPawnId(logic.getActor().getId());
                this._bodys.put(logic.getActor().getId(), (Object)body);
            }
        }
        super.bodyWillEnter(body);
    }

    public Transform2D getPortalTransform(Object portalKey) {
        Transform2D result = new Transform2D(Vector2f.ZERO, 0.0f);
        if (portalKey instanceof Logic || portalKey instanceof EntityKey.Actor) {
            Logic entrance;
            Logic logic = entrance = portalKey instanceof EntityKey.Actor ? this.getActorLogic(((EntityKey.Actor)((Object)portalKey)).getId()) : (Logic)portalKey;
            if (entrance != null && entrance.isActive()) {
                return entrance.getPortalTransform();
            }
        } else if (portalKey instanceof String) {
            Logic entrance = (Logic)Randoms.threadLocal().pick(this.getTagged((String)portalKey), null);
            if (entrance != null) {
                return new Transform2D(entrance.getTranslation(), entrance.getRotation());
            }
        } else {
            TudeySceneModel.Entry entry;
            if (portalKey instanceof Transform2D) {
                return (Transform2D)portalKey;
            }
            if (portalKey != null && (entry = ((TudeySceneModel)this._scene.getSceneModel()).getEntry(portalKey instanceof EntityKey.Entry ? ((EntityKey.Entry)((Object)portalKey)).getKey() : portalKey)) != null) {
                return new Transform2D(entry.getTranslation(this._cfgmgr), entry.getRotation(this._cfgmgr));
            }
        }
        return null;
    }

    public void bodyWillLeave(BodyObject body) {
        super.bodyWillLeave(body);
        TudeyBodyObject tbody = (TudeyBodyObject)body;
        if (tbody.pawnId != 0) {
            ActorLogic logic = (ActorLogic)this._actors.get(tbody.pawnId);
            if (logic != null) {
                logic.bodyWillLeave(body);
            } else {
                Log.log.warning((Object)"Missing pawn for leaving body.", new Object[]{"pawnId", tbody.pawnId, "who", tbody.who(), "where", this.where()});
            }
            this._bodys.remove(tbody.pawnId);
            tbody.setPawnId(0);
        }
    }

    @Override
    public void enteredPlace(ClientObject caller) {
        ClientLiaison client = (ClientLiaison)this._clients.get(caller.getOid());
        if (client == null) {
            Log.log.warning((Object)"Received entrance notification from unknown client.", new Object[]{"who", caller.who(), "where", this.where()});
            return;
        }
        client.enteredPlace();
    }

    @Override
    public void enqueueInputReliable(ClientObject caller, int acknowledge, int smoothedTime, InputFrame[] frames) {
        this.enqueueInputUnreliable(caller, acknowledge, smoothedTime, frames);
    }

    @Override
    public void enqueueInputUnreliable(ClientObject caller, int acknowledge, int smoothedTime, InputFrame[] frames) {
        ClientLiaison client = (ClientLiaison)this._clients.get(caller.getOid());
        if (client != null) {
            int currentTime = this._timestamp + (int)(RunAnywhere.currentTimeMillis() - this._lastTick);
            client.enqueueInput(acknowledge, currentTime - smoothedTime, frames);
        } else {
            Log.log.debug((Object)"Received input from unknown client.", new Object[]{"who", caller.who(), "where", this.where()});
        }
    }

    @Override
    public void setTarget(ClientObject caller, int pawnId) {
        int cloid = caller.getOid();
        ClientLiaison client = (ClientLiaison)this._clients.get(cloid);
        if (client == null) {
            Log.log.warning((Object)"Received target request from unknown client.", new Object[]{"who", caller.who(), "where", this.where()});
            return;
        }
        ActorLogic target = (ActorLogic)this._actors.get(pawnId);
        if (target instanceof PawnLogic) {
            client.setTarget((PawnLogic)target);
        } else {
            Log.log.warning((Object)"User tried to target non-pawn.", new Object[]{"who", caller.who(), "actor", target == null ? null : target.getActor()});
        }
    }

    @Override
    public void setCameraParams(ClientObject caller, CameraConfig config, float aspect) {
        ClientLiaison client = (ClientLiaison)this._clients.get(caller.getOid());
        if (client != null) {
            client.setCameraParams(config, aspect);
        } else {
            Log.log.warning((Object)"Received camera params from unknown client.", new Object[]{"who", caller.who(), "where", this.where()});
        }
    }

    @Override
    public void submitActorRequest(ClientObject caller, int actorId, String name) {
        int cloid = caller.getOid();
        ClientLiaison client = (ClientLiaison)this._clients.get(cloid);
        if (client == null) {
            Log.log.warning((Object)"Received actor request from unknown client.", new Object[]{"who", caller.who(), "where", this.where()});
            return;
        }
        int pawnId = this._tsobj.getPawnId(cloid);
        if (pawnId <= 0) {
            Log.log.warning((Object)"User without pawn tried to submit actor request.", new Object[]{"who", caller.who()});
            return;
        }
        PawnLogic source = (PawnLogic)this._actors.get(pawnId);
        ActorLogic target = (ActorLogic)this._actors.get(actorId);
        if (target == null) {
            Log.log.warning((Object)"Missing actor for request.", new Object[]{"who", caller.who(), "id", actorId});
            return;
        }
        target.request(this.getNextTimestamp(), source, name);
    }

    @Override
    public void submitEntryRequest(ClientObject caller, Object key, String name) {
        int cloid = caller.getOid();
        ClientLiaison client = (ClientLiaison)this._clients.get(cloid);
        if (client == null) {
            Log.log.warning((Object)"Received entry request from unknown client.", new Object[]{"who", caller.who(), "where", this.where()});
            return;
        }
        int pawnId = this._tsobj.getPawnId(cloid);
        if (pawnId <= 0) {
            Log.log.warning((Object)"User without pawn tried to submit entry request.", new Object[]{"who", caller.who()});
            return;
        }
        PawnLogic source = (PawnLogic)this._actors.get(pawnId);
        EntryLogic target = this._entries.get(key);
        if (target == null) {
            Log.log.warning((Object)"Missing entry for request.", new Object[]{"who", caller.who(), "key", key});
            return;
        }
        target.request(this.getNextTimestamp(), source, name);
    }

    @Override
    public void entryAdded(TudeySceneModel.Entry entry) {
        this.addLogic(entry, true);
    }

    @Override
    public void entryUpdated(TudeySceneModel.Entry oentry, TudeySceneModel.Entry nentry) {
        this.removeLogic(oentry.getKey());
        this.addLogic(nentry, true);
    }

    @Override
    public void entryRemoved(TudeySceneModel.Entry oentry) {
        this.removeLogic(oentry.getKey());
    }

    @Override
    public TudeySceneModel getSceneModel() {
        return (TudeySceneModel)this._scene.getSceneModel();
    }

    @Override
    public boolean getPenetration(Actor actor, Shape shape, Vector2f result) {
        ThreadLocalLogger.log(actor, "[starting..Penetration]", actor.getTranslation());
        result.set(Vector2f.ZERO);
        ((TudeySceneModel)this._scene.getSceneModel()).getPenetration(actor, shape, result);
        this._actorSpace.getIntersecting(shape, this._elements);
        SpaceElement resultEle = null;
        int ii = 0;
        int nn = this._elements.size();
        while (ii < nn) {
            SpaceElement element = this._elements.get(ii);
            Actor oactor = ((ActorLogic)element.getUserObject()).getActor();
            if (actor.canCollide(oactor)) {
                ThreadLocalLogger.log(actor, "[collide]", oactor.getTranslation());
                ((ShapeElement)element).getWorldShape().getPenetration(shape, this._penetration);
                ThreadLocalLogger.log(actor, "[adjust]", this._penetration);
                if (this._penetration.lengthSquared() > result.lengthSquared()) {
                    result.set(this._penetration);
                    resultEle = element;
                }
            }
            ++ii;
        }
        ThreadLocalLogger.log(actor, "[adjust result]", result);
        ThreadLocalLogger.log(actor, "[after..Penetration]", actor.getTranslation());
        this._elements.clear();
        return !result.equals(Vector2f.ZERO);
    }

    @Override
    public boolean collides(Actor actor, Shape shape) {
        return this.collides(actor, shape, this._timestamp);
    }

    @Override
    public int getDirections(Actor actor, Shape shape) {
        return ((TudeySceneModel)this._scene.getSceneModel()).getDirections(actor, shape);
    }

    public Actor getActor(int id) {
        ActorLogic logic = this.getActorLogic(id);
        if (logic != null) {
            return logic.getActor();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRunnable(Runnable runnable) {
        List<Runnable> list = this._runnables;
        synchronized (list) {
            this._runnables.add(runnable);
        }
    }

    public boolean isDispatchThread() {
        return this._omgr.isDispatchThread();
    }

    public boolean isRunning() {
        return this._ticker != null;
    }

    public BodyObject getBodyObject(int actorId) {
        return (BodyObject)this._bodys.get(actorId);
    }

    protected PlaceObject createPlaceObject() {
        this._tsobj = new TudeySceneObject();
        return this._tsobj;
    }

    protected void didStartup() {
        super.didStartup();
        TudeySceneModel sceneModel = (TudeySceneModel)this._scene.getSceneModel();
        this._cfgmgr = sceneModel.getConfigManager();
        this._pathfinder = new Pathfinder(this);
        this._ticker = this.getTicker();
        this.createEntryLogics(sceneModel);
        sceneModel.addObserver(this);
        this._tsobj.setTudeySceneService((TudeySceneMarshaller)this.addProvider(this, TudeySceneMarshaller.class));
    }

    protected void createEntryLogics(TudeySceneModel sceneModel) {
        for (TudeySceneModel.Entry entry : sceneModel.getEntries()) {
            this.addLogic(entry, false);
        }
        for (EntryLogic logic : this._entries.values()) {
            logic.added();
        }
    }

    protected void didShutdown() {
        try {
            ((TudeySceneModel)this._scene.getSceneModel()).removeObserver(this);
            this._actorSpace.dispose();
            this._sensorSpace.dispose();
            ActorLogic[] actors = this._actors.values().toArray(new ActorLogic[this._actors.size()]);
            int timestamp = this.getNextTimestamp();
            ActorLogic[] actorLogicArray = actors;
            int n = actors.length;
            int n2 = 0;
            while (n2 < n) {
                ActorLogic actorLogic = actorLogicArray[n2];
                actorLogic.destroy(timestamp, actorLogic);
                actorLogic.remove();
                ++n2;
            }
            this._actors.clear();
            for (EntryLogic entryLogic : this._entries.values()) {
                entryLogic.removed();
            }
            this._shutdownObservers.apply(_shutdownOp);
            this._ticker.remove(this);
            this._ticker = null;
            this._pathfinder.shutdown();
            this._pathfinder = null;
        }
        finally {
            super.didShutdown();
        }
    }

    protected void bodyEntered(int bodyOid) {
        super.bodyEntered(bodyOid);
        BodyObject bodyobj = (BodyObject)this._omgr.getObject(bodyOid);
        CrowdSession session = (CrowdSession)this._clmgr.getClient(bodyobj.username);
        this._clients.put(bodyOid, (Object)this.createClientLiaison(bodyobj, session));
        if (!this._ticker.contains(this)) {
            this._lastTick = RunAnywhere.currentTimeMillis();
            this._ticker.add(this);
        }
    }

    protected void bodyLeft(int bodyOid) {
        super.bodyLeft(bodyOid);
        this._clients.remove(bodyOid);
    }

    protected void placeBecameEmpty() {
        super.placeBecameEmpty();
        this._emptyTime = RunAnywhere.currentTimeMillis();
    }

    protected void bodyUpdated(OccupantInfo info) {
        super.bodyUpdated(info);
        ((ClientLiaison)this._clients.get(info.getBodyOid())).bodyUpdated(info);
    }

    protected ClientLiaison createClientLiaison(BodyObject bodyobj, CrowdSession session) {
        return new ClientLiaison(this, bodyobj, session);
    }

    protected Logic getDefaultEntrance(BodyObject body) {
        return (Logic)Randoms.threadLocal().pick(this._defaultEntrances, null);
    }

    protected void maybeAddDefaultEntrance(Logic logic) {
        if (logic.isDefaultEntrance()) {
            this._defaultEntrances.add(logic);
        }
    }

    protected EntryLogic addLogic(TudeySceneModel.Entry entry, boolean notify) {
        String cname = entry.getLogicClassName(this._cfgmgr);
        if (cname == null) {
            return null;
        }
        EntryLogic logic = (EntryLogic)this.createLogic(cname);
        if (logic == null) {
            return null;
        }
        try {
            logic.init(this, entry);
            this._entries.put(entry.getKey(), logic);
            this.addMappings(logic);
            if (notify) {
                logic.added();
            }
        }
        catch (NullPointerException e) {
            Log.log.error((Object)("config name=" + entry.getReference().getName() + ",class=" + entry.getClass()), new Object[]{e});
            throw e;
        }
        return logic;
    }

    protected void removeLogic(Object key) {
        EntryLogic logic = this._entries.remove(key);
        if (logic != null) {
            this.removeMappings(logic);
            logic.removed();
        }
    }

    public void addMappings(Logic logic) {
        ActorLogic actor;
        String tag;
        String[] stringArray = logic.getTags();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tag2 = stringArray[n2];
            ArrayList<Logic> list = this._tagged.get(tag2);
            if (list == null) {
                list = new ArrayList();
                this._tagged.put(tag2, list);
            }
            list.add(logic);
            ++n2;
        }
        if (logic instanceof ActorLogic && (tag = (actor = (ActorLogic)logic).getConfigName()) != null) {
            ArrayList<Logic> list = this._tagged.get(tag);
            if (list == null) {
                list = new ArrayList();
                this._tagged.put(tag, list);
            }
            list.add(logic);
        }
        Class<?> clazz = logic.getClass();
        while (Logic.class.isAssignableFrom(clazz)) {
            ArrayList<Logic> list = this._instances.get(clazz);
            if (list == null) {
                list = new ArrayList();
                this._instances.put(clazz, list);
            }
            list.add(logic);
            clazz = clazz.getSuperclass();
        }
        this.maybeAddDefaultEntrance(logic);
    }

    public void removeMappings(Logic logic) {
        ActorLogic actor;
        String tag;
        String[] stringArray = logic.getTags();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tag2 = stringArray[n2];
            ArrayList<Logic> list = this._tagged.get(tag2);
            if (list == null || !list.remove(logic)) {
                Log.log.warning((Object)"Missing tag mapping for logic.", new Object[]{"tag", tag2, "logic", logic});
            } else if (list.isEmpty()) {
                this._tagged.remove(tag2);
            }
            ++n2;
        }
        if (logic instanceof ActorLogic && (tag = (actor = (ActorLogic)logic).getConfigName()) != null) {
            ArrayList<Logic> list = this._tagged.get(tag);
            if (list == null || !list.remove(logic)) {
                Log.log.warning((Object)"Missing tag mapping for logic.", new Object[]{"tag", tag, "logic", logic});
            }
            if (list.isEmpty()) {
                this._tagged.remove(tag);
            }
        }
        Class<?> clazz = logic.getClass();
        while (Logic.class.isAssignableFrom(clazz)) {
            ArrayList<Logic> list = this._instances.get(clazz);
            if (list == null || !list.remove(logic)) {
                Log.log.warning((Object)"Missing class mapping for logic.", new Object[]{"class", clazz, "logic", logic});
            } else if (list.isEmpty()) {
                this._instances.remove(clazz);
            }
            clazz = clazz.getSuperclass();
        }
        if (logic.isDefaultEntrance()) {
            this._defaultEntrances.remove(logic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        long now = RunAnywhere.currentTimeMillis();
        if (this._plobj.occupants.size() == 0 && now - this._emptyTime >= this.idleTickPeriod()) {
            this._ticker.remove(this);
            return;
        }
        this._previousTimestamp = this._timestamp;
        this._timestamp += (int)(now - this._lastTick);
        this._lastTick = now;
        List<Runnable> list = this._runnables;
        synchronized (list) {
            this._runlist.addAll(this._runnables);
            this._runnables.clear();
        }
        this._ticking = true;
        if (_tickProfEnabled) {
            this._profileTickOp.init(this._timestamp);
            this._tickParticipants.apply((ObserverList.ObserverOp)this._profileTickOp);
            int ii = 0;
            int nn = this._runlist.size();
            while (ii < nn) {
                Runnable runnable = this._runlist.get(ii);
                try {
                    if (_tickParticipantCount++ % (long)_tickProfInterval == 0L) {
                        long started = System.nanoTime();
                        runnable.run();
                        TudeySceneManager.updateTickProfile(runnable, started);
                    } else {
                        runnable.run();
                    }
                }
                catch (Throwable t) {
                    Log.log.warning((Object)"Caught throwable executing runnable.", new Object[]{"where", this.where(), "runnable", runnable, t});
                }
                ++ii;
            }
            this._runlist.clear();
            for (ClientLiaison client : this._clients.values()) {
                try {
                    if (_tickParticipantCount++ % (long)_tickProfInterval == 0L) {
                        long started = System.nanoTime();
                        client.postDelta();
                        TudeySceneManager.updateTickProfile(client, started);
                        continue;
                    }
                    client.postDelta();
                }
                catch (Throwable t) {
                    Log.log.warning((Object)"Caught throwable posting delta.", new Object[]{"where", this.where(), "client", client, t});
                }
            }
        } else {
            this._tickOp.init(this._timestamp);
            this._tickParticipants.apply((ObserverList.ObserverOp)this._tickOp);
            int ii = 0;
            int nn = this._runlist.size();
            while (ii < nn) {
                Runnable runnable = this._runlist.get(ii);
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    Log.log.warning((Object)"Caught throwable executing runnable.", new Object[]{"where", this.where(), "runnable", runnable, t});
                }
                ++ii;
            }
            this._runlist.clear();
            for (ClientLiaison client : this._clients.values()) {
                try {
                    client.postDelta();
                }
                catch (Throwable t) {
                    Log.log.warning((Object)"Caught throwable posting delta.", new Object[]{"where", this.where(), "client", client, t});
                }
            }
        }
        this._ticking = false;
        this._staticActorsAdded.clear();
        this._staticActorsUpdated.clear();
        this._staticActorsRemoved.clear();
        this._effectsFired.clear();
        this._tickDuration = RunAnywhere.currentTimeMillis() - this._lastTick;
    }

    protected ConfigReference<ActorConfig> getPawnConfig(BodyObject body) {
        return null;
    }

    protected long idleTickPeriod() {
        return 5000L;
    }

    protected SceneTicker getTicker() {
        return ((TudeySceneRegistry)this._screg).getDefaultTicker();
    }

    protected static void updateTickProfile(Object participant, long started) {
        TickProfile tprof;
        long elapsed = (System.nanoTime() - started) / 1000L;
        String cname = participant instanceof Interval.RunBuddy ? StringUtil.shortClassName((String)((Interval.RunBuddy)participant).getIntervalClassName()) : StringUtil.shortClassName((Object)participant);
        if (participant instanceof Logic) {
            Logic logic = (Logic)participant;
            participant = logic.getSceneManager().getLogic(logic.getEntityKey());
        }
        ConfigReference ref = null;
        if (participant instanceof ActorLogic) {
            ref = ((ActorLogic)participant).getActor().getConfig();
        } else if (participant instanceof EntryLogic) {
            ref = ((EntryLogic)participant).getEntry().getReference();
        }
        if (ref != null) {
            String rname = ref.getName();
            cname = String.valueOf(cname) + ":" + rname.substring(rname.lastIndexOf(47) + 1);
        }
        if ((tprof = _profiles.get(cname)) == null) {
            tprof = new TickProfile();
            _profiles.put(cname, tprof);
        }
        tprof.record(elapsed);
    }

    public static interface ActorObserver {
        public void actorAdded(ActorLogic var1);

        public void actorRemoved(ActorLogic var1);
    }

    public static interface DamageSensor
    extends Sensor {
    }

    public static interface IntersectionSensor
    extends Sensor {
    }

    protected static class ProfileTickOp
    extends TickOp {
        protected ProfileTickOp() {
        }

        @Override
        public boolean apply(TickParticipant participant) {
            try {
                if (_tickParticipantCount++ % (long)_tickProfInterval != 0L) {
                    return participant.tick(this._timestamp);
                }
                long started = System.nanoTime();
                boolean result = participant.tick(this._timestamp);
                TudeySceneManager.updateTickProfile(participant, started);
                return result;
            }
            catch (Throwable t) {
                Log.log.warning((Object)"Caught throwable ticking participant.", new Object[]{"participant", participant, t});
                return false;
            }
        }
    }

    public static interface Sensor {
        public int getMask();

        public void trigger(int var1, ActorLogic var2);
    }

    public static interface ShutdownObserver {
        public void didShutdown();
    }

    protected static class TickOp
    implements ObserverList.ObserverOp<TickParticipant> {
        protected int _timestamp;

        protected TickOp() {
        }

        public void init(int timestamp) {
            this._timestamp = timestamp;
        }

        public boolean apply(TickParticipant participant) {
            try {
                return participant.tick(this._timestamp);
            }
            catch (Throwable t) {
                Log.log.warning((Object)"Caught throwable ticking participant.", new Object[]{"participant", participant, t});
                return false;
            }
        }
    }

    public static interface TickParticipant {
        public boolean tick(int var1);
    }

    protected static class TickProfile {
        protected long _totalElapsed;
        protected long _longest;
        protected Histogram _histo = new Histogram(0, 20000, 10);

        protected TickProfile() {
        }

        public void record(long elapsed) {
            this._totalElapsed += elapsed;
            this._histo.addValue((int)elapsed);
            this._longest = Math.max(elapsed, this._longest);
        }

        public String toString() {
            int count = this._histo.size();
            return String.valueOf(this._totalElapsed) + "us/" + count + " = " + this._totalElapsed / (long)count + "us avg " + StringUtil.toString((Object)this._histo.getBuckets()) + " " + this._longest + "us longest";
        }
    }
}

