/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.config.ConfigManager;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.config.ActionConfig;
import com.threerings.tudey.config.ExpressionConfig;
import com.threerings.tudey.config.RegionConfig;
import com.threerings.tudey.config.TargetConfig;
import com.threerings.util.DeepObject;

@EditorTypes(value={Tagged.class, InstanceOf.class, Intersecting.class, IntersectsScene.class, DistanceWithin.class, Random.class, Limit.class, All.class, Any.class, FlagSet.class, Cooldown.class, Not.class, Always.class, Evaluate.class, Action.class, Is.class, DateRange.class, DistanceGreater.class, Interval.class, DistanceGreaterSpawnOrigin.class})
@Strippable
public abstract class ConditionConfig
extends DeepObject
implements Exportable,
Streamable {
    public abstract String getLogicClassName();

    public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
    }

    public void invalidate() {
    }

    public static class Action
    extends ConditionConfig {
        @Editable
        public ActionConfig action = new ActionConfig.SpawnActor();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Action";
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            this.action.getPreloads(cfgmgr, preloads);
        }

        @Override
        public void invalidate() {
            this.action.invalidate();
        }
    }

    public static class All
    extends ConditionConfig {
        @Editable
        public ConditionConfig[] conditions = new ConditionConfig[0];

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$All";
        }

        @Override
        public void invalidate() {
            ConditionConfig[] conditionConfigArray = this.conditions;
            int n = this.conditions.length;
            int n2 = 0;
            while (n2 < n) {
                ConditionConfig condition = conditionConfigArray[n2];
                condition.invalidate();
                ++n2;
            }
        }
    }

    public static class Always
    extends ConditionConfig {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Always";
        }
    }

    public static class Any
    extends ConditionConfig {
        @Editable
        public ConditionConfig[] conditions = new ConditionConfig[0];

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Any";
        }

        @Override
        public void invalidate() {
            ConditionConfig[] conditionConfigArray = this.conditions;
            int n = this.conditions.length;
            int n2 = 0;
            while (n2 < n) {
                ConditionConfig condition = conditionConfigArray[n2];
                condition.invalidate();
                ++n2;
            }
        }
    }

    public static class Cooldown
    extends ConditionConfig {
        @Editable
        public int time = 0;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Cooldown";
        }
    }

    public static class DateRange
    extends ConditionConfig {
        @Editable(editor="datetime", nullable=true, hgroup="a")
        public Long start;
        @Editable(editor="datetime", nullable=true, hgroup="a")
        public Long end;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$DateRange";
        }
    }

    public static class DistanceGreater
    extends ConditionConfig {
        @Editable(min=0.0, step=0.1, hgroup="m")
        public float distance;
        @Editable(hgroup="a")
        public boolean allFirst;
        @Editable(hgroup="a")
        public boolean allSecond;
        @Editable
        public TargetConfig first = new TargetConfig.Source();
        @Editable
        public TargetConfig second = new TargetConfig.Activator();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$DistanceGreater";
        }

        @Override
        public void invalidate() {
            this.first.invalidate();
            this.second.invalidate();
        }
    }

    public static class DistanceGreaterSpawnOrigin
    extends ConditionConfig {
        @Editable(min=0.0, step=0.1, hgroup="m")
        public float distance;
        @Editable(hgroup="t")
        public boolean all;
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$DistanceGreaterSpawnOrigin";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class DistanceWithin
    extends ConditionConfig {
        @Editable(min=0.0, step=0.1, hgroup="m")
        public float minimum;
        @Editable(min=0.0, step=0.1, hgroup="m")
        public float maximum;
        @Editable(hgroup="a")
        public boolean allFirst;
        @Editable(hgroup="a")
        public boolean allSecond;
        @Editable
        public TargetConfig first = new TargetConfig.Source();
        @Editable
        public TargetConfig second = new TargetConfig.Activator();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$DistanceWithin";
        }

        @Override
        public void invalidate() {
            this.first.invalidate();
            this.second.invalidate();
        }
    }

    public static class Evaluate
    extends ConditionConfig {
        @Editable
        public ExpressionConfig expression = new ExpressionConfig.Constant();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Evaluate";
        }

        @Override
        public void invalidate() {
            this.expression.invalidate();
        }
    }

    public static class FlagSet
    extends ConditionConfig {
        @Editable(hgroup="f")
        public String flagName = "WARP";
        @Editable(hgroup="f")
        public boolean set = true;
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$FlagSet";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class InstanceOf
    extends ConditionConfig {
        @Editable(hgroup="c")
        public String logicClass = "com.threerings.tudey.server.logic.PawnLogic";
        @Editable(hgroup="c")
        public boolean all;
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$InstanceOf";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class Intersecting
    extends ConditionConfig {
        @Editable(hgroup="a")
        public boolean allFirst;
        @Editable(hgroup="a")
        public boolean allSecond;
        @Editable
        public RegionConfig first = new RegionConfig.Default();
        @Editable
        public RegionConfig second = new RegionConfig.Default();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Intersecting";
        }

        @Override
        public void invalidate() {
            this.first.invalidate();
            this.second.invalidate();
        }
    }

    public static class IntersectsScene
    extends ConditionConfig {
        @Editable
        public RegionConfig region = new RegionConfig.Default();
        @Editable(editor="mask", mode="collision")
        public int collisionMask;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$IntersectsScene";
        }

        @Override
        public void invalidate() {
            this.region.invalidate();
        }
    }

    public static class Interval
    extends ConditionConfig {
        @Editable(min=0.0, step=1.0)
        public int delay = 1;
        @Editable(min=0.0, step=1.0)
        public int interval = 1;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Interval";
        }
    }

    public static class Is
    extends ConditionConfig {
        @Editable(hgroup="t")
        public boolean all;
        @Editable
        public TargetConfig target = new TargetConfig.Tagged();
        @Editable
        public TargetConfig source = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Is";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
            this.source.invalidate();
        }
    }

    public static class Limit
    extends ConditionConfig {
        @Editable
        public int limit = 1;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Limit";
        }
    }

    public static class Not
    extends ConditionConfig {
        @Editable
        public ConditionConfig condition = new Tagged();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Not";
        }

        @Override
        public void invalidate() {
            this.condition.invalidate();
        }
    }

    public static class Random
    extends ConditionConfig {
        @Editable(min=0.0, max=1.0, step=0.01)
        public float probability = 0.5f;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Random";
        }
    }

    public static class Tagged
    extends ConditionConfig {
        @Editable(hgroup="t")
        public String tag = "";
        @Editable(hgroup="t")
        public boolean all;
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Tagged";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }
}

