/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeBasedTable;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntMap;
import com.samskivert.util.RunAnywhere;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.crowd.chat.client.ChatDisplay;
import com.threerings.crowd.chat.data.ChatMessage;
import com.threerings.crowd.chat.data.TellFeedbackMessage;
import com.threerings.crowd.chat.data.UserMessage;
import com.threerings.crowd.client.OccupantObserver;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.data.OccupantInfo;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.expr.DynamicScope;
import com.threerings.expr.Scoped;
import com.threerings.math.Box;
import com.threerings.math.FloatMath;
import com.threerings.math.Ray2D;
import com.threerings.math.Ray3D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import com.threerings.opengl.GlView;
import com.threerings.opengl.camera.OrbitCameraHandler;
import com.threerings.opengl.effect.Easing;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.StretchWindow;
import com.threerings.opengl.gui.Window;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.CompoundConfig;
import com.threerings.opengl.model.config.MergedStaticConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.scene.HashScene;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.scene.ViewerEffect;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.opengl.util.Tickable;
import com.threerings.tudey.Log;
import com.threerings.tudey.client.Pathfinder;
import com.threerings.tudey.client.TudeySceneController;
import com.threerings.tudey.client.sprite.ActorSprite;
import com.threerings.tudey.client.sprite.EffectSprite;
import com.threerings.tudey.client.sprite.EntrySprite;
import com.threerings.tudey.client.sprite.Sprite;
import com.threerings.tudey.client.util.TimeSmoother;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.config.CameraConfig;
import com.threerings.tudey.config.EffectConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.data.TudeyCodes;
import com.threerings.tudey.data.TudeyOccupantInfo;
import com.threerings.tudey.data.TudeySceneConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.data.TudeySceneObject;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.data.actor.Prespawnable;
import com.threerings.tudey.data.effect.Effect;
import com.threerings.tudey.data.effect.Prefireable;
import com.threerings.tudey.dobj.ActorDelta;
import com.threerings.tudey.dobj.SceneDeltaEvent;
import com.threerings.tudey.shape.Segment;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.ShapeElement;
import com.threerings.tudey.space.HashSpace;
import com.threerings.tudey.space.SpaceElement;
import com.threerings.tudey.util.ActorAdvancer;
import com.threerings.tudey.util.Coord;
import com.threerings.tudey.util.TruncatedAverage;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.tudey.util.TudeySceneMetrics;
import com.threerings.tudey.util.TudeyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

public class TudeySceneView
extends DynamicScope
implements GlView,
PlaceView,
TudeySceneModel.Observer,
OccupantObserver,
ChatDisplay,
ActorAdvancer.Environment,
TudeyCodes {
    protected TudeyContext _ctx;
    protected TudeySceneController _ctrl;
    protected TudeySceneConfig _placeConfig;
    protected TudeySceneObject _tsobj;
    protected OrbitCameraHandler _camhand;
    protected Window _inputWindow;
    protected Window _loadingWindow;
    protected PreloadableSet _preloads;
    protected List<TudeySceneModel.Entry> _loadingEntries;
    protected List<Sprite> _loadingMerged;
    protected List<Actor> _loadingActors;
    @Scoped
    protected HashScene _scene;
    protected TudeySceneModel _sceneModel;
    protected TimeSmoother _smoother;
    protected int _smoothedTime;
    protected TimeSmoother _delayedSmoother;
    protected int _delayedTime;
    protected TimeSmoother _advancedSmoother;
    protected int _advancedTime;
    protected int _ping;
    protected TruncatedAverage _pingAverage = new TruncatedAverage();
    protected TruncatedAverage _elapsedAverage = new TruncatedAverage();
    protected List<UpdateRecord> _records = Lists.newArrayList();
    protected HashMap<Object, EntrySprite> _entrySprites = new HashMap();
    protected HashIntMap<ActorSprite> _actorSprites = new HashIntMap();
    protected HashSpace _actorSpace = new HashSpace(64.0f, 6);
    protected List<TickParticipant> _tickParticipants = Lists.newArrayList();
    protected Map<Coord, Sprite> _mergedSprites = Maps.newHashMap();
    protected boolean _suppressMergeUpdates;
    protected ActorSprite _targetSprite;
    protected ActorSprite _controlledSprite;
    private MouseEvent _last_event;
    protected boolean useMouseCamera = false;
    protected int _zoom = 0;
    protected TreeBasedTable<Integer, Integer, List<CameraConfig>> _camcfgs = TreeBasedTable.create();
    protected Pathfinder _pathfinder;
    protected CameraConfig _camcfg = new CameraConfig(TudeySceneMetrics.getDefaultCameraConfig());
    protected Tickable _camtrans;
    protected boolean _disposed;
    protected Ray3D _ray = new Ray3D(Vector3f.ZERO, new Vector3f(0.0f, 0.0f, -1.0f));
    protected Vector3f _isect = new Vector3f();
    protected FloorMaskFilter _floorMaskFilter = new FloorMaskFilter();
    protected List<SpaceElement> _elements = Lists.newArrayList();
    protected Vector2f _penetration = new Vector2f();
    protected long _controllerTime;
    protected long _tickerTime;
    protected long _sceneTime;
    protected int _tickerCount;
    protected boolean _dumpTickers;
    protected static final long BATCH_LOAD_DURATION = 50L;
    protected static final float PRELOAD_PERCENT = 0.4f;
    protected static final float ENTRY_LOAD_PERCENT = 0.3f;
    protected static final float ENTRY_MERGE_PERCENT = 0.2f;
    protected static final float ACTOR_LOAD_PERCENT = 0.1f;
    private Vector3f _last_translation = new Vector3f();
    private boolean inited = false;

    public TudeySceneView(TudeyContext ctx) {
        this(ctx, null);
    }

    public TudeySceneView(TudeyContext ctx, TudeySceneController ctrl) {
        super("view", ctx.getScope());
        this._ctx = ctx;
        this._ctrl = ctrl;
        if (this._ctrl != null && ctrl._tsview == null) {
            this._ctrl._tsview = this;
        }
        this._placeConfig = ctrl == null ? new TudeySceneConfig() : (TudeySceneConfig)ctrl.getPlaceConfig();
        this._scene = new HashScene(ctx, 64.0f, 6){

            @Override
            public void getEffects(Box bounds, Collection<ViewerEffect> results) {
                super.getEffects(bounds, results);
                if (TudeySceneView.this._loadingWindow != null) {
                    Iterator<ViewerEffect> it = results.iterator();
                    while (it.hasNext()) {
                        if (!it.next().omitWhileLoading()) continue;
                        it.remove();
                    }
                }
            }

            @Override
            protected void dumpInfluence(SceneElement element, String msg, int diff) {
                if (this._dumpInfluences) {
                    Object user = element.getUserObject();
                    if (user instanceof EntrySprite) {
                        Log.log.info((Object)msg, new Object[]{"diff", diff, "entry", ((EntrySprite)user).getEntry().getReference()});
                    } else if (user instanceof ActorSprite) {
                        Log.log.info((Object)msg, new Object[]{"diff", diff, "actor", ((ActorSprite)user).getActor().getConfig()});
                    } else {
                        super.dumpInfluence(element, msg, diff);
                    }
                }
            }
        };
        this._scene.setParentScope(this);
        this._camhand = this.createCameraHandler();
        this._camcfg.apply(this._camhand);
        this._inputWindow = this._ctrl != null ? new StretchWindow(ctx, null){

            @Override
            public boolean shouldShadeBehind() {
                return false;
            }

            @Override
            public String getTooltipText() {
                Sprite sprite = TudeySceneView.this._ctrl.getHoverSprite();
                return sprite == null ? super.getTooltipText() : sprite.getTooltipText();
            }

            @Override
            public float getTooltipTimeout() {
                Sprite sprite = TudeySceneView.this._ctrl.getHoverSprite();
                return sprite == null ? super.getTooltipTimeout() : sprite.getTooltipTimeout();
            }

            @Override
            public String getTooltipWindowStyle() {
                Sprite sprite = TudeySceneView.this._ctrl.getHoverSprite();
                return sprite == null ? super.getTooltipWindowStyle() : sprite.getTooltipWindowStyle();
            }

            @Override
            protected Component createTooltipComponent(String tiptext) {
                Sprite sprite = TudeySceneView.this._ctrl.getHoverSprite();
                return sprite == null ? super.createTooltipComponent(tiptext) : sprite.createTooltipComponent(tiptext);
            }
        } : new StretchWindow(ctx, null){

            @Override
            public boolean shouldShadeBehind() {
                return false;
            }
        };
        this._inputWindow.setTooltipRelativeToMouse(true);
        this._inputWindow.setModal(true);
        this._records.add(new UpdateRecord(0, RunAnywhere.currentTimeMillis(), (HashIntMap<Actor>)new HashIntMap()));
    }

    public TudeySceneController getController() {
        return this._ctrl;
    }

    public OrbitCameraHandler getCameraHandler() {
        return this._camhand;
    }

    public Window getInputWindow() {
        return this._inputWindow;
    }

    public HashScene getScene() {
        return this._scene;
    }

    public HashSpace getActorSpace() {
        return this._actorSpace;
    }

    public int getControlDelta() {
        return this._advancedTime - this._delayedTime;
    }

    public int getDelayedTime() {
        return this._delayedTime;
    }

    public int getBufferDelay() {
        return TudeyUtil.getBufferDelay(this._elapsedAverage.value());
    }

    public int getPing() {
        return this._pingAverage.value();
    }

    public int getElapsed() {
        return this._elapsedAverage.value();
    }

    public int getAdvancedTime() {
        return this._advancedTime;
    }

    public int getInputAdvance() {
        return this._placeConfig.getInputAdvance(this._pingAverage.value());
    }

    public int getSmoothedTime() {
        return this._smoothedTime;
    }

    public long getControllerTime() {
        return this._controllerTime;
    }

    public long getTickerTime() {
        return this._tickerTime;
    }

    public int getTickerCount() {
        return this._tickerCount;
    }

    public void dumpTickers() {
        this._dumpTickers = true;
    }

    public long getSceneTime() {
        return this._sceneTime;
    }

    public void setSceneModel(TudeySceneModel model) {
        if (this._sceneModel != null) {
            this._sceneModel.removeObserver(this);
        }
        for (EntrySprite entrySprite : this._entrySprites.values()) {
            entrySprite.dispose();
        }
        this._entrySprites.clear();
        System.gc();
        System.runFinalization();
        this._sceneModel = model;
        this._sceneModel.addObserver(this);
        this._suppressMergeUpdates = true;
        for (TudeySceneModel.Entry entry : this._sceneModel.getEntries()) {
            try {
                this.addEntrySprite(entry);
            }
            catch (Exception e) {
                Log.log.warning((Object)"add entry sprite error", new Object[]{e});
            }
        }
        this._suppressMergeUpdates = false;
        for (Sprite sprite : this._mergedSprites.values()) {
            sprite.getModel().getConfig().wasUpdated();
        }
    }

    public Sprite getSprite(EntityKey key) {
        if (key instanceof EntityKey.Entry) {
            return this.getEntrySprite(((EntityKey.Entry)key).getKey());
        }
        if (key instanceof EntityKey.Actor) {
            return this.getActorSprite(((EntityKey.Actor)key).getId());
        }
        return null;
    }

    public EntrySprite getEntrySprite(Object key) {
        return this._entrySprites.get(key);
    }

    public ActorSprite getActorSprite(int id) {
        return (ActorSprite)this._actorSprites.get(id);
    }

    public ActorSprite getTargetSprite() {
        return this._targetSprite;
    }

    public ActorSprite getControlledSprite() {
        return this._controlledSprite;
    }

    public boolean canMerge() {
        return this.getMergeGranularity() > 0;
    }

    public Model maybeMerge(int x, int y, ConfigReference<ModelConfig> ref, Transform3D transform, final int floorFlags) {
        Model model;
        int granularity = this.getMergeGranularity();
        Coord key = new Coord(x >> granularity, y >> granularity);
        Sprite sprite = this._mergedSprites.get(key);
        if (sprite == null) {
            final Model fmodel = model = new Model(this._ctx){

                @Override
                protected void updateFromConfig() {
                    if (!TudeySceneView.this._suppressMergeUpdates) {
                        super.updateFromConfig();
                    }
                }
            };
            sprite = new Sprite(this._ctx, this){

                @Override
                public int getFloorFlags() {
                    return floorFlags;
                }

                @Override
                public Model getModel() {
                    return fmodel;
                }
            };
            this._mergedSprites.put(key, sprite);
            model.setUserObject(sprite);
            model.setConfig(new ModelConfig(new MergedStaticConfig(new CompoundConfig.ComponentModel[]{new CompoundConfig.ComponentModel(ref, transform)})){
                {
                    this._cfgmgr = this._configs = TudeySceneView.this._ctx.getConfigManager();
                }

                @Override
                protected void maybeFireOnConfigManager() {
                }
            });
            this._scene.add(model);
        } else {
            if (sprite.getFloorFlags() != floorFlags) {
                return null;
            }
            model = sprite.getModel();
            ModelConfig mconfig = model.getConfig();
            MergedStaticConfig impl = (MergedStaticConfig)mconfig.implementation;
            impl.models = (CompoundConfig.ComponentModel[])ArrayUtil.append((Object[])impl.models, (Object)new CompoundConfig.ComponentModel(ref, transform));
            mconfig.wasUpdated();
        }
        return model;
    }

    public boolean unmerge(int x, int y, ConfigReference<ModelConfig> ref, Transform3D transform) {
        if (this._disposed) {
            return true;
        }
        int granularity = this.getMergeGranularity();
        Coord key = new Coord(x >> granularity, y >> granularity);
        Sprite sprite = this._mergedSprites.get(key);
        if (sprite == null) {
            return false;
        }
        Model model = sprite.getModel();
        ModelConfig mconfig = sprite.getModel().getConfig();
        MergedStaticConfig impl = (MergedStaticConfig)mconfig.implementation;
        int ii = 0;
        while (ii < impl.models.length) {
            CompoundConfig.ComponentModel cmodel = impl.models[ii];
            if (Objects.equal(cmodel.model, ref) && cmodel.transform.equals(transform)) {
                if (impl.models.length == 1) {
                    this._scene.remove(model);
                    this._mergedSprites.remove(key);
                    if (this._loadingMerged != null) {
                        this._loadingMerged.remove(sprite);
                    }
                } else {
                    impl.models = (CompoundConfig.ComponentModel[])ArrayUtil.splice((Object[])impl.models, (int)ii, (int)1);
                    mconfig.wasUpdated();
                }
                return true;
            }
            ++ii;
        }
        return false;
    }

    public Sprite getIntersection(Ray3D ray, Vector3f location) {
        Predicate filter = Predicates.alwaysTrue();
        return this.getIntersection(ray, location, (Predicate<? super Sprite>)filter);
    }

    public Sprite getIntersection(Ray3D ray, Vector3f location, final Predicate<? super Sprite> filter) {
        SceneElement el = this._scene.getIntersection(ray, location, (Predicate<? super SceneElement>)new Predicate<SceneElement>(){

            public boolean apply(SceneElement element) {
                Object userObject = element.getUserObject();
                return userObject instanceof Sprite && filter.apply((Object)((Sprite)userObject));
            }
        });
        return el == null ? null : (Sprite)el.getUserObject();
    }

    public Transform3D getFloorTransform(float x, float y, float rotation, int mask) {
        return this.getFloorTransform(x, y, rotation, this._floorMaskFilter.init(mask));
    }

    public Transform3D getFloorTransform(float x, float y, float rotation, Predicate<? super SceneElement> filter) {
        return this.getFloorTransform(x, y, rotation, filter, new Transform3D(2));
    }

    public Transform3D getFloorTransform(float x, float y, float rotation, int mask, Transform3D result) {
        return this.getFloorTransform(x, y, rotation, this._floorMaskFilter.init(mask), result);
    }

    public Transform3D getFloorTransform(float x, float y, float rotation, Predicate<? super SceneElement> filter, Transform3D result) {
        Vector3f translation = result.getTranslation();
        translation.set(x, y, this.getFloorZ(x, y, filter, translation.z));
        result.getRotation().fromAngleAxis(1.5707964f + rotation, Vector3f.UNIT_Z);
        return result;
    }

    public float getFloorZ(float x, float y, int mask, float defvalue) {
        return this.getFloorZ(x, y, this._floorMaskFilter.init(mask), defvalue);
    }

    public float getFloorZ(float x, float y, Predicate<? super SceneElement> filter, float defvalue) {
        this._ray.getOrigin().set(x, y, 10000.0f);
        return this._scene.getIntersection(this._ray, this._isect, filter) == null ? defvalue : this._isect.z;
    }

    public ActorSprite prespawnActor(int timestamp, ActorSprite source, Vector2f translation, float rotation, ConfigReference<ActorConfig> ref) {
        ActorConfig.Original original;
        int id = -timestamp;
        ActorSprite osprite = (ActorSprite)this._actorSprites.get(id);
        if (osprite != null) {
            return null;
        }
        ConfigManager cfgmgr = this._ctx.getConfigManager();
        ActorConfig config = cfgmgr.getConfig(ActorConfig.class, ref);
        ActorConfig.Original original2 = original = config == null ? null : config.getOriginal(cfgmgr);
        if (original == null) {
            Log.log.warning((Object)"Failed to resolve actor config.", new Object[]{"actor", ref});
            return null;
        }
        Actor actor = original.createActor(ref, id, timestamp, translation, rotation);
        actor.init(cfgmgr);
        if (actor instanceof Prespawnable && source != null) {
            ((Prespawnable)((Object)actor)).noteSource(source.getActor());
        }
        ActorSprite sprite = new ActorSprite(this._ctx, this, timestamp, actor);
        this._actorSprites.put(id, (Object)sprite);
        return sprite;
    }

    public EffectSprite prefireEffect(int timestamp, EntityKey target, Vector2f translation, float rotation, ConfigReference<EffectConfig> ref) {
        Sprite sprite;
        EffectConfig.Original original;
        ConfigManager cfgmgr = this._ctx.getConfigManager();
        EffectConfig config = cfgmgr.getConfig(EffectConfig.class, ref);
        EffectConfig.Original original2 = original = config == null ? null : config.getOriginal(cfgmgr);
        if (original == null) {
            Log.log.warning((Object)"Failed to resolve effect config.", new Object[]{"effect", ref});
            return null;
        }
        if (target != null && (sprite = this.getSprite(target)) instanceof ActorSprite) {
            Actor a = ((ActorSprite)sprite).getActor();
            translation = translation == null ? a.getTranslation() : translation.add(a.getTranslation());
            rotation = FloatMath.normalizeAngle(rotation + a.getRotation());
        }
        Effect effect = original.createEffect(ref, timestamp, target, translation, rotation);
        effect.init(cfgmgr);
        return new EffectSprite(this._ctx, this, effect);
    }

    public boolean processSceneDelta(SceneDeltaEvent event) {
        Effect[] fired;
        int[] removed;
        ActorDelta[] updated;
        Object oactor3;
        int n;
        short s = event.getPing();
        this._ping = s;
        this._pingAverage.record(s);
        short elapsed = event.getElapsed();
        this._elapsedAverage.record(elapsed);
        int timestamp = event.getTimestamp();
        long now = RunAnywhere.currentTimeMillis();
        UpdateRecord lrecord = this._records.get(this._records.size() - 1);
        if (lrecord.getTimestamp() + elapsed == timestamp) {
            this.noteJitter((int)(now - lrecord.getReceived()) - elapsed);
        }
        int delayed = timestamp - this.getBufferDelay();
        int advanced = timestamp + this.getInputAdvance();
        if (this._smoother == null) {
            this._smoothedTime = timestamp;
            this._smoother = new TimeSmoother(this._smoothedTime);
            this._delayedTime = delayed;
            this._delayedSmoother = new TimeSmoother(this._delayedTime);
            this._advancedTime = advanced;
            this._advancedSmoother = new TimeSmoother(this._advancedTime);
        } else {
            this._smoother.update(timestamp);
            this._delayedSmoother.update(delayed);
            this._advancedSmoother.update(advanced);
        }
        if (!this.pruneRecords(event.getReference())) {
            return false;
        }
        HashIntMap<Actor> oactors = this._records.get(0).getActors();
        HashIntMap actors = new HashIntMap();
        HashSet uids = Sets.newHashSet();
        actors.putAll(oactors);
        Actor[] added = event.getAddedActors();
        if (added != null) {
            Actor[] actorArray = added;
            n = added.length;
            int n2 = 0;
            while (n2 < n) {
                Actor actor = actorArray[n2];
                actor.init(this._ctx.getConfigManager());
                oactor3 = (Actor)actors.put(actor.getId(), (Object)actor);
                uids.add(actor.getId());
                if (oactor3 != null) {
                    Log.log.warning((Object)(String.valueOf(event.getTimestamp()) + " ,Replacing existing actor."), new Object[]{"oactor", oactor3, "nactor", actor});
                }
                ++n2;
            }
        }
        if ((updated = event.getUpdatedActorDeltas()) != null) {
            oactor3 = updated;
            int n3 = updated.length;
            n = 0;
            while (n < n3) {
                ActorDelta delta = oactor3[n];
                int id = delta.getId();
                Actor oactor2 = (Actor)actors.get(id);
                if (oactor2 != null) {
                    Actor nactor = (Actor)delta.apply(oactor2);
                    nactor.init(this._ctx.getConfigManager());
                    actors.put(id, (Object)nactor);
                    uids.add(id);
                } else {
                    Log.log.warning((Object)"Missing actor for delta.", new Object[]{"delta", delta});
                }
                ++n;
            }
        }
        if ((removed = event.getRemovedActorIds()) != null) {
            int[] id = removed;
            int oactor3 = removed.length;
            int n4 = 0;
            while (n4 < oactor3) {
                int id2 = id[n4];
                actors.remove(id2);
                ++n4;
            }
        }
        this._records.add(new UpdateRecord(timestamp, now, (HashIntMap<Actor>)actors));
        if (this._loadingWindow != null && this._preloads == null) {
            this._preloads = new PreloadableSet(this._ctx);
            ((TudeySceneModel)this._ctx.getSceneDirector().getScene().getSceneModel()).getPreloads(this._preloads);
            ConfigManager cfgmgr = this._ctx.getConfigManager();
            for (Object actor : actors.values()) {
                ((Actor)actor).getPreloads(cfgmgr, this._preloads);
            }
            this._loadingActors = Lists.newArrayList((Iterable)actors.values());
            this.addExtraPreloads();
            return true;
        }
        block4: for (Actor actor : actors.values()) {
            ActorSprite sprite;
            int id = actor.getId();
            if (this._loadingActors != null) {
                int ii = 0;
                int nn = this._loadingActors.size();
                while (ii < nn) {
                    if (this._loadingActors.get(ii).getId() == id) {
                        this._loadingActors.set(ii, actor);
                        continue block4;
                    }
                    ++ii;
                }
            }
            if ((sprite = (ActorSprite)this._actorSprites.get(id)) != null) {
                if (this._ctrl.isControlledId(id)) {
                    this._ctrl.controlledActorUpdated(timestamp, actor);
                    continue;
                }
                sprite.update(timestamp, actor, uids.contains(id));
                continue;
            }
            this.addActorSprite(actor);
        }
        Iterator it = this._actorSprites.intEntrySet().iterator();
        while (it.hasNext()) {
            IntMap.IntEntry entry = (IntMap.IntEntry)it.next();
            int id = entry.getIntKey();
            if (id < 0) {
                ActorSprite sprite = (ActorSprite)entry.getValue();
                if (sprite.getActor().getCreated() > timestamp) continue;
                sprite.remove(timestamp);
                it.remove();
                continue;
            }
            if (actors.containsKey(id)) continue;
            ActorSprite sprite = (ActorSprite)entry.getValue();
            sprite.remove(timestamp);
            if (this._controlledSprite == sprite) {
                this._controlledSprite = null;
                this._ctrl.controlledSpriteRemoved(timestamp);
            }
            if (this._targetSprite == sprite) {
                this._targetSprite = this._controlledSprite;
            }
            it.remove();
        }
        if (this._loadingActors != null) {
            int ii = this._loadingActors.size() - 1;
            while (ii >= 0) {
                if (!actors.containsKey(this._loadingActors.get(ii).getId())) {
                    this._loadingActors.remove(ii);
                }
                --ii;
            }
        }
        if ((fired = event.getEffectsFired()) != null) {
            int last = this._records.get(this._records.size() - 2).getTimestamp();
            Effect[] effectArray = fired;
            int n5 = fired.length;
            int n6 = 0;
            while (n6 < n5) {
                Effect effect = effectArray[n6];
                if (!(effect.getTimestamp() <= last || effect instanceof Prefireable && effect.getClientOid() == this._ctx.getClient().getClientOid())) {
                    effect.init(this._ctx.getConfigManager());
                    new EffectSprite(this._ctx, this, effect);
                }
                ++n6;
            }
        }
        return true;
    }

    public void addTickParticipant(TickParticipant participant) {
        this._tickParticipants.add(participant);
    }

    public void addTickParticipant(TickParticipant participant, boolean prepend) {
        this._tickParticipants.add(prepend ? 0 : this._tickParticipants.size(), participant);
    }

    public void removeTickParticipant(TickParticipant participant) {
        this._tickParticipants.remove(participant);
    }

    public void updateTargetSprite() {
        this._targetSprite = (ActorSprite)this._actorSprites.get(this._ctrl.getTargetId());
    }

    public void updateControlledSprite() {
        this._controlledSprite = (ActorSprite)this._actorSprites.get(this._ctrl.getControlledId());
    }

    public void addCameraConfig(CameraConfig camcfg) {
        this.addCameraConfig(camcfg, 0.0f, null);
    }

    public void addCameraConfig(CameraConfig camcfg, float transition, Easing easing) {
        List cfgs = (List)this._camcfgs.get((Object)camcfg.priority, (Object)camcfg.zoom);
        if (cfgs == null) {
            cfgs = Lists.newArrayList();
            this._camcfgs.put((Object)camcfg.priority, (Object)camcfg.zoom, (Object)cfgs);
        }
        cfgs.add(camcfg);
        if (this.getTopCameraConfig() == camcfg) {
            this.setCameraConfig(camcfg, transition, easing);
        }
    }

    public boolean isCameraEffectEnable() {
        return true;
    }

    public void removeCameraConfig(CameraConfig camcfg) {
        this.removeCameraConfig(camcfg, 0.0f, null);
    }

    public void removeCameraConfig(CameraConfig camcfg, float transition, Easing easing) {
        CameraConfig topcfg = this.getTopCameraConfig();
        List cfgs = (List)this._camcfgs.get((Object)camcfg.priority, (Object)camcfg.zoom);
        if (cfgs != null && cfgs.remove(camcfg)) {
            if (cfgs.size() == 0) {
                this._camcfgs.remove((Object)camcfg.priority, (Object)camcfg.zoom);
            }
            if (camcfg == topcfg) {
                this.setCameraConfig(this.getTopCameraConfig(), transition, easing);
            }
        }
    }

    public void setPreferredZoom(int zoom) {
        this.setPreferredZoom(zoom, 0.0f, null);
    }

    public void setPreferredZoom(int zoom, float transition, Easing easing) {
        CameraConfig topcfg = this.getTopCameraConfig();
        this._zoom = zoom;
        CameraConfig cfg = this.getTopCameraConfig();
        if (topcfg != cfg) {
            this.setCameraConfig(cfg, transition, easing);
        }
    }

    public void dumpInfluences() {
        this._scene.dumpInfluences();
    }

    @Override
    public void wasAdded() {
        this._ctx.setCameraHandler(this._camhand);
        this._ctx.getRoot().addWindow(this._inputWindow);
        if (this._ctrl != null) {
            this._ctrl.wasAdded();
        }
    }

    @Override
    public void wasRemoved() {
        this._ctx.getRoot().removeWindow(this._inputWindow);
        if (this._loadingWindow != null) {
            this._ctx.getRoot().removeWindow(this._loadingWindow);
            this._loadingWindow = null;
        }
        if (this._ctrl != null) {
            this._ctrl.wasRemoved();
        }
        this.dispose();
        this._disposed = true;
        this._scene.dispose();
        this._actorSpace.dispose();
        for (EntrySprite entrySprite : this._entrySprites.values()) {
            entrySprite.dispose();
        }
        for (ActorSprite actorSprite : this._actorSprites.values()) {
            actorSprite.dispose();
        }
        this._entrySprites.clear();
        this._actorSprites.clear();
        this._mergedSprites.clear();
    }

    @Override
    public void tick(float elapsed) {
        if (this.doLoading()) {
            float ppct = 0.0f;
            float epct = 0.0f;
            float mpct = 0.0f;
            float apct = 0.0f;
            ppct = this._preloads.preloadBatch(50L);
            if (ppct == 1.0f && (epct = this.createEntrySpriteBatch()) == 1.0f && (mpct = this.initMergedSpriteBatch()) == 1.0f) {
                apct = this.createActorSpriteBatch();
            }
            this.updateLoadingWindow(ppct * 0.4f + epct * 0.3f + mpct * 0.2f + apct * 0.1f);
            if (apct == 1.0f) {
                this._loadingWindow = null;
                this._loadingEntries = null;
                this._loadingMerged = null;
                this._loadingActors = null;
                if (this._targetSprite != null) {
                    Vector3f translation = this._targetSprite.getModel().getLocalTransform().getTranslation();
                    this._camhand.getTarget().set(translation).addLocal(this._camcfg.offset);
                    this._camhand.updatePosition();
                }
            }
        }
        if (this._smoother != null) {
            this._smoothedTime = this._smoother.getTime();
            this._delayedTime = this._delayedSmoother.getTime();
            this._advancedTime = this._advancedSmoother.getTime();
        }
        long tick = System.nanoTime();
        if (this._ctrl != null) {
            this._ctrl.tick(elapsed);
        }
        long tock = System.nanoTime();
        this._controllerTime = tock - tick;
        int delayedTime = this.getDelayedTime();
        this._tickerCount = this._tickParticipants.size();
        long start = 0L;
        if (this._dumpTickers) {
            start = System.nanoTime();
            Log.log.info((Object)"TICKERS!!!", new Object[0]);
        }
        int ii = this._tickParticipants.size() - 1;
        while (ii >= 0) {
            TickParticipant tp = this._tickParticipants.get(ii);
            if (!tp.tick(delayedTime)) {
                this._tickParticipants.remove(ii);
            }
            if (this._dumpTickers) {
                this.dumpTicker(tp, System.nanoTime() - start);
                start = System.nanoTime();
            }
            --ii;
        }
        this._dumpTickers = false;
        tick = System.nanoTime();
        this._tickerTime = tick - tock;
        if (this._camtrans != null) {
            this._camtrans.tick(elapsed);
        }
        if (this.useMouseCamera) {
            if (!this.inited && this._targetSprite != null && this._last_event != null) {
                int detal = 5;
                int mover = 55;
                int x = this._last_event.getX();
                int y = this._last_event.getY();
                ActorSprite sprite = this.getControlledSprite();
                if (sprite != null && !this.doLoading()) {
                    int sh = this.getInputWindow().getHeight();
                    int sw = this.getInputWindow().getWidth();
                    if (x <= detal || y <= detal || x >= sw - detal || y >= sh - detal) {
                        int dx = 0;
                        int dy = 0;
                        if (x <= detal) {
                            dx = -mover;
                        }
                        if (x >= sw - detal) {
                            dx = mover;
                        }
                        if (y <= detal) {
                            dy = mover;
                        }
                        if (y >= sh - detal) {
                            dy = -mover;
                        }
                        this._camhand.panXY((float)dx * 0.01f, (float)(-dy) * 0.01f);
                    }
                }
            }
        } else if (this._targetSprite != null) {
            Vector3f translation = this._targetSprite.getModel().getLocalTransform().getTranslation();
            this._camhand.getTarget().set(translation).addLocal(this._camcfg.offset);
            this._camhand.updatePosition();
            this._last_translation.set(translation);
        }
        tick = System.nanoTime();
        this._scene.tick(this._loadingWindow == null ? elapsed : 0.0f);
        this._sceneTime = System.nanoTime() - tick;
    }

    public void setMouseMovedEvent(MouseEvent event) {
        if (!this.inited && this._camhand != null && this._targetSprite != null) {
            this._last_event = event;
        }
    }

    @Override
    public void composite() {
        if (this._loadingWindow == null) {
            this._scene.composite();
        }
    }

    public void willEnterPlace(PlaceObject plobj) {
        this._tsobj = (TudeySceneObject)plobj;
        this._ctx.getOccupantDirector().addOccupantObserver((OccupantObserver)this);
        this._ctx.getChatDirector().addChatDisplay((ChatDisplay)this);
        TudeySceneModel model = (TudeySceneModel)this._ctx.getSceneDirector().getScene().getSceneModel();
        model.init(model.getConfigManager());
        if (this._pathfinder == null) {
            this._pathfinder = new Pathfinder(this);
        }
        this._pathfinder.setSceneModel(model);
        this._loadingWindow = this.maybeCreateLoadingWindow(model);
        if (this._loadingWindow == null) {
            this.setSceneModel(model);
            return;
        }
        this._ctx.getRoot().addWindow(this._loadingWindow);
        this.updateLoadingWindow(0.0f);
        System.gc();
        System.runFinalization();
    }

    public void didLeavePlace(PlaceObject plobj) {
        if (this._sceneModel != null) {
            this._sceneModel.removeObserver(this);
        }
        if (this._pathfinder != null) {
            this._pathfinder.clear();
        }
        this._ctx.getOccupantDirector().removeOccupantObserver((OccupantObserver)this);
        this._ctx.getChatDirector().removeChatDisplay((ChatDisplay)this);
        this._tsobj = null;
    }

    @Override
    public void entryAdded(TudeySceneModel.Entry entry) {
        this.addEntrySprite(entry);
    }

    @Override
    public void entryUpdated(TudeySceneModel.Entry oentry, TudeySceneModel.Entry nentry) {
        this.addPreloads(nentry);
        Object key = nentry.getKey();
        EntrySprite sprite = this._entrySprites.get(key);
        if (sprite != null) {
            sprite.update(nentry);
            return;
        }
        if (this._loadingEntries != null) {
            int ii = 0;
            int nn = this._loadingEntries.size();
            while (ii < nn) {
                TudeySceneModel.Entry entry = this._loadingEntries.get(ii);
                if (entry.getKey().equals(key)) {
                    this._loadingEntries.set(ii, nentry);
                    return;
                }
                ++ii;
            }
        }
        Log.log.warning((Object)"Missing sprite to update.", new Object[]{"entry", nentry});
    }

    @Override
    public void entryRemoved(TudeySceneModel.Entry oentry) {
        Object key = oentry.getKey();
        EntrySprite sprite = this._entrySprites.remove(key);
        if (sprite != null) {
            sprite.dispose();
            return;
        }
        if (this._loadingEntries != null) {
            int ii = 0;
            int nn = this._loadingEntries.size();
            while (ii < nn) {
                TudeySceneModel.Entry entry = this._loadingEntries.get(ii);
                if (entry.getKey().equals(key)) {
                    this._loadingEntries.remove(ii);
                    return;
                }
                ++ii;
            }
        }
        Log.log.warning((Object)"Missing entry sprite to remove.", new Object[]{"entry", oentry});
    }

    public void occupantEntered(OccupantInfo info) {
        TudeyOccupantInfo toi = (TudeyOccupantInfo)info;
        ActorSprite sprite = (ActorSprite)this._actorSprites.get(toi.pawnId);
        if (sprite != null) {
            sprite.occupantEntered(toi);
        }
    }

    public void occupantLeft(OccupantInfo info) {
        TudeyOccupantInfo toi = (TudeyOccupantInfo)info;
        ActorSprite sprite = (ActorSprite)this._actorSprites.get(toi.pawnId);
        if (sprite != null) {
            sprite.occupantLeft(toi);
        }
    }

    public void occupantUpdated(OccupantInfo oinfo, OccupantInfo ninfo) {
        TudeyOccupantInfo otoi = (TudeyOccupantInfo)oinfo;
        ActorSprite sprite = (ActorSprite)this._actorSprites.get(otoi.pawnId);
        if (sprite != null) {
            sprite.occupantUpdated(otoi, (TudeyOccupantInfo)ninfo);
        }
    }

    public boolean displayMessage(ChatMessage msg, boolean alreadyDisplayed) {
        if (!(msg instanceof UserMessage) || msg instanceof TellFeedbackMessage || !"placeChat".equals(msg.localtype) && !this.getChatType().equals(msg.localtype)) {
            return false;
        }
        UserMessage umsg = (UserMessage)msg;
        TudeyOccupantInfo info = (TudeyOccupantInfo)this._ctx.getOccupantDirector().getOccupantInfo(umsg.speaker);
        if (info == null) {
            return false;
        }
        ActorSprite sprite = (ActorSprite)this._actorSprites.get(info.pawnId);
        return sprite != null && sprite.displayMessage(umsg, alreadyDisplayed);
    }

    public void clear() {
        for (ActorSprite sprite : this._actorSprites.values()) {
            sprite.clearMessages();
        }
    }

    @Override
    public ConfigManager getConfigManager() {
        return this._ctx.getConfigManager();
    }

    @Override
    public TudeySceneModel getSceneModel() {
        return this._sceneModel;
    }

    @Override
    public boolean getPenetration(Actor actor, Shape shape, Vector2f result) {
        result.set(Vector2f.ZERO);
        this._sceneModel.getPenetration(actor, shape, result);
        this._actorSpace.getIntersecting(shape, this._elements);
        int ii = 0;
        int nn = this._elements.size();
        while (ii < nn) {
            SpaceElement element = this._elements.get(ii);
            Actor oactor = ((ActorSprite)element.getUserObject()).getActor();
            if (actor.canCollide(oactor)) {
                ((ShapeElement)element).getWorldShape().getPenetration(shape, this._penetration);
                if (this._penetration.lengthSquared() > result.lengthSquared()) {
                    result.set(this._penetration);
                }
            }
            ++ii;
        }
        this._elements.clear();
        return !result.equals(Vector2f.ZERO);
    }

    @Override
    public boolean getIntersection(Ray2D ray, float length, int mask, int timestamp, Vector2f intersection) {
        if (mask == 0) {
            return false;
        }
        boolean intersects = this.getSceneModel().getIntersection(ray, length, mask, intersection);
        float resultDist = intersects ? ray.getOrigin().distanceSquared(intersection) : length * length;
        Segment seg = new Segment(ray.getOrigin(), ray.getOrigin().add(ray.getDirection().mult(length)));
        this._actorSpace.getIntersecting(seg, this._elements);
        Vector2f result = new Vector2f();
        int ii = 0;
        int nn = this._elements.size();
        while (ii < nn) {
            float dist;
            SpaceElement element = this._elements.get(ii);
            ActorSprite logic = (ActorSprite)element.getUserObject();
            Actor actor = logic.getActor();
            if (timestamp < actor.getDestroyed() && (actor.getCollisionFlags() & mask) != 0 && ((ShapeElement)element).getWorldShape().getIntersection(ray, result) && (dist = ray.getOrigin().distanceSquared(result)) < resultDist) {
                intersection.set(result);
                resultDist = dist;
            }
            ++ii;
        }
        this._elements.clear();
        return resultDist < length * length;
    }

    @Override
    public boolean collides(Actor actor, Shape shape) {
        if (this._sceneModel != null && this._sceneModel.collides(actor, shape)) {
            return true;
        }
        this._actorSpace.getIntersecting(shape, this._elements);
        try {
            int ii = 0;
            int nn = this._elements.size();
            while (ii < nn) {
                SpaceElement element = this._elements.get(ii);
                Actor oactor = ((ActorSprite)element.getUserObject()).getActor();
                if (actor.canCollide(oactor)) {
                    return true;
                }
                ++ii;
            }
        }
        finally {
            this._elements.clear();
        }
        return false;
    }

    @Override
    public int getDirections(Actor actor, Shape shape) {
        return this._sceneModel.getDirections(actor, shape);
    }

    public boolean collides(int mask, Shape shape) {
        if (this._sceneModel.collides(mask, shape)) {
            return true;
        }
        this._actorSpace.getIntersecting(shape, this._elements);
        try {
            int ii = 0;
            int nn = this._elements.size();
            while (ii < nn) {
                SpaceElement element = this._elements.get(ii);
                Actor oactor = ((ActorSprite)element.getUserObject()).getActor();
                if ((oactor.getCollisionFlags() & mask) != 0) {
                    return true;
                }
                ++ii;
            }
        }
        finally {
            this._elements.clear();
        }
        return false;
    }

    protected OrbitCameraHandler createCameraHandler() {
        return new OrbitCameraHandler(this._ctx);
    }

    protected void setCameraConfig(CameraConfig camcfg, final float transition, final Easing easing) {
        if (transition <= 0.0f) {
            this._camcfg.set(camcfg).apply(this._camhand);
            this._camtrans = null;
            return;
        }
        final CameraConfig ocamcfg = new CameraConfig(this._camcfg);
        final CameraConfig ncamcfg = new CameraConfig(camcfg);
        this._camtrans = new Tickable(){
            protected float _total;

            @Override
            public void tick(float elapsed) {
                float f;
                this._total += elapsed;
                if (f >= transition) {
                    TudeySceneView.this.setCameraConfig(ncamcfg, 0.0f, null);
                } else {
                    ocamcfg.lerp(ncamcfg, easing.getTime(this._total / transition), TudeySceneView.this._camcfg).apply(TudeySceneView.this._camhand);
                }
            }
        };
    }

    protected Window maybeCreateLoadingWindow(TudeySceneModel model) {
        return null;
    }

    protected float createEntrySpriteBatch() {
        if (this._loadingEntries != null && this._loadingEntries.isEmpty()) {
            return 1.0f;
        }
        TudeySceneModel model = (TudeySceneModel)this._ctx.getSceneDirector().getScene().getSceneModel();
        Collection<TudeySceneModel.Entry> entries = model.getEntries();
        if (this._loadingEntries == null) {
            this._loadingEntries = Lists.newArrayList(entries);
            this._sceneModel = model;
            this._sceneModel.addObserver(this);
            this._suppressMergeUpdates = true;
        }
        long end = System.currentTimeMillis() + 50L;
        int ii = this._loadingEntries.size() - 1;
        while (ii >= 0 && System.currentTimeMillis() < end) {
            this.addEntrySprite(this._loadingEntries.remove(ii));
            --ii;
        }
        if (this._loadingEntries.isEmpty()) {
            return 1.0f;
        }
        return (float)this._entrySprites.size() / (float)entries.size();
    }

    protected float initMergedSpriteBatch() {
        if (this._loadingMerged != null && this._loadingMerged.isEmpty()) {
            return 1.0f;
        }
        if (this._loadingMerged == null) {
            this._loadingMerged = Lists.newArrayList(this._mergedSprites.values());
            this._suppressMergeUpdates = false;
        }
        long end = System.currentTimeMillis() + 50L;
        int ii = this._loadingMerged.size() - 1;
        while (ii >= 0 && System.currentTimeMillis() < end) {
            this._loadingMerged.remove(ii).getModel().getConfig().wasUpdated();
            --ii;
        }
        int size = this._loadingMerged.size();
        if (size == 0) {
            return 1.0f;
        }
        return 1.0f - (float)size / (float)this._mergedSprites.size();
    }

    protected float createActorSpriteBatch() {
        if (this._loadingActors != null && this._loadingActors.isEmpty()) {
            return 1.0f;
        }
        HashIntMap<Actor> actors = this._records.get(this._records.size() - 1).getActors();
        if (this._loadingActors == null) {
            this._loadingActors = Lists.newArrayList((Iterable)actors.values());
        }
        long end = System.currentTimeMillis() + 50L;
        int ii = this._loadingActors.size() - 1;
        while (ii >= 0 && System.currentTimeMillis() < end) {
            this.addActorSprite(this._loadingActors.remove(ii));
            --ii;
        }
        if (this._loadingActors.isEmpty()) {
            System.gc();
            System.runFinalization();
            return 1.0f;
        }
        return (float)this._actorSprites.size() / (float)actors.size();
    }

    protected void updateLoadingWindow(float pct) {
        if (pct == 1.0f) {
            this._ctx.getRoot().removeWindow(this._loadingWindow);
        }
    }

    protected void addEntrySprite(TudeySceneModel.Entry entry) {
        this.addPreloads(entry);
        this._entrySprites.put(entry.getKey(), entry.createSprite(this._ctx, this));
    }

    protected void addActorSprite(Actor actor) {
        ActorSprite sprite;
        this.addPreloads(actor);
        int id = actor.getId();
        int timestamp = this._records.get(this._records.size() - 1).getTimestamp();
        if (actor instanceof Prespawnable && ((Prespawnable)((Object)actor)).getClientOid() == this._ctx.getClient().getClientOid() && (sprite = (ActorSprite)this._actorSprites.remove(-actor.getCreated())) != null) {
            this._actorSprites.put(id, (Object)sprite);
            sprite.reinit(timestamp, actor);
            return;
        }
        sprite = new ActorSprite(this._ctx, this, timestamp, actor);
        this._actorSprites.put(id, (Object)sprite);
        if (this._ctrl != null) {
            if (id == this._ctrl.getControlledId()) {
                this._controlledSprite = sprite;
                this._ctrl.controlledActorAdded(timestamp, actor);
            }
            if (id == this._ctrl.getTargetId()) {
                this._targetSprite = sprite;
            }
        }
    }

    protected void addPreloads(TudeySceneModel.Entry entry) {
        if (this._preloads != null) {
            entry.getPreloads(this._ctx.getConfigManager(), this._preloads);
        }
    }

    protected void addPreloads(Actor actor) {
        if (this._preloads != null) {
            actor.getPreloads(this._ctx.getConfigManager(), this._preloads);
        }
    }

    protected void addPreloads(Effect effect) {
        if (this._preloads != null) {
            effect.getPreloads(this._ctx.getConfigManager(), this._preloads);
        }
    }

    protected void addExtraPreloads() {
    }

    protected int getMergeGranularity() {
        return 2;
    }

    protected void noteJitter(int value) {
    }

    protected boolean pruneRecords(int reference) {
        int ii = this._records.size() - 1;
        while (ii >= 0) {
            if (this._records.get(ii).getTimestamp() == reference) {
                this._records.subList(0, ii).clear();
                return true;
            }
            --ii;
        }
        return false;
    }

    protected String getChatType() {
        return "placeChat";
    }

    public boolean doLoading() {
        return this._loadingWindow != null && this._preloads != null && this._ctx.getSceneDirector() != null && this._ctx.getSceneDirector().getScene() != null;
    }

    protected CameraConfig getTopCameraConfig() {
        if (this._camcfgs.isEmpty()) {
            return TudeySceneMetrics.getDefaultCameraConfig();
        }
        Integer priority = (Integer)this._camcfgs.rowKeySet().last();
        SortedMap map = this._camcfgs.row((Object)priority);
        Integer zoom = this._zoom;
        List cfgs = (List)map.get(this._zoom);
        if (cfgs == null) {
            SortedMap submap = map.headMap(this._zoom);
            Integer n = zoom = submap.isEmpty() ? null : submap.lastKey();
            if (zoom != null) {
                cfgs = (List)map.get(zoom);
            } else {
                zoom = map.tailMap(this._zoom).firstKey();
                cfgs = (List)map.get(zoom);
            }
        }
        return (CameraConfig)cfgs.get(cfgs.size() - 1);
    }

    protected void dumpTicker(TickParticipant tp, long time) {
        time /= 1000L;
        if (tp instanceof ActorSprite) {
            ActorSprite sprite = (ActorSprite)tp;
            Log.log.info((Object)"  ", new Object[]{"time", time, "actor", sprite.getActor().getConfig()});
        } else if (tp instanceof EffectSprite) {
            EffectSprite sprite = (EffectSprite)tp;
            Log.log.info((Object)"  ", new Object[]{"time", time, "effect", sprite.getEffect().getConfig()});
        } else {
            Log.log.info((Object)"  ", new Object[]{"time", time, "ticker", tp});
        }
    }

    protected static class FloorMaskFilter
    implements Predicate<SceneElement> {
        protected int _mask;

        protected FloorMaskFilter() {
        }

        public FloorMaskFilter init(int mask) {
            this._mask = mask;
            return this;
        }

        public boolean apply(SceneElement element) {
            Object obj = element.getUserObject();
            return obj instanceof Sprite && (((Sprite)obj).getFloorFlags() & this._mask) != 0;
        }
    }

    public static interface TickParticipant {
        public boolean tick(int var1);
    }

    protected static class UpdateRecord {
        protected int _timestamp;
        protected long _received;
        protected HashIntMap<Actor> _actors;

        public UpdateRecord(int timestamp, long received, HashIntMap<Actor> actors) {
            this._timestamp = timestamp;
            this._received = received;
            this._actors = actors;
        }

        public int getTimestamp() {
            return this._timestamp;
        }

        public long getReceived() {
            return this._received;
        }

        public HashIntMap<Actor> getActors() {
            return this._actors;
        }
    }
}

