/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.util;

import com.threerings.opengl.compositor.Compositor;
import com.threerings.opengl.gui.text.CharacterTextFactory;
import com.threerings.opengl.gui.text.Text;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.SimpleOverlay;
import java.awt.Font;

public class Stats
extends SimpleOverlay {
    protected CharacterTextFactory _textFactory;
    protected Text _stats;
    protected long _lastUpdate = System.currentTimeMillis();
    protected int _frameCount;
    protected static final long REPORT_INTERVAL = 1000L;

    public Stats(GlContext ctx) {
        super(ctx);
        this._textFactory = CharacterTextFactory.getInstance(new Font("Dialog", 0, 12), true, 0.0f);
        this._stats = this._textFactory.createText("", Color4f.WHITE, 0, 0, Color4f.BLACK, true);
    }

    @Override
    public void composite() {
        Compositor compositor = this._ctx.getCompositor();
        if (compositor.getSubrenderDepth() > 0) {
            return;
        }
        compositor.addEnqueueable(this);
        ++this._frameCount;
        long now = System.currentTimeMillis();
        long interval = now - this._lastUpdate;
        if (interval >= 1000L) {
            int fps = (int)((long)(this._frameCount * 1000) / interval);
            Renderer renderer = this._ctx.getRenderer();
            this._stats = this._textFactory.createText(fps + " fps (" + "b: " + renderer.getBatchCount() + "; " + "p: " + renderer.getPrimitiveCount() + "; tc: " + renderer.getTextureChangeCount() + ") [bo: " + renderer.getBufferObjectCount() + "/" + renderer.getBufferObjectBytes() / 1024 + "k, tx: " + renderer.getTextureCount() + "/" + renderer.getTextureBytes() / 1024 + "k]", Color4f.WHITE, 0, 0, Color4f.BLACK, true);
            this._lastUpdate = now;
            this._frameCount = 0;
        }
    }

    @Override
    protected void draw() {
        this._stats.render(this._ctx.getRenderer(), 16, this.getY(), 1.0f);
    }

    protected int getY() {
        return 16;
    }
}

