/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.samskivert.util.ArrayUtil;
import com.threerings.config.ConfigReference;
import com.threerings.editor.Log;
import com.threerings.editor.PathProperty;
import com.threerings.editor.Property;
import com.threerings.editor.swing.BaseEditorPanel;
import com.threerings.editor.swing.BasePropertyEditor;
import com.threerings.editor.swing.editors.BooleanEditor;
import com.threerings.editor.swing.editors.ChoiceEditor;
import com.threerings.editor.swing.editors.Color4fEditor;
import com.threerings.editor.swing.editors.ColorizationEditor;
import com.threerings.editor.swing.editors.ConfigEditor;
import com.threerings.editor.swing.editors.ConfigReferenceEditor;
import com.threerings.editor.swing.editors.DateTimeEditor;
import com.threerings.editor.swing.editors.EnumEditor;
import com.threerings.editor.swing.editors.EnumPanelArrayListEditor;
import com.threerings.editor.swing.editors.FileEditor;
import com.threerings.editor.swing.editors.GetPathEditor;
import com.threerings.editor.swing.editors.MaskEditor;
import com.threerings.editor.swing.editors.NumberEditor;
import com.threerings.editor.swing.editors.ObjectEditor;
import com.threerings.editor.swing.editors.ObjectPanelArrayListEditor;
import com.threerings.editor.swing.editors.PathTableArrayListEditor;
import com.threerings.editor.swing.editors.PropertyViewer;
import com.threerings.editor.swing.editors.QuaternionEditor;
import com.threerings.editor.swing.editors.ResourceEditor;
import com.threerings.editor.swing.editors.StringEditor;
import com.threerings.editor.swing.editors.TableArrayListEditor;
import com.threerings.editor.swing.editors.Transform2DEditor;
import com.threerings.editor.swing.editors.Transform3DEditor;
import com.threerings.editor.swing.editors.Vector2fEditor;
import com.threerings.editor.swing.editors.Vector3fEditor;
import com.threerings.editor.util.EditorContext;
import com.threerings.editor.util.PropertyUtil;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform2D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.util.ReflectionUtil;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class PropertyEditor
extends BasePropertyEditor {
    protected EditorContext _ctx;
    protected Property _property;
    protected Property[] _lineage;
    protected Object _object;
    protected static HashMap<String, Class<? extends PropertyEditor>> _classesByName = new HashMap();
    protected static HashMap<Class<?>, Class<? extends PropertyEditor>> _classesByType = new HashMap();

    public static PropertyEditor createEditor(EditorContext ctx, Property property, Property[] ancestors) {
        PropertyEditor editor;
        String name = property.getAnnotation().editor();
        Class<? extends PropertyEditor> clazz = null;
        if (name.length() > 0 && (clazz = _classesByName.get(name)) == null) {
            Log.log.warning((Object)("Missing custom editor class [name=" + name + "]."), new Object[0]);
        }
        Class<?> type = property.getType();
        if (clazz != null || (clazz = _classesByType.get(type)) != null) {
            try {
                editor = clazz.newInstance();
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to create property editor.", new Object[]{e});
                editor = new ObjectEditor();
            }
        } else if (type.isEnum()) {
            editor = new EnumEditor();
        } else if (type.isArray() || List.class.isAssignableFrom(type)) {
            try {
                editor = PropertyEditor.getArrayListEditorType(property).newInstance();
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to create array list editor.", new Object[]{e});
                editor = new ObjectEditor();
            }
        } else {
            editor = new ObjectEditor();
        }
        editor.init(ctx, property, ancestors);
        return editor;
    }

    public static Class<? extends PropertyEditor> getArrayListEditorType(Property property) {
        Class<?> ctype = property.getComponentType();
        if (PropertyEditor.isTableCellType(ctype) || ctype.isArray() && PropertyEditor.isTableCellType(ctype.getComponentType())) {
            return TableArrayListEditor.class;
        }
        if (ctype.isEnum() || ctype.isArray() && ctype.getComponentType().isEnum()) {
            return EnumPanelArrayListEditor.class;
        }
        return ObjectPanelArrayListEditor.class;
    }

    public static void registerEditorClass(Class<?> type, Class<? extends PropertyEditor> clazz) {
        _classesByType.put(type, clazz);
    }

    public static void registerEditorClass(String name, Class<? extends PropertyEditor> clazz) {
        _classesByName.put(name, clazz);
    }

    public void init(EditorContext ctx, Property property, Property[] ancestors) {
        Property[] propertyArray;
        this._ctx = ctx;
        this._msgmgr = ctx.getMessageManager();
        this._msgs = this._msgmgr.getBundle("editor.default");
        this._property = property;
        if (ancestors == null) {
            Property[] propertyArray2 = new Property[1];
            propertyArray = propertyArray2;
            propertyArray2[0] = this._property;
        } else {
            propertyArray = (Property[])ArrayUtil.append((Object[])ancestors, (Object)this._property);
        }
        this._lineage = propertyArray;
        this.setBackground(this.getBackgroundColor(this._lineage));
        this.didInit();
    }

    @Override
    public String getComponentPath(Component comp, boolean mouse) {
        if (this.getProperty() instanceof PathProperty) {
            return "[\"" + this.getProperty().getName().replace("\"", "\\\"") + "\"]";
        }
        return this.getProperty().getName();
    }

    public Property getProperty() {
        return this._property;
    }

    public void setObject(Object object) {
        this._object = object;
        this.update();
    }

    public Object getObject() {
        return this._object;
    }

    public abstract void update();

    protected void didInit() {
    }

    protected String getPropertyLabel() {
        return this.getLabel(this._property);
    }

    protected void addUnits(JPanel panel) {
        String units = this.getUnits();
        if (units.length() > 0) {
            panel.add(new JLabel(this.getLabel(units, this._property.getMessageBundle())));
        }
    }

    protected BaseEditorPanel findBaseEditor() {
        BaseEditorPanel bep = null;
        for (Object c = this; c != null; c = ((Component)c).getParent()) {
            if (!(c instanceof BaseEditorPanel)) continue;
            bep = (BaseEditorPanel)c;
        }
        return bep;
    }

    protected Object getRootObject() {
        BaseEditorPanel bep = this.findBaseEditor();
        return bep == null ? null : bep.getObject();
    }

    protected int getPropertyColor() {
        return this.getPropertyColor(this._lineage);
    }

    protected String getMode() {
        return PropertyUtil.getMode(this._lineage);
    }

    protected String getUnits() {
        return PropertyUtil.getUnits(this._lineage);
    }

    protected double getMinimum() {
        return PropertyUtil.getMinimum(this._lineage);
    }

    protected double getMaximum() {
        return PropertyUtil.getMaximum(this._lineage);
    }

    protected double getStep() {
        return PropertyUtil.getStep(this._lineage);
    }

    protected double getScale() {
        return PropertyUtil.getScale(this._lineage);
    }

    protected int getMinSize() {
        return PropertyUtil.getMinSize(this._lineage);
    }

    protected int getMaxSize() {
        return PropertyUtil.getMaxSize(this._lineage);
    }

    protected static boolean isTableCellType(Class<?> type) {
        return type.isPrimitive() || Number.class.isAssignableFrom(type) || type == Boolean.class || type == Character.class || type == String.class;
    }

    protected static Object getDefaultInstance(Class<?> type, Object outer) {
        if (type == Boolean.class || type == Boolean.TYPE) {
            return false;
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Character.class || type == Character.TYPE) {
            return Character.valueOf(' ');
        }
        if (type == Double.class || type == Double.TYPE) {
            return 0.0;
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.class || type == Long.TYPE) {
            return 0L;
        }
        if (type == Short.class || type == Short.TYPE) {
            return (short)0;
        }
        if (type == String.class) {
            return "";
        }
        if (type.isEnum()) {
            return type.getEnumConstants()[0];
        }
        if (type.isArray()) {
            return Array.newInstance(type.getComponentType(), 0);
        }
        return ReflectionUtil.newInstance(type, outer);
    }

    static {
        PropertyEditor.registerEditorClass("choice", ChoiceEditor.class);
        PropertyEditor.registerEditorClass("colorization", ColorizationEditor.class);
        PropertyEditor.registerEditorClass("config", ConfigEditor.class);
        PropertyEditor.registerEditorClass("resource", ResourceEditor.class);
        PropertyEditor.registerEditorClass("table", TableArrayListEditor.class);
        PropertyEditor.registerEditorClass("mask", MaskEditor.class);
        PropertyEditor.registerEditorClass("paths", PathTableArrayListEditor.class);
        PropertyEditor.registerEditorClass("getPath", GetPathEditor.class);
        PropertyEditor.registerEditorClass("viewer", PropertyViewer.class);
        PropertyEditor.registerEditorClass("datetime", DateTimeEditor.class);
        PropertyEditor.registerEditorClass("date", DateTimeEditor.DateOnlyEditor.class);
        PropertyEditor.registerEditorClass("time", DateTimeEditor.TimeOnlyEditor.class);
        PropertyEditor.registerEditorClass(Boolean.class, BooleanEditor.class);
        PropertyEditor.registerEditorClass(Boolean.TYPE, BooleanEditor.class);
        PropertyEditor.registerEditorClass(Byte.class, NumberEditor.class);
        PropertyEditor.registerEditorClass(Byte.TYPE, NumberEditor.class);
        PropertyEditor.registerEditorClass(Color4f.class, Color4fEditor.class);
        PropertyEditor.registerEditorClass(ConfigReference.class, ConfigReferenceEditor.class);
        PropertyEditor.registerEditorClass(Double.class, NumberEditor.class);
        PropertyEditor.registerEditorClass(Double.TYPE, NumberEditor.class);
        PropertyEditor.registerEditorClass(File.class, FileEditor.class);
        PropertyEditor.registerEditorClass(Float.class, NumberEditor.class);
        PropertyEditor.registerEditorClass(Float.TYPE, NumberEditor.class);
        PropertyEditor.registerEditorClass(Integer.class, NumberEditor.class);
        PropertyEditor.registerEditorClass(Integer.TYPE, NumberEditor.class);
        PropertyEditor.registerEditorClass(Long.class, NumberEditor.class);
        PropertyEditor.registerEditorClass(Long.TYPE, NumberEditor.class);
        PropertyEditor.registerEditorClass(Quaternion.class, QuaternionEditor.class);
        PropertyEditor.registerEditorClass(Short.class, NumberEditor.class);
        PropertyEditor.registerEditorClass(Short.TYPE, NumberEditor.class);
        PropertyEditor.registerEditorClass(String.class, StringEditor.class);
        PropertyEditor.registerEditorClass(Date.class, DateTimeEditor.class);
        PropertyEditor.registerEditorClass(Transform2D.class, Transform2DEditor.class);
        PropertyEditor.registerEditorClass(Transform3D.class, Transform3DEditor.class);
        PropertyEditor.registerEditorClass(Vector2f.class, Vector2fEditor.class);
        PropertyEditor.registerEditorClass(Vector3f.class, Vector3fEditor.class);
    }
}

