/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import java.util.concurrent.atomic.AtomicInteger;

public class ThreadLocalLogger {
    private static boolean isDebug = false;
    private static ThreadLocal<Object> local = new ThreadLocal();
    private static AtomicInteger index = new AtomicInteger(0);

    public static void start(Object obj, String phaser, Object msg) {
        if (isDebug) {
            local.set(obj);
            System.out.println("<<start index=" + index.getAndIncrement() + "," + phaser + "," + msg);
        }
    }

    public static void stop(Object obj, String phaser, Object msg) {
        if (isDebug && local.get() == obj) {
            local.set(null);
            System.out.println(">>>end index=" + index.getAndIncrement() + "," + phaser + "," + msg);
        }
    }

    public static void log(Object obj, String phaser, Object msg) {
        if (isDebug && local.get() == obj) {
            System.out.println("index=" + index.getAndIncrement() + "," + phaser + "," + msg);
        }
    }
}

