/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.threerings.math.Vector2f;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.data.actor.Mobile;
import com.threerings.tudey.util.ActorAdvancer;

public class MobileAdvancer
extends ActorAdvancer {
    protected Mobile _mobile;
    protected Vector2f _penetration = new Vector2f();
    protected Vector2f _otrans = new Vector2f();
    protected static final float MAX_SUBSTEP = 0.16666667f;

    public MobileAdvancer(ActorAdvancer.Environment environment, Mobile mobile, int timestamp) {
        super(environment, mobile, timestamp);
    }

    @Override
    public void init(Actor actor, int timestamp) {
        super.init(actor, timestamp);
        this._mobile = (Mobile)actor;
        if (timestamp == this._mobile.getCreated() && ((ActorConfig.Mobile)this._mobile.getOriginal()).startMoving) {
            this._mobile.setDirection(this._mobile.getRotation());
            this._mobile.set(2);
        }
    }

    @Override
    protected void step(float elapsed) {
        this.takeSubsteps(elapsed);
    }

    protected void takeSubsteps(float elapsed) {
        while (elapsed > 0.0f) {
            float nelapsed = Math.max(elapsed - 0.16666667f, 0.0f);
            this.substep(elapsed - nelapsed, this._timestamp - (int)(nelapsed * 1000.0f));
            elapsed = nelapsed;
        }
    }

    protected void substep(float elapsed, int timestamp) {
        this._otrans.set(this._mobile.getTranslation());
        this.mobileStep(elapsed, timestamp);
        Vector2f translation = this._mobile.getTranslation();
        if (translation.equals(this._otrans)) {
            return;
        }
        if (translation.distanceSquared(this._otrans) > this._mobile.getMaxStepSquared()) {
            Vector2f step = translation.subtract(this._otrans).normalizeLocal().multLocal(this._mobile.getMaxStep());
            this._otrans.add(step, translation);
        }
        this._mobile.setDirty(true);
        for (int ii = 0; ii < 3; ++ii) {
            this.updateShape();
            if (!this._environment.getPenetration(this._mobile, this._shape, this._penetration)) {
                return;
            }
            this._mobile.getTranslation().addScaledLocal(this._penetration, 1.001f);
        }
        this._mobile.getTranslation().set(this._otrans);
    }

    protected void mobileStep(float elapsed, int timestamp) {
        this._mobile.step(elapsed, timestamp, this._environment.getDirections(this._mobile, this._shape));
    }
}

