/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.sprite;

import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.expr.Bound;
import com.threerings.expr.Scope;
import com.threerings.expr.SimpleScope;
import com.threerings.math.Transform3D;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.Log;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.sprite.EntrySprite;
import com.threerings.tudey.client.util.RectangleElement;
import com.threerings.tudey.config.TileConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.util.Coord;
import com.threerings.tudey.util.TudeyContext;

public class TileSprite
extends EntrySprite
implements ConfigUpdateListener<TileConfig> {
    protected TudeySceneModel.TileEntry _entry;
    protected TileConfig _config = INVALID_CONFIG;
    protected Implementation _impl = NULL_IMPLEMENTATION;
    protected static TileConfig INVALID_CONFIG = new TileConfig();
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null){};

    public TileSprite(TudeyContext ctx, TudeySceneView view, TudeySceneModel.TileEntry entry) {
        super(ctx, view);
        this.update(entry);
    }

    @Override
    public void configUpdated(ConfigEvent<TileConfig> event) {
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public int getFloorFlags() {
        return this._impl.getFloorFlags();
    }

    @Override
    public TudeySceneModel.Entry getEntry() {
        return this._entry;
    }

    @Override
    public void update(TudeySceneModel.Entry entry) {
        TudeySceneModel.TileEntry tentry = (TudeySceneModel.TileEntry)entry;
        this.setConfig(tentry.tile);
        this._entry = tentry;
        this._impl.update(this._entry);
    }

    @Override
    public Model getModel() {
        return this._impl.getModel();
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public void dispose() {
        super.dispose();
        this._impl.dispose();
        if (this._config != null) {
            this._config.removeListener(this);
        }
    }

    protected void setConfig(ConfigReference<TileConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(TileConfig.class, ref));
    }

    protected void setConfig(TileConfig config) {
        if (this._config == config) {
            return;
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    protected void updateFromConfig() {
        TileConfig.Original original = this._config == null ? null : this._config.getOriginal(this._ctx.getConfigManager());
        original = original == null ? TileConfig.NULL_ORIGINAL : original;
        Implementation nimpl = original.getSpriteImplementation(this._ctx, this, this._impl);
        Implementation implementation = nimpl = nimpl == null ? NULL_IMPLEMENTATION : nimpl;
        if (this._impl != nimpl) {
            this._impl.dispose();
            this._impl = nimpl;
        }
    }

    public static class Original
    extends Implementation {
        protected TudeyContext _ctx;
        protected TileConfig.Original _config;
        protected Model _model;
        protected RectangleElement _footprint;
        protected Transform3D _mergeTransform;
        @Bound
        protected Scene _scene;

        public Original(TudeyContext ctx, Scope parentScope, TileConfig.Original config) {
            super(parentScope);
            this._ctx = ctx;
            this.setConfig(config);
        }

        public void setConfig(TileConfig.Original config) {
            boolean selected;
            this.maybeUnmerge();
            this._config = config;
            TileSprite parent = (TileSprite)this._parentScope;
            if (parent._entry != null) {
                this.updateModel(parent._entry);
            }
            if ((selected = parent.isSelected()) && this._footprint == null) {
                this._footprint = new RectangleElement((GlContext)this._ctx, true);
                this._footprint.getColor().set(EntrySprite.SELECTED_COLOR);
                this._scene.add(this._footprint);
            } else if (!selected && this._footprint != null) {
                this._scene.remove(this._footprint);
                this._footprint = null;
            }
        }

        @Override
        public Model getModel() {
            return this._model;
        }

        @Override
        public int getFloorFlags() {
            return this._config.floorFlags;
        }

        @Override
        public void update(TudeySceneModel.TileEntry entry) {
            this.maybeUnmerge();
            this.updateModel(entry);
            if (this._footprint != null) {
                entry.getRegion(this._config, this._footprint.getRegion());
                this._footprint.setElevation(entry.elevation);
                this._footprint.updateBounds();
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            if (!this.maybeUnmerge()) {
                this._scene.remove(this._model);
            }
            if (this._footprint != null) {
                this._scene.remove(this._footprint);
            }
        }

        protected void updateModel(TudeySceneModel.TileEntry entry) {
            if (this._model == null) {
                if (this.maybeMerge()) {
                    return;
                }
                this._model = new Model(this._ctx);
                this._scene.add(this._model);
                this._model.setUserObject(this._parentScope);
            }
            entry.getTransform(this._config, this._model.getLocalTransform());
            this._model.setConfig(this._config.model);
            this._model.updateBounds();
        }

        protected boolean maybeMerge() {
            TileSprite parent = (TileSprite)this._parentScope;
            if (!parent._view.canMerge() || !this._config.isMergeable(this._ctx.getConfigManager())) {
                return false;
            }
            TudeySceneModel.TileEntry entry = parent._entry;
            Coord location = entry.getLocation();
            Transform3D transform = new Transform3D();
            entry.getTransform(this._config, transform);
            this._model = parent._view.maybeMerge(location.x, location.y, this._config.model, transform, this._config.floorFlags);
            if (this._model == null) {
                return false;
            }
            this._mergeTransform = transform;
            return true;
        }

        protected boolean maybeUnmerge() {
            if (this._mergeTransform == null) {
                return false;
            }
            TileSprite parent = (TileSprite)this._parentScope;
            Coord location = parent._entry.getLocation();
            if (!parent._view.unmerge(location.x, location.y, this._config.model, this._mergeTransform)) {
                Log.log.warning((Object)"Failed to unmerge static model.", new Object[]{"entry", parent._entry});
            }
            this._mergeTransform = null;
            this._model = null;
            return true;
        }
    }

    public static abstract class Implementation
    extends SimpleScope {
        public Implementation(Scope parentScope) {
            super(parentScope);
        }

        public Model getModel() {
            return null;
        }

        public int getFloorFlags() {
            return 0;
        }

        public void update(TudeySceneModel.TileEntry entry) {
        }

        @Override
        public String getScopeName() {
            return "impl";
        }
    }
}

