/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.tudey.config.ConditionConfig;
import com.threerings.tudey.config.RegionConfig;
import com.threerings.util.DeepObject;

@EditorTypes(value={Source.class, Activator.class, ActivatorOf.class, Tagged.class, InstanceOf.class, Intersecting.class, RandomSubset.class, NearestSubset.class, FarthestSubset.class, Conditional.class, Compound.class, Behavior.class, Excluding.class, Randomized.class})
@Strippable
public abstract class TargetConfig
extends DeepObject
implements Exportable,
Streamable {
    public abstract String getLogicClassName();

    public void invalidate() {
    }

    public static class Randomized
    extends TargetConfig {
        @Editable
        public TargetConfig target = new Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Randomized";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class Excluding
    extends TargetConfig {
        @Editable
        public TargetConfig target = new Source();
        @Editable
        public TargetConfig excluding = new Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Excluding";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
            this.excluding.invalidate();
        }
    }

    public static class Behavior
    extends TargetConfig {
        @Editable
        public TargetConfig target = new Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Behavior";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class Compound
    extends TargetConfig {
        @Editable
        public TargetConfig[] targets = new TargetConfig[0];

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Compound";
        }

        @Override
        public void invalidate() {
            for (TargetConfig target : this.targets) {
                target.invalidate();
            }
        }
    }

    public static class Conditional
    extends TargetConfig {
        @Editable
        public ConditionConfig condition = new ConditionConfig.Tagged();
        @Editable
        public TargetConfig target = new Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Conditional";
        }

        @Override
        public void invalidate() {
            this.condition.invalidate();
            this.target.invalidate();
        }
    }

    public static class FarthestSubset
    extends DistanceSubset {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$FarthestSubset";
        }
    }

    public static class NearestSubset
    extends DistanceSubset {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$NearestSubset";
        }
    }

    public static abstract class DistanceSubset
    extends Subset {
        @Editable
        public TargetConfig location = new Source();

        @Override
        public void invalidate() {
            super.invalidate();
            this.location.invalidate();
        }
    }

    public static class RandomSubset
    extends Subset {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$RandomSubset";
        }
    }

    public static abstract class Subset
    extends TargetConfig {
        @Editable(min=0.0)
        public int size = 1;
        @Editable
        public TargetConfig target = new Source();

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class RandomTransform
    extends TargetConfig {
        @Editable
        public float radius;
        @Editable
        public int number;

        @Override
        public String getLogicClassName() {
            return null;
        }
    }

    public static class Intersecting
    extends TargetConfig {
        @Editable(hgroup="a")
        public boolean actors = false;
        @Editable(hgroup="a")
        public boolean entries = false;
        @Editable
        public RegionConfig region = new RegionConfig.Default();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Intersecting";
        }

        @Override
        public void invalidate() {
            this.region.invalidate();
        }
    }

    public static class InstanceOf
    extends TargetConfig {
        @Editable
        public String logicClass = "com.threerings.tudey.server.logic.PawnLogic";

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$InstanceOf";
        }
    }

    public static class Tagged
    extends TargetConfig {
        @Editable
        public String tag = "";

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Tagged";
        }
    }

    public static class IsPlayer
    extends TargetConfig {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$IsPlayer";
        }
    }

    public static class ActivatorOf
    extends TargetConfig {
        @Editable
        public TargetConfig target = new Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$ActivatorOf";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class Activator
    extends TargetConfig {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Activator";
        }
    }

    public static class Source
    extends TargetConfig {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Source";
        }
    }
}

