/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.config;

import com.samskivert.util.ComparableTuple;
import com.samskivert.util.QuickSort;
import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.export.Importer;
import com.threerings.expr.Scope;
import com.threerings.expr.Updater;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Box;
import com.threerings.math.FloatMath;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.model.Articulated;
import com.threerings.opengl.model.CollisionMesh;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.AnimationConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.model.tools.ModelDef;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import com.threerings.util.Shallow;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.TreeSet;
import proguard.annotation.Keep;

public class ArticulatedConfig
extends ModelConfig.Imported {
    @Editable(hgroup="t")
    public SceneElement.TickPolicy tickPolicy = SceneElement.TickPolicy.DEFAULT;
    @Editable(hgroup="t")
    public boolean completable;
    @Editable
    public AnimationMapping[] animationMappings = new AnimationMapping[0];
    @Editable(depends={"source"})
    public NodeTransform[] nodeTransforms = new NodeTransform[0];
    @Editable(depends={"source"})
    public Attachment[] attachments = new Attachment[0];
    @Shallow
    public Node root;
    @Shallow
    public ModelConfig.MeshSet skin;

    public static Updater createBillboardUpdater(Scope scope, final Transform3D parentViewTransform, final Transform3D localTransform, BillboardRotationX rotationX, BillboardRotationY rotationY) {
        if (rotationX == BillboardRotationX.ALIGN_TO_VIEW && rotationY == BillboardRotationY.ALIGN_TO_VIEW) {
            return new ViewTransformUpdater(){

                @Override
                public void update() {
                    ArticulatedConfig.ensureRigidOrUniform(localTransform);
                    parentViewTransform.extractRotation(localTransform.getRotation()).invertLocal();
                }
            };
        }
        if (rotationX == BillboardRotationX.NONE && rotationY == BillboardRotationY.ALIGN_TO_VIEW) {
            final Quaternion brot = ScopeUtil.resolve(scope, "billboardRotation", Quaternion.IDENTITY);
            return new ViewTransformUpdater(){

                @Override
                public void update() {
                    ArticulatedConfig.ensureRigidOrUniform(localTransform);
                    parentViewTransform.extractRotation(localTransform.getRotation()).invertLocal().multLocal(brot);
                }
            };
        }
        if (rotationX == BillboardRotationX.FACE_VIEWER && rotationY == BillboardRotationY.ALIGN_TO_VIEW) {
            return new ViewTransformUpdater(){
                protected Vector3f _trans = new Vector3f();
                protected Quaternion _rot = new Quaternion();

                @Override
                public void update() {
                    ArticulatedConfig.ensureRigidOrUniform(localTransform);
                    parentViewTransform.transformPoint(localTransform.getTranslation(), this._trans);
                    this._rot.fromAngleAxis(FloatMath.atan2(this._trans.y, -this._trans.z), Vector3f.UNIT_X);
                    parentViewTransform.extractRotation(localTransform.getRotation()).invertLocal().multLocal(this._rot);
                }
            };
        }
        if (rotationX == BillboardRotationX.ALIGN_TO_VIEW && rotationY == BillboardRotationY.FACE_VIEWER) {
            return new ViewTransformUpdater(){
                protected Vector3f _trans = new Vector3f();
                protected Quaternion _rot = new Quaternion();

                @Override
                public void update() {
                    ArticulatedConfig.ensureRigidOrUniform(localTransform);
                    parentViewTransform.transformPoint(localTransform.getTranslation(), this._trans);
                    this._rot.fromAngleAxis(FloatMath.atan2(-this._trans.x, -this._trans.z), Vector3f.UNIT_Y);
                    parentViewTransform.extractRotation(localTransform.getRotation()).invertLocal().multLocal(this._rot);
                }
            };
        }
        if (rotationX == BillboardRotationX.FACE_VIEWER && rotationY == BillboardRotationY.FACE_VIEWER) {
            return new ViewTransformUpdater(){
                protected Vector3f _trans = new Vector3f();
                protected Quaternion _rot = new Quaternion();

                @Override
                public void update() {
                    ArticulatedConfig.ensureRigidOrUniform(localTransform);
                    parentViewTransform.transformPoint(localTransform.getTranslation(), this._trans);
                    this._rot.fromAnglesXY(FloatMath.atan2(this._trans.y, -this._trans.z), FloatMath.atan2(-this._trans.x, -this._trans.z));
                    parentViewTransform.extractRotation(localTransform.getRotation()).invertLocal().multLocal(this._rot);
                }
            };
        }
        final Quaternion brot = ScopeUtil.resolve(scope, "billboardRotation", Quaternion.IDENTITY);
        return new ViewTransformUpdater(){
            protected Vector3f _trans = new Vector3f();
            protected Quaternion _rot = new Quaternion();

            @Override
            public void update() {
                ArticulatedConfig.ensureRigidOrUniform(localTransform);
                parentViewTransform.transformPoint(localTransform.getTranslation(), this._trans);
                this._rot.fromAngleAxis(FloatMath.atan2(-this._trans.x, -this._trans.z), Vector3f.UNIT_Y);
                brot.mult(this._rot, this._rot);
                parentViewTransform.extractRotation(localTransform.getRotation()).invertLocal().multLocal(this._rot);
            }
        };
    }

    public String[] getNodeNames() {
        if (this.root == null) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>();
        this.root.getNames(names);
        QuickSort.sort(names);
        return names.toArray(new String[names.size()]);
    }

    public void readFields(Importer in) throws IOException {
        in.defaultReadFields();
        this.initTransientFields();
    }

    public void initTransientFields() {
        if (this.root != null) {
            this.root.updateRefTransforms(new Transform3D());
        }
    }

    @Override
    public Model.Implementation getModelImplementation(GlContext ctx, Scope scope, Model.Implementation impl) {
        if (this.root == null) {
            return null;
        }
        if (impl instanceof Articulated) {
            ((Articulated)impl).setConfig(ctx, this);
        } else {
            impl = new Articulated(ctx, scope, this);
        }
        return impl;
    }

    @Override
    protected void updateFromSource(ModelDef def) {
        if (def == null) {
            this.root = null;
            this.skin = null;
        } else {
            def.update(this);
        }
    }

    @Override
    protected void getTextures(TreeSet<String> textures) {
        if (this.root != null) {
            this.root.getTextures(textures);
        }
        if (this.skin != null) {
            this.skin.getTextures(textures);
        }
    }

    @Override
    protected void getTextureTagPairs(TreeSet<ComparableTuple<String, String>> pairs) {
        if (this.root != null) {
            this.root.getTextureTagPairs(pairs);
        }
        if (this.skin != null) {
            this.skin.getTextureTagPairs(pairs);
        }
    }

    protected static void ensureRigidOrUniform(Transform3D transform) {
        switch (transform.getType()) {
            case 0: {
                transform.promote(2);
                break;
            }
            case 3: 
            case 4: {
                Vector3f trans = transform.getTranslation();
                transform.set(transform.extractTranslation(trans == null ? new Vector3f() : trans), Quaternion.IDENTITY, transform.approximateUniformScale());
            }
        }
    }

    public class Attachment
    extends DeepObject
    implements Exportable {
        @Editable(editor="choice")
        public String node;
        @Editable(nullable=true)
        public ConfigReference<ModelConfig> model;
        @Editable(step=0.01)
        public Transform3D transform = new Transform3D();

        @Keep
        public String[] getNodeOptions() {
            return ArticulatedConfig.this.getNodeNames();
        }
    }

    public class Upright
    extends NodeTransform {
        @Editable
        public boolean directional;

        @Override
        public Updater createUpdater(GlContext ctx, Articulated.Node node) {
            final Transform3D pworld = node.getParentWorldTransform();
            final Transform3D local = node.getLocalTransform();
            if (!this.directional) {
                return new WorldTransformUpdater(){

                    @Override
                    public void update() {
                        ArticulatedConfig.ensureRigidOrUniform(local);
                        pworld.extractRotation(local.getRotation()).invertLocal();
                    }
                };
            }
            return new WorldTransformUpdater(){
                protected Vector3f _lup = new Vector3f();

                @Override
                public void update() {
                    ArticulatedConfig.ensureRigidOrUniform(local);
                    Quaternion lrot = local.getRotation();
                    pworld.extractRotation(lrot).invertLocal();
                    lrot.transformUnitZ(this._lup).normalizeLocal();
                    lrot.fromVectors(Vector3f.UNIT_Z, this._lup);
                }
            };
        }
    }

    public class Billboard
    extends NodeTransform {
        @Editable(hgroup="b")
        public BillboardRotationX rotationX;
        @Editable(hgroup="b")
        public BillboardRotationY rotationY;

        public Billboard() {
            this.rotationX = BillboardRotationX.ALIGN_TO_VIEW;
            this.rotationY = BillboardRotationY.ALIGN_TO_VIEW;
        }

        @Override
        public Updater createUpdater(GlContext ctx, Articulated.Node node) {
            return ArticulatedConfig.createBillboardUpdater(node, node.getParentViewTransform(), node.getLocalTransform(), this.rotationX, this.rotationY);
        }
    }

    public static interface ViewTransformUpdater
    extends Updater {
    }

    public static interface WorldTransformUpdater
    extends Updater {
    }

    @EditorTypes(value={Billboard.class, Upright.class})
    public abstract class NodeTransform
    extends DeepObject
    implements Exportable {
        @Editable(editor="choice")
        public String node;

        @Keep
        public String[] getNodeOptions() {
            return ArticulatedConfig.this.getNodeNames();
        }

        public abstract Updater createUpdater(GlContext var1, Articulated.Node var2);
    }

    public static class AnimationMapping
    extends DeepObject
    implements Exportable {
        @Editable
        public String name = "";
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> animation;
        @Editable(hgroup="s")
        public boolean startAutomatically;
        @Editable(hgroup="s")
        public boolean startOnUpdated;
    }

    public static class MeshNode
    extends Node {
        public ModelConfig.VisibleMesh visible;
        public CollisionMesh collision;

        public MeshNode(String name, Transform3D transform, Node[] children, ModelConfig.VisibleMesh visible, CollisionMesh collision) {
            super(name, transform, children);
            this.visible = visible;
            this.collision = collision;
        }

        public MeshNode() {
        }

        @Override
        public void getTextures(TreeSet<String> textures) {
            super.getTextures(textures);
            if (this.visible != null) {
                textures.add(this.visible.texture);
            }
        }

        @Override
        public void getTextureTagPairs(TreeSet<ComparableTuple<String, String>> pairs) {
            super.getTextureTagPairs(pairs);
            if (this.visible != null) {
                pairs.add((ComparableTuple<String, String>)new ComparableTuple((Comparable)((Object)this.visible.texture), (Comparable)((Object)this.visible.tag)));
            }
        }

        @Override
        public Box getBounds() {
            return this.visible == null ? this.collision.getBounds() : this.visible.geometry.getBounds();
        }

        @Override
        protected Articulated.Node createArticulatedNode(GlContext ctx, Scope scope, Transform3D parentWorldTransform, Transform3D parentViewTransform) {
            return new Articulated.MeshNode(ctx, scope, this, parentWorldTransform, parentViewTransform);
        }
    }

    public static class Node
    extends DeepObject
    implements Exportable {
        public String name;
        public Transform3D transform;
        public Node[] children;
        public transient Transform3D invRefTransform;

        public Node(String name, Transform3D transform, Node[] children) {
            this.name = name;
            this.transform = transform;
            this.children = children;
        }

        public Node() {
        }

        public void getNames(ArrayList<String> names) {
            names.add(this.name);
            for (Node child : this.children) {
                child.getNames(names);
            }
        }

        public void getTextures(TreeSet<String> textures) {
            for (Node child : this.children) {
                child.getTextures(textures);
            }
        }

        public void getTextureTagPairs(TreeSet<ComparableTuple<String, String>> pairs) {
            for (Node child : this.children) {
                child.getTextureTagPairs(pairs);
            }
        }

        public Box getBounds() {
            return Box.EMPTY;
        }

        public void updateRefTransforms(Transform3D parentRefTransform) {
            Transform3D refTransform = parentRefTransform.compose(this.transform);
            this.invRefTransform = refTransform.invert();
            for (Node child : this.children) {
                child.updateRefTransforms(refTransform);
            }
        }

        public void getArticulatedNodes(GlContext ctx, Scope scope, IdentityHashMap<Node, Articulated.Node> onodes, ArrayList<Articulated.Node> nnodes, Transform3D parentWorldTransform, Transform3D parentViewTransform) {
            Articulated.Node node = onodes.remove(this);
            if (node != null) {
                node.setConfig(this, parentWorldTransform, parentViewTransform);
            } else {
                node = this.createArticulatedNode(ctx, scope, parentWorldTransform, parentViewTransform);
            }
            nnodes.add(node);
            Transform3D worldTransform = node.getWorldTransform();
            Transform3D viewTransform = node.getViewTransform();
            for (Node child : this.children) {
                child.getArticulatedNodes(ctx, scope, onodes, nnodes, worldTransform, viewTransform);
            }
        }

        protected Articulated.Node createArticulatedNode(GlContext ctx, Scope scope, Transform3D parentWorldTransform, Transform3D parentViewTransform) {
            return new Articulated.Node(ctx, scope, this, parentWorldTransform, parentViewTransform);
        }
    }

    public static enum BillboardRotationY {
        ALIGN_TO_VIEW,
        FACE_VIEWER;

    }

    public static enum BillboardRotationX {
        ALIGN_TO_VIEW,
        FACE_VIEWER,
        NONE;

    }
}

