/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.util.DeepObject;

@EditorTypes(value={None.class, QuadraticIn.class, QuadraticOut.class, QuadraticInAndOut.class, CubicIn.class, CubicOut.class, CubicInAndOut.class, CubicInOvershoot.class, CubicOutOvershoot.class})
public abstract class Easing
extends DeepObject
implements Exportable,
Streamable {
    public abstract float getTime(float var1);

    public abstract Easing copy(Easing var1);

    public static class CubicOutOvershoot
    extends Easing {
        @Editable(min=0.0, step=1.0E-5)
        public float overshoot = 1.70158f;

        @Override
        public float getTime(float t) {
            return (t -= 1.0f) * t * ((this.overshoot + 1.0f) * t + this.overshoot) + 1.0f;
        }

        @Override
        public Easing copy(Easing result) {
            CubicOutOvershoot that = result instanceof CubicOutOvershoot ? (CubicOutOvershoot)result : new CubicOutOvershoot();
            that.overshoot = this.overshoot;
            return that;
        }
    }

    public static class CubicInOvershoot
    extends Easing {
        @Editable(min=0.0, step=1.0E-5)
        public float overshoot = 1.70158f;

        @Override
        public float getTime(float t) {
            return t * t * ((this.overshoot + 1.0f) * t - this.overshoot);
        }

        @Override
        public Easing copy(Easing result) {
            CubicInOvershoot that = result instanceof CubicInOvershoot ? (CubicInOvershoot)result : new CubicInOvershoot();
            that.overshoot = this.overshoot;
            return that;
        }
    }

    public static class CubicInAndOut
    extends Easing {
        @Override
        public float getTime(float t) {
            if ((t *= 2.0f) < 1.0f) {
                return 0.5f * t * t * t;
            }
            return 0.5f * ((t -= 2.0f) * t * t + 2.0f);
        }

        @Override
        public Easing copy(Easing result) {
            return result instanceof CubicInAndOut ? result : new CubicInAndOut();
        }
    }

    public static class CubicOut
    extends Easing {
        @Override
        public float getTime(float t) {
            return (t -= 1.0f) * t * t + 1.0f;
        }

        @Override
        public Easing copy(Easing result) {
            return result instanceof CubicOut ? result : new CubicOut();
        }
    }

    public static class CubicIn
    extends Easing {
        @Override
        public float getTime(float t) {
            return t * t * t;
        }

        @Override
        public Easing copy(Easing result) {
            return result instanceof CubicIn ? result : new CubicIn();
        }
    }

    public static class QuadraticInAndOut
    extends Easing {
        @Override
        public float getTime(float t) {
            return t <= 0.5f ? 2.0f * t * t : 2.0f * t * (2.0f - t) - 1.0f;
        }

        @Override
        public Easing copy(Easing result) {
            return result instanceof QuadraticInAndOut ? result : new QuadraticInAndOut();
        }
    }

    public static class QuadraticOut
    extends Easing {
        @Override
        public float getTime(float t) {
            return t * (2.0f - t);
        }

        @Override
        public Easing copy(Easing result) {
            return result instanceof QuadraticOut ? result : new QuadraticOut();
        }
    }

    public static class QuadraticIn
    extends Easing {
        @Override
        public float getTime(float t) {
            return t * t;
        }

        @Override
        public Easing copy(Easing result) {
            return result instanceof QuadraticIn ? result : new QuadraticIn();
        }
    }

    public static class None
    extends Easing {
        @Override
        public float getTime(float t) {
            return t;
        }

        @Override
        public Easing copy(Easing result) {
            return result instanceof None ? result : new None();
        }
    }
}

