/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.scene;

import com.google.common.collect.Maps;
import com.samskivert.util.Tuple;
import com.threerings.math.Box;
import com.threerings.opengl.material.Projection;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Light;
import com.threerings.opengl.renderer.state.FogState;
import com.threerings.opengl.renderer.state.LightState;
import com.threerings.opengl.scene.SceneInfluence;
import com.threerings.util.AbstractIdentityHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SceneInfluenceSet
extends AbstractIdentityHashSet<SceneInfluence> {
    protected static final int MAX_LIGHTS = 4;
    protected static final Projection[] NO_PROJECTIONS = new Projection[0];

    public FogState getFogState(Box bounds, FogState state) {
        FogState closestState = null;
        float cdist = Float.MAX_VALUE;
        for (SceneInfluence influence : this) {
            state = influence.getFogState();
            if (state == null) continue;
            float distance = influence.getBounds().getExtentDistance(bounds);
            if (closestState != null && !(distance < cdist)) continue;
            closestState = state;
            cdist = distance;
        }
        return closestState == null ? FogState.DISABLED : closestState;
    }

    public LightState getLightState(Box bounds, LightState state) {
        Color4f closestAmbient = null;
        float cdist = Float.MAX_VALUE;
        ArrayList<Light> lights = new ArrayList<Light>();
        for (SceneInfluence influence : this) {
            Light light;
            Color4f ambient = influence.getAmbientLight();
            if (ambient != null) {
                float distance = influence.getBounds().getExtentDistance(bounds);
                if (closestAmbient == null || distance <= cdist) {
                    closestAmbient = ambient;
                    cdist = distance;
                }
            }
            if ((light = influence.getLight()) == null || lights.size() >= 4) continue;
            lights.add(light);
        }
        if (closestAmbient == null) {
            return LightState.DISABLED;
        }
        if (this.canReuse(state, lights)) {
            Light[] olights = state.getLights();
            for (int ii = 0; ii < olights.length; ++ii) {
                olights[ii] = lights.get(ii);
            }
        } else {
            state = new LightState(lights.toArray(new Light[lights.size()]), Color4f.WHITE);
        }
        state.setGlobalAmbient(closestAmbient);
        return state;
    }

    public Projection[] getProjections(Projection[] projections) {
        ArrayList<Projection> projs = new ArrayList<Projection>();
        for (SceneInfluence influence : this) {
            Projection projection = influence.getProjection();
            if (projection == null) continue;
            projs.add(projection);
        }
        int size = projs.size();
        if (size == 0) {
            return NO_PROJECTIONS;
        }
        if (this.canReuse(projections, projs)) {
            return projections;
        }
        return projs.toArray(new Projection[size]);
    }

    public Map<String, Object> getDefinitions(Map<String, Object> definitions) {
        HashMap defs = Maps.newHashMap();
        for (SceneInfluence influence : this) {
            Tuple<String, Object>[] idefs = influence.getDefinitions();
            if (idefs == null) continue;
            for (Tuple<String, Object> def : idefs) {
                defs.put(def.left, def.right);
            }
        }
        if (defs.isEmpty()) {
            return null;
        }
        return this.canReuse(definitions, defs) ? definitions : defs;
    }

    protected boolean canReuse(LightState state, ArrayList<Light> nlights) {
        if (state == null) {
            return false;
        }
        Light[] olights = state.getLights();
        if (olights == null || olights.length != nlights.size()) {
            return false;
        }
        for (int ii = 0; ii < olights.length; ++ii) {
            if (olights[ii].isCompatible(nlights.get(ii))) continue;
            return false;
        }
        return true;
    }

    protected boolean canReuse(Projection[] projections, ArrayList<Projection> nprojs) {
        if (projections == null || projections.length != nprojs.size()) {
            return false;
        }
        for (Projection proj : projections) {
            if (nprojs.contains(proj)) continue;
            return false;
        }
        return true;
    }

    protected boolean canReuse(Map<String, Object> definitions, Map<String, Object> ndefs) {
        if (definitions == null || definitions.size() != ndefs.size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : definitions.entrySet()) {
            if (ndefs.get(entry.getKey()) == entry.getValue()) continue;
            return false;
        }
        return true;
    }
}

