/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.scene;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.threerings.config.ConfigReference;
import com.threerings.expr.DynamicScope;
import com.threerings.expr.Scoped;
import com.threerings.expr.Updater;
import com.threerings.math.Box;
import com.threerings.math.Frustum;
import com.threerings.math.Ray3D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.openal.SoundClipManager;
import com.threerings.openal.SoundGroup;
import com.threerings.opengl.Log;
import com.threerings.opengl.compositor.Compositable;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.ModelAdapter;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.scene.SceneInfluence;
import com.threerings.opengl.scene.SceneInfluenceSet;
import com.threerings.opengl.scene.SceneObject;
import com.threerings.opengl.scene.ViewerEffect;
import com.threerings.opengl.scene.ViewerEffectSet;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Tickable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public abstract class Scene
extends DynamicScope
implements Tickable,
Compositable {
    protected GlContext _ctx;
    protected ArrayList<SceneElement> _alwaysTick = new ArrayList();
    protected HashSet<SceneElement> _visible = new HashSet();
    protected HashSet<SceneElement> _updateInfluences = new HashSet();
    protected int _updateInfluencesCount;
    protected SceneElement[] _updateArray = new SceneElement[0];
    protected ViewerEffectSet _effects = new ViewerEffectSet();
    protected HashMap<ConfigReference, ArrayList<SoftReference<Transient>>> _transientPool = Maps.newHashMap();
    protected ModelAdapter _transientObserver = new ModelAdapter(){

        @Override
        public boolean modelCompleted(Model model) {
            Scene.this.remove(model, false);
            Scene.this.returnToTransientPool((Transient)model);
            return true;
        }
    };
    @Scoped
    protected SoundGroup _soundGroup;
    @Scoped
    protected SoundClipManager _clipmgr;
    protected boolean _disposed;
    protected Box _viewer = new Box();
    protected SceneInfluenceSet _influences = new SceneInfluenceSet();
    protected Vector3f _result = new Vector3f();
    protected ViewerEffectSet _neffects = new ViewerEffectSet();
    protected boolean _dumpInfluences;
    protected long _alwaysTickTime;
    protected long _visibleTickTime;
    protected long _updateInfluencesTime;
    protected long _viewerEffectTime;
    protected boolean _transientPolicy;
    protected static final int DEFAULT_SOURCES = 10;

    public Scene(GlContext ctx) {
        this(ctx, 10);
    }

    public Scene(GlContext ctx, int sources) {
        super("scene");
        this._ctx = ctx;
        this._soundGroup = ctx.getSoundManager().createGroup(ctx.getClipProvider(), sources);
        this._clipmgr = new SoundClipManager(ctx);
    }

    @Scoped
    public Transient spawnTransient(ConfigReference<ModelConfig> ref, Transform3D transform) {
        boolean add;
        Transient model = this.getFromTransientPool(ref);
        model.setLocalTransform(transform);
        boolean bl = add = !this._transientPolicy;
        if (this._transientPolicy) {
            switch (model.getTransientPolicy()) {
                case BOUNDS: {
                    add = this._ctx.getCompositor().getCamera().getWorldVolume().getBounds().intersects(model.getBounds());
                    break;
                }
                case FRUSTUM: {
                    add = this._ctx.getCompositor().getCamera().getWorldVolume().getIntersectionType(model.getBounds()) != Frustum.IntersectionType.NONE;
                    break;
                }
                case ALWAYS: 
                case DEFAULT: {
                    add = true;
                }
            }
        }
        if (add) {
            this.add(model);
        } else {
            this.returnToTransientPool(model);
            model = null;
        }
        return model;
    }

    @Scoped
    public Transient getFromTransientPool(ConfigReference<ModelConfig> ref) {
        ArrayList<SoftReference<Transient>> list = this._transientPool.get(ref);
        if (list != null) {
            for (int ii = list.size() - 1; ii >= 0; --ii) {
                Transient model = list.remove(ii).get();
                if (model == null) continue;
                model.reset();
                return model;
            }
            this._transientPool.remove(ref);
        }
        Transient model = new Transient(this._ctx, ref);
        model.setParentScope(this);
        model.setUserObject(ref);
        model.addObserver(this._transientObserver);
        return model;
    }

    @Scoped
    public void returnToTransientPool(Transient model) {
        model.setUpdater(null);
        ConfigReference ref = (ConfigReference)model.getUserObject();
        ArrayList<SoftReference<Transient>> list = this._transientPool.get(ref);
        if (list == null) {
            list = new ArrayList();
            this._transientPool.put(ref, list);
        }
        list.add(new SoftReference<Transient>(model));
    }

    public void addAll(SceneElement[] elements) {
        for (SceneElement element : elements) {
            this.add(element);
        }
    }

    public void add(SceneElement element) {
        if (element instanceof DynamicScope) {
            ((DynamicScope)((Object)element)).setParentScope(this);
        }
        this.addToTick(element);
        this.addToSpatial(element);
        this._updateInfluences.add(element);
        this.dumpInfluence(element, "add", 1);
        element.wasAdded(this);
    }

    public void removeAll(SceneElement[] elements) {
        this.removeAll(elements, true);
    }

    public void removeAll(SceneElement[] elements, boolean clearParentScopes) {
        for (SceneElement element : elements) {
            this.remove(element, clearParentScopes);
        }
    }

    public void remove(SceneElement element) {
        this.remove(element, true);
    }

    public void remove(SceneElement element, boolean clearParentScope) {
        if (this._disposed) {
            return;
        }
        element.willBeRemoved();
        this._visible.remove(element);
        this._updateInfluences.remove(element);
        this.dumpInfluence(element, "remove", -1);
        this.removeFromTick(element);
        this.removeFromSpatial(element);
        if (element instanceof DynamicScope && clearParentScope) {
            ((DynamicScope)((Object)element)).setParentScope(null);
        }
    }

    public void add(SceneInfluence influence) {
        this.addToSpatial(influence);
        int count = this._updateInfluences.size();
        this.getElements(influence.getBounds(), this._updateInfluences);
        this.dumpInfluence(influence, "add Influence", this._updateInfluences.size() - count);
    }

    public void remove(SceneInfluence influence) {
        if (this._disposed) {
            return;
        }
        int count = this._updateInfluences.size();
        this.getElements(influence.getBounds(), this._updateInfluences);
        this.dumpInfluence(influence, "remove influence", this._updateInfluences.size() - count);
        this.removeFromSpatial(influence);
    }

    public void add(ViewerEffect effect) {
        this.addToSpatial(effect);
    }

    public void remove(ViewerEffect effect) {
        if (!this._disposed) {
            this.removeFromSpatial(effect);
        }
    }

    public SceneElement getIntersection(Ray3D ray, Vector3f location) {
        Predicate filter = Predicates.alwaysTrue();
        return this.getIntersection(ray, location, (Predicate<? super SceneElement>)filter);
    }

    public abstract SceneElement getIntersection(Ray3D var1, Vector3f var2, Predicate<? super SceneElement> var3);

    public abstract void getElements(Box var1, Collection<SceneElement> var2);

    public abstract void getInfluences(Box var1, Collection<SceneInfluence> var2);

    public abstract void getEffects(Box var1, Collection<ViewerEffect> var2);

    public int getAlwaysTickCount() {
        return this._alwaysTick.size();
    }

    public long getAlwaysTickTime() {
        return this._alwaysTickTime;
    }

    public int getVisibleTickCount() {
        return this._visible.size();
    }

    public long getVisibleTickTime() {
        return this._visibleTickTime;
    }

    public int getUpdateInfluencesCount() {
        return this._updateInfluencesCount;
    }

    public long getUpdateInfluencesTime() {
        return this._updateInfluencesTime;
    }

    public int getViewerEffectCount() {
        return this._effects.size();
    }

    public long getViewerEffectTime() {
        return this._viewerEffectTime;
    }

    public void dumpViewerEffects() {
        Log.log.info((Object)("Viewer effects: " + this._effects), new Object[0]);
    }

    public void tickPolicyWillChange(SceneElement element) {
        this.removeFromTick(element);
    }

    public void tickPolicyDidChange(SceneElement element) {
        this.addToTick(element);
    }

    public void boundsWillChange(SceneElement element) {
    }

    public void boundsDidChange(SceneElement element) {
        this._updateInfluences.add(element);
        this.dumpInfluence(element, "bounds did change", 1);
    }

    public void boundsWillChange(SceneInfluence influence) {
        int count = this._updateInfluences.size();
        this.getElements(influence.getBounds(), this._updateInfluences);
        this.dumpInfluence(influence, "influence bounds will change", this._updateInfluences.size() - count);
    }

    public void boundsDidChange(SceneInfluence influence) {
        int count = this._updateInfluences.size();
        this.getElements(influence.getBounds(), this._updateInfluences);
        this.dumpInfluence(influence, "influence bounds did change", this._updateInfluences.size() - count);
    }

    public void boundsWillChange(ViewerEffect effect) {
    }

    public void boundsDidChange(ViewerEffect effect) {
    }

    public void clearEffects() {
        this.setEffects(this._neffects);
    }

    public void setTransientPolicy(boolean enabled) {
        this._transientPolicy = enabled;
    }

    @Override
    public void tick(float elapsed) {
        if (this._dumpInfluences) {
            Log.log.info((Object)"INFLUENCES!!!", new Object[0]);
        }
        long tick = System.nanoTime();
        for (int ii = this._alwaysTick.size() - 1; ii >= 0; --ii) {
            this._alwaysTick.get(ii).tick(elapsed);
        }
        long tock = System.nanoTime();
        this._alwaysTickTime = tock - tick;
        if (!this._visible.isEmpty()) {
            for (SceneElement element : this._visible.toArray(new SceneElement[this._visible.size()])) {
                element.tick(elapsed);
            }
            this._visible.clear();
        }
        tick = System.nanoTime();
        this._visibleTickTime = tick - tock;
        Vector3f location = this._ctx.getCameraHandler().getViewerTranslation();
        this.getEffects(this._viewer.set(location, location), this._neffects);
        this.setEffects(this._neffects);
        this._neffects.clear();
        for (ViewerEffect effect : this._effects) {
            effect.update();
        }
        tock = System.nanoTime();
        this._viewerEffectTime = tock - tick;
        this._updateInfluencesCount = this._updateInfluences.size();
        if (this._updateInfluencesCount > 0) {
            this._updateArray = this._updateInfluences.toArray(this._updateArray);
            this._updateInfluences.clear();
            for (int ii = 0; ii < this._updateInfluencesCount; ++ii) {
                SceneElement element = this._updateArray[ii];
                boolean contains = this._updateInfluences.contains(element);
                this.getInfluences(element.getBounds(), this._influences);
                this.dumpInfluence(element, "set influences", 0);
                element.setInfluences(this._influences);
                this._influences.clear();
                if (!this._dumpInfluences || contains || !this._updateInfluences.contains(element)) continue;
                this.dumpInfluence(element, "SELF REFERENTIAL!!", 0);
            }
            Arrays.fill(this._updateArray, 0, this._updateInfluencesCount, null);
        }
        this._dumpInfluences = false;
        tick = System.nanoTime();
        this._updateInfluencesTime = tick - tock;
        this._clipmgr.tick(elapsed);
    }

    public void dumpInfluences() {
        this._dumpInfluences = true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.clearEffects();
        this._soundGroup.dispose();
        this._disposed = true;
    }

    protected void setEffects(ViewerEffectSet effects) {
        if (this._effects.equals(effects)) {
            return;
        }
        for (ViewerEffect effect : this._effects) {
            if (effects.contains(effect)) continue;
            effect.deactivate();
        }
        for (ViewerEffect effect : effects) {
            if (this._effects.contains(effect)) continue;
            effect.activate(this);
        }
        this._effects.clear();
        this._effects.addAll(effects);
        this._ctx.getCompositor().setBackgroundColor(this._effects.getBackgroundColor(this._viewer));
    }

    protected void addToTick(SceneElement element) {
        if (element.getTickPolicy() == SceneElement.TickPolicy.ALWAYS) {
            this._alwaysTick.add(element);
        }
    }

    protected void removeFromTick(SceneElement element) {
        if (element.getTickPolicy() == SceneElement.TickPolicy.ALWAYS) {
            this._alwaysTick.remove(element);
        }
    }

    protected abstract void addToSpatial(SceneElement var1);

    protected abstract void removeFromSpatial(SceneElement var1);

    protected abstract void addToSpatial(SceneInfluence var1);

    protected abstract void removeFromSpatial(SceneInfluence var1);

    protected abstract void addToSpatial(ViewerEffect var1);

    protected abstract void removeFromSpatial(ViewerEffect var1);

    protected void composite(ArrayList<SceneElement> elements, Frustum frustum) {
        int nn = elements.size();
        for (int ii = 0; ii < nn; ++ii) {
            SceneElement element = elements.get(ii);
            if (frustum.getIntersectionType(element.getBounds()) == Frustum.IntersectionType.NONE) continue;
            this.composite(element);
        }
    }

    protected final void composite(SceneElement element) {
        element.composite();
        if (element.getTickPolicy() == SceneElement.TickPolicy.WHEN_VISIBLE) {
            this._visible.add(element);
        }
    }

    protected SceneElement getIntersection(ArrayList<SceneElement> elements, Ray3D ray, Vector3f location, Predicate<? super SceneElement> filter) {
        SceneElement closest = null;
        Vector3f origin = ray.getOrigin();
        int nn = elements.size();
        for (int ii = 0; ii < nn; ++ii) {
            SceneElement element = elements.get(ii);
            if (!filter.apply((Object)element) || !element.getIntersection(ray, this._result) || closest != null && !(origin.distanceSquared(this._result) < origin.distanceSquared(location))) continue;
            closest = element;
            location.set(this._result);
        }
        return closest;
    }

    protected static <T extends SceneObject> void getIntersecting(ArrayList<T> objects, Box bounds, Collection<T> results) {
        int nn = objects.size();
        for (int ii = 0; ii < nn; ++ii) {
            SceneObject object = (SceneObject)objects.get(ii);
            if (!object.getBounds().intersects(bounds)) continue;
            results.add(object);
        }
    }

    protected void dumpInfluence(SceneElement element, String msg, int diff) {
        if (this._dumpInfluences) {
            Log.log.info((Object)msg, new Object[]{"diff", diff, "element", element.getUserObject()});
        }
    }

    protected void dumpInfluence(SceneInfluence influence, String msg, int diff) {
        if (this._dumpInfluences) {
            Log.log.info((Object)msg, new Object[]{"diff", diff, "influence", influence});
        }
    }

    public static class Transient
    extends Model {
        protected Updater _updater;

        public Transient(GlContext ctx, ConfigReference<ModelConfig> ref) {
            super(ctx, ref);
        }

        public void setUpdater(Updater updater) {
            this._updater = updater;
        }

        @Override
        public void tick(float elapsed) {
            if (this._updater != null) {
                this._updater.update();
            }
            super.tick(elapsed);
        }
    }
}

