/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.config;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.opengl.gui.config.ActionConfig;
import com.threerings.util.DeepObject;

public class InterfaceScriptConfig
extends ParameterizedConfig {
    @Editable
    public Implementation implementation = new Original();

    public Original getOriginal(ConfigManager cfgmgr) {
        return this.implementation.getOriginal(cfgmgr);
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    @Override
    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    public static class TimedAction
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0, step=0.01)
        public float time;
        @Editable
        public ActionConfig action = new ActionConfig.CallFunction();
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<InterfaceScriptConfig> interfaceScript;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(InterfaceScriptConfig.class, this.interfaceScript);
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            InterfaceScriptConfig config = cfgmgr.getConfig(InterfaceScriptConfig.class, this.interfaceScript);
            return config == null ? null : config.getOriginal(cfgmgr);
        }
    }

    public static class Original
    extends Implementation {
        @Editable(min=0.0, step=0.01)
        public float loopDuration;
        @Editable
        public TimedAction[] actions = new TimedAction[0];

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            return this;
        }

        @Override
        public void invalidate() {
            for (TimedAction taction : this.actions) {
                taction.action.invalidate();
            }
        }
    }

    @EditorTypes(value={Original.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract Original getOriginal(ConfigManager var1);

        public void invalidate() {
        }
    }
}

