/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.samskivert.util.StringUtil;
import com.threerings.opengl.gui.BoundedRangeModel;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.config.FontConfig;
import com.threerings.opengl.gui.config.StyleConfig;
import com.threerings.opengl.gui.event.ChangeEvent;
import com.threerings.opengl.gui.event.ChangeListener;
import com.threerings.opengl.gui.text.Text;
import com.threerings.opengl.gui.text.TextFactory;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;
import java.util.ArrayList;

public class TextArea
extends Container {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    protected int[] _haligns = new int[this.getStateCount()];
    protected int[] _valigns = new int[this.getStateCount()];
    protected int[] _teffects = new int[this.getStateCount()];
    protected int[] _effsizes = new int[this.getStateCount()];
    protected Color4f[] _effcols = new Color4f[this.getStateCount()];
    protected TextFactory[][] _textfacts = new TextFactory[this.getStateCount()][];
    protected BoundedRangeModel _model = new BoundedRangeModel(0, 0, 0, 0);
    protected int _prefWidth = -1;
    protected ArrayList<Run> _runs = new ArrayList();
    protected ArrayList<Line> _lines = new ArrayList();

    public TextArea(GlContext ctx) {
        this(ctx, (String)null);
    }

    public TextArea(GlContext ctx, String text) {
        super(ctx);
        this._model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                TextArea.this.modelDidChange();
            }
        });
        if (text != null) {
            this.setText(text);
        }
    }

    public int getHorizontalAlignment() {
        if (this._haligns != null) {
            int halign = this._haligns[this.getState()];
            return halign != -1 ? halign : this._haligns[0];
        }
        return 0;
    }

    public int getVerticalAlignment() {
        if (this._valigns != null) {
            int valign = this._valigns[this.getState()];
            return valign != -1 ? valign : this._valigns[0];
        }
        return 0;
    }

    public void setPreferredWidth(int width) {
        this._prefWidth = width;
    }

    public BoundedRangeModel getScrollModel() {
        return this._model;
    }

    public void setText(String text) {
        this.clearText();
        this.appendText(text);
    }

    public void appendText(String text) {
        this.appendText(text, null);
    }

    public void appendText(String text, Color4f color) {
        this.appendText(text, color, 0);
    }

    public void appendText(String text, int style) {
        this.appendText(text, null, style);
    }

    public void appendText(String text, Color4f color, int style) {
        int nlidx;
        int offset = 0;
        while ((nlidx = text.indexOf("\n", offset)) != -1) {
            String line = text.substring(offset, nlidx);
            this._runs.add(new Run(line, color, style, true));
            offset = nlidx + 1;
        }
        if (offset < text.length()) {
            this._runs.add(new Run(text.substring(offset), color, style, false));
        }
        this.invalidate();
    }

    public void clearText() {
        this._runs.clear();
        this.invalidate();
    }

    public void scrollToLine(int line) {
    }

    public int getLineCount() {
        return this._lines.size();
    }

    public TextFactory getTextFactory() {
        return this.getTextFactory(0);
    }

    public TextFactory getTextFactory(int style) {
        TextFactory[] textfacts = this._textfacts[this.getState()];
        return textfacts != null ? textfacts[style] : this._textfacts[0][style];
    }

    public int getTextEffect() {
        if (this._teffects != null) {
            int teffect = this._teffects[this.getState()];
            return teffect != -1 ? teffect : this._teffects[0];
        }
        return 0;
    }

    public int getEffectSize() {
        if (this._effsizes != null) {
            int effsize = this._effsizes[this.getState()];
            return effsize > 0 ? effsize : this._effsizes[0];
        }
        return 1;
    }

    public Color4f getEffectColor() {
        if (this._effcols != null) {
            Color4f effcol = this._effcols[this.getState()];
            return effcol != null ? effcol : this._effcols[0];
        }
        return Color4f.WHITE;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean wasEnabled = this.isEnabled();
        super.setEnabled(enabled);
        if (this.isAdded() && wasEnabled != this.isEnabled()) {
            this.refigureContents(this.getWidth());
        }
    }

    @Override
    protected String getDefaultStyleConfig() {
        return "Default/TextArea";
    }

    @Override
    protected void updateFromStyleConfig(int state, StyleConfig.Original config) {
        super.updateFromStyleConfig(state, config);
        this._haligns[state] = config.textAlignment.getConstant();
        this._valigns[state] = config.verticalAlignment.getConstant();
        this._teffects[state] = config.textEffect.getConstant();
        this._effsizes[state] = config.effectSize;
        this._effcols[state] = config.effectColor;
        FontConfig fconfig = this._ctx.getConfigManager().getConfig(FontConfig.class, config.font);
        fconfig = fconfig == null ? FontConfig.NULL : fconfig;
        int style = config.fontStyle.getFlags();
        this._textfacts[state] = new TextFactory[]{fconfig.getTextFactory(this._ctx, style, config.fontSize), fconfig.getTextFactory(this._ctx, style | 1, config.fontSize), fconfig.getTextFactory(this._ctx, style | 2, config.fontSize)};
    }

    @Override
    protected void layout() {
        super.layout();
        this.refigureContents(this.getWidth());
    }

    @Override
    protected void renderComponent(Renderer renderer) {
        super.renderComponent(renderer);
        int halign = this.getHorizontalAlignment();
        int valign = this.getVerticalAlignment();
        int start = this._model.getValue();
        int stop = start + this._model.getExtent();
        int lheight = 0;
        for (int ii = start; ii < stop; ++ii) {
            lheight += this._lines.get((int)ii).height;
        }
        int x = this.getInsets().left;
        Insets insets = this.getInsets();
        int y = valign == 0 ? this._height - insets.top : (valign == 1 ? lheight + insets.bottom : lheight + insets.bottom + (this._height - insets.getVertical() - lheight) / 2);
        for (int ii = start; ii < stop; ++ii) {
            Line line = this._lines.get(ii);
            y -= line.height;
            if (halign == 1) {
                x = this._width - line.getWidth() - insets.right;
            } else if (halign == 2) {
                x = insets.left + (this._width - insets.getHorizontal() - line.getWidth()) / 2;
            }
            line.render(renderer, x, y, this._alpha);
        }
    }

    @Override
    protected Dimension computePreferredSize(int whint, int hhint) {
        if (this._lines.size() == 0) {
            if (this._prefWidth > 0) {
                whint = this._prefWidth;
            } else if (whint == -1) {
                whint = Short.MAX_VALUE;
            }
            this.refigureContents(whint);
        }
        Dimension d = new Dimension();
        int ll = this._lines.size();
        for (int ii = 0; ii < ll; ++ii) {
            Line line = this._lines.get(ii);
            d.width = Math.max(line.getWidth(), d.width);
            d.height += line.height;
        }
        return d;
    }

    protected void refigureContents(int width) {
        if (!this.isAdded()) {
            return;
        }
        this._lines.clear();
        int insets = this.getInsets().getHorizontal();
        int maxWidth = width - insets;
        Line current = null;
        int ll = this._runs.size();
        for (int ii = 0; ii < ll; ++ii) {
            Color4f color;
            Run run = this._runs.get(ii);
            if (current == null) {
                current = new Line();
                this._lines.add(current);
            }
            int offset = 0;
            Color4f color4f = color = run.color == null ? this.getColor() : run.color;
            while ((offset = current.addRun(this.getTextFactory(run.style), run, color, this.getTextEffect(), this.getEffectSize(), this.getEffectColor(), maxWidth, offset)) >= 0) {
                current = new Line();
                this._lines.add(current);
            }
            if (!run.endsLine) continue;
            current = null;
        }
        insets = this.getInsets().getVertical();
        int lines = 0;
        int lheight = 0;
        for (int ll2 = this._lines.size() - 1; ll2 >= 0 && (lheight += this._lines.get((int)ll2).height) <= this._height - insets; --ll2) {
            ++lines;
        }
        int sline = Math.min(this._model.getValue(), this._lines.size() - lines);
        if (!this._model.setRange(0, sline, lines, this._lines.size())) {
            this.modelDidChange();
        }
    }

    protected void modelDidChange() {
    }

    protected static class Line {
        public Run start;
        public Run end;
        public int dx;
        public int height;
        public ArrayList<Text> segments = new ArrayList();

        protected Line() {
        }

        public int addRun(TextFactory tfact, Run run, Color4f color, int effect, int effectSize, Color4f effectColor, int maxWidth, int offset) {
            String rtext;
            Text[] text;
            if (this.dx == 0) {
                this.start = run;
            }
            if ((text = tfact.wrapText(rtext = run.text.substring(offset), color, effect, effectSize, effectColor, maxWidth - this.dx))[0].getLength() == 0 && !StringUtil.isBlank((String)rtext)) {
                return offset;
            }
            this.segments.add(text[0]);
            int remainder = rtext.length() - text[0].getLength();
            this.height = Math.max(this.height, text[0].getSize().height);
            this.dx += text[0].getSize().width;
            return remainder == 0 ? -1 : run.text.length() - remainder;
        }

        public void render(Renderer renderer, int x, int y, float alpha) {
            int dx = x;
            int ll = this.segments.size();
            for (int ii = 0; ii < ll; ++ii) {
                Text text = this.segments.get(ii);
                text.render(renderer, dx, y, alpha);
                dx += text.getSize().width;
            }
        }

        public int getWidth() {
            int width = 0;
            int ll = this.segments.size();
            for (int ii = 0; ii < ll; ++ii) {
                width += this.segments.get((int)ii).getSize().width;
            }
            return width;
        }
    }

    protected static class Run {
        public String text;
        public Color4f color;
        public int style;
        public boolean endsLine;

        public Run(String text, Color4f color, int style, boolean endsLine) {
            this.text = text;
            this.color = color;
            this.style = style;
            this.endsLine = endsLine;
        }
    }
}

