/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.threerings.math.Box;
import com.threerings.math.FloatMath;
import com.threerings.math.Matrix3f;
import com.threerings.math.Plane;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;

public class Frustum {
    protected Vector3f[] _vertices = new Vector3f[8];
    protected Plane[] _planes = new Plane[6];
    protected Box _bounds = new Box();
    protected static Vector3f _vertex = new Vector3f();

    public Frustum() {
        int ii;
        for (ii = 0; ii < 8; ++ii) {
            this._vertices[ii] = new Vector3f();
        }
        for (ii = 0; ii < 6; ++ii) {
            this._planes[ii] = new Plane();
        }
    }

    public Vector3f[] getVertices() {
        return this._vertices;
    }

    public Box getBounds() {
        return this._bounds;
    }

    public Frustum setToPerspective(float fovy, float aspect, float znear, float zfar) {
        float top = znear * FloatMath.tan(fovy / 2.0f);
        float bottom = -top;
        float right = top * aspect;
        float left = -right;
        return this.setToFrustum(left, right, bottom, top, znear, zfar);
    }

    public Frustum setToFrustum(float left, float right, float bottom, float top, float near, float far) {
        return this.setToProjection(left, right, bottom, top, near, far, Vector3f.UNIT_Z, false, false);
    }

    public Frustum setToOrtho(float left, float right, float bottom, float top, float near, float far) {
        return this.setToProjection(left, right, bottom, top, near, far, Vector3f.UNIT_Z, true, false);
    }

    public Frustum setToProjection(float left, float right, float bottom, float top, float near, float far, Vector3f nearFarNormal, boolean ortho, boolean mirrored) {
        if (ortho) {
            float nrz = -1.0f / nearFarNormal.z;
            float xl = nearFarNormal.x * left * nrz;
            float xr = nearFarNormal.x * right * nrz;
            float yb = nearFarNormal.y * bottom * nrz;
            float yt = nearFarNormal.y * top * nrz;
            this._vertices[0].set(left, bottom, xl + yb - near);
            this._vertices[mirrored ? 3 : 1].set(right, bottom, xr + yb - near);
            this._vertices[2].set(right, top, xr + yt - near);
            this._vertices[mirrored ? 1 : 3].set(left, top, xl + yt - near);
            this._vertices[4].set(left, bottom, xl + yb - far);
            this._vertices[mirrored ? 7 : 5].set(right, bottom, xr + yb - far);
            this._vertices[6].set(right, top, xr + yt - far);
            this._vertices[mirrored ? 5 : 7].set(left, top, xl + yt - far);
        } else {
            float rn = 1.0f / near;
            float lrn = left * rn;
            float rrn = right * rn;
            float brn = bottom * rn;
            float trn = top * rn;
            float nz = near * nearFarNormal.z;
            float z0 = nz / (nearFarNormal.x * lrn + nearFarNormal.y * brn - nearFarNormal.z);
            this._vertices[0].set(-z0 * lrn, -z0 * brn, z0);
            float z1 = nz / (nearFarNormal.x * rrn + nearFarNormal.y * brn - nearFarNormal.z);
            this._vertices[mirrored ? 3 : 1].set(-z1 * rrn, -z1 * brn, z1);
            float z2 = nz / (nearFarNormal.x * rrn + nearFarNormal.y * trn - nearFarNormal.z);
            this._vertices[2].set(-z2 * rrn, -z2 * trn, z2);
            float z3 = nz / (nearFarNormal.x * lrn + nearFarNormal.y * trn - nearFarNormal.z);
            this._vertices[mirrored ? 1 : 3].set(-z3 * lrn, -z3 * trn, z3);
            float fz = far * nearFarNormal.z;
            float z4 = fz / (nearFarNormal.x * lrn + nearFarNormal.y * brn - nearFarNormal.z);
            this._vertices[4].set(-z4 * lrn, -z4 * brn, z4);
            float z5 = fz / (nearFarNormal.x * rrn + nearFarNormal.y * brn - nearFarNormal.z);
            this._vertices[mirrored ? 7 : 5].set(-z5 * rrn, -z5 * brn, z5);
            float z6 = fz / (nearFarNormal.x * rrn + nearFarNormal.y * trn - nearFarNormal.z);
            this._vertices[6].set(-z6 * rrn, -z6 * trn, z6);
            float z7 = fz / (nearFarNormal.x * lrn + nearFarNormal.y * trn - nearFarNormal.z);
            this._vertices[mirrored ? 5 : 7].set(-z7 * lrn, -z7 * trn, z7);
        }
        this.updateDerivedState();
        return this;
    }

    public Frustum transformLocal(Transform3D transform) {
        return this.transform(transform, this);
    }

    public Frustum transform(Transform3D transform) {
        return this.transform(transform, new Frustum());
    }

    public Frustum transform(Transform3D transform, Frustum result) {
        for (int ii = 0; ii < 8; ++ii) {
            transform.transformPoint(this._vertices[ii], result._vertices[ii]);
        }
        result.updateDerivedState();
        return result;
    }

    public float getDistance(Vector3f point) {
        float distance = -3.4028235E38f;
        for (Plane plane : this._planes) {
            distance = Math.max(distance, plane.getDistance(point));
        }
        return distance;
    }

    public IntersectionType getIntersectionType(Box box) {
        if (!this._bounds.intersects(box)) {
            return IntersectionType.NONE;
        }
        int ccount = 0;
        for (int ii = 0; ii < 6; ++ii) {
            int inside = 0;
            Plane plane = this._planes[ii];
            for (int jj = 0; jj < 8; ++jj) {
                if (!(plane.getDistance(box.getVertex(jj, _vertex)) <= 0.0f)) continue;
                ++inside;
            }
            if (inside == 0) {
                return IntersectionType.NONE;
            }
            if (inside != 8) continue;
            ++ccount;
        }
        return ccount == 6 ? IntersectionType.CONTAINS : IntersectionType.INTERSECTS;
    }

    public Box getBoundsUnderRotation(Matrix3f matrix, Box result) {
        result.setToEmpty();
        for (Vector3f vertex : this._vertices) {
            result.addLocal(matrix.transform(vertex, _vertex));
        }
        return result;
    }

    protected void updateDerivedState() {
        this._planes[0].fromPoints(this._vertices[0], this._vertices[1], this._vertices[2]);
        this._planes[1].fromPoints(this._vertices[5], this._vertices[4], this._vertices[7]);
        this._planes[2].fromPoints(this._vertices[1], this._vertices[5], this._vertices[6]);
        this._planes[3].fromPoints(this._vertices[4], this._vertices[0], this._vertices[3]);
        this._planes[4].fromPoints(this._vertices[3], this._vertices[2], this._vertices[6]);
        this._planes[5].fromPoints(this._vertices[4], this._vertices[5], this._vertices[1]);
        this._bounds.fromPoints(this._vertices);
    }

    public static enum IntersectionType {
        NONE,
        INTERSECTS,
        CONTAINS;

    }
}

