/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.samskivert.swing.CollapsiblePanel;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.Spacer;
import com.samskivert.swing.VGroupLayout;
import com.samskivert.util.StringUtil;
import com.threerings.editor.ConfigComponent;
import com.threerings.editor.Introspector;
import com.threerings.editor.Log;
import com.threerings.editor.Property;
import com.threerings.editor.util.EditorContext;
import com.threerings.media.image.ImageUtil;
import com.threerings.util.MessageBundle;
import com.threerings.util.MessageManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Stack;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class BasePropertyEditor
extends CollapsiblePanel
implements ActionListener,
ConfigComponent {
    protected EditorContext _ctx;
    protected MessageManager _msgmgr;
    protected MessageBundle _msgs;
    protected JButton _highlight;
    protected boolean _highlighted;
    protected JButton _tree;
    protected String _title;
    protected boolean _invalid;
    protected String _parameterLabel;
    protected static Icon _expandIcon;
    protected static Icon _collapseIcon;
    protected static Icon _highlightIcon;
    protected static Icon _treeIcon;
    protected static Icon _panelIcon;
    protected static final int BASE_BACKGROUND = 238;
    protected static final int DEFAULT_BACKGROUND = 0xEEEEEE;
    protected static final int SHADE_DECREMENT = 8;
    protected static final Dimension PANEL_BUTTON_SIZE;

    public BasePropertyEditor() {
        super((LayoutManager)new FlowLayout());
        this.setBackground(null);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public String getLabel(Class<?> type) {
        if (type == null) {
            return this._msgs.get("m.null_value");
        }
        String name = type.getName();
        name = name.substring(Math.max(name.lastIndexOf(36), name.lastIndexOf(46)) + 1);
        name = StringUtil.toUSLowerCase((String)StringUtil.unStudlyName((String)name));
        return this.getLabel(name, Introspector.getMessageBundle(type));
    }

    public String[] getLabels(String[] names) {
        return this.getLabels(names, this._msgs);
    }

    public String[] getLabels(String[] names, String bundle) {
        return this.getLabels(names, this._msgmgr.getBundle(bundle));
    }

    public String[] getLabels(String[] names, MessageBundle msgs) {
        String[] labels = new String[names.length];
        for (int ii = 0; ii < names.length; ++ii) {
            labels[ii] = this.getLabel(names[ii], msgs);
        }
        return labels;
    }

    public String getMousePath(Point pt) {
        return "";
    }

    public String getMousePath() {
        Component c;
        Point pt = this.getMousePosition();
        Component component = c = pt == null ? null : this.findComponentAt(pt);
        if (c == null) {
            return "";
        }
        Stack<ConfigComponent> stack = new Stack<ConfigComponent>();
        while (c != null) {
            if (c instanceof ConfigComponent) {
                stack.push((ConfigComponent)((Object)c));
            }
            c = c.getParent();
        }
        StringBuilder builder = new StringBuilder();
        while (stack.size() > 0) {
            ConfigComponent com = (ConfigComponent)stack.pop();
            String path = com.getComponentPath(c, true);
            if (StringUtil.isBlank((String)path)) continue;
            builder.append(path.startsWith("[") ? path : "." + path);
        }
        return builder.toString();
    }

    protected <T extends Component> T getNextParentComponent(Class<T> clazz, Component comp) {
        Component nearest = null;
        for (Component c = comp; c != this; c = c.getParent()) {
            if (c == null) {
                return null;
            }
            if (!clazz.isInstance(c)) continue;
            nearest = (Component)clazz.cast(c);
            break;
        }
        return (T)nearest;
    }

    @Override
    public String getComponentPath(Component comp, boolean mouse) {
        return "";
    }

    public void setParameterLabel(@Nullable String label, String parameterInfo) {
        this._parameterLabel = label;
        if (!"".equals(parameterInfo)) {
            Log.log.warning((Object)("Lost parameter information: " + parameterInfo), new Object[0]);
        }
        this.updateBorder();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this._highlight) {
            this.toggleHighlight();
            this.invalidate();
        } else if (source == this._tree) {
            Icon icon = this._tree.getIcon();
            boolean enabled = icon == _treeIcon;
            this.setTreeModeEnabled(enabled);
            this._tree.setIcon(enabled ? _panelIcon : _treeIcon);
        } else {
            super.actionPerformed(event);
        }
    }

    protected void setTreeModeEnabled(boolean enabled) {
    }

    public String getLabel(Property property) {
        String name = property.getName();
        return property.shouldTranslateName() ? this.getLabel(name, property.getMessageBundle()) : name;
    }

    protected String getLabel(String name) {
        return this.getLabel(name, this._msgs);
    }

    protected String getLabel(String name, String bundle) {
        return this.getLabel(name, this._msgmgr.getBundle(bundle));
    }

    protected String getLabel(String name, MessageBundle msgs) {
        name = name.isEmpty() ? "default" : name;
        String key = "m." + name;
        return msgs.exists(key) ? msgs.get(key) : name;
    }

    protected String getLabel(Enum value, MessageBundle msgs) {
        if (value == null) {
            return this._msgs.get("m.null_value");
        }
        String key = "m." + StringUtil.toUSLowerCase((String)value.name());
        return msgs.exists(key) ? msgs.get(key) : value.toString();
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = null;
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != ChangeListener.class) continue;
            if (event == null) {
                event = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[ii + 1]).stateChanged(event);
        }
    }

    protected void makeCollapsible(EditorContext ctx, String title, boolean tree) {
        VGroupLayout gl = new VGroupLayout(VGroupLayout.NONE);
        gl.setOffAxisPolicy(VGroupLayout.STRETCH);
        gl.setGap(0);
        gl.setJustification(VGroupLayout.TOP);
        gl.setOffAxisJustification(VGroupLayout.LEFT);
        this.setLayout((LayoutManager)gl);
        if (_expandIcon == null) {
            _expandIcon = this.loadIcon("expand", ctx);
            _collapseIcon = this.loadIcon("collapse", ctx);
            _highlightIcon = this.loadIcon("highlight", ctx);
            _treeIcon = this.loadIcon("tree", ctx);
            _panelIcon = this.loadIcon("panels", ctx);
        }
        JPanel tcont = GroupLayout.makeHBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.RIGHT, (GroupLayout.Policy)GroupLayout.NONE);
        tcont.setOpaque(false);
        if (tree) {
            this._tree = this.createButton(_treeIcon);
            tcont.add(this._tree);
            this._tree.addActionListener(this);
        }
        JButton expand = this.createButton(_expandIcon);
        tcont.add(expand);
        this._highlight = this.createButton(_highlightIcon);
        tcont.add(this._highlight);
        this._highlight.addActionListener(this);
        this.setTrigger(expand, _expandIcon, _collapseIcon);
        expand.setHorizontalAlignment(0);
        this.add((Component)new Spacer(1, -24));
        this.setTriggerContainer(tcont, new JPanel(), false);
        this.setGap(5);
        this.setCollapsed(false);
        this.getContent().setBackground(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    BasePropertyEditor.this.toggleHighlight();
                }
            }
        });
        this._content.setLayout((LayoutManager)new VGroupLayout(GroupLayout.NONE, GroupLayout.STRETCH, 5, GroupLayout.TOP));
        this.setTitle(title);
    }

    protected Icon loadIcon(String name, EditorContext ctx) {
        BufferedImage image;
        try {
            image = ctx.getResourceManager().getImageResource("media/editor/" + name + ".png");
        }
        catch (IOException e) {
            Log.log.warning((Object)"Error loading image.", new Object[]{"name", name, e});
            image = ImageUtil.createErrorImage((int)12, (int)12);
        }
        return new ImageIcon(image);
    }

    protected JButton createButton(Icon icon) {
        JButton button = new JButton(icon);
        button.setPreferredSize(PANEL_BUTTON_SIZE);
        return button;
    }

    protected int getColor(String name) {
        return this.getColor(name, this._msgs, 0xEEEEEE);
    }

    protected int getColor(String name, String bundle, int defaultColor) {
        return this.getColor(name, this._msgmgr.getBundle(bundle), defaultColor);
    }

    protected int getColor(String name, MessageBundle msgs, int defaultColor) {
        if (name.isEmpty()) {
            return defaultColor;
        }
        name = "c." + name;
        return msgs.exists(name) ? Integer.parseInt(msgs.get(name), 16) : defaultColor;
    }

    protected int getPropertyColor(Property[] lineage) {
        for (int ii = lineage.length - 1; ii >= 0; --ii) {
            int color = this.getColor(lineage[ii].getColorName(), lineage[ii].getMessageBundle(), -1);
            if (color == -1) continue;
            return color;
        }
        return 0xEEEEEE;
    }

    protected Color getDarkerBackground(float shades) {
        int value = 238 - (int)(shades * 8.0f);
        return new Color(value, value, value);
    }

    protected Color getBackgroundColor(Property[] lineage) {
        int color = this.getPropertyColor(lineage);
        if (lineage == null) {
            return new Color(color);
        }
        return this.darkenColor(color, lineage.length / 2);
    }

    protected Color darkenColor(int color, float shades) {
        int darken = (int)(shades * 8.0f);
        int r = Math.max(0, ((color & 0xFF0000) >> 16) - darken);
        int g = Math.max(0, ((color & 0xFF00) >> 8) - darken);
        int b = Math.max(0, (color & 0xFF) - darken);
        return new Color(r, g, b);
    }

    protected void copyPropertyPath(String path) {
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        if (!path.isEmpty()) {
            StringSelection contents = new StringSelection(path);
            this.getToolkit().getSystemClipboard().setContents(contents, contents);
        }
    }

    protected void toggleHighlight() {
        this._highlighted = !this._highlighted;
        this.updateBorder();
    }

    protected void setTitle(String title) {
        this._title = title;
        this.updateBorder();
    }

    protected void updateBorder() {
        this.setBorder(this.createBorder());
    }

    protected Border createBorder() {
        Border border;
        Border border2 = border = this._highlighted ? BorderFactory.createLineBorder(Color.BLACK, 2) : null;
        if (this._title != null) {
            border = BorderFactory.createTitledBorder(border, this._title);
        }
        if (this._invalid) {
            border = BorderFactory.createCompoundBorder(border, BorderFactory.createLineBorder(Color.RED, 1));
        }
        if (this._parameterLabel != null) {
            TitledBorder tb = new TitledBorder(this._parameterLabel);
            tb.setTitleJustification(5);
            tb.setTitleColor(Color.BLUE);
            if (border != null) {
                tb.setTitlePosition(1);
                tb.setBorder(border);
            }
            border = tb;
        }
        return border;
    }

    protected <T extends Component> T getNextChildComponent(Class<T> clazz, Component comp) {
        Component nearest = null;
        for (Component c = comp; c != this; c = c.getParent()) {
            if (c == null) {
                return null;
            }
            if (!clazz.isInstance(c)) continue;
            nearest = (Component)clazz.cast(c);
        }
        return (T)nearest;
    }

    static {
        PANEL_BUTTON_SIZE = new Dimension(16, 16);
    }
}

