/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.threerings.math.Vector2f;
import com.threerings.tudey.util.Direction;

public class DirectionUtil {
    public static boolean alterStep(Vector2f paramVector2f, int direction) {
        if (direction == 0) {
            return true;
        }
        int i = 0;
        while (i < 4) {
            if ((direction & 1 << i) != 0 && paramVector2f.dot(Direction.CARDINAL_VALUES[i].getVector2f()) < 0.0f) {
                float f;
                Vector2f localVector2f = Direction.CARDINAL_VALUES[(i + 3) % 4].getVector2f();
                float f2 = paramVector2f.dot(localVector2f);
                if (f > 0.0f) {
                    paramVector2f.set(localVector2f.mult(f2));
                } else {
                    float f3;
                    localVector2f = Direction.CARDINAL_VALUES[(i + 1) % 4].getVector2f();
                    f2 = paramVector2f.dot(localVector2f);
                    if (f3 > 0.0f) {
                        paramVector2f.set(localVector2f.mult(f2));
                    } else {
                        paramVector2f.set(0.0f, 0.0f);
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public static int rotateDirections(int directions, float angle) {
        if (directions == 0) {
            return 0;
        }
        Vector2f vec = Vector2f.UNIT_Y.rotate(angle);
        int offset = 0;
        float minDist = Float.POSITIVE_INFINITY;
        int ii = 0;
        while (ii < 4) {
            float dist = Direction.CARDINAL_VALUES[ii].getVector2f().distanceSquared(vec);
            if (dist < minDist) {
                minDist = dist;
                offset = ii;
            }
            ++ii;
        }
        if (offset != 0) {
            return DirectionUtil.rotateCardinal(directions, offset);
        }
        return directions;
    }

    public static int rotateCardinal(int directions, int rotation) {
        int cardinal = directions & 0xF;
        int rotCardinal = (cardinal << rotation | cardinal >> 4 - rotation) & 0xF;
        directions = directions & 0xFFFFFFF0 | rotCardinal;
        return directions;
    }
}

