/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.cursor;

import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.expr.Scope;
import com.threerings.expr.SimpleScope;
import com.threerings.opengl.compositor.Compositable;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Tickable;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.cursor.EntryCursor;
import com.threerings.tudey.client.util.RectangleElement;
import com.threerings.tudey.config.TileConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.util.TudeyContext;

public class TileCursor
extends EntryCursor
implements ConfigUpdateListener<TileConfig> {
    protected TudeySceneModel.TileEntry _entry;
    protected TileConfig _config;
    protected Implementation _impl = NULL_IMPLEMENTATION;
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null){};

    public TileCursor(TudeyContext ctx, TudeySceneView view, TudeySceneModel.TileEntry entry) {
        super(ctx, view);
        this.update(entry);
    }

    @Override
    public void configUpdated(ConfigEvent<TileConfig> event) {
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public TudeySceneModel.Entry getEntry() {
        return this._entry;
    }

    @Override
    public Shape getShape() {
        return this._impl.getShape();
    }

    @Override
    public void update(TudeySceneModel.Entry entry) {
        this._entry = (TudeySceneModel.TileEntry)entry;
        this.setConfig(this._entry.tile);
        this._impl.update(this._entry);
    }

    @Override
    public void tick(float elapsed) {
        this._impl.tick(elapsed);
    }

    @Override
    public void composite() {
        this._impl.composite();
    }

    @Override
    public void dispose() {
        super.dispose();
        this._impl.dispose();
        if (this._config != null) {
            this._config.removeListener(this);
        }
    }

    protected void setConfig(ConfigReference<TileConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(TileConfig.class, ref));
    }

    protected void setConfig(TileConfig config) {
        if (this._config == config) {
            return;
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    protected void updateFromConfig() {
        Implementation nimpl = this._config == null ? null : this._config.getCursorImplementation(this._ctx, this, this._impl);
        Implementation implementation = nimpl = nimpl == null ? NULL_IMPLEMENTATION : nimpl;
        if (this._impl != nimpl) {
            this._impl.dispose();
            this._impl = nimpl;
        }
    }

    public static abstract class Implementation
    extends SimpleScope
    implements Tickable,
    Compositable {
        public Implementation(Scope parentScope) {
            super(parentScope);
        }

        public Shape getShape() {
            return null;
        }

        public void update(TudeySceneModel.TileEntry entry) {
        }

        @Override
        public void tick(float elapsed) {
        }

        @Override
        public void composite() {
        }

        @Override
        public String getScopeName() {
            return "impl";
        }
    }

    public static class Original
    extends Implementation {
        protected TileConfig.Original _config;
        protected Model _model;
        protected RectangleElement _footprint;
        protected Polygon _shape = new Polygon(4);

        public Original(TudeyContext ctx, Scope parentScope, TileConfig.Original config) {
            super(parentScope);
            this._model = new Model(ctx);
            this._model.setParentScope(this);
            this._model.setRenderScheme("Translucent");
            this._model.setColorState(new ColorState());
            this._model.getColorState().getColor().set(0.5f, 0.5f, 0.5f, 0.45f);
            this._footprint = new RectangleElement((GlContext)ctx, true);
            this._footprint.getColor().set(FOOTPRINT_COLOR);
            this.setConfig(config);
        }

        public void setConfig(TileConfig.Original config) {
            this._config = config;
            this._model.setConfig(this._config.model);
        }

        @Override
        public Shape getShape() {
            return this._shape;
        }

        @Override
        public void update(TudeySceneModel.TileEntry entry) {
            entry.getTransform(this._config, this._model.getLocalTransform());
            this._model.updateBounds();
            Rectangle region = this._footprint.getRegion();
            entry.getRegion(this._config, region);
            this._footprint.setElevation(entry.elevation);
            this._shape.getVertex(0).set(region.x, region.y);
            this._shape.getVertex(1).set(region.x + region.width, region.y);
            this._shape.getVertex(2).set(region.x + region.width, region.y + region.height);
            this._shape.getVertex(3).set(region.x, region.y + region.height);
            this._shape.updateBounds();
        }

        @Override
        public void tick(float elapsed) {
            this._model.tick(elapsed);
        }

        @Override
        public void composite() {
            this._model.composite();
            this._footprint.composite();
        }
    }
}

