/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.expr;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.expr.ExpressionParser;
import com.threerings.expr.ObjectExpression;
import com.threerings.expr.Scope;
import com.threerings.expr.Variable;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.util.DeepOmit;
import java.io.Reader;
import java.io.StringReader;

@EditorTypes(value={Parsed.class, Constant.class, Reference.class})
public abstract class StringExpression
extends ObjectExpression<String> {
    protected static StringExpression parseExpression(String expression) throws Exception {
        return (StringExpression)new ExpressionParser<Object>((Reader)new StringReader(expression)){

            @Override
            protected Object handleString(String value) {
                return new Constant(value);
            }

            @Override
            protected Object handleIdentifier(String name) {
                Reference ref = new Reference();
                ref.name = name;
                return ref;
            }
        }.parse();
    }

    public static class Constant
    extends StringExpression {
        @Editable
        public String value = "";

        public Constant(String value) {
            this.value = value;
        }

        public Constant() {
        }

        @Override
        public ObjectExpression.Evaluator<String> createEvaluator(Scope scope) {
            return new ObjectExpression.Evaluator<String>(){

                @Override
                public String evaluate() {
                    return Constant.this.value;
                }
            };
        }
    }

    public static class Parsed
    extends StringExpression {
        @Editable
        public String expression = "";
        @DeepOmit
        protected transient StringExpression _expr;

        @Override
        public ObjectExpression.Evaluator<String> createEvaluator(Scope scope) {
            if (this._expr == null) {
                try {
                    this._expr = Parsed.parseExpression(this.expression);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this._expr == null) {
                    this._expr = new Constant("");
                }
            }
            return this._expr.createEvaluator(scope);
        }

        @Override
        public void invalidate() {
            this._expr = null;
        }
    }

    public static class Reference
    extends StringExpression {
        @Editable
        public String name = "";
        @Editable
        public String defvalue = "";

        @Override
        public ObjectExpression.Evaluator<String> createEvaluator(Scope scope) {
            final StringBuilder reference = ScopeUtil.resolve(scope, this.name, null, StringBuilder.class);
            if (reference != null) {
                return new ObjectExpression.Evaluator<String>(){

                    @Override
                    public String evaluate() {
                        return reference.toString();
                    }
                };
            }
            final Variable variable = ScopeUtil.resolve(scope, this.name, Variable.newInstance(this.defvalue));
            return new ObjectExpression.Evaluator<String>(){

                @Override
                public String evaluate() {
                    return (String)variable.get();
                }
            };
        }
    }
}

