/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor;

import com.samskivert.util.StringUtil;
import com.threerings.editor.Log;
import com.threerings.editor.Property;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;

public class FieldProperty
extends Property {
    protected Field _field;

    public FieldProperty(Field field) {
        this._field = field;
        this._field.setAccessible(true);
        this._name = StringUtil.toUSLowerCase((String)StringUtil.unStudlyName((String)this._field.getName()));
    }

    @Override
    public Member getMember() {
        return this._field;
    }

    @Override
    public Class<?> getType() {
        return this._field.getType();
    }

    @Override
    public Type getGenericType() {
        return this._field.getGenericType();
    }

    @Override
    public boolean getBoolean(Object object) {
        try {
            return this._field.getBoolean(object);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
            return false;
        }
    }

    @Override
    public byte getByte(Object object) {
        try {
            return this._field.getByte(object);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
            return 0;
        }
    }

    @Override
    public char getChar(Object object) {
        try {
            return this._field.getChar(object);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
            return '\u0000';
        }
    }

    @Override
    public double getDouble(Object object) {
        try {
            return this._field.getDouble(object);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
            return 0.0;
        }
    }

    @Override
    public float getFloat(Object object) {
        try {
            return this._field.getFloat(object);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
            return 0.0f;
        }
    }

    @Override
    public int getInt(Object object) {
        try {
            return this._field.getInt(object);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
            return 0;
        }
    }

    @Override
    public long getLong(Object object) {
        try {
            return this._field.getLong(object);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
            return 0L;
        }
    }

    @Override
    public short getShort(Object object) {
        try {
            return this._field.getShort(object);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
            return 0;
        }
    }

    @Override
    public Object get(Object object) {
        try {
            return this._field.get(object);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
            return null;
        }
    }

    @Override
    public void setBoolean(Object object, boolean value) {
        try {
            this._field.setBoolean(object, value);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
        }
    }

    @Override
    public void setByte(Object object, byte value) {
        try {
            this._field.setByte(object, value);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
        }
    }

    @Override
    public void setChar(Object object, char value) {
        try {
            this._field.setChar(object, value);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
        }
    }

    @Override
    public void setDouble(Object object, double value) {
        try {
            this._field.setDouble(object, value);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
        }
    }

    @Override
    public void setFloat(Object object, float value) {
        try {
            this._field.setFloat(object, value);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
        }
    }

    @Override
    public void setInt(Object object, int value) {
        try {
            this._field.setInt(object, value);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
        }
    }

    @Override
    public void setLong(Object object, long value) {
        try {
            this._field.setLong(object, value);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
        }
    }

    @Override
    public void setShort(Object object, short value) {
        try {
            this._field.setShort(object, value);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
        }
    }

    @Override
    public void set(Object object, Object value) {
        try {
            this._field.set(object, value);
        }
        catch (IllegalAccessException e) {
            this.logWarning(e);
        }
        catch (IllegalArgumentException e) {
            Log.log.warning((Object)("Failed to access property [field=" + this._field + "],obj=" + object), new Object[]{e});
        }
    }

    protected void logWarning(Exception e) {
        Log.log.warning((Object)("Failed to access property [field=" + this._field + "]."), new Object[]{e});
    }
}

