/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.delta;

import com.google.common.collect.Lists;
import com.threerings.delta.BareArrayMask;
import com.threerings.delta.Delta;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamer;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;

public class ArrayDelta
extends Delta {
    protected Class<?> _clazz;
    protected int _length;
    protected BareArrayMask _mask;
    protected Object[] _values;

    public ArrayDelta(Object original, Object revised) {
        this._clazz = original.getClass();
        this._length = Array.getLength(revised);
        this._mask = new BareArrayMask(this._length);
        ArrayList values = Lists.newArrayList();
        int olen = Array.getLength(original);
        Object defvalue = Array.get(Array.newInstance(this._clazz.getComponentType(), 1), 0);
        Object[] oarray = new Object[1];
        Object[] narray = new Object[1];
        int ii = 0;
        while (ii < this._length) {
            oarray[0] = ii < olen ? Array.get(original, ii) : defvalue;
            Object ovalue = oarray[0];
            Object nvalue = narray[0] = Array.get(revised, ii);
            if (!Arrays.deepEquals(oarray, narray)) {
                if (Delta.checkDeltable(ovalue, nvalue)) {
                    nvalue = Delta.createDelta(ovalue, nvalue);
                }
                this._mask.set(ii);
                values.add(nvalue);
            }
            ++ii;
        }
        this._values = values.toArray();
    }

    public ArrayDelta() {
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        _classStreamer.writeObject(this._clazz, out, true);
        out.writeInt(this._length);
        this._mask.writeTo(out);
        boolean primitive = this._clazz.getComponentType().isPrimitive();
        int ii = 0;
        int idx = 0;
        while (ii < this._length) {
            if (this._mask.isSet(ii)) {
                Object value = this._values[idx++];
                if (primitive) {
                    out.writeBareObject(value);
                } else {
                    out.writeObject(value);
                }
            }
            ++ii;
        }
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._clazz = (Class)_classStreamer.createObject(in);
        this._length = in.readInt();
        this._mask = new BareArrayMask(this._length);
        this._mask.readFrom(in);
        Class<?> ctype = this._clazz.getComponentType();
        Streamer streamer = ctype.isPrimitive() ? (Streamer)_wrapperStreamers.get(ctype) : null;
        ArrayList values = Lists.newArrayList();
        int ii = 0;
        while (ii < this._length) {
            if (this._mask.isSet(ii)) {
                if (streamer != null) {
                    values.add(streamer.createObject(in));
                } else {
                    values.add(in.readObject());
                }
            }
            ++ii;
        }
        this._values = values.toArray();
    }

    @Override
    public Object apply(Object original) {
        if (original.getClass() != this._clazz) {
            throw new IllegalArgumentException("Delta class mismatch: original is " + original.getClass() + ", expected " + this._clazz);
        }
        Object revised = Array.newInstance(this._clazz.getComponentType(), this._length);
        int olen = Array.getLength(original);
        int ii = 0;
        int idx = 0;
        while (ii < this._length) {
            block9: {
                Object value;
                block8: {
                    block7: {
                        if (!this._mask.isSet(ii)) break block7;
                        if ((value = this._values[idx++]) instanceof Delta) {
                            value = ((Delta)value).apply(Array.get(original, ii));
                        }
                        break block8;
                    }
                    if (ii >= olen) break block9;
                    value = Array.get(original, ii);
                }
                Array.set(revised, ii, value);
            }
            ++ii;
        }
        return revised;
    }

    @Override
    public Delta merge(Delta other) {
        int mlength;
        ArrayDelta aother;
        block12: {
            block11: {
                if (!(other instanceof ArrayDelta)) break block11;
                aother = (ArrayDelta)other;
                if (aother._clazz == this._clazz) break block12;
            }
            throw new IllegalArgumentException("Cannot merge delta " + other);
        }
        ArrayDelta merged = new ArrayDelta();
        merged._clazz = this._clazz;
        merged._length = mlength = aother._length;
        merged._mask = new BareArrayMask(mlength);
        ArrayList values = Lists.newArrayList();
        int ii = 0;
        int oidx = 0;
        int nidx = 0;
        while (ii < mlength) {
            block15: {
                Object value;
                block14: {
                    block13: {
                        if (ii >= this._length || !this._mask.isSet(ii)) break block13;
                        Object ovalue = this._values[oidx++];
                        if (aother._mask.isSet(ii)) {
                            Object nvalue;
                            if ((nvalue = aother._values[nidx++]) instanceof Delta) {
                                Delta ndelta = (Delta)nvalue;
                                value = ovalue instanceof Delta ? ((Delta)ovalue).merge(ndelta) : ndelta.apply(ovalue);
                            } else {
                                value = nvalue;
                            }
                        } else {
                            value = ovalue;
                        }
                        break block14;
                    }
                    if (!aother._mask.isSet(ii)) break block15;
                    value = aother._values[nidx++];
                }
                merged._mask.set(ii);
                values.add(value);
            }
            ++ii;
        }
        merged._values = values.toArray();
        return merged;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[class=" + this._clazz.getName());
        int ii = 0;
        int idx = 0;
        while (ii < this._length) {
            if (this._mask.isSet(ii)) {
                buf.append(", " + ii + ":" + this._values[idx++]);
            }
            ++ii;
        }
        return buf.append("]").toString();
    }
}

