/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.samskivert.util.ListUtil;
import com.samskivert.util.OneLineLogFormatter;
import com.samskivert.util.RepeatRecordFilter;
import com.samskivert.util.StringUtil;
import com.threerings.ClydeLog;
import com.threerings.editor.Editable;
import com.threerings.export.util.ExportUtil;
import com.threerings.export.util.SerializableWrapper;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.resource.ResourceManager;
import com.threerings.util.MessageBundle;
import com.threerings.util.ResourceUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.LogManager;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ToolUtil {
    public static final DataFlavor LOCAL_WRAPPED_FLAVOR = ToolUtil.createLocalFlavor(SerializableWrapper.class);
    public static final DataFlavor SERIALIZED_WRAPPED_FLAVOR = new DataFlavor(SerializableWrapper.class, null);
    public static final DataFlavor[] WRAPPED_FLAVORS = new DataFlavor[]{LOCAL_WRAPPED_FLAVOR, SERIALIZED_WRAPPED_FLAVOR};
    protected static boolean _logConfigured;
    protected static int _windowCount;

    public static DataFlavor createLocalFlavor(Class<?> clazz) {
        try {
            return new DataFlavor("application/x-java-jvm-local-objectref;class=" + clazz.getName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Object getWrappedTransferData(Transferable t) {
        Object data;
        block5: {
            try {
                if (t.isDataFlavorSupported(LOCAL_WRAPPED_FLAVOR)) {
                    data = t.getTransferData(LOCAL_WRAPPED_FLAVOR);
                    break block5;
                }
                if (t.isDataFlavorSupported(SERIALIZED_WRAPPED_FLAVOR)) {
                    data = t.getTransferData(SERIALIZED_WRAPPED_FLAVOR);
                    break block5;
                }
                return null;
            }
            catch (Exception e) {
                ClydeLog.log.warning((Object)"Error retrieving transfer data.", new Object[]{"transferable", t, e});
                return null;
            }
        }
        return ((SerializableWrapper)data).getObject();
    }

    public static void configureLog(String logfile) {
        File nlog;
        if (_logConfigured || Boolean.getBoolean("no_log_redir")) {
            return;
        }
        File olog = new File(ToolUtil.getLogPath("old-" + logfile));
        if (olog.exists()) {
            olog.delete();
        }
        if ((nlog = new File(ToolUtil.getLogPath(logfile))).exists()) {
            nlog.renameTo(olog);
        }
        try {
            PrintStream logOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(nlog)), true);
            System.setOut(logOut);
            System.setErr(logOut);
            LogManager.getLogManager().readConfiguration();
            OneLineLogFormatter.configureDefaultHandler();
            RepeatRecordFilter.configureDefaultHandler((int)100);
        }
        catch (IOException ioe) {
            ClydeLog.log.warning((Object)"Failed to open debug log.", new Object[]{"path", nlog, ioe});
            return;
        }
        ClydeLog.log.info((Object)("Logging to '" + nlog + "'."), new Object[0]);
        _logConfigured = true;
    }

    public static JMenu createMenu(MessageBundle msgs, String name, int mnemonic) {
        JMenu menu = new JMenu(msgs.get("m." + name));
        menu.setMnemonic(mnemonic);
        return menu;
    }

    public static JMenuItem createMenuItem(ActionListener listener, MessageBundle msgs, String action, int mnemonic, int accelerator) {
        return ToolUtil.createMenuItem(listener, msgs, action, mnemonic, accelerator, 2);
    }

    public static JMenuItem createMenuItem(ActionListener listener, MessageBundle msgs, String action, int mnemonic, int accelerator, int modifiers) {
        return new JMenuItem(ToolUtil.createAction(listener, msgs, action, mnemonic, accelerator, modifiers));
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(ActionListener listener, MessageBundle msgs, String action, int mnemonic, int accelerator) {
        return ToolUtil.createCheckBoxMenuItem(listener, msgs, action, mnemonic, accelerator, 2);
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(ActionListener listener, MessageBundle msgs, String action, int mnemonic, int accelerator, int modifiers) {
        return new JCheckBoxMenuItem(ToolUtil.createAction(listener, msgs, action, mnemonic, accelerator, modifiers));
    }

    public static Action createAction(ActionListener listener, MessageBundle msgs, String command, int mnemonic, int accelerator) {
        return ToolUtil.createAction(listener, msgs, command, mnemonic, accelerator, 2);
    }

    public static Action createAction(final ActionListener listener, MessageBundle msgs, String command, int mnemonic, int accelerator, int modifiers) {
        AbstractAction action = new AbstractAction(msgs.get("m." + command)){

            @Override
            public void actionPerformed(ActionEvent event) {
                listener.actionPerformed(event);
            }
        };
        action.putValue("ActionCommandKey", command);
        action.putValue("MnemonicKey", mnemonic);
        if (accelerator != -1) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accelerator, modifiers));
        }
        return action;
    }

    public static JButton createButton(ActionListener listener, MessageBundle msgs, String action) {
        return ToolUtil.createButton(listener, msgs, action, "m." + action);
    }

    public static JButton createButton(ActionListener listener, MessageBundle msgs, String action, String key) {
        JButton button = new JButton(msgs.get(key));
        button.setActionCommand(action);
        button.addActionListener(listener);
        return button;
    }

    public static void windowAdded() {
        ++_windowCount;
    }

    public static void windowRemoved() {
        if (--_windowCount == 0) {
            System.exit(0);
        }
    }

    protected static String getLogPath(String logfile) {
        String appdir = System.getProperty("appdir", ".");
        File parent = new File(appdir, System.getProperty("logs.dir.prefix", ".playn"));
        parent.mkdirs();
        return new File(parent, logfile).getAbsolutePath();
    }

    public static class EditablePrefs {
        protected Preferences _prefs;
        protected ResourceManager _rsrcmgr;
        protected File _resourceDir;

        public EditablePrefs(Preferences prefs) {
            this._prefs = prefs;
        }

        public void init(ResourceManager rsrcmgr) {
            this._rsrcmgr = rsrcmgr;
            String dstr = ResourceUtil.getPreferredResourceDir();
            this._resourceDir = dstr == null ? null : new File(dstr);
            this._rsrcmgr.initResource(dstr);
        }

        @Editable(mode="directory", nullable=true)
        public void setResourceDir(File dir) {
            this._resourceDir = dir;
            String dstr = dir == null ? null : dir.toString();
            ResourceUtil.setPreferredResourceDir(dstr);
            this._rsrcmgr.initResource(dstr);
        }

        @Editable
        public File getResourceDir() {
            return this._resourceDir;
        }

        protected Color4f getPref(String key, Color4f def) {
            String cstr = this._prefs.get(key, null);
            if (cstr != null) {
                try {
                    return new Color4f(StringUtil.parseFloatArray((String)cstr));
                }
                catch (Exception e) {
                    ClydeLog.log.warning((Object)("Error reading color preference [prefs=" + this._prefs + ", key=" + key + ", value=" + cstr + "]."), new Object[]{e});
                }
            }
            return def;
        }

        protected void putPref(String key, Color4f value) {
            this._prefs.put(key, String.valueOf(value.r) + ", " + value.g + ", " + value.b + ", " + value.a);
        }

        protected Object getPref(String key, Object def) {
            byte[] bytes = this._prefs.getByteArray(key, null);
            Object object = bytes == null ? null : ExportUtil.fromBytes(bytes);
            return object == null ? def : object;
        }

        protected void putPref(String key, Object value) {
            byte[] bytes = ExportUtil.toBytes(value);
            if (bytes != null) {
                this._prefs.putByteArray(key, bytes);
            }
        }
    }

    public static class WrappedTransfer
    implements Transferable {
        protected SerializableWrapper _wrapper;

        public WrappedTransfer(Object object) {
            this._wrapper = new SerializableWrapper(object);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return WRAPPED_FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return ListUtil.contains((Object[])WRAPPED_FLAVORS, (Object)flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            return this._wrapper;
        }
    }
}

