/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.material.tools;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class NormalMapCreator {
    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.err.println("Usage: NormalMapCreator <input bump map> <output normal map> <scale> <include depth>");
            return;
        }
        BufferedImage in = ImageIO.read(new File(args[0]));
        int width = in.getWidth();
        int height = in.getHeight();
        float scale = Float.parseFloat(args[2]);
        boolean depth = Boolean.parseBoolean(args[3]);
        int[] inRGB = in.getRGB(0, 0, width, height, null, 0, width);
        int[] outRGB = new int[width * height];
        int yy = 0;
        while (yy < height) {
            int xx = 0;
            while (xx < width) {
                int top = inRGB[Math.max(0, yy - 1) * width + xx];
                int bottom = inRGB[Math.min(height - 1, yy + 1) * width + xx];
                int left = inRGB[yy * width + Math.max(0, xx - 1)];
                int right = inRGB[yy * width + Math.min(width - 1, xx + 1)];
                double nx = (double)((float)((left & 0xFF) - (right & 0xFF)) * scale) / 255.0;
                double ny = (double)((float)((bottom & 0xFF) - (top & 0xFF)) * scale) / 255.0;
                double nz = 1.0;
                double rlen = 1.0 / Math.sqrt(nx * nx + ny * ny + nz * nz);
                int r = (int)((nx * rlen + 1.0) * 255.0 / 2.0);
                int g = (int)((ny * rlen + 1.0) * 255.0 / 2.0);
                int b = (int)((nz * rlen + 1.0) * 255.0 / 2.0);
                int a = inRGB[yy * width + xx] & 0xFF;
                outRGB[yy * width + xx] = a << 24 | r << 16 | g << 8 | b;
                ++xx;
            }
            ++yy;
        }
        BufferedImage out = new BufferedImage(width, height, depth ? 6 : 5);
        out.setRGB(0, 0, width, height, outRGB, 0, width);
        ImageIO.write((RenderedImage)out, "png", new File(args[1]));
    }
}

