/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.google.common.base.Objects;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.config.ManagedConfig;
import com.threerings.math.FloatMath;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.Cursor;
import com.threerings.opengl.gui.Label;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.gui.Tooltip;
import com.threerings.opengl.gui.TransferHandler;
import com.threerings.opengl.gui.Window;
import com.threerings.opengl.gui.background.Background;
import com.threerings.opengl.gui.border.Border;
import com.threerings.opengl.gui.config.CursorConfig;
import com.threerings.opengl.gui.config.StyleConfig;
import com.threerings.opengl.gui.event.ComponentListener;
import com.threerings.opengl.gui.event.Event;
import com.threerings.opengl.gui.event.KeyEvent;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.gui.text.HTMLView;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lwjgl.opengl.GL11;

public class Component
implements ConfigUpdateListener<ManagedConfig> {
    public static final int DEFAULT = 0;
    public static final int HOVER = 1;
    public static final int DISABLED = 2;
    protected GlContext _ctx;
    protected StyleConfig[] _styleConfigs = new StyleConfig[this.getStateCount()];
    protected Tooltip _tooltip = new Tooltip();
    protected Container _parent;
    protected Dimension _preferredSize;
    protected int _x;
    protected int _y;
    protected int _width;
    protected int _height;
    protected CopyOnWriteArrayList<ComponentListener> _listeners;
    protected HashMap<String, Object> _properties;
    protected boolean _valid;
    protected boolean _enabled = true;
    protected boolean _visible = true;
    protected boolean _hoverable = true;
    protected boolean _hover;
    protected float _alpha = 1.0f;
    protected String _tag;
    protected Color4f[] _colors = new Color4f[this.getStateCount()];
    protected Insets[] _insets = new Insets[this.getStateCount()];
    protected Border[] _borders = new Border[this.getStateCount()];
    protected Background[] _backgrounds = new Background[this.getStateCount()];
    protected Cursor _cursor;
    protected TransferHandler _transferHandler;
    protected Transform2D _offset;
    protected static Rectangle _rect = new Rectangle();
    protected static final int STATE_COUNT = 3;
    protected static final String[] STATE_PCLASSES;

    static {
        String[] stringArray = new String[3];
        stringArray[1] = "Hover";
        stringArray[2] = "Disabled";
        STATE_PCLASSES = stringArray;
    }

    public static Component createDefaultTooltipComponent(GlContext ctx, String tiptext) {
        return Component.createDefaultTooltipComponent(ctx, tiptext, null);
    }

    public static Component createDefaultTooltipComponent(GlContext ctx, String tiptext, ConfigReference<StyleConfig> tipstyle) {
        if (tiptext.startsWith("<html>")) {
            return new HTMLView(ctx, "", tiptext);
        }
        Label label = new Label(ctx, tiptext);
        label.setStyleConfig(tipstyle);
        return label;
    }

    public Component(GlContext ctx) {
        this._ctx = ctx;
    }

    public GlContext getContext() {
        return this._ctx;
    }

    public void setStyleConfig(String name) {
        this.setStyleConfig(new ConfigReference<StyleConfig>(name));
    }

    public void setStyleConfig(String name, String firstKey, Object firstValue, Object ... otherArgs) {
        this.setStyleConfig(new ConfigReference<StyleConfig>(name, firstKey, firstValue, otherArgs));
    }

    public void setStyleConfig(ConfigReference<StyleConfig> ref) {
        if (ref == null) {
            ref = new ConfigReference(this.getDefaultStyleConfig());
        }
        StyleConfig[] styleConfigs = new StyleConfig[this._styleConfigs.length];
        styleConfigs[0] = this._ctx.getConfigManager().getConfig(StyleConfig.class, ref);
        String name = ref.getName();
        ArgumentMap args = ref.getArguments();
        int ii = 1;
        while (ii < styleConfigs.length) {
            String temp = this.getStatePseudoClass(ii) == null ? name : String.valueOf(name) + ":" + this.getStatePseudoClass(ii);
            styleConfigs[ii] = this._ctx.getConfigManager().getConfig(StyleConfig.class, temp, args);
            ++ii;
        }
        this.setStyleConfigs(styleConfigs);
    }

    public void setStyleConfigs(StyleConfig ... styleConfigs) {
        int ii = 0;
        while (ii < this._styleConfigs.length) {
            StyleConfig nconfig;
            StyleConfig oconfig = this._styleConfigs[ii];
            StyleConfig styleConfig = nconfig = ii < styleConfigs.length ? styleConfigs[ii] : null;
            if (oconfig != nconfig || oconfig == null) {
                if (oconfig != null) {
                    oconfig.removeListener(this);
                }
                if (nconfig == null) {
                    nconfig = ii == 0 ? this._ctx.getConfigManager().getConfig(StyleConfig.class, this.getDefaultStyleConfig()) : this._styleConfigs[this.getFallbackState(ii)];
                }
                if ((this._styleConfigs[ii] = nconfig) != null) {
                    nconfig.removeListener(this);
                    nconfig.addListener(this);
                }
                this.updateFromStyleConfig(ii);
            }
            ++ii;
        }
    }

    public StyleConfig[] getStyleConfigs() {
        return this._styleConfigs;
    }

    public String getTooltipWindowStyle() {
        return this._tooltip.getWindowStyle();
    }

    public void setParent(Container parent) {
        if (this._parent != null && parent != null) {
            Log.log.warning((Object)("Already added child readded to interface hierarchy! [comp=" + this + ", oparent=" + this._parent + ", nparent=" + parent + "]."), new Object[]{new Exception()});
        } else if (this._parent == null && parent == null) {
            Log.log.warning((Object)("Already removed child reremoved from interface hierarchy! [comp=" + this + "]."), new Object[]{new Exception()});
        }
        this._parent = parent;
    }

    public List<Component> getChildren() {
        return ImmutableList.of();
    }

    public Iterable<Component> getDescendants() {
        return ImmutableList.of();
    }

    public Iterable<Component> getUpwards() {
        return Iterables.concat((Iterable)ImmutableList.of((Object)this), this.getParents());
    }

    public Iterable<Component> getDownwards() {
        return ImmutableList.of((Object)this);
    }

    public Container getParent() {
        return this._parent;
    }

    public Iterable<Container> getParents() {
        return new Iterable<Container>(){

            @Override
            public Iterator<Container> iterator() {
                return new AbstractIterator<Container>(){
                    Component c;
                    {
                        this.c = Component.this;
                    }

                    protected Container computeNext() {
                        Container p = this.c.getParent();
                        if (p == null) {
                            return (Container)this.endOfData();
                        }
                        this.c = p;
                        return p;
                    }
                };
            }
        };
    }

    public Dimension getPreferredSize(int whint, int hhint) {
        Dimension ps;
        if (this._preferredSize != null && this._preferredSize.width != -1 && this._preferredSize.height != -1) {
            ps = new Dimension(this._preferredSize);
        } else {
            if (this._preferredSize != null) {
                if (this._preferredSize.width > 0) {
                    whint = this._preferredSize.width;
                }
                if (this._preferredSize.height > 0) {
                    hhint = this._preferredSize.height;
                }
            }
            Insets insets = this.getInsets();
            if (whint > 0) {
                whint -= insets.getHorizontal();
            }
            if (hhint > 0) {
                hhint -= insets.getVertical();
            }
            ps = this.computePreferredSize(whint, hhint);
            ps.width += insets.getHorizontal();
            ps.height += insets.getVertical();
            if (this._preferredSize != null) {
                if (this._preferredSize.width != -1) {
                    ps.width = this._preferredSize.width;
                }
                if (this._preferredSize.height != -1) {
                    ps.height = this._preferredSize.height;
                }
            }
        }
        Background background = this.getBackground();
        if (background != null) {
            ps.width = Math.max(ps.width, background.getMinimumWidth());
            ps.height = Math.max(ps.height, background.getMinimumHeight());
        }
        return ps;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this._preferredSize = preferredSize;
    }

    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    public int getX() {
        return this._x;
    }

    public int getY() {
        return this._y;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public int getAbsoluteX() {
        return this._x + (this._parent == null ? 0 : this._parent.getAbsoluteX());
    }

    public int getAbsoluteY() {
        return this._y + (this._parent == null ? 0 : this._parent.getAbsoluteY());
    }

    public Rectangle getBounds() {
        return new Rectangle(this._x, this._y, this._width, this._height);
    }

    public String getTag() {
        return this._tag;
    }

    public void setTag(String tag) {
        this._tag = tag;
    }

    public Insets getInsets() {
        Insets insets = this._insets[this.getState()];
        return insets == null ? Insets.ZERO_INSETS : insets;
    }

    public Color4f getColor() {
        Color4f color = this._colors[this.getState()];
        return color != null ? color : this._colors[0];
    }

    public String boundsToString() {
        return String.valueOf(this._width) + "x" + this._height + "+" + this._x + "+" + this._y;
    }

    public Border getBorder() {
        Border border = this._borders[this.getState()];
        return border != null ? border : this._borders[0];
    }

    public Background getBackground() {
        Background background = this._backgrounds[this.getState()];
        return background != null ? background : this._backgrounds[0];
    }

    public void setBackground(int state, Background background) {
        this._backgrounds[state] = background;
    }

    public Cursor getCursor() {
        return this._cursor;
    }

    public void setCursor(Cursor cursor) {
        if (this._cursor == cursor) {
            return;
        }
        this._cursor = cursor;
        if (this.isAdded() && this.changeCursor() && this._hover) {
            this.updateCursor(this._cursor);
        }
    }

    public void setAlpha(float alpha) {
        this._alpha = alpha;
    }

    public float getAlpha() {
        return this._alpha;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this._enabled) {
            this._enabled = enabled;
            this.stateDidChange();
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setVisible(boolean visible) {
        if (visible != this._visible) {
            this._visible = visible;
            this.invalidate();
            if (!visible && this.hasFocus()) {
                this.getWindow().getRoot().requestFocus(null);
            }
        }
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setHoverable(boolean hoverable) {
        this._hoverable = hoverable;
    }

    public boolean isHoverable() {
        return this._hoverable;
    }

    public boolean isShowing() {
        return this.isAdded() && this.isVisible();
    }

    public int getState() {
        return this._enabled ? (this._hover ? 1 : 0) : 2;
    }

    public void setProperty(String key, Object value) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this._properties == null ? null : this._properties.get(key);
    }

    public boolean acceptsFocus() {
        return false;
    }

    public boolean hasFocus() {
        return this.isAdded() && this.getWindow().getRoot().getFocus() == this;
    }

    public Component getFocusTarget() {
        if (this.acceptsFocus()) {
            return this;
        }
        if (this._parent != null) {
            return this._parent.getFocusTarget();
        }
        return null;
    }

    public void requestFocus() {
        if (!this.acceptsFocus()) {
            Log.log.warning((Object)("Unfocusable component requested focus: " + this), new Object[]{new Exception()});
            return;
        }
        Window window = this.getWindow();
        if (window == null) {
            Log.log.warning((Object)("Focus requested for un-added component: " + this), new Object[]{new Exception()});
        } else {
            window.requestFocus(this);
        }
    }

    public void setLocation(int x, int y) {
        this.setBounds(x, y, this._width, this._height);
    }

    public void setSize(int width, int height) {
        this.setBounds(this._x, this._y, width, height);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this._x != x || this._y != y) {
            this._x = x;
            this._y = y;
        }
        if (this._width != width || this._height != height) {
            this._width = width;
            this._height = height;
            this.invalidate();
        }
    }

    public void setOffset(Transform2D offset) {
        this._offset = offset;
    }

    public Transform2D getOffset() {
        return this._offset;
    }

    public void addListener(ComponentListener listener) {
        if (this._listeners == null) {
            this._listeners = new CopyOnWriteArrayList();
        }
        this._listeners.add(listener);
    }

    public boolean removeListener(ComponentListener listener) {
        return this._listeners != null && this._listeners.remove(listener);
    }

    public void removeAllListeners() {
        this._listeners = null;
    }

    public void removeAllListeners(Class<? extends ComponentListener> clazz) {
        if (this._listeners == null) {
            return;
        }
        int ii = this._listeners.size() - 1;
        while (ii >= 0) {
            if (clazz.isInstance(this._listeners.get(ii))) {
                this._listeners.remove(ii);
            }
            --ii;
        }
    }

    public void setTooltipText(String text) {
        this._tooltip.setText(text);
    }

    public String getTooltipText() {
        return this._tooltip.getText();
    }

    public void setTooltipRelativeToMouse(boolean mouse) {
        this._tooltip.setRelativeToMouse(mouse);
    }

    public boolean isTooltipRelativeToMouse() {
        return this._tooltip.isRelativeToMouse();
    }

    public float getTooltipTimeout() {
        return this._tooltip.getTimeout();
    }

    public Tooltip getTooltip() {
        return this._tooltip;
    }

    public void setTooltip(Tooltip tooltip) {
        this._tooltip = tooltip;
    }

    public void setTransferHandler(TransferHandler handler) {
        this._transferHandler = handler;
    }

    public TransferHandler getTransferHandler() {
        return this._transferHandler == null && this._parent != null ? this._parent.getTransferHandler() : this._transferHandler;
    }

    public boolean isAdded() {
        Window win = this.getWindow();
        return win != null && win.isAdded();
    }

    public boolean isValid() {
        return this._valid;
    }

    public void validate() {
        if (!this._valid) {
            if (this.isVisible()) {
                this.layout();
            }
            this._valid = true;
        }
    }

    public void invalidate() {
        if (this._valid) {
            this._valid = false;
            if (this._parent != null) {
                this._parent.invalidate();
            }
        }
    }

    public void render(Renderer renderer) {
        if (!this._visible) {
            return;
        }
        if (this._offset != null) {
            GL11.glPushMatrix();
            this.applyTransform();
        } else {
            GL11.glTranslatef((float)this._x, (float)this._y, (float)0.0f);
        }
        try {
            this.renderBackground(renderer);
            this.renderComponent(renderer);
            this.renderBorder(renderer);
        }
        finally {
            if (this._offset != null) {
                GL11.glPopMatrix();
            } else {
                GL11.glTranslatef((float)(-this._x), (float)(-this._y), (float)0.0f);
            }
        }
    }

    public Component getHitComponent(int mx, int my) {
        return this.isVisible() && this._hoverable && this.contains(mx, my) ? this : null;
    }

    public boolean contains(int mx, int my) {
        return mx >= this._x && my >= this._y && mx < this._x + this._width && my < this._y + this._height;
    }

    public final void scrollRectToVisible(Rectangle rect) {
        this.scrollRectToVisible(rect.x, rect.y, rect.width, rect.height);
    }

    public void scrollRectToVisible(int x, int y, int w, int h) {
        if (this._parent != null) {
            this._parent.scrollRectToVisible(x + this._x, y + this._y, w, h);
        }
    }

    public boolean dispatchEvent(Event event) {
        KeyEvent kev;
        boolean processed;
        boolean bl = processed = !event.propagateUpHierarchy();
        if (event instanceof KeyEvent && (kev = (KeyEvent)event).getType() == 0) {
            int modifiers = kev.getModifiers();
            int keyCode = kev.getKeyCode();
            if (keyCode == 15 && this.getWindow() != null) {
                if (modifiers == 0) {
                    this.getWindow().requestFocus(this.getNextFocus());
                    processed = true;
                } else if (modifiers == 8) {
                    this.getWindow().requestFocus(this.getPreviousFocus());
                    processed = true;
                }
            }
        }
        if (event instanceof MouseEvent) {
            int ostate = this.getState();
            MouseEvent mev = (MouseEvent)event;
            switch (mev.getType()) {
                case 3: {
                    this._hover = true;
                    processed = true;
                    break;
                }
                case 4: {
                    this._hover = false;
                    processed = true;
                }
            }
            if (this.getState() != ostate) {
                this.stateDidChange();
            }
            if (processed && this.changeCursor()) {
                this.updateCursor(this._hover ? this._cursor : null);
            }
        }
        if (this._listeners != null) {
            for (ComponentListener listener : this._listeners) {
                event.dispatch(listener);
            }
        }
        if (!processed && this._parent != null) {
            return this.getParent().dispatchEvent(event);
        }
        return processed;
    }

    @Override
    public void configUpdated(ConfigEvent<ManagedConfig> event) {
        StyleConfig config = (StyleConfig)event.getConfig();
        int ii = 0;
        while (ii < this._styleConfigs.length) {
            if (this._styleConfigs[ii] == config) {
                this.updateFromStyleConfig(ii);
            }
            ++ii;
        }
    }

    public final String toString() {
        return this.toStringHelper().toString();
    }

    protected Objects.ToStringHelper toStringHelper() {
        return Objects.toStringHelper((Object)this);
    }

    protected void updateFromStyleConfig(int state) {
        StyleConfig config = this._styleConfigs[state];
        StyleConfig.Original original = config == null ? null : config.getOriginal(this._ctx);
        this.updateFromStyleConfig(state, original == null ? StyleConfig.NULL_ORIGINAL : original);
        this.invalidate();
    }

    protected void updateFromStyleConfig(int state, StyleConfig.Original config) {
        if (state == 0) {
            this._preferredSize = config.size == null ? this._preferredSize : config.size.createDimension();
            this._tooltip.setStyle(config.tooltipStyle);
            CursorConfig cconfig = this._ctx.getConfigManager().getConfig(CursorConfig.class, config.cursor);
            this._cursor = cconfig == null ? null : cconfig.getCursor(this._ctx);
        }
        this._colors[state] = config.color;
        this._insets[state] = config.padding.createInsets();
        Border border = this._borders[state] = config.border == null ? null : config.border.getBorder();
        if (this._borders[state] != null) {
            this._insets[state] = this._borders[state].adjustInsets(this._insets[state]);
        }
        this._backgrounds[state] = config.background == null ? null : config.background.getBackground(this._ctx);
    }

    protected void layout() {
    }

    protected Dimension computePreferredSize(int whint, int hhint) {
        return new Dimension(0, 0);
    }

    protected void wasAdded() {
        if (this._styleConfigs[0] == null) {
            this.setStyleConfig(this.getDefaultStyleConfig());
        }
    }

    protected void wasRemoved() {
        this._valid = false;
    }

    protected Component createTooltipComponent(String tiptext) {
        return this._tooltip.createComponent(this._ctx, tiptext);
    }

    protected void applyTransform() {
        float hwidth = (float)this._width / 2.0f;
        float hheight = (float)this._height / 2.0f;
        GL11.glTranslatef((float)((float)this._x + hwidth), (float)((float)this._y + hheight), (float)0.0f);
        int type = this._offset.getType();
        if (type != 0) {
            if (type == 3 || type == 4) {
                Log.log.warning((Object)"Unsupported offset transform type.", new Object[]{"offset", this._offset});
            } else {
                Vector2f translation = this._offset.getTranslation();
                GL11.glTranslatef((float)translation.x, (float)translation.y, (float)0.0f);
                GL11.glRotatef((float)FloatMath.toDegrees(this._offset.getRotation()), (float)0.0f, (float)0.0f, (float)1.0f);
                if (type == 2) {
                    float scale = this._offset.getScale();
                    GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                }
            }
        }
        GL11.glTranslatef((float)(-hwidth), (float)(-hheight), (float)0.0f);
    }

    protected void renderBackground(Renderer renderer) {
        Background background = this.getBackground();
        if (background != null) {
            background.render(renderer, 0, 0, this._width, this._height, this._alpha);
        }
    }

    protected void renderBorder(Renderer renderer) {
        Border border = this.getBorder();
        if (border != null) {
            border.render(renderer, 0, 0, this._width, this._height, this._alpha);
        }
    }

    protected void renderComponent(Renderer renderer) {
    }

    protected String getDefaultStyleConfig() {
        return "Default/Component";
    }

    protected int getStateCount() {
        return 3;
    }

    protected String getStatePseudoClass(int state) {
        return STATE_PCLASSES[state];
    }

    protected int getFallbackState(int state) {
        return 0;
    }

    protected void stateDidChange() {
        this.invalidate();
    }

    protected boolean changeCursor() {
        return this._enabled && this._visible;
    }

    protected void updateCursor(Cursor cursor) {
        if (this.isAdded()) {
            this.getWindow().getRoot().setCursor(cursor);
        }
    }

    protected Window getWindow() {
        if (this instanceof Window) {
            return (Window)this;
        }
        if (this._parent != null) {
            return this._parent.getWindow();
        }
        return null;
    }

    protected Component getNextFocus() {
        return this._parent == null ? this.getFirstDescendantFocus() : this._parent.getNextFocus(this);
    }

    protected Component getPreviousFocus() {
        return this._parent == null ? this.getLastDescendantFocus() : this._parent.getPreviousFocus(this);
    }

    protected Component getFirstDescendantFocus() {
        return this.acceptsFocus() ? this : null;
    }

    protected Component getLastDescendantFocus() {
        return this.acceptsFocus() ? this : null;
    }

    protected boolean emitEvent(Event event) {
        Root root;
        Window window = this.getWindow();
        if (window == null || (root = window.getRoot()) == null) {
            return false;
        }
        root.dispatchEvent(this, event);
        return true;
    }

    protected static Rectangle intersectScissor(Renderer renderer, Rectangle store, int x, int y, int width, int height) {
        Rectangle scissor = renderer.getScissor();
        _rect.set(x, y, width, height);
        if (scissor != null) {
            _rect.intersectLocal(store.set(scissor));
        } else {
            store = null;
        }
        Component._rect.width = Math.max(Component._rect.width, 0);
        Component._rect.height = Math.max(Component._rect.height, 0);
        renderer.setScissor(_rect);
        return store;
    }
}

