/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.prefs;

import java.io.File;

public abstract class FileWatchdog
extends Thread {
    public static final long DEFAULT_DELAY = 60000L;
    protected long delay = 60000L;
    File[] files;
    long lastModif = 0L;
    boolean warnedAlready = false;
    boolean interrupted = false;

    protected FileWatchdog(File ... files) {
        long last = 0L;
        if (files == null || files.length == 0) {
            throw new NullPointerException("create fileWatchDog error,File is null");
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            last = file.lastModified() > last ? file.lastModified() : last;
            ++n2;
        }
        this.files = files;
        this.setDaemon(true);
        this.checkAndConfigure();
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    protected abstract void doOnChange();

    protected void checkAndConfigure() {
        boolean needFire = false;
        File[] fileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            boolean fileExists;
            File file = fileArray[n2];
            try {
                fileExists = file.exists();
            }
            catch (SecurityException e) {
                this.interrupted = true;
                return;
            }
            if (fileExists) {
                long l = file.lastModified();
                if (l > this.lastModif) {
                    this.lastModif = l;
                    needFire = true;
                }
            } else if (!this.warnedAlready) {
                this.warnedAlready = true;
            }
            ++n2;
        }
        if (needFire) {
            this.doOnChange();
            this.warnedAlready = false;
        }
    }

    @Override
    public void run() {
        while (!this.interrupted) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkAndConfigure();
        }
    }
}

