/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal.config;

import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.FileConstraints;
import com.threerings.export.Exportable;
import com.threerings.expr.BooleanExpression;
import com.threerings.expr.Scope;
import com.threerings.openal.Sounder;
import com.threerings.openal.util.AlContext;
import com.threerings.probs.FloatVariable;
import com.threerings.util.DeepObject;
import java.util.HashSet;

public class SounderConfig
extends ParameterizedConfig {
    @Editable
    public Implementation implementation = new Clip();

    public Sounder.Implementation getSounderImplementation(AlContext ctx, Scope scope, Sounder.Implementation impl) {
        return this.implementation.getSounderImplementation(ctx, scope, impl);
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    @Override
    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    @Override
    protected void getUpdateResources(HashSet<String> paths) {
        this.implementation.getUpdateResources(paths);
    }

    public static abstract class BaseClip
    extends Fixed {
        @Editable(weight=-3.0, hgroup="f")
        public boolean loop;
    }

    public static abstract class BaseStream
    extends Fixed {
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float fadeIn;
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float fadeOut;
        @Editable(hgroup="s")
        public String stack = "default";
        @Editable(hgroup="s")
        public boolean push;
        @Editable
        public boolean attenuate;
    }

    public static class Case
    extends DeepObject
    implements Exportable {
        @Editable
        public BooleanExpression condition = new BooleanExpression.Constant(true);
        @Editable(nullable=true)
        public ConfigReference<SounderConfig> sounder;
    }

    public static class Clip
    extends BaseClip {
        @Editable(editor="resource", nullable=true, weight=-3.0, hgroup="f")
        @FileConstraints(description="m.sound_files_desc", extensions={".ogg"}, directory="sound_dir")
        public String file;

        @Override
        public void getUpdateResources(HashSet<String> paths) {
            if (this.file != null) {
                paths.add(this.file);
            }
        }

        @Override
        public Sounder.Implementation getSounderImplementation(AlContext ctx, Scope scope, Sounder.Implementation impl) {
            if (this.file == null) {
                return null;
            }
            if (impl instanceof Sounder.Clip) {
                ((Sounder.Clip)impl).setConfig(this);
            } else {
                impl = new Sounder.Clip(ctx, scope, this);
            }
            return impl;
        }
    }

    public static class ComponentSounder
    extends DeepObject
    implements Exportable {
        @Editable(nullable=true)
        public ConfigReference<SounderConfig> sounder;
    }

    public static class Compound
    extends Implementation {
        @Editable
        public ComponentSounder[] sounders = new ComponentSounder[0];

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            ComponentSounder[] componentSounderArray = this.sounders;
            int n = this.sounders.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentSounder comp = componentSounderArray[n2];
                refs.add(SounderConfig.class, comp.sounder);
                ++n2;
            }
        }

        @Override
        public Sounder.Implementation getSounderImplementation(AlContext ctx, Scope scope, Sounder.Implementation impl) {
            if (this.sounders.length == 0) {
                return null;
            }
            if (impl instanceof Sounder.Compound) {
                ((Sounder.Compound)impl).setConfig(this);
            } else {
                impl = new Sounder.Compound(ctx, scope, this);
            }
            return impl;
        }
    }

    public static class Conditional
    extends Implementation {
        @Editable
        public Case[] cases = new Case[0];
        @Editable(nullable=true)
        public ConfigReference<SounderConfig> defaultSounder;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            Case[] caseArray = this.cases;
            int n = this.cases.length;
            int n2 = 0;
            while (n2 < n) {
                Case caze = caseArray[n2];
                refs.add(SounderConfig.class, caze.sounder);
                ++n2;
            }
            refs.add(SounderConfig.class, this.defaultSounder);
        }

        @Override
        public Sounder.Implementation getSounderImplementation(AlContext ctx, Scope scope, Sounder.Implementation impl) {
            if (impl instanceof Sounder.Conditional) {
                ((Sounder.Conditional)impl).setConfig(this);
            } else {
                impl = new Sounder.Conditional(ctx, scope, this);
            }
            return impl;
        }

        @Override
        public void invalidate() {
            Case[] caseArray = this.cases;
            int n = this.cases.length;
            int n2 = 0;
            while (n2 < n) {
                Case caze = caseArray[n2];
                caze.condition.invalidate();
                ++n2;
            }
        }
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<SounderConfig> sounder;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(SounderConfig.class, this.sounder);
        }

        @Override
        public Sounder.Implementation getSounderImplementation(AlContext ctx, Scope scope, Sounder.Implementation impl) {
            SounderConfig config = ctx.getConfigManager().getConfig(SounderConfig.class, this.sounder);
            return config == null ? null : config.getSounderImplementation(ctx, scope, impl);
        }
    }

    public static abstract class Fixed
    extends Original {
        @Editable(min=0.0, step=0.01, hgroup="g", weight=-1.0)
        public float gain = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="g", weight=-1.0)
        public float pitch = 1.0f;

        @Override
        public float getGain() {
            return this.gain;
        }

        @Override
        public float getPitch() {
            return this.pitch;
        }
    }

    @EditorTypes(value={Clip.class, MetaClip.class, VariableClip.class, Stream.class, MetaStream.class, Conditional.class, Compound.class, Sequential.class, Scripted.class, Random.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public void getUpdateResources(HashSet<String> paths) {
        }

        public abstract Sounder.Implementation getSounderImplementation(AlContext var1, Scope var2, Sounder.Implementation var3);

        public void invalidate() {
        }
    }

    public static class MetaClip
    extends BaseClip {
        @Editable(weight=-3.0)
        public PitchWeightedFile[] files = new PitchWeightedFile[0];

        @Override
        public void getUpdateResources(HashSet<String> paths) {
            PitchWeightedFile[] pitchWeightedFileArray = this.files;
            int n = this.files.length;
            int n2 = 0;
            while (n2 < n) {
                PitchWeightedFile wfile = pitchWeightedFileArray[n2];
                if (wfile.file != null) {
                    paths.add(wfile.file);
                }
                ++n2;
            }
        }

        @Override
        public Sounder.Implementation getSounderImplementation(AlContext ctx, Scope scope, Sounder.Implementation impl) {
            if (this.files.length == 0) {
                return null;
            }
            if (impl instanceof Sounder.MetaClip) {
                ((Sounder.MetaClip)impl).setConfig(this);
            } else {
                impl = new Sounder.MetaClip(ctx, scope, this);
            }
            return impl;
        }
    }

    public static class MetaStream
    extends BaseStream {
        @Editable(weight=-3.0)
        public WeightedFile[] files = new WeightedFile[0];
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float crossFade;

        @Override
        public void getUpdateResources(HashSet<String> paths) {
            WeightedFile[] weightedFileArray = this.files;
            int n = this.files.length;
            int n2 = 0;
            while (n2 < n) {
                WeightedFile wfile = weightedFileArray[n2];
                if (wfile.file != null) {
                    paths.add(wfile.file);
                }
                ++n2;
            }
        }

        @Override
        public Sounder.Implementation getSounderImplementation(AlContext ctx, Scope scope, Sounder.Implementation impl) {
            if (this.files.length == 0) {
                return null;
            }
            if (impl instanceof Sounder.MetaStream) {
                ((Sounder.MetaStream)impl).setConfig(this);
            } else {
                impl = new Sounder.MetaStream(ctx, scope, this);
            }
            return impl;
        }
    }

    public static abstract class Original
    extends Implementation {
        @Editable(hgroup="s", weight=-2.0)
        public boolean sourceRelative;
        @Editable(hgroup="s", weight=-2.0)
        public boolean directional;
        @Editable(min=0.0, max=1.0, step=0.01, hgroup="m")
        public float minGain;
        @Editable(min=0.0, max=1.0, step=0.01, hgroup="m")
        public float maxGain = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="r")
        public float referenceDistance = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="r")
        public float rolloffFactor = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="m")
        public float maxDistance = Float.MAX_VALUE;
        @Editable(min=0.0, max=1.0, step=0.01, hgroup="m")
        public float coneOuterGain;
        @Editable(min=-360.0, max=360.0, hgroup="c")
        public float coneInnerAngle = 360.0f;
        @Editable(min=-360.0, max=360.0, hgroup="c")
        public float coneOuterAngle = 360.0f;

        public abstract float getGain();

        public abstract float getPitch();
    }

    public static class PitchWeightedFile
    extends WeightedFile {
        @Editable(min=0.0, step=0.01)
        public float pitch = 1.0f;
    }

    public static class QueuedFile
    extends DeepObject
    implements Exportable {
        @Editable(editor="resource", nullable=true, hgroup="f")
        @FileConstraints(description="m.sound_files_desc", extensions={".ogg"}, directory="sound_dir")
        public String file;
        @Editable(hgroup="f")
        public boolean loop;
    }

    public static class Random
    extends Implementation {
        @Editable
        public WeightedSounder[] sounders = new WeightedSounder[0];

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            WeightedSounder[] weightedSounderArray = this.sounders;
            int n = this.sounders.length;
            int n2 = 0;
            while (n2 < n) {
                WeightedSounder comp = weightedSounderArray[n2];
                refs.add(SounderConfig.class, comp.sounder);
                ++n2;
            }
        }

        @Override
        public Sounder.Implementation getSounderImplementation(AlContext ctx, Scope scope, Sounder.Implementation impl) {
            if (this.sounders.length == 0) {
                return null;
            }
            if (impl instanceof Sounder.Random) {
                ((Sounder.Random)impl).setConfig(this);
            } else {
                impl = new Sounder.Random(ctx, scope, this);
            }
            return impl;
        }
    }

    public static class Scripted
    extends Implementation {
        @Editable(min=0.0, step=0.01)
        public float loopDuration;
        @Editable
        public TimedSounder[] sounders = new TimedSounder[0];

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            TimedSounder[] timedSounderArray = this.sounders;
            int n = this.sounders.length;
            int n2 = 0;
            while (n2 < n) {
                TimedSounder comp = timedSounderArray[n2];
                refs.add(SounderConfig.class, comp.sounder);
                ++n2;
            }
        }

        @Override
        public Sounder.Implementation getSounderImplementation(AlContext ctx, Scope scope, Sounder.Implementation impl) {
            if (this.sounders.length == 0) {
                return null;
            }
            if (impl instanceof Sounder.Scripted) {
                ((Sounder.Scripted)impl).setConfig(this);
            } else {
                impl = new Sounder.Scripted(ctx, scope, this);
            }
            return impl;
        }
    }

    public static class Sequential
    extends Implementation {
        @Editable
        public boolean loop;
        @Editable
        public ComponentSounder[] sounders = new ComponentSounder[0];

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            ComponentSounder[] componentSounderArray = this.sounders;
            int n = this.sounders.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentSounder comp = componentSounderArray[n2];
                refs.add(SounderConfig.class, comp.sounder);
                ++n2;
            }
        }

        @Override
        public Sounder.Implementation getSounderImplementation(AlContext ctx, Scope scope, Sounder.Implementation impl) {
            if (this.sounders.length == 0) {
                return null;
            }
            if (impl instanceof Sounder.Sequential) {
                ((Sounder.Sequential)impl).setConfig(this);
            } else {
                impl = new Sounder.Sequential(ctx, scope, this);
            }
            return impl;
        }
    }

    public static class Stream
    extends BaseStream {
        @Editable(weight=-3.0)
        public QueuedFile[] queue = new QueuedFile[0];

        public boolean loops() {
            QueuedFile[] queuedFileArray = this.queue;
            int n = this.queue.length;
            int n2 = 0;
            while (n2 < n) {
                QueuedFile queued = queuedFileArray[n2];
                if (queued.loop) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public void getUpdateResources(HashSet<String> paths) {
            QueuedFile[] queuedFileArray = this.queue;
            int n = this.queue.length;
            int n2 = 0;
            while (n2 < n) {
                QueuedFile queued = queuedFileArray[n2];
                if (queued.file != null) {
                    paths.add(queued.file);
                }
                ++n2;
            }
        }

        @Override
        public Sounder.Implementation getSounderImplementation(AlContext ctx, Scope scope, Sounder.Implementation impl) {
            if (this.queue.length == 0 || this.queue[0].file == null) {
                return null;
            }
            if (impl instanceof Sounder.Stream) {
                ((Sounder.Stream)impl).setConfig(this);
            } else {
                impl = new Sounder.Stream(ctx, scope, this);
            }
            return impl;
        }
    }

    public static class TimedSounder
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0, step=0.01)
        public float time;
        @Editable(nullable=true)
        public ConfigReference<SounderConfig> sounder;
    }

    public static abstract class Variable
    extends Original {
        @Editable(min=0.0, step=0.01, weight=-1.0)
        public FloatVariable gain = new FloatVariable.Constant(1.0f);
        @Editable(min=0.0, step=0.01, weight=-1.0)
        public FloatVariable pitch = new FloatVariable.Constant(1.0f);

        @Override
        public float getGain() {
            return this.gain.getValue();
        }

        @Override
        public float getPitch() {
            return this.pitch.getValue();
        }
    }

    public static class VariableClip
    extends Variable {
        @Editable(weight=-3.0, hgroup="f")
        public boolean loop;
        @Editable(editor="resource", nullable=true, weight=-3.0, hgroup="f")
        @FileConstraints(description="m.sound_files_desc", extensions={".ogg"}, directory="sound_dir")
        public String file;

        @Override
        public void getUpdateResources(HashSet<String> paths) {
            if (this.file != null) {
                paths.add(this.file);
            }
        }

        @Override
        public Sounder.Implementation getSounderImplementation(AlContext ctx, Scope scope, Sounder.Implementation impl) {
            if (this.file == null) {
                return null;
            }
            if (impl instanceof Sounder.VariableClip) {
                ((Sounder.VariableClip)impl).setConfig(this);
            } else {
                impl = new Sounder.VariableClip(ctx, scope, this);
            }
            return impl;
        }
    }

    public static class WeightedFile
    extends DeepObject
    implements Exportable {
        @Editable(editor="resource", nullable=true, hgroup="f")
        @FileConstraints(description="m.sound_files_desc", extensions={".ogg"}, directory="sound_dir")
        public String file;
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float weight = 1.0f;
        @Editable(min=0.0, step=0.01)
        public float gain = 1.0f;
    }

    public static class WeightedSounder
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0, step=0.01)
        public float weight = 1.0f;
        @Editable(nullable=true)
        public ConfigReference<SounderConfig> sounder;
    }
}

