/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export.tools;

import com.threerings.export.tools.XMLToBinaryConverter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class XMLToBinaryTask
extends Task {
    protected File _dest;
    protected boolean _compress = true;
    protected ArrayList<FileSet> _filesets = new ArrayList();

    public void setDest(File dest) {
        this._dest = dest;
    }

    public void setCompress(boolean compress) {
        this._compress = compress;
    }

    public void addFileset(FileSet set) {
        this._filesets.add(set);
    }

    public void execute() throws BuildException {
        for (FileSet fs : this._filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File fromDir = fs.getDir(this.getProject());
            String[] stringArray = ds.getIncludedFiles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                try {
                    this.convert(fromDir, file);
                }
                catch (Exception e) {
                    System.err.println("Error converting " + new File(fromDir, file) + ": " + e);
                }
                ++n2;
            }
        }
    }

    protected void convert(File sourceDir, String sourceName) throws IOException {
        int didx = sourceName.lastIndexOf(46);
        String root = didx == -1 ? sourceName : sourceName.substring(0, didx);
        File target = new File(this._dest == null ? sourceDir : this._dest, String.valueOf(root) + ".dat");
        File source = new File(sourceDir, sourceName);
        long lastmod = target.lastModified();
        if (source.lastModified() < lastmod) {
            return;
        }
        System.out.println("Converting " + source + " to " + target + "...");
        File parent = target.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        XMLToBinaryConverter.convert(source.getPath(), target.getPath(), this._compress);
    }
}

