/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export;

import com.threerings.export.Encodable;
import com.threerings.export.Log;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import org.lwjgl.BufferUtils;

public abstract class Streamer<T> {
    protected static HashMap<Class<?>, Streamer> _streamers = new HashMap();

    static {
        Streamer<Comparable<Boolean>> streamer = new Streamer<Boolean>(){

            @Override
            public void write(Boolean value, DataOutputStream out) throws IOException {
                out.writeBoolean(value);
            }

            @Override
            public Boolean read(DataInputStream in) throws IOException {
                return in.readBoolean();
            }
        };
        _streamers.put(Boolean.class, streamer);
        _streamers.put(Boolean.TYPE, streamer);
        streamer = new Streamer<Byte>(){

            @Override
            public void write(Byte value, DataOutputStream out) throws IOException {
                out.writeByte(value.byteValue());
            }

            @Override
            public Byte read(DataInputStream in) throws IOException {
                return in.readByte();
            }
        };
        _streamers.put(Byte.class, streamer);
        _streamers.put(Byte.TYPE, streamer);
        streamer = new Streamer<Character>(){

            @Override
            public void write(Character value, DataOutputStream out) throws IOException {
                out.writeChar(value.charValue());
            }

            @Override
            public Character read(DataInputStream in) throws IOException {
                return Character.valueOf(in.readChar());
            }
        };
        _streamers.put(Character.class, streamer);
        _streamers.put(Character.TYPE, streamer);
        _streamers.put(Class.class, new Streamer<Class<?>>(){

            @Override
            public void write(Class<?> value, DataOutputStream out) throws IOException {
                out.writeUTF(value.getName());
            }

            @Override
            public Class<?> read(DataInputStream in) throws IOException, ClassNotFoundException {
                return Class.forName(in.readUTF());
            }
        });
        streamer = new Streamer<Double>(){

            @Override
            public void write(Double value, DataOutputStream out) throws IOException {
                out.writeDouble(value);
            }

            @Override
            public Double read(DataInputStream in) throws IOException {
                return in.readDouble();
            }
        };
        _streamers.put(Double.class, streamer);
        _streamers.put(Double.TYPE, streamer);
        streamer = new Streamer<Float>(){

            @Override
            public void write(Float value, DataOutputStream out) throws IOException {
                out.writeFloat(value.floatValue());
            }

            @Override
            public Float read(DataInputStream in) throws IOException {
                return Float.valueOf(in.readFloat());
            }
        };
        _streamers.put(Float.class, streamer);
        _streamers.put(Float.TYPE, streamer);
        streamer = new Streamer<Integer>(){

            @Override
            public void write(Integer value, DataOutputStream out) throws IOException {
                out.writeInt(value);
            }

            @Override
            public Integer read(DataInputStream in) throws IOException {
                return in.readInt();
            }
        };
        _streamers.put(Integer.class, streamer);
        _streamers.put(Integer.TYPE, streamer);
        streamer = new Streamer<Long>(){

            @Override
            public void write(Long value, DataOutputStream out) throws IOException {
                out.writeLong(value);
            }

            @Override
            public Long read(DataInputStream in) throws IOException {
                return in.readLong();
            }
        };
        _streamers.put(Long.class, streamer);
        _streamers.put(Long.TYPE, streamer);
        streamer = new Streamer<Short>(){

            @Override
            public void write(Short value, DataOutputStream out) throws IOException {
                out.writeShort(value.shortValue());
            }

            @Override
            public Short read(DataInputStream in) throws IOException {
                return in.readShort();
            }
        };
        _streamers.put(Short.class, streamer);
        _streamers.put(Short.TYPE, streamer);
        _streamers.put(String.class, new Streamer<String>(){

            @Override
            public void write(String value, DataOutputStream out) throws IOException {
                out.writeUTF(value);
            }

            @Override
            public String read(DataInputStream in) throws IOException {
                return in.readUTF();
            }
        });
        _streamers.put(boolean[].class, new Streamer<boolean[]>(){

            @Override
            public void write(boolean[] value, DataOutputStream out) throws IOException {
                out.writeInt(value.length);
                boolean[] blArray = value;
                int n = value.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean val = blArray[n2];
                    out.writeBoolean(val);
                    ++n2;
                }
            }

            @Override
            public boolean[] read(DataInputStream in) throws IOException {
                boolean[] value = new boolean[in.readInt()];
                int ii = 0;
                while (ii < value.length) {
                    value[ii] = in.readBoolean();
                    ++ii;
                }
                return value;
            }
        });
        _streamers.put(byte[].class, new Streamer<byte[]>(){

            @Override
            public void write(byte[] value, DataOutputStream out) throws IOException {
                out.writeInt(value.length);
                byte[] byArray = value;
                int n = value.length;
                int n2 = 0;
                while (n2 < n) {
                    byte val = byArray[n2];
                    out.writeByte(val);
                    ++n2;
                }
            }

            @Override
            public byte[] read(DataInputStream in) throws IOException {
                byte[] value = new byte[in.readInt()];
                int ii = 0;
                while (ii < value.length) {
                    value[ii] = in.readByte();
                    ++ii;
                }
                return value;
            }
        });
        _streamers.put(char[].class, new Streamer<char[]>(){

            @Override
            public void write(char[] value, DataOutputStream out) throws IOException {
                out.writeInt(value.length);
                char[] cArray = value;
                int n = value.length;
                int n2 = 0;
                while (n2 < n) {
                    char val = cArray[n2];
                    out.writeChar(val);
                    ++n2;
                }
            }

            @Override
            public char[] read(DataInputStream in) throws IOException {
                char[] value = new char[in.readInt()];
                int ii = 0;
                while (ii < value.length) {
                    value[ii] = in.readChar();
                    ++ii;
                }
                return value;
            }
        });
        _streamers.put(double[].class, new Streamer<double[]>(){

            @Override
            public void write(double[] value, DataOutputStream out) throws IOException {
                out.writeInt(value.length);
                double[] dArray = value;
                int n = value.length;
                int n2 = 0;
                while (n2 < n) {
                    double val = dArray[n2];
                    out.writeDouble(val);
                    ++n2;
                }
            }

            @Override
            public double[] read(DataInputStream in) throws IOException {
                double[] value = new double[in.readInt()];
                int ii = 0;
                while (ii < value.length) {
                    value[ii] = in.readDouble();
                    ++ii;
                }
                return value;
            }
        });
        _streamers.put(float[].class, new Streamer<float[]>(){

            @Override
            public void write(float[] value, DataOutputStream out) throws IOException {
                out.writeInt(value.length);
                float[] fArray = value;
                int n = value.length;
                int n2 = 0;
                while (n2 < n) {
                    float val = fArray[n2];
                    out.writeFloat(val);
                    ++n2;
                }
            }

            @Override
            public float[] read(DataInputStream in) throws IOException {
                float[] value = new float[in.readInt()];
                int ii = 0;
                while (ii < value.length) {
                    value[ii] = in.readFloat();
                    ++ii;
                }
                return value;
            }
        });
        _streamers.put(int[].class, new Streamer<int[]>(){

            @Override
            public void write(int[] value, DataOutputStream out) throws IOException {
                out.writeInt(value.length);
                int[] nArray = value;
                int n = value.length;
                int n2 = 0;
                while (n2 < n) {
                    int val = nArray[n2];
                    out.writeInt(val);
                    ++n2;
                }
            }

            @Override
            public int[] read(DataInputStream in) throws IOException {
                int[] value = new int[in.readInt()];
                int ii = 0;
                while (ii < value.length) {
                    value[ii] = in.readInt();
                    ++ii;
                }
                return value;
            }
        });
        _streamers.put(long[].class, new Streamer<long[]>(){

            @Override
            public void write(long[] value, DataOutputStream out) throws IOException {
                out.writeInt(value.length);
                long[] lArray = value;
                int n = value.length;
                int n2 = 0;
                while (n2 < n) {
                    long val = lArray[n2];
                    out.writeLong(val);
                    ++n2;
                }
            }

            @Override
            public long[] read(DataInputStream in) throws IOException {
                long[] value = new long[in.readInt()];
                int ii = 0;
                while (ii < value.length) {
                    value[ii] = in.readLong();
                    ++ii;
                }
                return value;
            }
        });
        _streamers.put(short[].class, new Streamer<short[]>(){

            @Override
            public void write(short[] value, DataOutputStream out) throws IOException {
                out.writeInt(value.length);
                short[] sArray = value;
                int n = value.length;
                int n2 = 0;
                while (n2 < n) {
                    short val = sArray[n2];
                    out.writeShort(val);
                    ++n2;
                }
            }

            @Override
            public short[] read(DataInputStream in) throws IOException {
                short[] value = new short[in.readInt()];
                int ii = 0;
                while (ii < value.length) {
                    value[ii] = in.readShort();
                    ++ii;
                }
                return value;
            }
        });
        _streamers.put(File.class, new Streamer<File>(){

            @Override
            public void write(File value, DataOutputStream out) throws IOException {
                out.writeUTF(value.toString());
            }

            @Override
            public File read(DataInputStream in) throws IOException {
                return new File(in.readUTF());
            }
        });
        _streamers.put(ByteBuffer.class, new Streamer<ByteBuffer>(){

            @Override
            public void write(ByteBuffer value, DataOutputStream out) throws IOException {
                out.writeInt(value.limit());
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    out.writeByte(value.get(ii));
                    ++ii;
                }
            }

            @Override
            public ByteBuffer read(DataInputStream in) throws IOException {
                ByteBuffer value = BufferUtils.createByteBuffer((int)in.readInt());
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    value.put(ii, in.readByte());
                    ++ii;
                }
                return value;
            }
        });
        _streamers.put(CharBuffer.class, new Streamer<CharBuffer>(){

            @Override
            public void write(CharBuffer value, DataOutputStream out) throws IOException {
                out.writeInt(value.limit());
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    out.writeChar(value.get(ii));
                    ++ii;
                }
            }

            @Override
            public CharBuffer read(DataInputStream in) throws IOException {
                CharBuffer value = BufferUtils.createCharBuffer((int)in.readInt());
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    value.put(ii, in.readChar());
                    ++ii;
                }
                return value;
            }
        });
        _streamers.put(DoubleBuffer.class, new Streamer<DoubleBuffer>(){

            @Override
            public void write(DoubleBuffer value, DataOutputStream out) throws IOException {
                out.writeInt(value.limit());
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    out.writeDouble(value.get(ii));
                    ++ii;
                }
            }

            @Override
            public DoubleBuffer read(DataInputStream in) throws IOException {
                DoubleBuffer value = BufferUtils.createDoubleBuffer((int)in.readInt());
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    value.put(ii, in.readDouble());
                    ++ii;
                }
                return value;
            }
        });
        _streamers.put(FloatBuffer.class, new Streamer<FloatBuffer>(){

            @Override
            public void write(FloatBuffer value, DataOutputStream out) throws IOException {
                out.writeInt(value.limit());
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    out.writeFloat(value.get(ii));
                    ++ii;
                }
            }

            @Override
            public FloatBuffer read(DataInputStream in) throws IOException {
                FloatBuffer value = BufferUtils.createFloatBuffer((int)in.readInt());
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    value.put(ii, in.readFloat());
                    ++ii;
                }
                return value;
            }
        });
        _streamers.put(IntBuffer.class, new Streamer<IntBuffer>(){

            @Override
            public void write(IntBuffer value, DataOutputStream out) throws IOException {
                out.writeInt(value.limit());
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    out.writeInt(value.get(ii));
                    ++ii;
                }
            }

            @Override
            public IntBuffer read(DataInputStream in) throws IOException {
                IntBuffer value = BufferUtils.createIntBuffer((int)in.readInt());
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    value.put(ii, in.readInt());
                    ++ii;
                }
                return value;
            }
        });
        _streamers.put(LongBuffer.class, new Streamer<LongBuffer>(){

            @Override
            public void write(LongBuffer value, DataOutputStream out) throws IOException {
                out.writeInt(value.limit());
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    out.writeLong(value.get(ii));
                    ++ii;
                }
            }

            @Override
            public LongBuffer read(DataInputStream in) throws IOException {
                LongBuffer value = BufferUtils.createLongBuffer((int)in.readInt());
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    value.put(ii, in.readLong());
                    ++ii;
                }
                return value;
            }
        });
        _streamers.put(ShortBuffer.class, new Streamer<ShortBuffer>(){

            @Override
            public void write(ShortBuffer value, DataOutputStream out) throws IOException {
                out.writeInt(value.limit());
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    out.writeShort(value.get(ii));
                    ++ii;
                }
            }

            @Override
            public ShortBuffer read(DataInputStream in) throws IOException {
                ShortBuffer value = BufferUtils.createShortBuffer((int)in.readInt());
                int ii = 0;
                int nn = value.limit();
                while (ii < nn) {
                    value.put(ii, in.readShort());
                    ++ii;
                }
                return value;
            }
        });
    }

    public static Streamer getStreamer(final Class<?> clazz) {
        Streamer streamer = _streamers.get(clazz);
        if (streamer == null) {
            if (clazz.isEnum()) {
                streamer = new Streamer<Enum<Dummy>>(){

                    @Override
                    public void write(Enum value, DataOutputStream out) throws IOException {
                        out.writeUTF(value.name());
                    }

                    @Override
                    public Enum<Dummy> read(DataInputStream in) throws IOException {
                        Class eclass = clazz;
                        return Enum.valueOf(eclass, in.readUTF());
                    }
                };
                _streamers.put(clazz, streamer);
            } else if (Encodable.class.isAssignableFrom(clazz)) {
                streamer = new Streamer<Encodable>(){

                    @Override
                    public void write(Encodable value, DataOutputStream out) throws IOException {
                        value.encodeToStream(out);
                    }

                    @Override
                    public Encodable read(DataInputStream in) throws IOException {
                        Encodable value;
                        try {
                            value = (Encodable)clazz.newInstance();
                        }
                        catch (Exception e) {
                            Log.log.warning((Object)"Failed to create instance.", new Object[]{e});
                            return null;
                        }
                        value.decodeFromStream(in);
                        return value;
                    }
                };
                _streamers.put(clazz, streamer);
            }
        }
        return streamer;
    }

    public abstract void write(T var1, DataOutputStream var2) throws IOException;

    public abstract T read(DataInputStream var1) throws IOException, ClassNotFoundException;

    protected static enum Dummy {

    }
}

