/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export;

import com.threerings.export.Exportable;
import com.threerings.export.Exporter;
import com.threerings.export.FieldMarshaller;
import com.threerings.export.Importer;
import com.threerings.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;

public class ObjectMarshaller {
    protected Method _reader;
    protected Method _writer;
    protected FieldData[] _fields;
    protected Object _prototype;
    protected static HashMap<Class<?>, ObjectMarshaller> _marshallers = new HashMap();

    public static ObjectMarshaller getObjectMarshaller(Class<?> clazz) {
        ObjectMarshaller marshaller = _marshallers.get(clazz);
        if (marshaller == null) {
            marshaller = new ObjectMarshaller(clazz);
            _marshallers.put(clazz, marshaller);
        }
        return marshaller;
    }

    public Object getPrototype() {
        return this._prototype;
    }

    public void readFields(Object object, Importer importer, boolean useReader) throws IOException {
        if (this._reader != null && useReader) {
            try {
                this._reader.invoke(object, importer);
            }
            catch (Exception e) {
                throw (IOException)new IOException("Error invoking custom read method.").initCause(e);
            }
        }
        try {
            FieldData[] fieldDataArray = this._fields;
            int n = this._fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldData field = fieldDataArray[n2];
                field.read(object, importer);
                ++n2;
            }
        }
        catch (IllegalAccessException iae) {
            throw (IOException)new IOException("Error reading field.").initCause(iae);
        }
    }

    public void writeFields(Object object, Exporter exporter, boolean useWriter) throws IOException {
        if (this._writer != null && useWriter) {
            try {
                this._writer.invoke(object, exporter);
            }
            catch (Exception e) {
                throw (IOException)new IOException("Error invoking custom write method.").initCause(e);
            }
        }
        try {
            FieldData[] fieldDataArray = this._fields;
            int n = this._fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldData field = fieldDataArray[n2];
                field.write(object, exporter);
                ++n2;
            }
        }
        catch (IllegalAccessException iae) {
            throw (IOException)new IOException("Error writing field.").initCause(iae);
        }
    }

    protected ObjectMarshaller(Class<?> clazz) {
        try {
            this._reader = clazz.getMethod("readFields", Importer.class);
            this._reader.setAccessible(true);
            if (Modifier.isStatic(this._reader.getModifiers())) {
                this._reader = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (NoClassDefFoundError err) {
            System.err.print("class=" + clazz.getName());
            err.printStackTrace();
        }
        try {
            this._writer = clazz.getMethod("writeFields", Exporter.class);
            this._writer.setAccessible(true);
            if (Modifier.isStatic(this._writer.getModifiers())) {
                this._writer = null;
            }
        }
        catch (NoSuchMethodException err) {
            // empty catch block
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        ObjectMarshaller.getExportableFields(clazz, fields);
        this._fields = new FieldData[fields.size()];
        int ii = 0;
        while (ii < this._fields.length) {
            this._fields[ii] = new FieldData(fields.get(ii));
            ++ii;
        }
        try {
            Class<?> oclazz = ReflectionUtil.getOuterClass(clazz);
            if (oclazz == null) {
                this._prototype = clazz.newInstance();
            } else {
                Object oproto = ObjectMarshaller.getObjectMarshaller(oclazz)._prototype;
                this._prototype = ReflectionUtil.newInstance(clazz, oproto);
            }
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Failed to create object prototype [class=" + clazz + "].").initCause(e);
        }
    }

    protected static void getExportableFields(Class<?> clazz, ArrayList<Field> fields) {
        Class<?> sclazz = clazz.getSuperclass();
        if (Exportable.class.isAssignableFrom(sclazz)) {
            ObjectMarshaller.getExportableFields(sclazz, fields);
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int mods = field.getModifiers();
            if (!(Modifier.isStatic(mods) || Modifier.isTransient(mods) || field.isSynthetic())) {
                field.setAccessible(true);
                fields.add(field);
            }
            ++n2;
        }
    }

    protected class FieldData {
        protected Field _field;
        protected String _name;
        protected FieldMarshaller _marshaller;

        public FieldData(Field field) {
            this._field = field;
            String fname = field.getName();
            this._name = (fname.charAt(0) == '_' ? fname.substring(1) : fname).intern();
            this._marshaller = FieldMarshaller.getFieldMarshaller(field);
        }

        public void read(Object target, Importer importer) throws IOException, IllegalAccessException {
            this._marshaller.readField(this._field, this._name, target, ObjectMarshaller.this._prototype, importer);
        }

        public void write(Object source, Exporter exporter) throws IOException, IllegalAccessException {
            this._marshaller.writeField(this._field, this._name, source, ObjectMarshaller.this._prototype, exporter);
        }
    }
}

