/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.tools;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.QuickSort;
import com.threerings.ClydeLog;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigManager;
import com.threerings.config.ManagedConfig;
import com.threerings.config.swing.ConfigTree;
import com.threerings.config.swing.ConfigTreeFilterPanel;
import com.threerings.config.swing.ConfigTreeNode;
import com.threerings.config.tools.BaseConfigEditor;
import com.threerings.config.tools.ResourceEditor;
import com.threerings.editor.Log;
import com.threerings.editor.swing.BaseEditorPanel;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.editor.swing.TreeEditorPanel;
import com.threerings.editor.swing.editors.ConfigReferenceEditor;
import com.threerings.editor.util.EditorContext;
import com.threerings.media.image.ColorPository;
import com.threerings.resource.ResourceManager;
import com.threerings.resource.file.FileResourceManager;
import com.threerings.swing.PrintStreamDialog;
import com.threerings.util.MessageManager;
import com.threerings.util.ToolUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ConfigEditor
extends BaseConfigEditor
implements ClipboardOwner {
    protected JPopupMenu _popup;
    protected JMenuItem _save;
    protected JMenuItem _revert;
    protected JMenuItem _saveAll;
    protected JMenuItem _revertAll;
    protected JMenuItem _sync;
    protected JMenuItem _exportConfigs;
    protected Action _cut;
    protected Action _copy;
    protected Action _paste;
    protected Action _delete;
    protected Action _validate;
    protected Action _copyName;
    protected JCheckBoxMenuItem _treeMode;
    protected JFileChooser _chooser;
    protected JSplitPane _split;
    protected JTabbedPane _tabs;
    protected Class<?> _clipclass;

    public static void main(String[] args) {
        FileResourceManager rsrcmgr = new FileResourceManager("rsrc/");
        MessageManager msgmgr = new MessageManager("i18n", (ResourceManager)rsrcmgr);
        ConfigManager cfgmgr = new ConfigManager((ResourceManager)rsrcmgr, msgmgr, "config/");
        ColorPository colorpos = ColorPository.loadColorPository((ResourceManager)rsrcmgr);
        new ConfigEditor(msgmgr, cfgmgr, colorpos).setVisible(true);
    }

    public ConfigEditor(MessageManager msgmgr, ConfigManager cfgmgr, ColorPository colorpos) {
        this(msgmgr, cfgmgr, colorpos, null, null);
    }

    public ConfigEditor(final MessageManager msgmgr, final ConfigManager cfgmgr, final ColorPository colorpos, Class<?> clazz, String name) {
        super(msgmgr, cfgmgr, colorpos, "editor.config");
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        JMenu file = this.createMenu("file", 70);
        menubar.add(file);
        JMenu nmenu = this.createMenu("new", 78);
        file.add(nmenu);
        nmenu.add(this.createMenuItem("window", 87, 78));
        nmenu.addSeparator();
        Action nconfig = this.createAction("config", 67, 79);
        nmenu.add(new JMenuItem(nconfig));
        Action nfolder = this.createAction("folder", 70, 68);
        nmenu.add(new JMenuItem(nfolder));
        file.addSeparator();
        this._save = this.createMenuItem("save_group", 83, 83);
        file.add(this._save);
        this._revert = this.createMenuItem("revert_group", 82, 82);
        file.add(this._revert);
        file.addSeparator();
        file.add(this.createMenuItem("import_group", 73, 73));
        file.add(this.createMenuItem("export_group", 69, 69));
        file.addSeparator();
        file.add(this.createMenuItem("import_configs", 77, -1));
        this._exportConfigs = this.createMenuItem("export_configs", 88, -1);
        file.add(this._exportConfigs);
        file.addSeparator();
        file.add(this.createMenuItem("close", 67, 87));
        file.add(this.createMenuItem("quit", 81, 81));
        final JMenu edit = this.createMenu("edit", 69);
        edit.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent event) {
                TreeEditorPanel panel = (TreeEditorPanel)((Object)SwingUtilities.getAncestorOfClass(TreeEditorPanel.class, ConfigEditor.this.getFocusOwner()));
                if (panel != null) {
                    edit.getItem(0).setAction(panel.getCutAction());
                    edit.getItem(1).setAction(panel.getCopyAction());
                    edit.getItem(2).setAction(panel.getPasteAction());
                    edit.getItem(3).setAction(panel.getDeleteAction());
                } else {
                    this.restoreActions();
                }
            }

            @Override
            public void menuDeselected(MenuEvent event) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.restoreActions();
                    }
                });
            }

            @Override
            public void menuCanceled(MenuEvent event) {
            }

            protected void restoreActions() {
                edit.getItem(0).setAction(ConfigEditor.this._cut);
                edit.getItem(1).setAction(ConfigEditor.this._copy);
                edit.getItem(2).setAction(ConfigEditor.this._paste);
                edit.getItem(3).setAction(ConfigEditor.this._delete);
            }
        });
        menubar.add(edit);
        this._cut = this.createAction("cut", 84, 88);
        edit.add(new JMenuItem(this._cut));
        this._copy = this.createAction("copy", 67, 67);
        edit.add(new JMenuItem(this._copy));
        this._paste = this.createAction("paste", 80, 86);
        edit.add(new JMenuItem(this._paste));
        this._delete = this.createAction("delete", 68, 127, 0);
        edit.add(new JMenuItem(this._delete));
        this.addFindMenu(edit);
        edit.addSeparator();
        edit.add(this.createMenuItem("validate_refs", 86, -1));
        this.addEditMenuItems(edit);
        edit.addSeparator();
        edit.add(this.createMenuItem("resources", 82, 85));
        edit.add(this.createMenuItem("preferences", 70, -1));
        JMenu view = this.createMenu("view", 86);
        menubar.add(view);
        this._treeMode = ToolUtil.createCheckBoxMenuItem(this, this._msgs, "tree_mode", 84, -1);
        view.add(this._treeMode);
        JMenu gmenu = this.createMenu("groups", 71);
        menubar.add(gmenu);
        this._saveAll = this.createMenuItem("save_all", 83, 65);
        gmenu.add(this._saveAll);
        this._revertAll = this.createMenuItem("revert_all", 82, 84);
        gmenu.add(this._revertAll);
        this._popup = new JPopupMenu();
        nmenu = this.createMenu("new", 78);
        this._popup.add(nmenu);
        nmenu.add(new JMenuItem(nconfig));
        nmenu.add(new JMenuItem(nfolder));
        this._popup.addSeparator();
        this._popup.add(new JMenuItem(this._cut));
        this._popup.add(new JMenuItem(this._copy));
        this._popup.add(new JMenuItem(this._paste));
        this._popup.add(new JMenuItem(this._delete));
        this._validate = this.createAction("validate_item", 73, 76);
        this._popup.add(new JMenuItem(this._validate));
        this._popup.addSeparator();
        this._popup.add(new JMenuItem(this.createAction("copy_name", 75, 77)));
        this._sync = new JMenuItem(this.createAction("sync", 75, 75));
        this._chooser = new JFileChooser(_prefs.get("config_dir", null));
        this._chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.toString() != null && file.toString().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return ConfigEditor.this._msgs.get("m.xml_files");
            }
        });
        this._split = new JSplitPane(1, true);
        this.add((Component)this._split, "Center");
        this._tabs = new JTabbedPane();
        this._split.setLeftComponent(this._tabs);
        this._tabs.setPreferredSize(new Dimension(250, 1));
        this._tabs.setMaximumSize(new Dimension(250, Integer.MAX_VALUE));
        ConfigReferenceEditor.initOuter(new EditorContext(){

            @Override
            public ResourceManager getResourceManager() {
                return cfgmgr.getResourceManager();
            }

            @Override
            public MessageManager getMessageManager() {
                return msgmgr;
            }

            @Override
            public ConfigManager getConfigManager() {
                return cfgmgr;
            }

            @Override
            public ColorPository getColorPository() {
                return colorpos;
            }
        });
        ConfigManager outer = ConfigReferenceEditor.getOuterManager();
        if (outer != null) {
            this._tabs.add(new ManagerPanel(outer), "OUTER", 0);
        }
        ConfigManager mgr = cfgmgr;
        while (mgr != null) {
            this._tabs.add(new ManagerPanel(mgr), this.getLabel(mgr.getType()), 0);
            mgr = mgr.getParent();
        }
        ManagerPanel panel = (ManagerPanel)this._tabs.getComponentAt(0);
        this._tabs.setSelectedComponent(panel);
        panel.activate();
        this._tabs.addChangeListener(new ChangeListener(panel){
            protected ManagerPanel _panel;
            {
                this._panel = managerPanel;
            }

            @Override
            public void stateChanged(ChangeEvent event) {
                this._panel = (ManagerPanel)ConfigEditor.this._tabs.getSelectedComponent();
                this._panel.activate();
            }
        });
        this.setSize(850, 600);
        SwingUtil.centerWindow((Window)this);
        this.restorePrefs();
        if (clazz != null) {
            this.select(clazz, name);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this._paste.setEnabled(false);
        this._clipclass = null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        ManagerPanel panel = (ManagerPanel)this._tabs.getSelectedComponent();
        ManagerPanel.GroupItem item = (ManagerPanel.GroupItem)panel.gbox.getSelectedItem();
        if (action.equals("window")) {
            this.showFrame(new ConfigEditor(this._msgmgr, this._cfgmgr, this._colorpos));
        } else if (action.equals("config")) {
            item.newConfig();
        } else if (action.equals("folder")) {
            item.newFolder();
        } else if (action.equals("save_group")) {
            item.group.save();
        } else if (action.equals("revert_group")) {
            if (this.showCantUndo()) {
                item.group.revert();
            }
        } else if (action.equals("import_group")) {
            item.importGroup();
        } else if (action.equals("export_group")) {
            item.exportGroup();
        } else if (action.equals("import_configs")) {
            item.importConfigs();
        } else if (action.equals("export_configs")) {
            item.exportConfigs();
        } else if (action.equals("cut")) {
            item.cutNode();
        } else if (action.equals("copy")) {
            item.copyNode();
        } else if (action.equals("paste")) {
            item.pasteNode();
        } else if (action.equals("delete")) {
            item.deleteNode();
        } else if (action.equals("validate_item")) {
            item.validate();
        } else if (action.equals("copy_name")) {
            item.copyName();
        } else if (action.equals("validate_refs")) {
            this.validateReferences();
        } else if (action.equals("resources")) {
            this.showFrame(new ResourceEditor(this._msgmgr, this._cfgmgr, this._colorpos));
        } else if (action.equals("tree_mode")) {
            boolean enabled = this._treeMode.isSelected();
            int ii = this._tabs.getComponentCount() - 1;
            while (ii >= 0) {
                ((ManagerPanel)this._tabs.getComponentAt(ii)).setTreeModeEnabled(enabled);
                --ii;
            }
        } else if (action.equals("save_all")) {
            panel.cfgmgr.saveAll();
        } else if (action.equals("revert_all")) {
            panel.cfgmgr.revertAll();
        } else if (action.equalsIgnoreCase("sync")) {
            Class<ManagedConfig> type = item.group.getConfigClass();
            ConfigManager manager = this._cfgmgr;
            while (manager.getParent() != null) {
                manager = manager.getParent();
            }
            ConfigGroup<ManagedConfig> group = manager.getGroup(type);
            ManagedConfig config = ConfigReferenceEditor.getOuterManager().getConfig(type, item.getName());
            if (config != null) {
                try {
                    group.addConfig(config);
                }
                catch (Exception e) {
                    Log.log.warning((Object)"sync error", new Object[]{e});
                    group.removeConfig(config);
                }
            } else {
                int result = JOptionPane.showConfirmDialog(this, "Sync All configs under the folder=" + item.getName(), "Sync Folder", 0);
                if (result == 0) {
                    ConfigGroup<ManagedConfig> outer = ConfigReferenceEditor.getOuterManager().getGroup(type);
                    Collection<ManagedConfig> array = outer.getConfigs();
                    for (ManagedConfig old : array) {
                        if (!old.getName().startsWith(item.getName()) || group.getConfig(old.getName()) != null) continue;
                        try {
                            group.addConfig(old);
                        }
                        catch (Exception e) {
                            Log.log.warning((Object)"sync error", new Object[]{e});
                            group.removeConfig(config);
                        }
                    }
                }
            }
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        int ii = 0;
        int nn = this._tabs.getComponentCount();
        while (ii < nn) {
            ((ManagerPanel)this._tabs.getComponentAt(ii)).dispose();
            ++ii;
        }
    }

    protected void select(Class<?> clazz, String name) {
        int ii = this._tabs.getComponentCount() - 1;
        while (ii >= 0) {
            ManagerPanel panel = (ManagerPanel)this._tabs.getComponentAt(ii);
            if (panel.getConfigManager() != ConfigReferenceEditor.getOuterManager() && panel.select(clazz, name)) {
                return;
            }
            --ii;
        }
    }

    protected boolean showCantUndo() {
        return JOptionPane.showConfirmDialog(this, this._msgs.get("m.cant_undo"), this._msgs.get("t.cant_undo"), 2, 2) == 0;
    }

    protected void validateReferences() {
        PrintStreamDialog dialog = new PrintStreamDialog((Frame)this, this._msgs.get("m.validate_refs"), this._msgs.get("m.ok"));
        this._cfgmgr.validateReferences("", dialog.getPrintStream());
        dialog.maybeShow();
    }

    protected void addEditMenuItems(JMenu edit) {
    }

    @Override
    protected BaseEditorPanel getFindEditorPanel() {
        return ((ManagerPanel)this._tabs.getSelectedComponent()).getEditorPanel();
    }

    protected void restorePrefs() {
        String p = "ConfigEditor.";
        Rectangle r = this.getBounds();
        this.setBounds(_prefs.getInt("ConfigEditor..x", r.x), _prefs.getInt("ConfigEditor..y", r.y), _prefs.getInt("ConfigEditor..w", r.width), _prefs.getInt("ConfigEditor..h", r.height));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent event) {
                this.saveBounds();
            }

            @Override
            public void componentResized(ComponentEvent event) {
                this.saveBounds();
            }

            protected void saveBounds() {
                Rectangle r = ConfigEditor.this.getBounds();
                _prefs.putInt("ConfigEditor..x", r.x);
                _prefs.putInt("ConfigEditor..y", r.y);
                _prefs.putInt("ConfigEditor..w", r.width);
                _prefs.putInt("ConfigEditor..h", r.height);
            }
        });
        this._split.setDividerLocation(_prefs.getInt("ConfigEditor..div", this._split.getDividerLocation()));
        this._split.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("dividerLocation".equals(event.getPropertyName())) {
                    _prefs.putInt("ConfigEditor..div", ConfigEditor.this._split.getDividerLocation());
                }
            }
        });
        String cat = _prefs.get("ConfigEditor..group", null);
        int tab = this._tabs.getComponentCount() - 1;
        while (tab >= 0) {
            final JComboBox gbox = ((ManagerPanel)this._tabs.getComponentAt((int)tab)).gbox;
            if (cat != null) {
                int ii = 0;
                int nn = gbox.getItemCount();
                while (ii < nn) {
                    if (cat.equals(String.valueOf(gbox.getItemAt(ii)))) {
                        gbox.setSelectedIndex(ii);
                        break;
                    }
                    ++ii;
                }
            }
            gbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    _prefs.put("ConfigEditor..group", String.valueOf(gbox.getSelectedItem()));
                }
            });
            --tab;
        }
    }

    protected class ManagerPanel
    extends JPanel
    implements EditorContext,
    ItemListener,
    ChangeListener {
        public ConfigManager cfgmgr;
        public JComboBox gbox;
        protected ConfigTreeFilterPanel _filterPanel;
        protected JScrollPane _pane;
        protected BaseEditorPanel _epanel;

        public ManagerPanel(ConfigManager cfgmgr) {
            super((LayoutManager)new VGroupLayout(GroupLayout.STRETCH, GroupLayout.STRETCH, 5, GroupLayout.TOP));
            this.cfgmgr = cfgmgr;
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel gpanel = GroupLayout.makeHStretchBox((int)5);
            this.add((Component)gpanel, GroupLayout.FIXED);
            gpanel.add((Component)new JLabel(ConfigEditor.this._msgs.get("m.group")), GroupLayout.FIXED);
            Collection<ConfigGroup> groups = cfgmgr.getGroups();
            Object[] items = new GroupItem[groups.size()];
            int idx = 0;
            for (ConfigGroup group : groups) {
                if (group == null) continue;
                items[idx++] = new GroupItem(group);
            }
            QuickSort.sort((Object[])items, (Comparator)new Comparator<GroupItem>(){

                @Override
                public int compare(GroupItem g1, GroupItem g2) {
                    return g1.toString().compareTo(g2.toString());
                }
            });
            this.gbox = new JComboBox<Object>(items);
            gpanel.add(this.gbox);
            this.gbox.addItemListener(this);
            this._filterPanel = new ConfigTreeFilterPanel(ConfigEditor.this._msgmgr);
            this.add((Component)this._filterPanel, VGroupLayout.FIXED);
            this._pane = new JScrollPane();
            this.add(this._pane);
            this._epanel = new EditorPanel((EditorContext)this, EditorPanel.CategoryMode.TABS, null);
            this._epanel.addChangeListener(this);
        }

        public void activate() {
            ConfigEditor.this._split.setRightComponent((Component)((Object)this._epanel));
            SwingUtil.refresh((JComponent)((Object)this._epanel));
            if (this.gbox.getSelectedItem() != null) {
                ((GroupItem)this.gbox.getSelectedItem()).activate();
            }
            boolean enable = this.cfgmgr.getConfigPath() != null;
            ConfigEditor.this._save.setEnabled(enable);
            ConfigEditor.this._revert.setEnabled(enable);
            ConfigEditor.this._saveAll.setEnabled(enable);
            ConfigEditor.this._revertAll.setEnabled(enable);
        }

        public boolean select(Class<?> clazz, String name) {
            int ii = 0;
            int nn = this.gbox.getItemCount();
            while (ii < nn) {
                GroupItem item = (GroupItem)this.gbox.getItemAt(ii);
                if (item.group.getConfigClass() == clazz) {
                    return item.select(name);
                }
                ++ii;
            }
            return false;
        }

        public void setTreeModeEnabled(boolean enabled) {
            BaseEditorPanel opanel = this._epanel;
            this._epanel = enabled ? new TreeEditorPanel(this) : new EditorPanel(this, EditorPanel.CategoryMode.TABS);
            this._epanel.addChangeListener(this);
            this._epanel.setObject(opanel.getObject());
            if (ConfigEditor.this._split.getRightComponent() == opanel) {
                ConfigEditor.this._split.setRightComponent((Component)((Object)this._epanel));
                SwingUtil.refresh((JComponent)((Object)this._epanel));
            }
        }

        public void dispose() {
            int ii = 0;
            int nn = this.gbox.getItemCount();
            while (ii < nn) {
                ((GroupItem)this.gbox.getItemAt(ii)).dispose();
                ++ii;
            }
        }

        public BaseEditorPanel getEditorPanel() {
            return this._epanel;
        }

        @Override
        public ResourceManager getResourceManager() {
            return ConfigEditor.this._rsrcmgr;
        }

        @Override
        public MessageManager getMessageManager() {
            return ConfigEditor.this._msgmgr;
        }

        @Override
        public ConfigManager getConfigManager() {
            return this.cfgmgr;
        }

        @Override
        public ColorPository getColorPository() {
            return ConfigEditor.this._colorpos;
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            ((GroupItem)this.gbox.getSelectedItem()).activate();
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            ((GroupItem)this.gbox.getSelectedItem()).configChanged();
        }

        public class GroupItem
        implements TreeSelectionListener {
            public ConfigGroup<ManagedConfig> group;
            protected String _label;
            protected ConfigTree _tree;

            public GroupItem(ConfigGroup group) {
                ConfigGroup mgroup;
                this.group = mgroup = group;
                this._label = ConfigEditor.this.getLabel(group.getConfigClass(), group.getName());
            }

            public String getItemName() {
                ConfigTreeNode node = this._tree.getSelectedNode();
                return node.getConfig().getName();
            }

            public String getName() {
                ConfigTreeNode node = this._tree.getSelectedNode();
                return node.getName();
            }

            public void copyName() {
                ConfigTreeNode node = this._tree.getSelectedNode();
                StringSelection stringSelection = new StringSelection(node.getConfig().getName());
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                clpbrd.setContents(stringSelection, null);
            }

            public void validate() {
                ConfigTreeNode node = this._tree.getSelectedNode();
                PrintStreamDialog dialog = new PrintStreamDialog((Frame)ConfigEditor.this, ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._msgs.get("m.validate_refs"), ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._msgs.get("m.ok"));
                node.getConfig().validateReferences(node.getConfig().getName(), dialog.getPrintStream());
                dialog.maybeShow();
            }

            public void activate() {
                if (this._tree == null) {
                    this._tree = new ConfigTree(this.group, true){

                        @Override
                        public void selectedConfigUpdated() {
                            ((GroupItem)GroupItem.this).ManagerPanel.this._epanel.update();
                            ConfigTreeNode node = GroupItem.this._tree.getSelectedNode();
                            if (node != null) {
                                String title = String.valueOf(GroupItem.this.group.getName()) + " : " + node.getName();
                                ConfigEditor.this.setTitle(title);
                            } else {
                                ConfigEditor.this.setTitle(((ManagerPanel)((GroupItem)GroupItem.this).ManagerPanel.this).ConfigEditor.this._msgs.get("m.title"));
                            }
                        }
                    };
                    this._tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    this._tree.addTreeSelectionListener(this);
                    this._tree.setComponentPopupMenu(((ManagerPanel)ManagerPanel.this).ConfigEditor.this._popup);
                    InputMap imap = this._tree.getInputMap();
                    imap.put(KeyStroke.getKeyStroke(88, 2), "noop");
                    imap.put(KeyStroke.getKeyStroke(67, 2), "noop");
                    imap.put(KeyStroke.getKeyStroke(86, 2), "noop");
                }
                if (this.group.getConfigManager() == ConfigReferenceEditor.getOuterManager()) {
                    ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._popup.add(((ManagerPanel)ManagerPanel.this).ConfigEditor.this._sync);
                } else {
                    ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._popup.remove(((ManagerPanel)ManagerPanel.this).ConfigEditor.this._sync);
                }
                ManagerPanel.this._pane.setViewportView(this._tree);
                ManagerPanel.this._filterPanel.setTree(this._tree);
                ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._paste.setEnabled(((ManagerPanel)ManagerPanel.this).ConfigEditor.this._clipclass == this.group.getConfigClass());
                this.updateSelection();
            }

            public void newConfig() {
                Class<ManagedConfig> clazz = this.group.getConfigClass();
                try {
                    this.newNode(clazz.newInstance());
                }
                catch (Exception e) {
                    ClydeLog.log.warning((Object)("Failed to instantiate config [class=" + clazz + "]."), new Object[]{e});
                }
            }

            public void newFolder() {
                this.newNode(null);
            }

            public void importGroup() {
                if (((ManagerPanel)ManagerPanel.this).ConfigEditor.this._chooser.showOpenDialog(ConfigEditor.this) == 0) {
                    this.group.load(((ManagerPanel)ManagerPanel.this).ConfigEditor.this._chooser.getSelectedFile());
                }
                _prefs.put("config_dir", ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._chooser.getCurrentDirectory().toString());
            }

            public void exportGroup() {
                if (((ManagerPanel)ManagerPanel.this).ConfigEditor.this._chooser.showSaveDialog(ConfigEditor.this) == 0) {
                    this.group.save(((ManagerPanel)ManagerPanel.this).ConfigEditor.this._chooser.getSelectedFile());
                }
                _prefs.put("config_dir", ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._chooser.getCurrentDirectory().toString());
            }

            public void importConfigs() {
                if (((ManagerPanel)ManagerPanel.this).ConfigEditor.this._chooser.showOpenDialog(ConfigEditor.this) == 0) {
                    this.group.load(((ManagerPanel)ManagerPanel.this).ConfigEditor.this._chooser.getSelectedFile(), true);
                }
                _prefs.put("config_dir", ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._chooser.getCurrentDirectory().toString());
            }

            public void exportConfigs() {
                if (((ManagerPanel)ManagerPanel.this).ConfigEditor.this._chooser.showOpenDialog(ConfigEditor.this) == 0) {
                    ArrayList<ManagedConfig> configs = new ArrayList<ManagedConfig>();
                    this._tree.getSelectedNode().getConfigs(configs);
                    this.group.save(configs, ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._chooser.getSelectedFile());
                }
                _prefs.put("config_dir", ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._chooser.getCurrentDirectory().toString());
            }

            public void cutNode() {
                this.copyNode();
                this.deleteNode();
            }

            public void copyNode() {
                Clipboard clipboard = this._tree.getToolkit().getSystemClipboard();
                clipboard.setContents(this._tree.createClipboardTransferable(), ConfigEditor.this);
                ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._clipclass = this.group.getConfigClass();
                ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._paste.setEnabled(true);
            }

            public void pasteNode() {
                Clipboard clipboard = this._tree.getToolkit().getSystemClipboard();
                this._tree.getTransferHandler().importData(this._tree, clipboard.getContents(this));
            }

            public void deleteNode() {
                ConfigTreeNode node = this._tree.getSelectedNode();
                ConfigTreeNode parent = (ConfigTreeNode)node.getParent();
                int index = parent.getIndex(node);
                ((DefaultTreeModel)this._tree.getModel()).removeNodeFromParent(node);
                int ccount = parent.getChildCount();
                ConfigTreeNode configTreeNode = node = ccount > 0 ? (ConfigTreeNode)parent.getChildAt(Math.min(index, ccount - 1)) : parent;
                if (node != this._tree.getModel().getRoot()) {
                    this._tree.setSelectionPath(new TreePath(node.getPath()));
                }
            }

            public void configChanged() {
                this._tree.selectedConfigChanged();
            }

            public boolean select(String name) {
                if (this.group.getConfig(name) == null) {
                    return false;
                }
                ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._tabs.setSelectedComponent(ManagerPanel.this);
                ManagerPanel.this.gbox.setSelectedItem(this);
                this._tree.setSelectedNode(name);
                return true;
            }

            public void dispose() {
                if (this._tree != null) {
                    this._tree.dispose();
                    this._tree = null;
                }
            }

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                this.updateSelection();
            }

            public String toString() {
                return this._label;
            }

            protected void updateSelection() {
                ConfigTreeNode node = this._tree.getSelectedNode();
                if (node != null) {
                    if (node.getConfig() != null) {
                        String title = String.valueOf(this.group.getName()) + " : " + node.getName();
                        ConfigEditor.this.setTitle(title);
                    }
                } else {
                    ConfigEditor.this.setTitle(((ManagerPanel)ManagerPanel.this).ConfigEditor.this._msgs.get("m.title"));
                }
                ManagerPanel.this._epanel.setObject(node == null ? null : node.getConfig());
                boolean enable = node != null;
                ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._exportConfigs.setEnabled(enable);
                ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._cut.setEnabled(enable);
                ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._copy.setEnabled(enable);
                ((ManagerPanel)ManagerPanel.this).ConfigEditor.this._delete.setEnabled(enable);
            }

            protected void newNode(ManagedConfig config) {
                ManagerPanel.this._filterPanel.clearFilter();
                ConfigTreeNode snode = this._tree.getSelectedNode();
                ConfigTreeNode parent = (ConfigTreeNode)(snode == null ? this._tree.getModel().getRoot() : snode.getParent());
                String name = parent.findNameForChild(((ManagerPanel)ManagerPanel.this).ConfigEditor.this._msgs.get(config == null ? "m.new_folder" : "m.new_config"));
                ConfigTreeNode child = new ConfigTreeNode(name, config);
                ((DefaultTreeModel)this._tree.getModel()).insertNodeInto(child, parent, parent.getInsertionIndex(child));
                this._tree.startEditingAtPath(new TreePath(child.getPath()));
            }
        }
    }
}

