/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.util;

import com.threerings.math.Box;
import com.threerings.opengl.compositor.Compositor;
import com.threerings.opengl.gui.UIConstants;
import com.threerings.opengl.gui.text.CharacterTextFactory;
import com.threerings.opengl.gui.text.Text;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.AlphaState;
import com.threerings.opengl.renderer.state.DepthState;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.scene.SimpleSceneElement;
import com.threerings.opengl.util.GlContext;
import java.awt.Font;

public class TextBillboard
extends SimpleSceneElement
implements UIConstants {
    protected Text _text;
    protected Box _localBounds = new Box();
    protected float _alpha = 1.0f;

    public TextBillboard(GlContext ctx, Font font, boolean antialias, String text, Color4f color) {
        this(ctx, (Text)null);
        this.setText(font, antialias, text, color);
    }

    public TextBillboard(GlContext ctx, Font font, boolean antialias, String text, Color4f color, int effect, int effectSize, Color4f effectColor) {
        this(ctx, (Text)null);
        this.setText(font, antialias, text, color, effect, effectSize, effectColor);
    }

    public TextBillboard(GlContext ctx, Text text) {
        super(ctx, "Transparent");
        this.setText(text);
    }

    public void setText(Font font, boolean antialias, String text, Color4f color) {
        this.setText(font, antialias, text, color, 0, 0, Color4f.BLACK);
    }

    public void setText(Font font, boolean antialias, String text, Color4f color, int effect, int effectSize, Color4f effectColor) {
        this.setText(CharacterTextFactory.getInstance(font, antialias, 0.0f).createText(text, color, effect, effectSize, effectColor, true));
    }

    public void setText(Text text) {
        this._text = text;
        Dimension size = this._text.getSize();
        float extent = Math.max(size.width / 2, size.height);
        this._localBounds.getMinimumExtent().set(-extent, -extent, -extent);
        this._localBounds.getMaximumExtent().set(extent, extent, extent);
        this.updateBounds();
    }

    public Text getText() {
        return this._text;
    }

    public void setAlpha(float alpha) {
        this._alpha = alpha;
    }

    public float getAlpha() {
        return this._alpha;
    }

    @Override
    public void enqueue() {
        Compositor compositor = this._ctx.getCompositor();
        if (compositor.getSubrenderDepth() > 0) {
            return;
        }
        this._transform.getRotation().set(compositor.getCamera().getWorldTransform().getRotation());
        super.enqueue();
    }

    @Override
    protected RenderState[] createStates() {
        RenderState[] states = super.createStates();
        states[0] = AlphaState.PREMULTIPLIED;
        states[5] = DepthState.TEST;
        return states;
    }

    @Override
    protected Box getLocalBounds() {
        return this._localBounds;
    }

    @Override
    protected void draw() {
        if (this._text != null) {
            this._text.render(this._ctx.getRenderer(), this._text.getSize().width / 2, 0, this._alpha);
        }
    }
}

