/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.util;

import com.samskivert.util.SoftCache;
import com.threerings.opengl.renderer.Light;
import com.threerings.opengl.renderer.TextureUnit;
import com.threerings.opengl.renderer.state.CullState;
import com.threerings.opengl.renderer.state.FogState;
import com.threerings.opengl.renderer.state.LightState;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.renderer.state.TextureState;
import com.threerings.util.ArrayKey;
import java.util.List;

public class SnippetUtil {
    protected static SoftCache<ArrayKey, String> _fogParams = new SoftCache();
    protected static SoftCache<ArrayKey, String> _texCoords = new SoftCache();
    protected static SoftCache<ArrayKey, String> _vertexLighting = new SoftCache();
    protected static SoftCache<ArrayKey, String> _fragmentLighting = new SoftCache();

    public static void getFogParam(String name, String eyeVertex, RenderState[] states, List<String> defs) {
        int mode;
        FogState state = (FogState)states[6];
        int n = mode = state == null ? -1 : state.getFogMode();
        if (mode == -1) {
            defs.add("SET_" + name);
            return;
        }
        ArrayKey key = new ArrayKey(name, eyeVertex, mode);
        String def = (String)_fogParams.get((Object)key);
        if (def == null) {
            def = SnippetUtil.createFogParamDef(name, eyeVertex, mode);
            _fogParams.put((Object)key, (Object)def);
        }
        defs.add(def);
    }

    public static void getFogBlend(String name, RenderState[] states, List<String> defs) {
        int mode;
        FogState state = (FogState)states[6];
        int n = mode = state == null ? -1 : state.getFogMode();
        if (mode == -1) {
            defs.add("BLEND_" + name);
            return;
        }
        defs.add("BLEND_" + name + " gl_FragColor.rgb = mix(gl_Fog.color.rgb, gl_FragColor.rgb, " + "gl_FogFragCoord);");
    }

    public static void getTexCoord(String name, String eyeVertex, String eyeNormal, RenderState[] states, List<String> defs) {
        TextureState state = (TextureState)states[14];
        TextureUnit[] units = state == null ? null : state.getUnits();
        ArrayKey key = SnippetUtil.createTexCoordKey(name, eyeVertex, eyeNormal, units);
        String def = (String)_texCoords.get((Object)key);
        if (def == null) {
            def = SnippetUtil.createTexCoordDef(name, eyeVertex, eyeNormal, units);
            _texCoords.put((Object)key, (Object)def);
        }
        defs.add(def);
    }

    public static void getVertexLighting(String name, String eyeVertex, String eyeNormal, RenderState[] states, boolean vertexProgramTwoSide, List<String> defs) {
        CullState cstate = (CullState)states[4];
        LightState lstate = (LightState)states[7];
        int cullFace = cstate == null ? -1 : cstate.getCullFace();
        Light.Type[] lights = lstate == null ? null : SnippetUtil.getLightTypes(lstate.getLights());
        ArrayKey key = new ArrayKey(new Object[]{name, eyeVertex, eyeNormal, cullFace, vertexProgramTwoSide, lights});
        String def = (String)_vertexLighting.get((Object)key);
        if (def == null) {
            def = SnippetUtil.createVertexLightingDef(name, eyeVertex, eyeNormal, cullFace, vertexProgramTwoSide, lights);
            _vertexLighting.put((Object)key, (Object)def);
        }
        defs.add(def);
    }

    public static void getFragmentLighting(String name, String eyeVertex, String eyeNormal, RenderState[] states, List<String> defs) {
        LightState lstate = (LightState)states[7];
        Light.Type[] lights = lstate == null ? null : SnippetUtil.getLightTypes(lstate.getLights());
        ArrayKey key = new ArrayKey(new Object[]{name, eyeVertex, eyeNormal, lights});
        String def = (String)_fragmentLighting.get((Object)key);
        if (def == null) {
            def = SnippetUtil.createFragmentLightingDef(name, eyeVertex, eyeNormal, lights);
            _fragmentLighting.put((Object)key, (Object)def);
        }
        defs.add(def);
    }

    protected static String createFogParamDef(String name, String eyeVertex, int mode) {
        StringBuilder buf = new StringBuilder();
        switch (mode) {
            case 9729: {
                buf.append("gl_FogFragCoord = clamp((gl_Fog.end + " + eyeVertex + ".z) * gl_Fog.scale");
                break;
            }
            case 2048: {
                buf.append("gl_FogFragCoord = clamp(exp(gl_Fog.density * " + eyeVertex + ".z)");
                break;
            }
            case 2049: {
                buf.append("float f = gl_Fog.density * " + eyeVertex + ".z; ");
                buf.append("gl_FogFragCoord = clamp(exp(-f*f)");
            }
        }
        buf.append(", 0.0, 1.0); ");
        return "SET_" + name + " { " + buf + "}";
    }

    protected static ArrayKey createTexCoordKey(String name, String eyeVertex, String eyeNormal, TextureUnit[] units) {
        int[][] genModes = new int[units == null ? 0 : units.length][];
        int ii = 0;
        while (ii < genModes.length) {
            int[] nArray;
            TextureUnit unit = units[ii];
            if (unit == null) {
                nArray = null;
            } else {
                int[] nArray2 = new int[4];
                nArray2[0] = unit.genModeS;
                nArray2[1] = unit.genModeT;
                nArray2[2] = unit.genModeR;
                nArray = nArray2;
                nArray2[3] = unit.genModeQ;
            }
            genModes[ii] = nArray;
            ++ii;
        }
        return new ArrayKey(new Object[]{name, eyeVertex, eyeNormal, genModes});
    }

    protected static String createTexCoordDef(String name, String eyeVertex, String eyeNormal, TextureUnit[] units) {
        StringBuilder buf = new StringBuilder();
        if (units != null) {
            if (SnippetUtil.anySphereMapped(units)) {
                buf.append("vec3 f = reflect(normalize(" + eyeVertex + ".xyz), " + eyeNormal + ".xyz); ");
                buf.append("float z1 = f.z + 1.0; ");
                buf.append("float rm = 0.5 / sqrt(f.x*f.x + f.y*f.y + (z1*z1)); ");
                buf.append("vec4 sphereTexCoord = vec4(f.x*rm + 0.5, f.y*rm + 0.5, 0.0, 1.0); ");
            }
            int ii = 0;
            while (ii < units.length) {
                SnippetUtil.createTexCoordUnit(ii, units[ii], eyeVertex, buf);
                ++ii;
            }
        }
        return String.valueOf(name) + " { " + buf + "}";
    }

    protected static boolean anySphereMapped(TextureUnit[] units) {
        TextureUnit[] textureUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            TextureUnit unit = textureUnitArray[n2];
            if (unit != null && unit.anyGenModesEqual(9218)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static void createTexCoordUnit(int idx, TextureUnit unit, String eyeVertex, StringBuilder buf) {
        if (unit == null) {
            return;
        }
        if (unit.genModeS == 9218 && unit.genModeT == 9218) {
            buf.append("gl_TexCoord[" + idx + "] = sphereTexCoord; ");
        } else if (unit.allGenModesEqual(-1)) {
            buf.append("gl_TexCoord[" + idx + "] = gl_TextureMatrix[" + idx + "] * gl_MultiTexCoord" + idx + "; ");
        } else {
            if (unit.anyGenModesEqual(-1)) {
                buf.append("vec4 texCoord" + idx + " = gl_TextureMatrix[" + idx + "] * gl_MultiTexCoord" + idx + "; ");
            }
            buf.append("gl_TexCoord[" + idx + "] = vec4(");
            buf.append(String.valueOf(SnippetUtil.createTexCoordElement(idx, 's', unit.genModeS, eyeVertex)) + ", ");
            buf.append(String.valueOf(SnippetUtil.createTexCoordElement(idx, 't', unit.genModeT, eyeVertex)) + ", ");
            buf.append(String.valueOf(SnippetUtil.createTexCoordElement(idx, 'r', unit.genModeR, eyeVertex)) + ", ");
            buf.append(String.valueOf(SnippetUtil.createTexCoordElement(idx, 'q', unit.genModeQ, eyeVertex)) + "); ");
        }
    }

    protected static String createTexCoordElement(int idx, char element, int mode, String eyeVertex) {
        switch (mode) {
            case 9218: {
                return "sphereTexCoord." + element;
            }
            case 9217: {
                return "dot(gl_ObjectPlane" + Character.toUpperCase(element) + "[" + idx + "], gl_Vertex)";
            }
            case 9216: {
                return "dot(gl_EyePlane" + Character.toUpperCase(element) + "[" + idx + "], " + eyeVertex + ")";
            }
        }
        return "(gl_TextureMatrix[" + idx + "] * gl_MultiTexCoord" + idx + ")." + element;
    }

    protected static Light.Type[] getLightTypes(Light[] lights) {
        if (lights == null) {
            return null;
        }
        Light.Type[] types = new Light.Type[lights.length];
        int ii = 0;
        while (ii < types.length) {
            Light light = lights[ii];
            types[ii] = light == null ? null : light.getType();
            ++ii;
        }
        return types;
    }

    protected static String createVertexLightingDef(String name, String eyeVertex, String eyeNormal, int cullFace, boolean vertexProgramTwoSide, Light.Type[] lights) {
        StringBuilder buf = new StringBuilder();
        buf.append(SnippetUtil.createLightingSide("Front", "Front", eyeVertex, eyeNormal, lights));
        if (vertexProgramTwoSide) {
            buf.append("vec4 rnormal = -" + eyeNormal + "; ");
            buf.append(SnippetUtil.createLightingSide("Back", "Back", eyeVertex, "rnormal", lights));
        }
        return String.valueOf(name) + " { " + buf + "}";
    }

    protected static String createFragmentLightingDef(String name, String eyeVertex, String eyeNormal, Light.Type[] lights) {
        StringBuilder buf = new StringBuilder();
        buf.append(SnippetUtil.createLightingSide("Frag", "Front", eyeVertex, eyeNormal, lights));
        return String.valueOf(name) + " { " + buf + "}";
    }

    protected static String createLightingSide(String dest, String side, String eyeVertex, String eyeNormal, Light.Type[] lights) {
        String variable = "gl_" + dest + "Color";
        if (lights == null) {
            return String.valueOf(variable) + " = gl_Color; ";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(String.valueOf(variable) + " = gl_" + side + "LightModelProduct.sceneColor; ");
        int ii = 0;
        while (ii < lights.length) {
            Light.Type light = lights[ii];
            if (light != null) {
                switch (light) {
                    case DIRECTIONAL: {
                        SnippetUtil.addDirectionalLight(ii, dest, side, eyeNormal, buf);
                        break;
                    }
                    case POINT: {
                        SnippetUtil.addPointLight(ii, dest, side, eyeVertex, eyeNormal, buf);
                        break;
                    }
                    case SPOT: {
                        SnippetUtil.addSpotLight(ii, dest, side, eyeVertex, eyeNormal, buf);
                    }
                }
            }
            ++ii;
        }
        return buf.toString();
    }

    protected static void addDirectionalLight(int idx, String dest, String side, String eyeNormal, StringBuilder buf) {
        String lightProduct = "gl_" + side + "LightProduct[" + idx + "]";
        buf.append("gl_" + dest + "Color += " + lightProduct + ".ambient + " + lightProduct + ".diffuse * max(dot(" + eyeNormal + ", gl_LightSource[" + idx + "].position), 0.0); ");
    }

    protected static void addPointLight(int idx, String dest, String side, String eyeVertex, String eyeNormal, StringBuilder buf) {
        String lightSource = "gl_LightSource[" + idx + "]";
        String lightProduct = "gl_" + side + "LightProduct[" + idx + "]";
        buf.append("{ vec4 lvec = " + lightSource + ".position - " + eyeVertex + "; ");
        buf.append("float d = length(lvec); ");
        buf.append("gl_" + dest + "Color += (" + lightProduct + ".ambient + " + lightProduct + ".diffuse * max(dot(" + eyeNormal + ", lvec/d), 0.0)) / (" + lightSource + ".constantAttenuation + d*(" + lightSource + ".linearAttenuation + d*" + lightSource + ".quadraticAttenuation)); } ");
    }

    protected static void addSpotLight(int idx, String dest, String side, String eyeVertex, String eyeNormal, StringBuilder buf) {
        String lightSource = "gl_LightSource[" + idx + "]";
        String lightProduct = "gl_" + side + "LightProduct[" + idx + "]";
        buf.append("{ vec4 lvec = " + lightSource + ".position - " + eyeVertex + "; ");
        buf.append("float d = length(lvec); ");
        buf.append("vec4 nvec = lvec/d; ");
        buf.append("float cosa = -dot(nvec.xyz, " + lightSource + ".spotDirection); ");
        buf.append("gl_" + dest + "Color += step(" + lightSource + ".spotCosCutoff, cosa) * pow(cosa, " + lightSource + ".spotExponent) * (" + lightProduct + ".ambient + " + lightProduct + ".diffuse * max(dot(" + eyeNormal + ", nvec), 0.0)) / (" + lightSource + ".constantAttenuation + d*(" + lightSource + ".linearAttenuation + d*" + lightSource + ".quadraticAttenuation)); } ");
    }
}

