/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.config;

import com.google.common.collect.Lists;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.FileConstraints;
import com.threerings.export.Exportable;
import com.threerings.expr.BooleanExpression;
import com.threerings.expr.Color4fExpression;
import com.threerings.expr.FloatExpression;
import com.threerings.expr.IntegerExpression;
import com.threerings.expr.ObjectExpression;
import com.threerings.expr.Scope;
import com.threerings.expr.Transform3DExpression;
import com.threerings.expr.Updater;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Matrix4f;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector4f;
import com.threerings.opengl.geometry.config.PassDescriptor;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Program;
import com.threerings.opengl.renderer.Shader;
import com.threerings.opengl.renderer.config.CoordSpace;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.renderer.util.SnippetUtil;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ShaderConfig
extends ParameterizedConfig {
    @Editable
    public Implementation implementation = new Vertex();
    protected static final DecimalFormat GLSL_FLOAT = new DecimalFormat("0.0");
    protected static final int FIRST_VERTEX_ATTRIB_INDEX = 9;

    public void populateDescriptor(GlContext ctx, PassDescriptor desc) {
        this.implementation.populateDescriptor(ctx, desc);
    }

    public Shader getShader(GlContext ctx, Scope scope, RenderState[] states, boolean vertexProgramTwoSide) {
        return this.implementation.getShader(ctx, scope, states, vertexProgramTwoSide);
    }

    public UniformConfig[] getUniforms(GlContext ctx) {
        return this.implementation.getUniforms(ctx);
    }

    @Override
    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    @Override
    protected void getUpdateResources(HashSet<String> paths) {
        this.implementation.getUpdateResources(paths);
    }

    public static abstract class ArrayRefUniformConfig<T>
    extends UniformConfig {
        @Override
        public void createUniforms(Scope scope, Program program, List<Program.Uniform> uniforms, List<Updater> updaters) {
            T[] values = ScopeUtil.resolve(scope, this.name, null, this.getArrayClass());
            if (values == null) {
                return;
            }
            ArrayList list = Lists.newArrayList();
            int ii = 0;
            while (ii < values.length) {
                int location = program.getUniformLocation(String.valueOf(this.name) + "[" + ii + "]");
                if (location != -1) {
                    list.add(this.createUniform(location, values[ii]));
                }
                ++ii;
            }
            if (list.isEmpty()) {
                return;
            }
            uniforms.addAll(list);
            final Program.Uniform[] array = list.toArray(new Program.Uniform[list.size()]);
            updaters.add(new Updater(){

                @Override
                public void update() {
                    Program.Uniform[] uniformArray = array;
                    int n = array.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Program.Uniform uniform = uniformArray[n2];
                        uniform.dirty = true;
                        ++n2;
                    }
                }
            });
        }

        protected abstract Class<? extends T[]> getArrayClass();

        protected abstract Program.Uniform createUniform(int var1, T var2);
    }

    public static class BooleanDefinition
    extends Definition {
        @Editable(hgroup="p")
        public boolean value;

        @Override
        public void getDefinitions(Scope scope, RenderState[] states, boolean vertexProgramTwoSide, List<String> defs) {
            if (this.value) {
                defs.add(this.name);
            }
        }
    }

    public static class BooleanExprUniformConfig
    extends ExpressionUniformConfig {
        @Editable
        public BooleanExpression expression = new BooleanExpression.Constant();

        @Override
        protected Program.Uniform createUniform(int location, Scope scope, List<Updater> updaters) {
            final Program.IntegerUniform uniform = new Program.IntegerUniform(location);
            final BooleanExpression.Evaluator eval = this.expression.createEvaluator(scope);
            updaters.add(new Updater(){

                @Override
                public void update() {
                    uniform.value = eval.evaluate() ? 1 : 0;
                    uniform.dirty = true;
                }
            });
            return uniform;
        }
    }

    public static class BooleanUniformConfig
    extends SimpleUniformConfig {
        @Editable(hgroup="p")
        public boolean value;

        @Override
        public Program.Uniform createUniform(int location) {
            return new Program.IntegerUniform(location, this.value ? 1 : 0);
        }
    }

    public static class ColorDefinition
    extends Definition {
        @Editable(mode="alpha", hgroup="p")
        public Color4f value = new Color4f();

        @Override
        public void getDefinitions(Scope scope, RenderState[] states, boolean vertexProgramTwoSide, List<String> defs) {
            defs.add(String.valueOf(this.name) + " vec4(" + GLSL_FLOAT.format(this.value.r) + ", " + GLSL_FLOAT.format(this.value.g) + ", " + GLSL_FLOAT.format(this.value.b) + ", " + GLSL_FLOAT.format(this.value.a) + ")");
        }
    }

    public static class ColorExprUniformConfig
    extends ExpressionUniformConfig {
        @Editable
        public Color4fExpression expression = new Color4fExpression.Constant();

        @Override
        protected Program.Uniform createUniform(int location, Scope scope, List<Updater> updaters) {
            final Program.Vector4fUniform uniform = new Program.Vector4fUniform(location);
            final ObjectExpression.Evaluator eval = this.expression.createEvaluator(scope);
            updaters.add(new Updater(){

                @Override
                public void update() {
                    Color4f value = (Color4f)eval.evaluate();
                    uniform.value.set(value.r, value.g, value.b, value.a);
                    uniform.dirty = true;
                }
            });
            return uniform;
        }
    }

    public static class ColorUniformConfig
    extends SimpleUniformConfig {
        @Editable(mode="alpha", hgroup="p")
        public Color4f value = new Color4f();

        @Override
        public Program.Uniform createUniform(int location) {
            return new Program.Vector4fUniform(location, new Vector4f(this.value.r, this.value.g, this.value.b, this.value.a));
        }
    }

    @EditorTypes(value={BooleanDefinition.class, ColorDefinition.class, FloatDefinition.class, IntegerDefinition.class, StringDefinition.class, TransformDefinition.class, FogParamSnippet.class, FogBlendSnippet.class, TexCoordSnippet.class, VertexLightingSnippet.class, FragmentLightingSnippet.class})
    public static abstract class Definition
    extends DeepObject
    implements Exportable {
        @Editable(hgroup="p")
        public String name = "";

        public abstract void getDefinitions(Scope var1, RenderState[] var2, boolean var3, List<String> var4);
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<ShaderConfig> shader;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(ShaderConfig.class, this.shader);
        }

        @Override
        public void populateDescriptor(GlContext ctx, PassDescriptor desc) {
            ShaderConfig config = this.getConfig(ctx);
            if (config != null) {
                config.populateDescriptor(ctx, desc);
            }
        }

        @Override
        public Shader getShader(GlContext ctx, Scope scope, RenderState[] states, boolean vertexProgramTwoSide) {
            ShaderConfig config = this.getConfig(ctx);
            return config == null ? null : config.getShader(ctx, scope, states, vertexProgramTwoSide);
        }

        @Override
        public UniformConfig[] getUniforms(GlContext ctx) {
            ShaderConfig config = this.getConfig(ctx);
            return config == null ? null : config.getUniforms(ctx);
        }

        protected ShaderConfig getConfig(GlContext ctx) {
            return this.shader == null ? null : ctx.getConfigManager().getConfig(ShaderConfig.class, this.shader);
        }
    }

    public static abstract class ExpressionUniformConfig
    extends UniformConfig {
        @Override
        public void createUniforms(Scope scope, Program program, List<Program.Uniform> uniforms, List<Updater> updaters) {
            int location = program.getUniformLocation(this.name);
            if (location != -1) {
                uniforms.add(this.createUniform(location, scope, updaters));
            }
        }

        protected abstract Program.Uniform createUniform(int var1, Scope var2, List<Updater> var3);
    }

    public static class FloatDefinition
    extends Definition {
        @Editable(step=0.01, hgroup="p")
        public float value;

        @Override
        public void getDefinitions(Scope scope, RenderState[] states, boolean vertexProgramTwoSide, List<String> defs) {
            defs.add(String.valueOf(this.name) + " " + GLSL_FLOAT.format(this.value));
        }
    }

    public static class FloatExprUniformConfig
    extends ExpressionUniformConfig {
        @Editable
        public FloatExpression expression = new FloatExpression.Constant();

        @Override
        protected Program.Uniform createUniform(int location, Scope scope, List<Updater> updaters) {
            final Program.FloatUniform uniform = new Program.FloatUniform(location);
            final FloatExpression.Evaluator eval = this.expression.createEvaluator(scope);
            updaters.add(new Updater(){

                @Override
                public void update() {
                    uniform.value = eval.evaluate();
                    uniform.dirty = true;
                }
            });
            return uniform;
        }
    }

    public static class FloatUniformConfig
    extends SimpleUniformConfig {
        @Editable(step=0.01, hgroup="p")
        public float value;

        @Override
        public Program.Uniform createUniform(int location) {
            return new Program.FloatUniform(location, this.value);
        }
    }

    public static class FogBlendSnippet
    extends Definition {
        @Override
        public void getDefinitions(Scope scope, RenderState[] states, boolean vertexProgramTwoSide, List<String> defs) {
            SnippetUtil.getFogBlend(this.name, states, defs);
        }
    }

    public static class FogParamSnippet
    extends Definition {
        @Editable
        public String eyeVertex = "eyeVertex";

        @Override
        public void getDefinitions(Scope scope, RenderState[] states, boolean vertexProgramTwoSide, List<String> defs) {
            SnippetUtil.getFogParam(this.name, this.eyeVertex, states, defs);
        }
    }

    public static class Fragment
    extends Original {
        @Editable
        public Contents contents = new SourceFile();

        @Override
        public void getUpdateResources(HashSet<String> paths) {
            this.contents.getUpdateResources(paths);
        }

        @Override
        public void populateDescriptor(GlContext ctx, PassDescriptor desc) {
        }

        @Override
        public Shader getShader(GlContext ctx, Scope scope, RenderState[] states, boolean vertexProgramTwoSide) {
            return this.contents.getShader(ctx, scope, states, vertexProgramTwoSide);
        }

        @EditorTypes(value={SourceFile.class})
        public static abstract class Contents
        extends DeepObject
        implements Exportable {
            public void getUpdateResources(HashSet<String> paths) {
            }

            public abstract Shader getShader(GlContext var1, Scope var2, RenderState[] var3, boolean var4);
        }

        public static class SourceFile
        extends Contents {
            @Editable(editor="resource", nullable=true)
            @FileConstraints(description="m.fragment_shader_files", extensions={".frag"}, directory="shader_dir")
            public String file;
            @Editable
            public Definition[] definitions = new Definition[0];

            @Override
            public void getUpdateResources(HashSet<String> paths) {
                if (this.file != null) {
                    paths.add(this.file);
                }
            }

            @Override
            public Shader getShader(GlContext ctx, Scope scope, RenderState[] states, boolean vertexProgramTwoSide) {
                if (this.file == null) {
                    return null;
                }
                ArrayList defs = Lists.newArrayList();
                Definition[] definitionArray = this.definitions;
                int n = this.definitions.length;
                int n2 = 0;
                while (n2 < n) {
                    Definition definition = definitionArray[n2];
                    definition.getDefinitions(scope, states, vertexProgramTwoSide, defs);
                    ++n2;
                }
                return ctx.getShaderCache().getShader(this.file, defs.toArray(new String[defs.size()]));
            }
        }
    }

    public static class FragmentLightingSnippet
    extends Definition {
        @Editable
        public String eyeVertex = "eyeVertex";
        @Editable
        public String eyeNormal = "eyeNormal";

        @Override
        public void getDefinitions(Scope scope, RenderState[] states, boolean vertexProgramTwoSide, List<String> defs) {
            SnippetUtil.getFragmentLighting(this.name, this.eyeVertex, this.eyeNormal, states, defs);
        }
    }

    @EditorTypes(value={Vertex.class, Fragment.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public void getUpdateResources(HashSet<String> paths) {
        }

        public abstract void populateDescriptor(GlContext var1, PassDescriptor var2);

        public abstract Shader getShader(GlContext var1, Scope var2, RenderState[] var3, boolean var4);

        public abstract UniformConfig[] getUniforms(GlContext var1);
    }

    public static class IntegerDefinition
    extends Definition {
        @Editable(hgroup="p")
        public int value;

        @Override
        public void getDefinitions(Scope scope, RenderState[] states, boolean vertexProgramTwoSide, List<String> defs) {
            defs.add(String.valueOf(this.name) + " " + this.value);
        }
    }

    public static class IntegerExprUniformConfig
    extends ExpressionUniformConfig {
        @Editable
        public IntegerExpression expression = new IntegerExpression.Constant();

        @Override
        protected Program.Uniform createUniform(int location, Scope scope, List<Updater> updaters) {
            final Program.IntegerUniform uniform = new Program.IntegerUniform(location);
            final IntegerExpression.Evaluator eval = this.expression.createEvaluator(scope);
            updaters.add(new Updater(){

                @Override
                public void update() {
                    uniform.value = eval.evaluate();
                    uniform.dirty = true;
                }
            });
            return uniform;
        }
    }

    public static class IntegerUniformConfig
    extends SimpleUniformConfig {
        @Editable(hgroup="p")
        public int value;

        @Override
        public Program.Uniform createUniform(int location) {
            return new Program.IntegerUniform(location, this.value);
        }
    }

    public static class MatrixArrayRefUniformConfig
    extends ArrayRefUniformConfig<Matrix4f> {
        @Override
        protected Class<? extends Matrix4f[]> getArrayClass() {
            return Matrix4f.EMPTY_ARRAY.getClass();
        }

        @Override
        protected Program.Uniform createUniform(int location, Matrix4f value) {
            Program.Matrix4fUniform uniform = new Program.Matrix4fUniform(location);
            uniform.value = value;
            return uniform;
        }
    }

    public static abstract class Original
    extends Implementation {
        @Editable
        public UniformConfig[] uniforms = new UniformConfig[0];

        @Override
        public UniformConfig[] getUniforms(GlContext ctx) {
            return this.uniforms;
        }
    }

    public static class PolarUniformConfig
    extends SimpleUniformConfig {
        @Editable(step=0.01, mode="polar", hgroup="p")
        public Vector2f value = new Vector2f();

        @Override
        public Program.Uniform createUniform(int location) {
            return new Program.Vector2fUniform(location, this.value);
        }
    }

    public static abstract class SimpleUniformConfig
    extends UniformConfig {
        @Override
        public void createUniforms(Scope scope, Program program, List<Program.Uniform> uniforms, List<Updater> updaters) {
            int location = program.getUniformLocation(this.name);
            if (location != -1) {
                uniforms.add(this.createUniform(location));
            }
        }

        protected abstract Program.Uniform createUniform(int var1);
    }

    public static class StringDefinition
    extends Definition {
        @Editable(hgroup="p")
        public String value = "";

        @Override
        public void getDefinitions(Scope scope, RenderState[] states, boolean vertexProgramTwoSide, List<String> defs) {
            defs.add(String.valueOf(this.name) + " " + this.value);
        }
    }

    public static class TexCoordSnippet
    extends Definition {
        @Editable
        public String eyeVertex = "eyeVertex";
        @Editable
        public String eyeNormal = "eyeNormal";

        @Override
        public void getDefinitions(Scope scope, RenderState[] states, boolean vertexProgramTwoSide, List<String> defs) {
            SnippetUtil.getTexCoord(this.name, this.eyeVertex, this.eyeNormal, states, defs);
        }
    }

    public static class TransformDefinition
    extends Definition {
        @Editable(step=0.01, hgroup="p")
        public Transform3D value = new Transform3D();

        @Override
        public void getDefinitions(Scope scope, RenderState[] states, boolean vertexProgramTwoSide, List<String> defs) {
            this.value.update(4);
            Matrix4f matrix = this.value.getMatrix();
            defs.add(String.valueOf(this.name) + " mat4(" + GLSL_FLOAT.format(matrix.m00) + ", " + GLSL_FLOAT.format(matrix.m01) + ", " + GLSL_FLOAT.format(matrix.m02) + ", " + GLSL_FLOAT.format(matrix.m03) + ", " + GLSL_FLOAT.format(matrix.m10) + ", " + GLSL_FLOAT.format(matrix.m11) + ", " + GLSL_FLOAT.format(matrix.m12) + ", " + GLSL_FLOAT.format(matrix.m13) + ", " + GLSL_FLOAT.format(matrix.m20) + ", " + GLSL_FLOAT.format(matrix.m21) + ", " + GLSL_FLOAT.format(matrix.m22) + ", " + GLSL_FLOAT.format(matrix.m23) + ", " + GLSL_FLOAT.format(matrix.m30) + ", " + GLSL_FLOAT.format(matrix.m31) + ", " + GLSL_FLOAT.format(matrix.m32) + ", " + GLSL_FLOAT.format(matrix.m33) + ")");
        }
    }

    public static class TransformExprUniformConfig
    extends ExpressionUniformConfig {
        @Editable
        public Transform3DExpression expression = new Transform3DExpression.Constant();

        @Override
        protected Program.Uniform createUniform(int location, Scope scope, List<Updater> updaters) {
            final Program.Matrix4fUniform uniform = new Program.Matrix4fUniform(location);
            final ObjectExpression.Evaluator eval = this.expression.createEvaluator(scope);
            updaters.add(new Updater(){

                @Override
                public void update() {
                    Transform3D value = (Transform3D)eval.evaluate();
                    value.update(4);
                    uniform.value.set(value.getMatrix());
                    uniform.dirty = true;
                }
            });
            return uniform;
        }
    }

    public static class TransformUniformConfig
    extends SimpleUniformConfig {
        @Editable(step=0.01, hgroup="p")
        public Transform3D value = new Transform3D();

        @Override
        public Program.Uniform createUniform(int location) {
            this.value.update(4);
            return new Program.Matrix4fUniform(location, this.value.getMatrix());
        }
    }

    @EditorTypes(value={BooleanUniformConfig.class, ColorUniformConfig.class, FloatUniformConfig.class, IntegerUniformConfig.class, PolarUniformConfig.class, TransformUniformConfig.class, BooleanExprUniformConfig.class, ColorExprUniformConfig.class, FloatExprUniformConfig.class, IntegerExprUniformConfig.class, TransformExprUniformConfig.class, MatrixArrayRefUniformConfig.class})
    public static abstract class UniformConfig
    extends DeepObject
    implements Exportable {
        @Editable(hgroup="p")
        public String name = "";

        public abstract void createUniforms(Scope var1, Program var2, List<Program.Uniform> var3, List<Updater> var4);
    }

    public static class Vertex
    extends Original {
        @Editable(width=15)
        public String[] hints = new String[0];
        @Editable(width=15)
        public String[] attributes = new String[0];
        @Editable(hgroup="t")
        public CoordSpace coordSpace = CoordSpace.OBJECT;
        @Editable(hgroup="t")
        public boolean colors = true;
        @Editable(hgroup="t")
        public boolean normals = true;
        @Editable
        public Contents contents = new SourceFile();

        @Override
        public void getUpdateResources(HashSet<String> paths) {
            this.contents.getUpdateResources(paths);
        }

        @Override
        public void populateDescriptor(GlContext ctx, PassDescriptor desc) {
            desc.coordSpace = this.coordSpace;
            desc.hints = this.hints;
            desc.firstVertexAttribIndex = 9;
            desc.vertexAttribs = this.attributes;
            desc.colors |= this.colors;
            desc.normals |= this.normals;
        }

        @Override
        public Shader getShader(GlContext ctx, Scope scope, RenderState[] states, boolean vertexProgramTwoSide) {
            return this.contents.getShader(ctx, scope, states, vertexProgramTwoSide);
        }

        @EditorTypes(value={SourceFile.class})
        public static abstract class Contents
        extends DeepObject
        implements Exportable {
            public void getUpdateResources(HashSet<String> paths) {
            }

            public abstract Shader getShader(GlContext var1, Scope var2, RenderState[] var3, boolean var4);
        }

        public static class SourceFile
        extends Contents {
            @Editable(editor="resource", nullable=true)
            @FileConstraints(description="m.vertex_shader_files", extensions={".vert"}, directory="shader_dir")
            public String file;
            @Editable
            public Definition[] definitions = new Definition[0];

            @Override
            public void getUpdateResources(HashSet<String> paths) {
                if (this.file != null) {
                    paths.add(this.file);
                }
            }

            @Override
            public Shader getShader(GlContext ctx, Scope scope, RenderState[] states, boolean vertexProgramTwoSide) {
                if (this.file == null) {
                    return null;
                }
                ArrayList defs = Lists.newArrayList();
                Definition[] definitionArray = this.definitions;
                int n = this.definitions.length;
                int n2 = 0;
                while (n2 < n) {
                    Definition definition = definitionArray[n2];
                    definition.getDefinitions(scope, states, vertexProgramTwoSide, defs);
                    ++n2;
                }
                return ctx.getShaderCache().getShader(this.file, defs.toArray(new String[defs.size()]));
            }
        }
    }

    public static class VertexLightingSnippet
    extends Definition {
        @Editable
        public String eyeVertex = "eyeVertex";
        @Editable
        public String eyeNormal = "eyeNormal";

        @Override
        public void getDefinitions(Scope scope, RenderState[] states, boolean vertexProgramTwoSide, List<String> defs) {
            SnippetUtil.getVertexLighting(this.name, this.eyeVertex, this.eyeNormal, states, vertexProgramTwoSide, defs);
        }
    }
}

