/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.material.config;

import com.google.common.base.Objects;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.opengl.compositor.config.RenderSchemeConfig;
import com.threerings.opengl.material.config.MaterialRewriter;
import com.threerings.opengl.material.config.TechniqueConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.util.ArrayList;

public class MaterialConfig
extends ParameterizedConfig {
    @Editable
    public Implementation implementation = new Original();

    public TechniqueConfig getTechnique(GlContext ctx, String scheme) {
        return this.implementation.getTechnique(ctx, scheme);
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    @Override
    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<MaterialConfig> material;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(MaterialConfig.class, this.material);
        }

        @Override
        public TechniqueConfig getTechnique(GlContext ctx, String scheme) {
            if (this.material == null) {
                return null;
            }
            MaterialConfig config = ctx.getConfigManager().getConfig(MaterialConfig.class, this.material);
            return config == null ? null : config.getTechnique(ctx, scheme);
        }
    }

    @EditorTypes(value={Original.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public abstract void getUpdateReferences(ConfigReferenceSet var1);

        public abstract TechniqueConfig getTechnique(GlContext var1, String var2);

        public void invalidate() {
        }
    }

    public static class Original
    extends Implementation {
        @Editable
        public TechniqueConfig[] techniques = new TechniqueConfig[]{new TechniqueConfig()};
        @DeepOmit
        protected transient ArrayList<TechniqueConfig> _processedTechniques;
        @DeepOmit
        protected transient boolean _compatibilityMode;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            TechniqueConfig[] techniqueConfigArray = this.techniques;
            int n = this.techniques.length;
            int n2 = 0;
            while (n2 < n) {
                TechniqueConfig technique = techniqueConfigArray[n2];
                technique.getUpdateReferences(refs);
                ++n2;
            }
        }

        @Override
        public TechniqueConfig getTechnique(GlContext ctx, String scheme) {
            MaterialRewriter rewriter;
            ArrayList<TechniqueConfig> processed = this.getProcessedTechniques(ctx);
            int ii = 0;
            int nn = processed.size();
            while (ii < nn) {
                TechniqueConfig technique = processed.get(ii);
                if (Objects.equal((Object)technique.scheme, (Object)scheme)) {
                    return technique;
                }
                ++ii;
            }
            RenderSchemeConfig sconfig = scheme == null ? null : ctx.getConfigManager().getConfig(RenderSchemeConfig.class, scheme);
            int ii2 = 0;
            int nn2 = processed.size();
            while (ii2 < nn2) {
                TechniqueConfig technique = processed.get(ii2);
                RenderSchemeConfig tconfig = technique.getSchemeConfig(ctx);
                if (sconfig == null ? tconfig == null || tconfig.isCompatibleWith(sconfig) : sconfig.isCompatibleWith(tconfig)) {
                    return technique;
                }
                ++ii2;
            }
            MaterialRewriter materialRewriter = rewriter = sconfig == null ? null : sconfig.getMaterialRewriter();
            if (rewriter == null) {
                return null;
            }
            int ii3 = 0;
            int nn3 = processed.size();
            while (ii3 < nn3) {
                TechniqueConfig rewritten;
                TechniqueConfig technique = processed.get(ii3);
                RenderSchemeConfig tconfig = technique.getSchemeConfig(ctx);
                if ((tconfig == null || tconfig.isCompatibleWith(null)) && (rewritten = rewriter.rewrite(technique)) != null) {
                    rewritten.scheme = scheme;
                    processed.add(rewritten);
                    return rewritten;
                }
                ++ii3;
            }
            return null;
        }

        @Override
        public void invalidate() {
            this._processedTechniques = null;
            TechniqueConfig[] techniqueConfigArray = this.techniques;
            int n = this.techniques.length;
            int n2 = 0;
            while (n2 < n) {
                TechniqueConfig technique = techniqueConfigArray[n2];
                technique.invalidate();
                ++n2;
            }
        }

        protected ArrayList<TechniqueConfig> getProcessedTechniques(GlContext ctx) {
            boolean compatibility = ctx.getApp().getCompatibilityMode();
            if (this._processedTechniques == null || this._compatibilityMode != compatibility) {
                this._processedTechniques = new ArrayList(this.techniques.length);
                ArrayList<TechniqueConfig> fallbacks = new ArrayList<TechniqueConfig>(0);
                TechniqueConfig[] techniqueConfigArray = this.techniques;
                int n = this.techniques.length;
                int n2 = 0;
                while (n2 < n) {
                    TechniqueConfig technique = techniqueConfigArray[n2];
                    TechniqueConfig processed = technique.process(ctx, false);
                    if (processed == null) {
                        TechniqueConfig fallback = technique.process(ctx, true);
                        if (fallback != null) {
                            fallbacks.add(fallback);
                        }
                    } else {
                        this._processedTechniques.add(processed);
                    }
                    ++n2;
                }
                this._processedTechniques.addAll(fallbacks);
                this._compatibilityMode = compatibility;
            }
            return this._processedTechniques;
        }
    }
}

